/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.common.collections;

import codetoolkit.janalysis.common.graph.DefaultMatcher;
import codetoolkit.janalysis.common.graph.Holder;
import codetoolkit.janalysis.common.graph.Matcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class MatcherLinkedHashSet<T>
implements Set<T> {
    protected final Matcher<T> matcher;
    private final LinkedHashSet<Holder<T>> set;

    public MatcherLinkedHashSet() {
        this(16);
    }

    public MatcherLinkedHashSet(int capacity) {
        this(capacity, new DefaultMatcher());
    }

    public MatcherLinkedHashSet(int capacity, Matcher<T> matcher) {
        this.set = new LinkedHashSet(capacity, 0.8f);
        this.matcher = matcher;
    }

    public MatcherLinkedHashSet(Set<T> set, Matcher<T> matcher) {
        this.matcher = matcher;
        this.set = new LinkedHashSet(16, 0.8f);
        for (T e : set) {
            this.set.add(new Holder<T>(e, matcher));
        }
    }

    @Override
    public boolean add(T e) {
        return this.set.add(new Holder<T>(e, this.matcher));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new Holder<Object>(o, this.matcher));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object obj : c) {
            result |= this.remove(obj);
        }
        return result;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.set.contains(new Holder<Object>(obj, this.matcher));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        for (Object obj : c) {
            result &= this.contains(obj);
        }
        return result;
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public Iterator<T> iterator() {
        Iterator iter = new Iterator<T>(){
            private Iterator<Holder<T>> wrpIter;
            {
                this.wrpIter = MatcherLinkedHashSet.this.set.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrpIter.hasNext();
            }

            @Override
            public T next() {
                return this.wrpIter.next().object;
            }

            @Override
            public void remove() {
                this.wrpIter.remove();
            }
        };
        return iter;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.set.size()];
        int idx = 0;
        for (Holder holder : this.set) {
            array[idx] = holder.object;
            ++idx;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int idx = 0;
        for (Holder holder : this.set) {
            array[idx] = holder.object;
            ++idx;
        }
        return array;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Holder wrp = (Holder)iter.next();
            if (c.contains(wrp.object)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }
}

