/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.cg.stat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;

public class MethodVisitor
extends EmptyVisitor {
    JavaClass visitedClass;
    private MethodGen mg;
    private ConstantPoolGen cp;
    private String format;
    private List<String> methodCalls = new ArrayList<String>();

    public MethodVisitor(MethodGen m, JavaClass jc) {
        this.visitedClass = jc;
        this.mg = m;
        this.cp = this.mg.getConstantPool();
        this.format = "M:" + this.visitedClass.getClassName() + ":" + this.mg.getName() + "(" + this.argumentList(this.mg.getArgumentTypes()) + ") (%s)%s:%s(%s)";
    }

    private String argumentList(Type[] arguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }

    public List<String> start() {
        if (this.mg.isAbstract() || this.mg.isNative()) {
            return Collections.emptyList();
        }
        for (InstructionHandle ih = this.mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (this.visitInstruction(i)) continue;
            i.accept(this);
        }
        return this.methodCalls;
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        return InstructionConst.getInstruction(opcode) != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL i) {
        this.methodCalls.add(String.format(this.format, "M", i.getReferenceType(this.cp), i.getMethodName(this.cp), this.argumentList(i.getArgumentTypes(this.cp))));
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE i) {
        this.methodCalls.add(String.format(this.format, "I", i.getReferenceType(this.cp), i.getMethodName(this.cp), this.argumentList(i.getArgumentTypes(this.cp))));
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL i) {
        this.methodCalls.add(String.format(this.format, "O", i.getReferenceType(this.cp), i.getMethodName(this.cp), this.argumentList(i.getArgumentTypes(this.cp))));
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC i) {
        this.methodCalls.add(String.format(this.format, "S", i.getReferenceType(this.cp), i.getMethodName(this.cp), this.argumentList(i.getArgumentTypes(this.cp))));
    }

    @Override
    public void visitINVOKEDYNAMIC(INVOKEDYNAMIC i) {
        this.methodCalls.add(String.format(this.format, "D", i.getType(this.cp), i.getMethodName(this.cp), this.argumentList(i.getArgumentTypes(this.cp))));
    }
}

