/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.cg.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class DynamicCallManager {
    private static final Pattern BOOTSTRAP_CALL_PATTERN = Pattern.compile("invokedynamic\t(\\d+):\\S+ \\S+ \\(\\d+\\)");
    private static final int CALL_HANDLE_INDEX_ARGUMENT = 1;
    private final Map<String, String> dynamicCallers = new HashMap<String, String>();

    public void retrieveCalls(Method method, JavaClass jc) {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        ConstantPool cp = method.getConstantPool();
        BootstrapMethod[] boots = this.getBootstrapMethods(jc);
        String code = method.getCode().toString();
        Matcher matcher = BOOTSTRAP_CALL_PATTERN.matcher(code);
        while (matcher.find()) {
            int bootIndex = Integer.parseInt(matcher.group(1));
            BootstrapMethod bootMethod = boots[bootIndex];
            if (bootMethod.getBootstrapArguments().length < 2) continue;
            int calledIndex = bootMethod.getBootstrapArguments()[1];
            String calledName = this.getMethodNameFromHandleIndex(cp, calledIndex);
            String callerName = method.getName();
            this.dynamicCallers.put(calledName, callerName);
        }
    }

    private String getMethodNameFromHandleIndex(ConstantPool cp, int callIndex) {
        ConstantMethodHandle handle = (ConstantMethodHandle)cp.getConstant(callIndex);
        ConstantCP ref = (ConstantCP)cp.getConstant(handle.getReferenceIndex());
        ConstantNameAndType nameAndType = (ConstantNameAndType)cp.getConstant(ref.getNameAndTypeIndex());
        return nameAndType.getName(cp);
    }

    public void linkCalls(Method method) {
        String methodName;
        int nameIndex = method.getNameIndex();
        ConstantPool cp = method.getConstantPool();
        String linkedName = methodName = ((ConstantUtf8)cp.getConstant(nameIndex)).getBytes();
        String callerName = methodName;
        while (linkedName.matches("(lambda\\$)+null(\\$\\d+)+")) {
            callerName = this.dynamicCallers.get(callerName);
            linkedName = linkedName.replace("null", callerName);
        }
        cp.setConstant(nameIndex, new ConstantUtf8(linkedName));
    }

    private BootstrapMethod[] getBootstrapMethods(JavaClass jc) {
        for (Attribute attribute : jc.getAttributes()) {
            if (!(attribute instanceof BootstrapMethods)) continue;
            return ((BootstrapMethods)attribute).getBootstrapMethods();
        }
        return new BootstrapMethod[0];
    }
}

