/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.cg.stat;

import codetoolkit.janalysis.cg.stat.DynamicCallManager;
import codetoolkit.janalysis.cg.stat.MethodVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

public class ClassVisitor
extends EmptyVisitor {
    private JavaClass clazz;
    private ConstantPoolGen constants;
    private String classReferenceFormat;
    private final DynamicCallManager DCManager = new DynamicCallManager();
    private List<String> methodCalls = new ArrayList<String>();

    public ClassVisitor(JavaClass jc) {
        this.clazz = jc;
        this.constants = new ConstantPoolGen(this.clazz.getConstantPool());
        this.classReferenceFormat = "C:" + this.clazz.getClassName() + " %s";
    }

    @Override
    public void visitJavaClass(JavaClass jc) {
        jc.getConstantPool().accept(this);
        Method[] methods = jc.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.DCManager.retrieveCalls(method, jc);
            this.DCManager.linkCalls(method);
            method.accept(this);
        }
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        for (int i = 0; i < constantPool.getLength(); ++i) {
            Constant constant = constantPool.getConstant(i);
            if (constant == null || constant.getTag() != 7) continue;
            String string = constantPool.constantToString(constant);
        }
    }

    @Override
    public void visitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.clazz.getClassName(), this.constants);
        MethodVisitor visitor = new MethodVisitor(mg, this.clazz);
        this.methodCalls.addAll(visitor.start());
    }

    public ClassVisitor start() {
        this.visitJavaClass(this.clazz);
        return this;
    }

    public List<String> methodCalls() {
        return this.methodCalls;
    }
}

