/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.cg.stat;

import codetoolkit.janalysis.cg.stat.ClassVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.bcel.classfile.ClassParser;

public class CallGraphBuilder {
    public static List<String> build(String path) {
        return CallGraphBuilder.build(new String[]{path});
    }

    public static List<String> build(String[] paths) {
        ArrayList<String> methodCalls = new ArrayList<String>(1000);
        Function<ClassParser, ClassVisitor> classVisitorFunc = cp -> {
            try {
                return new ClassVisitor(cp.parse());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        for (String path : paths) {
            File f = new File(path);
            if (!f.exists()) {
                System.err.println("Path `" + path + "` does not exist");
            }
            List<String> classFiles = new ArrayList<String>(100);
            if (f.isFile() && f.getName().endsWith(".jar")) {
                classFiles = CallGraphBuilder.enumerateJar(f);
            } else if (f.isDirectory()) {
                CallGraphBuilder.enumerateDir(f, classFiles);
            }
            classFiles.stream().forEach(e -> {
                ClassParser cp = new ClassParser((String)e);
                List<String> mc = ((ClassVisitor)classVisitorFunc.apply(cp)).start().methodCalls();
                methodCalls.addAll(mc);
            });
        }
        return methodCalls;
    }

    public static List<String> enumerateJar(File jarFile) {
        ArrayList<String> classFiles = new ArrayList<String>(100);
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry entry;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                classFiles.add(entry.getName());
            }
        }
        catch (Exception e) {
            System.out.println("Oops.. Encounter an issue while parsing jar" + e.toString());
        }
        return classFiles;
    }

    public static void enumerateDir(File dir, List<String> classFiles) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                CallGraphBuilder.enumerateDir(file, classFiles);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classFiles.add(file.getAbsolutePath());
        }
    }
}

