# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class QueryAuthConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: str = None,
        resource_owner_id: str = None,
        resource_owner_account: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_id = resource_owner_id
        self.resource_owner_account = resource_owner_account
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryAuthConfigResponseBody(TeaModel):
    def __init__(
        self,
        key_2: str = None,
        key_1: str = None,
        request_id: str = None,
    ):
        self.key_2 = key_2
        self.key_1 = key_1
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_2 is not None:
            result['Key2'] = self.key_2
        if self.key_1 is not None:
            result['Key1'] = self.key_1
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key2') is not None:
            self.key_2 = m.get('Key2')
        if m.get('Key1') is not None:
            self.key_1 = m.get('Key1')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryAuthConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAuthConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAuthConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAsrPipelineListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        pipeline_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.pipeline_ids = pipeline_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue_name: str = None,
        topic: str = None,
    ):
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class QueryAsrPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryAsrPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryAsrPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[QueryAsrPipelineListResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = QueryAsrPipelineListResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class QueryAsrPipelineListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAsrPipelineListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        pipeline_list: QueryAsrPipelineListResponseBodyPipelineList = None,
        non_exist_ids: QueryAsrPipelineListResponseBodyNonExistIds = None,
    ):
        self.request_id = request_id
        self.pipeline_list = pipeline_list
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PipelineList') is not None:
            temp_model = QueryAsrPipelineListResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryAsrPipelineListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryAsrPipelineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAsrPipelineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAsrPipelineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitMediaCensorJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        input: str = None,
        cover_images: str = None,
        title: str = None,
        description: str = None,
        barrages: str = None,
        pipeline_id: str = None,
        video_censor_config: str = None,
        user_data: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.input = input
        self.cover_images = cover_images
        self.title = title
        self.description = description
        self.barrages = barrages
        self.pipeline_id = pipeline_id
        self.video_censor_config = video_censor_config
        self.user_data = user_data
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.input is not None:
            result['Input'] = self.input
        if self.cover_images is not None:
            result['CoverImages'] = self.cover_images
        if self.title is not None:
            result['Title'] = self.title
        if self.description is not None:
            result['Description'] = self.description
        if self.barrages is not None:
            result['Barrages'] = self.barrages
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.video_censor_config is not None:
            result['VideoCensorConfig'] = self.video_censor_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('CoverImages') is not None:
            self.cover_images = m.get('CoverImages')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Barrages') is not None:
            self.barrages = m.get('Barrages')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('VideoCensorConfig') is not None:
            self.video_censor_config = m.get('VideoCensorConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitMediaCensorJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class SubmitMediaCensorJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitMediaCensorJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitMediaCensorJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSessionRequest(TeaModel):
    def __init__(
        self,
        owner_id: str = None,
        resource_owner_id: str = None,
        resource_owner_account: str = None,
        owner_account: str = None,
        end_user_id: str = None,
        session_time: int = None,
        media_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_id = resource_owner_id
        self.resource_owner_account = resource_owner_account
        self.owner_account = owner_account
        self.end_user_id = end_user_id
        self.session_time = session_time
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.session_time is not None:
            result['SessionTime'] = self.session_time
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('SessionTime') is not None:
            self.session_time = m.get('SessionTime')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class CreateSessionResponseBody(TeaModel):
    def __init__(
        self,
        ticket: str = None,
        request_id: str = None,
        session_id: str = None,
    ):
        self.ticket = ticket
        self.request_id = request_id
        self.session_id = session_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ticket is not None:
            result['Ticket'] = self.ticket
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ticket') is not None:
            self.ticket = m.get('Ticket')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        return self


class CreateSessionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSessionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSessionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAsrPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state = state
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state is not None:
            result['State'] = self.state
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue_name: str = None,
        topic: str = None,
    ):
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListAsrPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = ListAsrPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListAsrPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListAsrPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListAsrPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListAsrPipelineResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        pipeline_list: ListAsrPipelineResponseBodyPipelineList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.pipeline_list = pipeline_list

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PipelineList') is not None:
            temp_model = ListAsrPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        return self


class ListAsrPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAsrPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAsrPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        next_page_token: str = None,
        maximum_page_size: int = None,
        state: str = None,
        start_of_job_created_time_range: str = None,
        end_of_job_created_time_range: str = None,
        pipeline_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.next_page_token = next_page_token
        self.maximum_page_size = maximum_page_size
        self.state = state
        self.start_of_job_created_time_range = start_of_job_created_time_range
        self.end_of_job_created_time_range = end_of_job_created_time_range
        self.pipeline_id = pipeline_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.state is not None:
            result['State'] = self.state
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ListJobResponseBodyJobListJobOutputVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class ListJobResponseBodyJobListJobOutputVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: ListJobResponseBodyJobListJobOutputVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
        reso_priority: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode
        self.reso_priority = reso_priority

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        return self


class ListJobResponseBodyJobListJobOutputTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        trans_mode: str = None,
        is_check_reso: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.trans_mode = trans_mode
        self.is_check_reso = is_check_reso
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class ListJobResponseBodyJobListJobOutputEncryption(TeaModel):
    def __init__(
        self,
        type: str = None,
        key: str = None,
        key_type: str = None,
        id: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
    ):
        self.type = type
        self.key = key
        self.key_type = key_type
        self.id = id
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.id is not None:
            result['Id'] = self.id
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        refer_pos: str = None,
        dx: str = None,
        width: str = None,
        height: str = None,
        input_file: ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile = None,
        water_mark_template_id: str = None,
        dy: str = None,
    ):
        self.type = type
        self.refer_pos = refer_pos
        self.dx = dx
        self.width = width
        self.height = height
        self.input_file = input_file
        self.water_mark_template_id = water_mark_template_id
        self.dy = dy

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.dy is not None:
            result['Dy'] = self.dy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        return self


class ListJobResponseBodyJobListJobOutputWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = ListJobResponseBodyJobListJobOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        size_support: bool = None,
        md_5support: bool = None,
    ):
        self.size_support = size_support
        self.md_5support = md_5support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        return self


class ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class ListJobResponseBodyJobListJobOutputAudioVolume(TeaModel):
    def __init__(
        self,
        method: str = None,
        level: str = None,
    ):
        self.method = method
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class ListJobResponseBodyJobListJobOutputAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        volume: ListJobResponseBodyJobListJobOutputAudioVolume = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.volume = volume
        self.bitrate = bitrate

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Volume') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class ListJobResponseBodyJobListJobOutputMergeListMerge(TeaModel):
    def __init__(
        self,
        start: str = None,
        role_arn: str = None,
        merge_url: str = None,
        duration: str = None,
    ):
        self.start = start
        self.role_arn = role_arn
        self.merge_url = merge_url
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobResponseBodyJobListJobOutputMergeList(TeaModel):
    def __init__(
        self,
        merge: List[ListJobResponseBodyJobListJobOutputMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = ListJobResponseBodyJobListJobOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
        out_subtitle_file: ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile = None,
        success: bool = None,
        message: str = None,
    ):
        self.map = map
        self.out_subtitle_file = out_subtitle_file
        self.success = success
        self.message = message

    def validate(self):
        if self.out_subtitle_file:
            self.out_subtitle_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        if self.out_subtitle_file is not None:
            result['OutSubtitleFile'] = self.out_subtitle_file.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        if m.get('OutSubtitleFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile()
            self.out_subtitle_file = temp_model.from_map(m['OutSubtitleFile'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ListJobResponseBodyJobListJobOutputOutSubtitleList(TeaModel):
    def __init__(
        self,
        out_subtitle: List[ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle] = None,
    ):
        self.out_subtitle = out_subtitle

    def validate(self):
        if self.out_subtitle:
            for k in self.out_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutSubtitle'] = []
        if self.out_subtitle is not None:
            for k in self.out_subtitle:
                result['OutSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.out_subtitle = []
        if m.get('OutSubtitle') is not None:
            for k in m.get('OutSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleListOutSubtitle()
                self.out_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputOutputFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListJobResponseBodyJobListJobOutputContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListJobResponseBodyJobListJobOutputClipTimeSpan(TeaModel):
    def __init__(
        self,
        seek: str = None,
        duration: str = None,
    ):
        self.seek = seek
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seek is not None:
            result['Seek'] = self.seek
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobResponseBodyJobListJobOutputClip(TeaModel):
    def __init__(
        self,
        time_span: ListJobResponseBodyJobListJobOutputClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class ListJobResponseBodyJobListJobOutputOpeningListOpening(TeaModel):
    def __init__(
        self,
        open_url: str = None,
        start: str = None,
        width: str = None,
        height: str = None,
    ):
        self.open_url = open_url
        self.start = start
        self.width = width
        self.height = height

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_url is not None:
            result['openUrl'] = self.open_url
        if self.start is not None:
            result['Start'] = self.start
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('openUrl') is not None:
            self.open_url = m.get('openUrl')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        return self


class ListJobResponseBodyJobListJobOutputOpeningList(TeaModel):
    def __init__(
        self,
        opening: List[ListJobResponseBodyJobListJobOutputOpeningListOpening] = None,
    ):
        self.opening = opening

    def validate(self):
        if self.opening:
            for k in self.opening:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Opening'] = []
        if self.opening is not None:
            for k in self.opening:
                result['Opening'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.opening = []
        if m.get('Opening') is not None:
            for k in m.get('Opening'):
                temp_model = ListJobResponseBodyJobListJobOutputOpeningListOpening()
                self.opening.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigWebp(TeaModel):
    def __init__(
        self,
        loop: str = None,
    ):
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListJobResponseBodyJobListJobOutputMuxConfig(TeaModel):
    def __init__(
        self,
        webp: ListJobResponseBodyJobListJobOutputMuxConfigWebp = None,
        gif: ListJobResponseBodyJobListJobOutputMuxConfigGif = None,
        segment: ListJobResponseBodyJobListJobOutputMuxConfigSegment = None,
    ):
        self.webp = webp
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.webp:
            self.webp.validate()
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Webp') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        if m.get('Gif') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class ListJobResponseBodyJobListJobOutputTailSlateListTailSlate(TeaModel):
    def __init__(
        self,
        start: str = None,
        bg_color: str = None,
        is_merge_audio: bool = None,
        width: str = None,
        height: str = None,
        blend_duration: str = None,
        tail_url: str = None,
    ):
        self.start = start
        self.bg_color = bg_color
        self.is_merge_audio = is_merge_audio
        self.width = width
        self.height = height
        self.blend_duration = blend_duration
        self.tail_url = tail_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.is_merge_audio is not None:
            result['IsMergeAudio'] = self.is_merge_audio
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.blend_duration is not None:
            result['BlendDuration'] = self.blend_duration
        if self.tail_url is not None:
            result['TailUrl'] = self.tail_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('IsMergeAudio') is not None:
            self.is_merge_audio = m.get('IsMergeAudio')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('BlendDuration') is not None:
            self.blend_duration = m.get('BlendDuration')
        if m.get('TailUrl') is not None:
            self.tail_url = m.get('TailUrl')
        return self


class ListJobResponseBodyJobListJobOutputTailSlateList(TeaModel):
    def __init__(
        self,
        tail_slate: List[ListJobResponseBodyJobListJobOutputTailSlateListTailSlate] = None,
    ):
        self.tail_slate = tail_slate

    def validate(self):
        if self.tail_slate:
            for k in self.tail_slate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TailSlate'] = []
        if self.tail_slate is not None:
            for k in self.tail_slate:
                result['TailSlate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tail_slate = []
        if m.get('TailSlate') is not None:
            for k in m.get('TailSlate'):
                temp_model = ListJobResponseBodyJobListJobOutputTailSlateListTailSlate()
                self.tail_slate.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList = None,
        subtitle_list: ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        preload_time: str = None,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
    ):
        self.preload_time = preload_time
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        timebase: str = None,
        avg_fps: str = None,
        pix_fmt: str = None,
        sar: str = None,
        lang: str = None,
        codec_long_name: str = None,
        height: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        has_bframes: str = None,
        profile: str = None,
        start_time: str = None,
        network_cost: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        dar: str = None,
        codec_name: str = None,
        width: str = None,
        duration: str = None,
        fps: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
        level: str = None,
    ):
        self.index = index
        self.timebase = timebase
        self.avg_fps = avg_fps
        self.pix_fmt = pix_fmt
        self.sar = sar
        self.lang = lang
        self.codec_long_name = codec_long_name
        self.height = height
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.has_bframes = has_bframes
        self.profile = profile
        self.start_time = start_time
        self.network_cost = network_cost
        self.dar = dar
        self.codec_name = codec_name
        self.width = width
        self.duration = duration
        self.fps = fps
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base
        self.level = level

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.height is not None:
            result['Height'] = self.height
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NetworkCost') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        timebase: str = None,
        index: str = None,
        sample_fmt: str = None,
        channel_layout: str = None,
        lang: str = None,
        samplerate: str = None,
        codec_long_name: str = None,
        channels: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        start_time: str = None,
        codec_name: str = None,
        duration: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
    ):
        self.timebase = timebase
        self.index = index
        self.sample_fmt = sample_fmt
        self.channel_layout = channel_layout
        self.lang = lang
        self.samplerate = samplerate
        self.codec_long_name = codec_long_name
        self.channels = channels
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.start_time = start_time
        self.codec_name = codec_name
        self.duration = duration
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.index is not None:
            result['Index'] = self.index
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class ListJobResponseBodyJobListJobOutputPropertiesStreams(TeaModel):
    def __init__(
        self,
        video_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList = None,
        audio_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList = None,
    ):
        self.video_stream_list = video_stream_list
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list

    def validate(self):
        if self.video_stream_list:
            self.video_stream_list.validate()
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        if m.get('AudioStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        return self


class ListJobResponseBodyJobListJobOutputPropertiesFormat(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        num_programs: str = None,
        size: str = None,
        num_streams: str = None,
        format_long_name: str = None,
        duration: str = None,
        bitrate: str = None,
        format_name: str = None,
    ):
        self.start_time = start_time
        self.num_programs = num_programs
        self.size = size
        self.num_streams = num_streams
        self.format_long_name = format_long_name
        self.duration = duration
        self.bitrate = bitrate
        self.format_name = format_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.size is not None:
            result['Size'] = self.size
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        return self


class ListJobResponseBodyJobListJobOutputProperties(TeaModel):
    def __init__(
        self,
        width: str = None,
        height: str = None,
        duration: str = None,
        fps: str = None,
        bitrate: str = None,
        file_format: str = None,
        streams: ListJobResponseBodyJobListJobOutputPropertiesStreams = None,
        format: ListJobResponseBodyJobListJobOutputPropertiesFormat = None,
        file_size: str = None,
    ):
        self.width = width
        self.height = height
        self.duration = duration
        self.fps = fps
        self.bitrate = bitrate
        self.file_format = file_format
        self.streams = streams
        self.format = format
        self.file_size = file_size

    def validate(self):
        if self.streams:
            self.streams.validate()
        if self.format:
            self.format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Streams') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Format') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class ListJobResponseBodyJobListJobOutput(TeaModel):
    def __init__(
        self,
        video: ListJobResponseBodyJobListJobOutputVideo = None,
        trans_config: ListJobResponseBodyJobListJobOutputTransConfig = None,
        encryption: ListJobResponseBodyJobListJobOutputEncryption = None,
        water_mark_list: ListJobResponseBodyJobListJobOutputWaterMarkList = None,
        water_mark_config_url: str = None,
        de_watermark: str = None,
        m_3u8non_standard_support: ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport = None,
        priority: str = None,
        audio: ListJobResponseBodyJobListJobOutputAudio = None,
        audio_stream_map: str = None,
        merge_list: ListJobResponseBodyJobListJobOutputMergeList = None,
        super_reso: ListJobResponseBodyJobListJobOutputSuperReso = None,
        user_data: str = None,
        out_subtitle_list: ListJobResponseBodyJobListJobOutputOutSubtitleList = None,
        video_stream_map: str = None,
        output_file: ListJobResponseBodyJobListJobOutputOutputFile = None,
        rotate: str = None,
        container: ListJobResponseBodyJobListJobOutputContainer = None,
        clip: ListJobResponseBodyJobListJobOutputClip = None,
        merge_config_url: str = None,
        opening_list: ListJobResponseBodyJobListJobOutputOpeningList = None,
        mux_config: ListJobResponseBodyJobListJobOutputMuxConfig = None,
        tail_slate_list: ListJobResponseBodyJobListJobOutputTailSlateList = None,
        template_id: str = None,
        subtitle_config: ListJobResponseBodyJobListJobOutputSubtitleConfig = None,
        properties: ListJobResponseBodyJobListJobOutputProperties = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.encryption = encryption
        self.water_mark_list = water_mark_list
        self.water_mark_config_url = water_mark_config_url
        self.de_watermark = de_watermark
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.priority = priority
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.merge_list = merge_list
        self.super_reso = super_reso
        self.user_data = user_data
        self.out_subtitle_list = out_subtitle_list
        self.video_stream_map = video_stream_map
        self.output_file = output_file
        self.rotate = rotate
        self.container = container
        self.clip = clip
        self.merge_config_url = merge_config_url
        self.opening_list = opening_list
        self.mux_config = mux_config
        self.tail_slate_list = tail_slate_list
        self.template_id = template_id
        self.subtitle_config = subtitle_config
        self.properties = properties

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.encryption:
            self.encryption.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.audio:
            self.audio.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.out_subtitle_list:
            self.out_subtitle_list.validate()
        if self.output_file:
            self.output_file.validate()
        if self.container:
            self.container.validate()
        if self.clip:
            self.clip.validate()
        if self.opening_list:
            self.opening_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.tail_slate_list:
            self.tail_slate_list.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.out_subtitle_list is not None:
            result['OutSubtitleList'] = self.out_subtitle_list.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.opening_list is not None:
            result['OpeningList'] = self.opening_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.tail_slate_list is not None:
            result['TailSlateList'] = self.tail_slate_list.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Encryption') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('WaterMarkList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Audio') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('MergeList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('SuperReso') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('OutSubtitleList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutSubtitleList()
            self.out_subtitle_list = temp_model.from_map(m['OutSubtitleList'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('OutputFile') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Container') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Clip') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('OpeningList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputOpeningList()
            self.opening_list = temp_model.from_map(m['OpeningList'])
        if m.get('MuxConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('TailSlateList') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputTailSlateList()
            self.tail_slate_list = temp_model.from_map(m['TailSlateList'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('SubtitleConfig') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('Properties') is not None:
            temp_model = ListJobResponseBodyJobListJobOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        return self


class ListJobResponseBodyJobListJobInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListJobResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListJobResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        finish_time: str = None,
        state: str = None,
        job_id: str = None,
        code: str = None,
        message: str = None,
        output: ListJobResponseBodyJobListJobOutput = None,
        pipeline_id: str = None,
        input: ListJobResponseBodyJobListJobInput = None,
        mnsmessage_result: ListJobResponseBodyJobListJobMNSMessageResult = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.code = code
        self.message = message
        self.output = output
        self.pipeline_id = pipeline_id
        self.input = input
        self.mnsmessage_result = mnsmessage_result

    def validate(self):
        if self.output:
            self.output.validate()
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            temp_model = ListJobResponseBodyJobListJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Input') is not None:
            temp_model = ListJobResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('MNSMessageResult') is not None:
            temp_model = ListJobResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        return self


class ListJobResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[ListJobResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = ListJobResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        next_page_token: str = None,
        job_list: ListJobResponseBodyJobList = None,
    ):
        self.request_id = request_id
        self.next_page_token = next_page_token
        self.job_list = job_list

    def validate(self):
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('JobList') is not None:
            temp_model = ListJobResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryIProductionJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        iproduction_job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.iproduction_job_ids = iproduction_job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.iproduction_job_ids is not None:
            result['IProductionJobIds'] = self.iproduction_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('IProductionJobIds') is not None:
            self.iproduction_job_ids = m.get('IProductionJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryIProductionJobListResponseBodyJobs(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryIProductionJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryIProductionJobListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        jobs: QueryIProductionJobListResponseBodyJobs = None,
        next_page_token: str = None,
        non_exist_ids: QueryIProductionJobListResponseBodyNonExistIds = None,
    ):
        self.request_id = request_id
        self.jobs = jobs
        self.next_page_token = next_page_token
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.jobs:
            self.jobs.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Jobs') is not None:
            temp_model = QueryIProductionJobListResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NonExistIds') is not None:
            temp_model = QueryIProductionJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryIProductionJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryIProductionJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryIProductionJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateMediaPublishStateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        media_id: str = None,
        publish: bool = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.media_id = media_id
        self.publish = publish
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.publish is not None:
            result['Publish'] = self.publish
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Publish') is not None:
            self.publish = m.get('Publish')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UpdateMediaPublishStateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateMediaPublishStateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateMediaPublishStateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateMediaPublishStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFpFileDeleteJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        pipeline_id: str = None,
        fp_dbid: str = None,
        user_data: str = None,
        file_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.pipeline_id = pipeline_id
        self.fp_dbid = fp_dbid
        self.user_data = user_data
        self.file_ids = file_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitFpFileDeleteJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class SubmitFpFileDeleteJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitFpFileDeleteJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFpFileDeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAnalysisJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        analysis_job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.analysis_job_ids = analysis_job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.analysis_job_ids is not None:
            result['AnalysisJobIds'] = self.analysis_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('AnalysisJobIds') is not None:
            self.analysis_job_ids = m.get('AnalysisJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl(TeaModel):
    def __init__(
        self,
        method_streaming: str = None,
        rate_quality: str = None,
    ):
        self.method_streaming = method_streaming
        self.rate_quality = rate_quality

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_streaming is not None:
            result['MethodStreaming'] = self.method_streaming
        if self.rate_quality is not None:
            result['RateQuality'] = self.rate_quality
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MethodStreaming') is not None:
            self.method_streaming = m.get('MethodStreaming')
        if m.get('RateQuality') is not None:
            self.rate_quality = m.get('RateQuality')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop(TeaModel):
    def __init__(
        self,
        top: str = None,
        width: str = None,
        height: str = None,
        left: str = None,
        mode: str = None,
    ):
        self.top = top
        self.width = width
        self.height = height
        self.left = left
        self.mode = mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.top is not None:
            result['Top'] = self.top
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.left is not None:
            result['Left'] = self.left
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Top') is not None:
            self.top = m.get('Top')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl(TeaModel):
    def __init__(
        self,
        deinterlace: str = None,
        crop: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop = None,
    ):
        self.deinterlace = deinterlace
        self.crop = crop

    def validate(self):
        if self.crop:
            self.crop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deinterlace is not None:
            result['Deinterlace'] = self.deinterlace
        if self.crop is not None:
            result['Crop'] = self.crop.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Deinterlace') is not None:
            self.deinterlace = m.get('Deinterlace')
        if m.get('Crop') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControlCrop()
            self.crop = temp_model.from_map(m['Crop'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig(TeaModel):
    def __init__(
        self,
        quality_control: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl = None,
        properties_control: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl = None,
    ):
        self.quality_control = quality_control
        self.properties_control = properties_control

    def validate(self):
        if self.quality_control:
            self.quality_control.validate()
        if self.properties_control:
            self.properties_control.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quality_control is not None:
            result['QualityControl'] = self.quality_control.to_map()
        if self.properties_control is not None:
            result['PropertiesControl'] = self.properties_control.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QualityControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigQualityControl()
            self.quality_control = temp_model.from_map(m['QualityControl'])
        if m.get('PropertiesControl') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfigPropertiesControl()
            self.properties_control = temp_model.from_map(m['PropertiesControl'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd = None,
        pix_fmt: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        bitrate: str = None,
        maxrate: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig(TeaModel):
    def __init__(
        self,
        trans_mode: str = None,
    ):
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        loop: str = None,
    ):
        self.final_delay = final_delay
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif = None,
        segment: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.bitrate = bitrate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate(TeaModel):
    def __init__(
        self,
        video: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo = None,
        trans_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig = None,
        state: str = None,
        mux_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig = None,
        name: str = None,
        audio: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio = None,
        id: str = None,
        container: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.state = state
        self.mux_config = mux_config
        self.name = name
        self.audio = audio
        self.id = id
        self.container = container

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.container is not None:
            result['Container'] = self.container.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('MuxConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Audio') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Container') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList(TeaModel):
    def __init__(
        self,
        template: List[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        state: str = None,
        analysis_config: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig = None,
        message: str = None,
        priority: str = None,
        mnsmessage_result: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult = None,
        template_list: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList = None,
        user_data: str = None,
        code: str = None,
        input_file: QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile = None,
        pipeline_id: str = None,
        id: str = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.state = state
        self.analysis_config = analysis_config
        self.message = message
        self.priority = priority
        self.mnsmessage_result = mnsmessage_result
        self.template_list = template_list
        self.user_data = user_data
        self.code = code
        self.input_file = input_file
        self.pipeline_id = pipeline_id
        self.id = id

    def validate(self):
        if self.analysis_config:
            self.analysis_config.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.template_list:
            self.template_list.validate()
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.state is not None:
            result['State'] = self.state
        if self.analysis_config is not None:
            result['AnalysisConfig'] = self.analysis_config.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.code is not None:
            result['Code'] = self.code
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('AnalysisConfig') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobAnalysisConfig()
            self.analysis_config = temp_model.from_map(m['AnalysisConfig'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('TemplateList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InputFile') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJobInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryAnalysisJobListResponseBodyAnalysisJobList(TeaModel):
    def __init__(
        self,
        analysis_job: List[QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob] = None,
    ):
        self.analysis_job = analysis_job

    def validate(self):
        if self.analysis_job:
            for k in self.analysis_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnalysisJob'] = []
        if self.analysis_job is not None:
            for k in self.analysis_job:
                result['AnalysisJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.analysis_job = []
        if m.get('AnalysisJob') is not None:
            for k in m.get('AnalysisJob'):
                temp_model = QueryAnalysisJobListResponseBodyAnalysisJobListAnalysisJob()
                self.analysis_job.append(temp_model.from_map(k))
        return self


class QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAnalysisJobListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        analysis_job_list: QueryAnalysisJobListResponseBodyAnalysisJobList = None,
        non_exist_analysis_job_ids: QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds = None,
    ):
        self.request_id = request_id
        self.analysis_job_list = analysis_job_list
        self.non_exist_analysis_job_ids = non_exist_analysis_job_ids

    def validate(self):
        if self.analysis_job_list:
            self.analysis_job_list.validate()
        if self.non_exist_analysis_job_ids:
            self.non_exist_analysis_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.analysis_job_list is not None:
            result['AnalysisJobList'] = self.analysis_job_list.to_map()
        if self.non_exist_analysis_job_ids is not None:
            result['NonExistAnalysisJobIds'] = self.non_exist_analysis_job_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AnalysisJobList') is not None:
            temp_model = QueryAnalysisJobListResponseBodyAnalysisJobList()
            self.analysis_job_list = temp_model.from_map(m['AnalysisJobList'])
        if m.get('NonExistAnalysisJobIds') is not None:
            temp_model = QueryAnalysisJobListResponseBodyNonExistAnalysisJobIds()
            self.non_exist_analysis_job_ids = temp_model.from_map(m['NonExistAnalysisJobIds'])
        return self


class QueryAnalysisJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAnalysisJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAnalysisJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitInferenceJobRequest(TeaModel):
    def __init__(
        self,
        server_name: str = None,
        model_type: str = None,
        input: str = None,
    ):
        self.server_name = server_name
        self.model_type = model_type
        self.input = input

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.server_name is not None:
            result['ServerName'] = self.server_name
        if self.model_type is not None:
            result['ModelType'] = self.model_type
        if self.input is not None:
            result['Input'] = self.input
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServerName') is not None:
            self.server_name = m.get('ServerName')
        if m.get('ModelType') is not None:
            self.model_type = m.get('ModelType')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        return self


class SubmitInferenceJobResponseBody(TeaModel):
    def __init__(
        self,
        test_id: str = None,
        message: str = None,
        request_id: str = None,
        code: str = None,
        job_id: str = None,
    ):
        self.test_id = test_id
        self.message = message
        self.request_id = request_id
        self.code = code
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.test_id is not None:
            result['TestId'] = self.test_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TestId') is not None:
            self.test_id = m.get('TestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class SubmitInferenceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitInferenceJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitInferenceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportCensorJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        label: str = None,
        detail: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.label = label
        self.detail = detail
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.label is not None:
            result['Label'] = self.label
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportCensorJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportCensorJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportCensorJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportCensorJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMcuJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        job_ids: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.job_ids = job_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        return self


class DeleteMcuJobResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class DeleteMcuJobResponseBodyDeletedJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class DeleteMcuJobResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_job_ids: DeleteMcuJobResponseBodyNonExistJobIds = None,
        request_id: str = None,
        deleted_job_ids: DeleteMcuJobResponseBodyDeletedJobIds = None,
    ):
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id
        self.deleted_job_ids = deleted_job_ids

    def validate(self):
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()
        if self.deleted_job_ids:
            self.deleted_job_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.deleted_job_ids is not None:
            result['DeletedJobIds'] = self.deleted_job_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistJobIds') is not None:
            temp_model = DeleteMcuJobResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeletedJobIds') is not None:
            temp_model = DeleteMcuJobResponseBodyDeletedJobIds()
            self.deleted_job_ids = temp_model.from_map(m['DeletedJobIds'])
        return self


class DeleteMcuJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMcuJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMcuJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryInferenceServerRequest(TeaModel):
    def __init__(
        self,
        model_type: str = None,
        create_time: int = None,
        page_number: int = None,
        max_page_size: int = None,
    ):
        self.model_type = model_type
        self.create_time = create_time
        self.page_number = page_number
        self.max_page_size = max_page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_type is not None:
            result['ModelType'] = self.model_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.max_page_size is not None:
            result['MaxPageSize'] = self.max_page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelType') is not None:
            self.model_type = m.get('ModelType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('MaxPageSize') is not None:
            self.max_page_size = m.get('MaxPageSize')
        return self


class QueryInferenceServerResponseBodyFunctions(TeaModel):
    def __init__(
        self,
        function_name: str = None,
        create_time: int = None,
        user_id: int = None,
        model_type: str = None,
        model_path: str = None,
        pipeline_id: str = None,
        test_id: str = None,
    ):
        self.function_name = function_name
        self.create_time = create_time
        self.user_id = user_id
        self.model_type = model_type
        self.model_path = model_path
        self.pipeline_id = pipeline_id
        self.test_id = test_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.model_type is not None:
            result['ModelType'] = self.model_type
        if self.model_path is not None:
            result['ModelPath'] = self.model_path
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.test_id is not None:
            result['TestId'] = self.test_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ModelType') is not None:
            self.model_type = m.get('ModelType')
        if m.get('ModelPath') is not None:
            self.model_path = m.get('ModelPath')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('TestId') is not None:
            self.test_id = m.get('TestId')
        return self


class QueryInferenceServerResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        functions: List[QueryInferenceServerResponseBodyFunctions] = None,
        code: str = None,
        total_size: int = None,
    ):
        self.message = message
        self.request_id = request_id
        self.functions = functions
        self.code = code
        self.total_size = total_size

    def validate(self):
        if self.functions:
            for k in self.functions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Functions'] = []
        if self.functions is not None:
            for k in self.functions:
                result['Functions'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.functions = []
        if m.get('Functions') is not None:
            for k in m.get('Functions'):
                temp_model = QueryInferenceServerResponseBodyFunctions()
                self.functions.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class QueryInferenceServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryInferenceServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryInferenceServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckResourceRequest(TeaModel):
    def __init__(
        self,
        interrupt: bool = None,
        invoker: str = None,
        pk: str = None,
        bid: str = None,
        hid: int = None,
        country: str = None,
        task_identifier: str = None,
        task_extra_data: str = None,
        gmt_wakeup: str = None,
        success: bool = None,
        message: str = None,
        level: int = None,
        url: str = None,
        prompt: str = None,
    ):
        self.interrupt = interrupt
        self.invoker = invoker
        self.pk = pk
        self.bid = bid
        self.hid = hid
        self.country = country
        self.task_identifier = task_identifier
        self.task_extra_data = task_extra_data
        self.gmt_wakeup = gmt_wakeup
        self.success = success
        self.message = message
        self.level = level
        self.url = url
        self.prompt = prompt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.country is not None:
            result['Country'] = self.country
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.success is not None:
            result['Success'] = self.success
        if self.message is not None:
            result['Message'] = self.message
        if self.level is not None:
            result['Level'] = self.level
        if self.url is not None:
            result['Url'] = self.url
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        return self


class CheckResourceResponseBody(TeaModel):
    def __init__(
        self,
        gmt_wakeup: str = None,
        hid: int = None,
        message: str = None,
        task_identifier: str = None,
        success: bool = None,
        url: str = None,
        interrupt: bool = None,
        invoker: str = None,
        task_extra_data: str = None,
        country: str = None,
        prompt: str = None,
        level: int = None,
        pk: str = None,
        bid: str = None,
    ):
        self.gmt_wakeup = gmt_wakeup
        self.hid = hid
        self.message = message
        self.task_identifier = task_identifier
        self.success = success
        self.url = url
        self.interrupt = interrupt
        self.invoker = invoker
        self.task_extra_data = task_extra_data
        self.country = country
        self.prompt = prompt
        self.level = level
        self.pk = pk
        self.bid = bid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_wakeup is not None:
            result['GmtWakeup'] = self.gmt_wakeup
        if self.hid is not None:
            result['Hid'] = self.hid
        if self.message is not None:
            result['Message'] = self.message
        if self.task_identifier is not None:
            result['TaskIdentifier'] = self.task_identifier
        if self.success is not None:
            result['Success'] = self.success
        if self.url is not None:
            result['Url'] = self.url
        if self.interrupt is not None:
            result['Interrupt'] = self.interrupt
        if self.invoker is not None:
            result['Invoker'] = self.invoker
        if self.task_extra_data is not None:
            result['TaskExtraData'] = self.task_extra_data
        if self.country is not None:
            result['Country'] = self.country
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.level is not None:
            result['Level'] = self.level
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.bid is not None:
            result['Bid'] = self.bid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtWakeup') is not None:
            self.gmt_wakeup = m.get('GmtWakeup')
        if m.get('Hid') is not None:
            self.hid = m.get('Hid')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TaskIdentifier') is not None:
            self.task_identifier = m.get('TaskIdentifier')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Interrupt') is not None:
            self.interrupt = m.get('Interrupt')
        if m.get('Invoker') is not None:
            self.invoker = m.get('Invoker')
        if m.get('TaskExtraData') is not None:
            self.task_extra_data = m.get('TaskExtraData')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        return self


class CheckResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTerrorismPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state = state
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state is not None:
            result['State'] = self.state
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        topic: str = None,
        queue: str = None,
    ):
        self.topic = topic
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class ListTerrorismPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = ListTerrorismPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListTerrorismPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListTerrorismPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListTerrorismPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListTerrorismPipelineResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        pipeline_list: ListTerrorismPipelineResponseBodyPipelineList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.pipeline_list = pipeline_list

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PipelineList') is not None:
            temp_model = ListTerrorismPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        return self


class ListTerrorismPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTerrorismPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTerrorismPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportTerrorismJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        label: str = None,
        detail: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.label = label
        self.detail = detail
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.label is not None:
            result['Label'] = self.label
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportTerrorismJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportTerrorismJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportTerrorismJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportTerrorismJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllMediaBucketRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        next_page_token: str = None,
        maximum_page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.next_page_token = next_page_token
        self.maximum_page_size = maximum_page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        return self


class ListAllMediaBucketResponseBodyMediaBucketListMediaBucket(TeaModel):
    def __init__(
        self,
        type: str = None,
        bucket: str = None,
    ):
        self.type = type
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class ListAllMediaBucketResponseBodyMediaBucketList(TeaModel):
    def __init__(
        self,
        media_bucket: List[ListAllMediaBucketResponseBodyMediaBucketListMediaBucket] = None,
    ):
        self.media_bucket = media_bucket

    def validate(self):
        if self.media_bucket:
            for k in self.media_bucket:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaBucket'] = []
        if self.media_bucket is not None:
            for k in self.media_bucket:
                result['MediaBucket'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_bucket = []
        if m.get('MediaBucket') is not None:
            for k in m.get('MediaBucket'):
                temp_model = ListAllMediaBucketResponseBodyMediaBucketListMediaBucket()
                self.media_bucket.append(temp_model.from_map(k))
        return self


class ListAllMediaBucketResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        next_page_token: str = None,
        media_bucket_list: ListAllMediaBucketResponseBodyMediaBucketList = None,
    ):
        self.request_id = request_id
        self.next_page_token = next_page_token
        self.media_bucket_list = media_bucket_list

    def validate(self):
        if self.media_bucket_list:
            self.media_bucket_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.media_bucket_list is not None:
            result['MediaBucketList'] = self.media_bucket_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MediaBucketList') is not None:
            temp_model = ListAllMediaBucketResponseBodyMediaBucketList()
            self.media_bucket_list = temp_model.from_map(m['MediaBucketList'])
        return self


class ListAllMediaBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAllMediaBucketResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAllMediaBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SearchPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state = state
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state is not None:
            result['State'] = self.state
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SearchPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        mq_topic: str = None,
        queue_name: str = None,
        mq_tag: str = None,
        topic: str = None,
    ):
        self.mq_topic = mq_topic
        self.queue_name = queue_name
        self.mq_tag = mq_tag
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mq_topic is not None:
            result['MqTopic'] = self.mq_topic
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.mq_tag is not None:
            result['MqTag'] = self.mq_tag
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MqTopic') is not None:
            self.mq_topic = m.get('MqTopic')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('MqTag') is not None:
            self.mq_tag = m.get('MqTag')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class SearchPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        speed: str = None,
        state: str = None,
        speed_level: int = None,
        notify_config: SearchPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        role: str = None,
        name: str = None,
        id: str = None,
        quota_allocate: int = None,
    ):
        self.speed = speed
        self.state = state
        self.speed_level = speed_level
        self.notify_config = notify_config
        self.role = role
        self.name = name
        self.id = id
        self.quota_allocate = quota_allocate

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.state is not None:
            result['State'] = self.state
        if self.speed_level is not None:
            result['SpeedLevel'] = self.speed_level
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.role is not None:
            result['Role'] = self.role
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.quota_allocate is not None:
            result['QuotaAllocate'] = self.quota_allocate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('SpeedLevel') is not None:
            self.speed_level = m.get('SpeedLevel')
        if m.get('NotifyConfig') is not None:
            temp_model = SearchPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('QuotaAllocate') is not None:
            self.quota_allocate = m.get('QuotaAllocate')
        return self


class SearchPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[SearchPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = SearchPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class SearchPipelineResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        pipeline_list: SearchPipelineResponseBodyPipelineList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.pipeline_list = pipeline_list

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PipelineList') is not None:
            temp_model = SearchPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        return self


class SearchPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SearchPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SearchPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UnbindOutputBucketRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        bucket: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.bucket = bucket
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UnbindOutputBucketResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UnbindOutputBucketResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UnbindOutputBucketResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UnbindOutputBucketResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateMediaCategoryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        media_id: str = None,
        cate_id: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.media_id = media_id
        self.cate_id = cate_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UpdateMediaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateMediaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateMediaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateMediaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryComplexJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryComplexJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        is_check_reso: str = None,
        trans_mode: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        duration: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_reso = is_check_reso
        self.trans_mode = trans_mode
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.duration = duration
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption(TeaModel):
    def __init__(
        self,
        type: str = None,
        key: str = None,
        key_type: str = None,
        id: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
    ):
        self.type = type
        self.key = key
        self.key_type = key_type
        self.id = id
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.id is not None:
            result['Id'] = self.id
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        refer_pos: str = None,
        dx: str = None,
        width: str = None,
        height: str = None,
        input_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile = None,
        water_mark_template_id: str = None,
        dy: str = None,
    ):
        self.type = type
        self.refer_pos = refer_pos
        self.dx = dx
        self.width = width
        self.height = height
        self.input_file = input_file
        self.water_mark_template_id = water_mark_template_id
        self.dy = dy

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.dy is not None:
            result['Dy'] = self.dy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        size_support: bool = None,
        md_5support: bool = None,
    ):
        self.size_support = size_support
        self.md_5support = md_5support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume(TeaModel):
    def __init__(
        self,
        method: str = None,
        level: str = None,
    ):
        self.method = method
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        volume: QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.volume = volume
        self.bitrate = bitrate

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Volume') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge(TeaModel):
    def __init__(
        self,
        start: str = None,
        role_arn: str = None,
        merge_url: str = None,
        duration: str = None,
    ):
        self.start = start
        self.role_arn = role_arn
        self.merge_url = merge_url
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList(TeaModel):
    def __init__(
        self,
        merge: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        alpha: str = None,
        input_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile = None,
    ):
        self.type = type
        self.alpha = alpha
        self.input_file = input_file

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.alpha is not None:
            result['Alpha'] = self.alpha
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Alpha') is not None:
            self.alpha = m.get('Alpha')
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan(TeaModel):
    def __init__(
        self,
        seek: str = None,
        duration: str = None,
    ):
        self.seek = seek
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seek is not None:
            result['Seek'] = self.seek
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip(TeaModel):
    def __init__(
        self,
        time_span: QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif = None,
        segment: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList = None,
        subtitle_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        preload_time: str = None,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
    ):
        self.preload_time = preload_time
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        timebase: str = None,
        avg_fps: str = None,
        pix_fmt: str = None,
        sar: str = None,
        lang: str = None,
        codec_long_name: str = None,
        height: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        has_bframes: str = None,
        profile: str = None,
        start_time: str = None,
        network_cost: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        dar: str = None,
        codec_name: str = None,
        width: str = None,
        duration: str = None,
        fps: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
        level: str = None,
    ):
        self.index = index
        self.timebase = timebase
        self.avg_fps = avg_fps
        self.pix_fmt = pix_fmt
        self.sar = sar
        self.lang = lang
        self.codec_long_name = codec_long_name
        self.height = height
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.has_bframes = has_bframes
        self.profile = profile
        self.start_time = start_time
        self.network_cost = network_cost
        self.dar = dar
        self.codec_name = codec_name
        self.width = width
        self.duration = duration
        self.fps = fps
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base
        self.level = level

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.height is not None:
            result['Height'] = self.height
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NetworkCost') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        timebase: str = None,
        index: str = None,
        sample_fmt: str = None,
        channel_layout: str = None,
        lang: str = None,
        samplerate: str = None,
        codec_long_name: str = None,
        channels: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        start_time: str = None,
        codec_name: str = None,
        duration: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
    ):
        self.timebase = timebase
        self.index = index
        self.sample_fmt = sample_fmt
        self.channel_layout = channel_layout
        self.lang = lang
        self.samplerate = samplerate
        self.codec_long_name = codec_long_name
        self.channels = channels
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.start_time = start_time
        self.codec_name = codec_name
        self.duration = duration
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.index is not None:
            result['Index'] = self.index
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams(TeaModel):
    def __init__(
        self,
        video_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList = None,
        audio_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList = None,
    ):
        self.video_stream_list = video_stream_list
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list

    def validate(self):
        if self.video_stream_list:
            self.video_stream_list.validate()
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        if m.get('AudioStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        num_programs: str = None,
        size: str = None,
        num_streams: str = None,
        format_long_name: str = None,
        duration: str = None,
        bitrate: str = None,
        format_name: str = None,
    ):
        self.start_time = start_time
        self.num_programs = num_programs
        self.size = size
        self.num_streams = num_streams
        self.format_long_name = format_long_name
        self.duration = duration
        self.bitrate = bitrate
        self.format_name = format_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.size is not None:
            result['Size'] = self.size
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties(TeaModel):
    def __init__(
        self,
        width: str = None,
        height: str = None,
        duration: str = None,
        fps: str = None,
        bitrate: str = None,
        file_format: str = None,
        streams: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams = None,
        format: QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat = None,
        file_size: str = None,
    ):
        self.width = width
        self.height = height
        self.duration = duration
        self.fps = fps
        self.bitrate = bitrate
        self.file_format = file_format
        self.streams = streams
        self.format = format
        self.file_size = file_size

    def validate(self):
        if self.streams:
            self.streams.validate()
        if self.format:
            self.format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Streams') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Format') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class QueryComplexJobListResponseBodyJobListJobTranscodeOutput(TeaModel):
    def __init__(
        self,
        video: QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo = None,
        trans_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig = None,
        encryption: QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption = None,
        water_mark_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList = None,
        de_watermark: str = None,
        water_mark_config_url: str = None,
        m_3u8non_standard_support: QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport = None,
        priority: str = None,
        audio: QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio = None,
        audio_stream_map: str = None,
        merge_list: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList = None,
        super_reso: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso = None,
        user_data: str = None,
        digi_water_mark: QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark = None,
        video_stream_map: str = None,
        output_file: QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile = None,
        rotate: str = None,
        container: QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer = None,
        clip: QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip = None,
        merge_config_url: str = None,
        mux_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig = None,
        template_id: str = None,
        subtitle_config: QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig = None,
        properties: QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.encryption = encryption
        self.water_mark_list = water_mark_list
        self.de_watermark = de_watermark
        self.water_mark_config_url = water_mark_config_url
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.priority = priority
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.merge_list = merge_list
        self.super_reso = super_reso
        self.user_data = user_data
        self.digi_water_mark = digi_water_mark
        self.video_stream_map = video_stream_map
        self.output_file = output_file
        self.rotate = rotate
        self.container = container
        self.clip = clip
        self.merge_config_url = merge_config_url
        self.mux_config = mux_config
        self.template_id = template_id
        self.subtitle_config = subtitle_config
        self.properties = properties

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.encryption:
            self.encryption.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.audio:
            self.audio.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.digi_water_mark:
            self.digi_water_mark.validate()
        if self.output_file:
            self.output_file.validate()
        if self.container:
            self.container.validate()
        if self.clip:
            self.clip.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.digi_water_mark is not None:
            result['DigiWaterMark'] = self.digi_water_mark.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Encryption') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('WaterMarkList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Audio') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('MergeList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('SuperReso') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('DigiWaterMark') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputDigiWaterMark()
            self.digi_water_mark = temp_model.from_map(m['DigiWaterMark'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('OutputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Container') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Clip') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MuxConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('Properties') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        return self


class QueryComplexJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo(TeaModel):
    def __init__(
        self,
        t: str = None,
        l: str = None,
    ):
        self.t = t
        self.l = l

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.t is not None:
            result['T'] = self.t
        if self.l is not None:
            result['L'] = self.l
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('T') is not None:
            self.t = m.get('T')
        if m.get('L') is not None:
            self.l = m.get('L')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig(TeaModel):
    def __init__(
        self,
        clips_config_video: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo = None,
    ):
        self.clips_config_video = clips_config_video

    def validate(self):
        if self.clips_config_video:
            self.clips_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config_video is not None:
            result['ClipsConfigVideo'] = self.clips_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfigVideo') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo()
            self.clips_config_video = temp_model.from_map(m['ClipsConfigVideo'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip(TeaModel):
    def __init__(
        self,
        clips_config: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig = None,
        out: str = None,
        in_: str = None,
        clip_id: str = None,
    ):
        self.clips_config = clips_config
        self.out = out
        self.in_ = in_
        self.clip_id = clip_id

    def validate(self):
        if self.clips_config:
            self.clips_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config is not None:
            result['ClipsConfig'] = self.clips_config.to_map()
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.clip_id is not None:
            result['clipID'] = self.clip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClipClipsConfig()
            self.clips_config = temp_model.from_map(m['ClipsConfig'])
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('clipID') is not None:
            self.clip_id = m.get('clipID')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips(TeaModel):
    def __init__(
        self,
        clip: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClipsClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack(TeaModel):
    def __init__(
        self,
        type: str = None,
        order: str = None,
        id: str = None,
        clips: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips = None,
    ):
        self.type = type
        self.order = order
        self.id = id
        self.clips = clips

    def validate(self):
        if self.clips:
            self.clips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.order is not None:
            result['Order'] = self.order
        if self.id is not None:
            result['Id'] = self.id
        if self.clips is not None:
            result['Clips'] = self.clips.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Clips') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrackClips()
            self.clips = temp_model.from_map(m['Clips'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList(TeaModel):
    def __init__(
        self,
        track: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack] = None,
    ):
        self.track = track

    def validate(self):
        if self.track:
            for k in self.track:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Track'] = []
        if self.track is not None:
            for k in self.track:
                result['Track'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track = []
        if m.get('Track') is not None:
            for k in m.get('Track'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackListTrack()
                self.track.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio(TeaModel):
    def __init__(
        self,
        channel_layout: str = None,
        samplerate: str = None,
        channels: str = None,
    ):
        self.channel_layout = channel_layout
        self.samplerate = samplerate
        self.channels = channels

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.channels is not None:
            result['Channels'] = self.channels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        width: str = None,
        render_ratio: str = None,
        is_gpu_data: str = None,
        height: str = None,
        is_one_track_data: str = None,
        fps: str = None,
        reclose_prec: str = None,
    ):
        self.bg_color = bg_color
        self.width = width
        self.render_ratio = render_ratio
        self.is_gpu_data = is_gpu_data
        self.height = height
        self.is_one_track_data = is_one_track_data
        self.fps = fps
        self.reclose_prec = reclose_prec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.width is not None:
            result['Width'] = self.width
        if self.render_ratio is not None:
            result['RenderRatio'] = self.render_ratio
        if self.is_gpu_data is not None:
            result['IsGpuData'] = self.is_gpu_data
        if self.height is not None:
            result['Height'] = self.height
        if self.is_one_track_data is not None:
            result['IsOneTrackData'] = self.is_one_track_data
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.reclose_prec is not None:
            result['ReclosePrec'] = self.reclose_prec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('RenderRatio') is not None:
            self.render_ratio = m.get('RenderRatio')
        if m.get('IsGpuData') is not None:
            self.is_gpu_data = m.get('IsGpuData')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsOneTrackData') is not None:
            self.is_one_track_data = m.get('IsOneTrackData')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('ReclosePrec') is not None:
            self.reclose_prec = m.get('ReclosePrec')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig(TeaModel):
    def __init__(
        self,
        timeline_config_audio: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio = None,
        timeline_config_video: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo = None,
    ):
        self.timeline_config_audio = timeline_config_audio
        self.timeline_config_video = timeline_config_video

    def validate(self):
        if self.timeline_config_audio:
            self.timeline_config_audio.validate()
        if self.timeline_config_video:
            self.timeline_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config_audio is not None:
            result['TimelineConfigAudio'] = self.timeline_config_audio.to_map()
        if self.timeline_config_video is not None:
            result['TimelineConfigVideo'] = self.timeline_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfigAudio') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigAudio()
            self.timeline_config_audio = temp_model.from_map(m['TimelineConfigAudio'])
        if m.get('TimelineConfigVideo') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfigTimelineConfigVideo()
            self.timeline_config_video = temp_model.from_map(m['TimelineConfigVideo'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline(TeaModel):
    def __init__(
        self,
        track_list: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList = None,
        timeline_config: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig = None,
    ):
        self.track_list = track_list
        self.timeline_config = timeline_config

    def validate(self):
        if self.track_list:
            self.track_list.validate()
        if self.timeline_config:
            self.timeline_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.track_list is not None:
            result['TrackList'] = self.track_list.to_map()
        if self.timeline_config is not None:
            result['TimelineConfig'] = self.timeline_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TrackList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTrackList()
            self.track_list = temp_model.from_map(m['TrackList'])
        if m.get('TimelineConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimelineTimelineConfig()
            self.timeline_config = temp_model.from_map(m['TimelineConfig'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect(TeaModel):
    def __init__(
        self,
        effect: str = None,
        effect_config: str = None,
    ):
        self.effect = effect
        self.effect_config = effect_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('EffectConfig') is not None:
            self.effect_config = m.get('EffectConfig')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects(TeaModel):
    def __init__(
        self,
        effect: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect] = None,
    ):
        self.effect = effect

    def validate(self):
        if self.effect:
            for k in self.effect:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Effect'] = []
        if self.effect is not None:
            for k in self.effect:
                result['Effect'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effect = []
        if m.get('Effect') is not None:
            for k in m.get('Effect'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffectsEffect()
                self.effect.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip(TeaModel):
    def __init__(
        self,
        type: str = None,
        source_id: str = None,
        effects: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects = None,
        source_type: str = None,
        source_strm_map: str = None,
        out: str = None,
        in_: str = None,
        id: str = None,
    ):
        self.type = type
        self.source_id = source_id
        self.effects = effects
        self.source_type = source_type
        self.source_strm_map = source_strm_map
        self.out = out
        self.in_ = in_
        self.id = id

    def validate(self):
        if self.effects:
            self.effects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.source_id is not None:
            result['SourceID'] = self.source_id
        if self.effects is not None:
            result['Effects'] = self.effects.to_map()
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_strm_map is not None:
            result['SourceStrmMap'] = self.source_strm_map
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SourceID') is not None:
            self.source_id = m.get('SourceID')
        if m.get('Effects') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClipEffects()
            self.effects = temp_model.from_map(m['Effects'])
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceStrmMap') is not None:
            self.source_strm_map = m.get('SourceStrmMap')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList(TeaModel):
    def __init__(
        self,
        clip: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipListClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing(TeaModel):
    def __init__(
        self,
        timeline: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline = None,
        clip_list: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList = None,
    ):
        self.timeline = timeline
        self.clip_list = clip_list

    def validate(self):
        if self.timeline:
            self.timeline.validate()
        if self.clip_list:
            self.clip_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.clip_list is not None:
            result['ClipList'] = self.clip_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timeline') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('ClipList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditingClipList()
            self.clip_list = temp_model.from_map(m['ClipList'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs(TeaModel):
    def __init__(
        self,
        editing: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing = None,
    ):
        self.editing = editing

    def validate(self):
        if self.editing:
            self.editing.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing is not None:
            result['Editing'] = self.editing.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Editing') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigsEditing()
            self.editing = temp_model.from_map(m['Editing'])
        return self


class QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs(TeaModel):
    def __init__(
        self,
        complex_editing_configs: List[QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs] = None,
    ):
        self.complex_editing_configs = complex_editing_configs

    def validate(self):
        if self.complex_editing_configs:
            for k in self.complex_editing_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplexEditingConfigs'] = []
        if self.complex_editing_configs is not None:
            for k in self.complex_editing_configs:
                result['ComplexEditingConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.complex_editing_configs = []
        if m.get('ComplexEditingConfigs') is not None:
            for k in m.get('ComplexEditingConfigs'):
                temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigsComplexEditingConfigs()
                self.complex_editing_configs.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig(TeaModel):
    def __init__(
        self,
        is_normal_sar: str = None,
        deinterlace_method: str = None,
    ):
        self.is_normal_sar = is_normal_sar
        self.deinterlace_method = deinterlace_method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_normal_sar is not None:
            result['IsNormalSar'] = self.is_normal_sar
        if self.deinterlace_method is not None:
            result['DeinterlaceMethod'] = self.deinterlace_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsNormalSar') is not None:
            self.is_normal_sar = m.get('IsNormalSar')
        if m.get('DeinterlaceMethod') is not None:
            self.deinterlace_method = m.get('DeinterlaceMethod')
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput(TeaModel):
    def __init__(
        self,
        input_file: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile = None,
        input_config: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig = None,
        id: str = None,
    ):
        self.input_file = input_file
        self.input_config = input_config
        self.id = id

    def validate(self):
        if self.input_file:
            self.input_file.validate()
        if self.input_config:
            self.input_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('InputConfig') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInputInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs(TeaModel):
    def __init__(
        self,
        editing_input: List[QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput] = None,
    ):
        self.editing_input = editing_input

    def validate(self):
        if self.editing_input:
            for k in self.editing_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EditingInput'] = []
        if self.editing_input is not None:
            for k in self.editing_input:
                result['EditingInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.editing_input = []
        if m.get('EditingInput') is not None:
            for k in m.get('EditingInput'):
                temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputsEditingInput()
                self.editing_input.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJobInputsInputs(TeaModel):
    def __init__(
        self,
        editing_inputs: QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs = None,
    ):
        self.editing_inputs = editing_inputs

    def validate(self):
        if self.editing_inputs:
            self.editing_inputs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditingInputs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputsEditingInputs()
            self.editing_inputs = temp_model.from_map(m['EditingInputs'])
        return self


class QueryComplexJobListResponseBodyJobListJobInputs(TeaModel):
    def __init__(
        self,
        inputs: List[QueryComplexJobListResponseBodyJobListJobInputsInputs] = None,
    ):
        self.inputs = inputs

    def validate(self):
        if self.inputs:
            for k in self.inputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inputs'] = []
        if self.inputs is not None:
            for k in self.inputs:
                result['Inputs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inputs = []
        if m.get('Inputs') is not None:
            for k in m.get('Inputs'):
                temp_model = QueryComplexJobListResponseBodyJobListJobInputsInputs()
                self.inputs.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        finish_time: str = None,
        state: str = None,
        transcode_output: QueryComplexJobListResponseBodyJobListJobTranscodeOutput = None,
        message: str = None,
        mnsmessage_result: QueryComplexJobListResponseBodyJobListJobMNSMessageResult = None,
        complex_editing_configs: QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs = None,
        inputs: QueryComplexJobListResponseBodyJobListJobInputs = None,
        job_id: str = None,
        code: str = None,
        pipeline_id: str = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.finish_time = finish_time
        self.state = state
        self.transcode_output = transcode_output
        self.message = message
        self.mnsmessage_result = mnsmessage_result
        self.complex_editing_configs = complex_editing_configs
        self.inputs = inputs
        self.job_id = job_id
        self.code = code
        self.pipeline_id = pipeline_id

    def validate(self):
        if self.transcode_output:
            self.transcode_output.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()
        if self.complex_editing_configs:
            self.complex_editing_configs.validate()
        if self.inputs:
            self.inputs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.transcode_output is not None:
            result['transcodeOutput'] = self.transcode_output.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        if self.complex_editing_configs is not None:
            result['ComplexEditingConfigs'] = self.complex_editing_configs.to_map()
        if self.inputs is not None:
            result['Inputs'] = self.inputs.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.code is not None:
            result['Code'] = self.code
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('transcodeOutput') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobTranscodeOutput()
            self.transcode_output = temp_model.from_map(m['transcodeOutput'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        if m.get('ComplexEditingConfigs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobComplexEditingConfigs()
            self.complex_editing_configs = temp_model.from_map(m['ComplexEditingConfigs'])
        if m.get('Inputs') is not None:
            temp_model = QueryComplexJobListResponseBodyJobListJobInputs()
            self.inputs = temp_model.from_map(m['Inputs'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class QueryComplexJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryComplexJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryComplexJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryComplexJobListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_job_ids: QueryComplexJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
        job_list: QueryComplexJobListResponseBodyJobList = None,
    ):
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id
        self.job_list = job_list

    def validate(self):
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryComplexJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobList') is not None:
            temp_model = QueryComplexJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class QueryComplexJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryComplexJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryComplexJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInferenceJobRequest(TeaModel):
    def __init__(
        self,
        server_name: str = None,
        page_number: int = None,
        max_page_size: int = None,
    ):
        self.server_name = server_name
        self.page_number = page_number
        self.max_page_size = max_page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.server_name is not None:
            result['ServerName'] = self.server_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.max_page_size is not None:
            result['MaxPageSize'] = self.max_page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServerName') is not None:
            self.server_name = m.get('ServerName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('MaxPageSize') is not None:
            self.max_page_size = m.get('MaxPageSize')
        return self


class ListInferenceJobResponseBodyJobs(TeaModel):
    def __init__(
        self,
        status: str = None,
        result: str = None,
        job_id: str = None,
        user_id: int = None,
        message: str = None,
        job_time: int = None,
        job_params: str = None,
    ):
        self.status = status
        self.result = result
        self.job_id = job_id
        self.user_id = user_id
        self.message = message
        self.job_time = job_time
        self.job_params = job_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.result is not None:
            result['Result'] = self.result
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.message is not None:
            result['Message'] = self.message
        if self.job_time is not None:
            result['JobTime'] = self.job_time
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('JobTime') is not None:
            self.job_time = m.get('JobTime')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        return self


class ListInferenceJobResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        jobs: List[ListInferenceJobResponseBodyJobs] = None,
        code: str = None,
        total_size: int = None,
    ):
        self.message = message
        self.request_id = request_id
        self.jobs = jobs
        self.code = code
        self.total_size = total_size

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListInferenceJobResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListInferenceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInferenceJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInferenceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryJobListResponseBodyJobListJobOutputVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
        reso_priority: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode
        self.reso_priority = reso_priority

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        return self


class QueryJobListResponseBodyJobListJobOutputTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        trans_mode: str = None,
        is_check_reso: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.trans_mode = trans_mode
        self.is_check_reso = is_check_reso
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class QueryJobListResponseBodyJobListJobOutputEncryption(TeaModel):
    def __init__(
        self,
        type: str = None,
        key: str = None,
        key_type: str = None,
        id: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
    ):
        self.type = type
        self.key = key
        self.key_type = key_type
        self.id = id
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.id is not None:
            result['Id'] = self.id
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        refer_pos: str = None,
        dx: str = None,
        width: str = None,
        height: str = None,
        input_file: QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile = None,
        water_mark_template_id: str = None,
        dy: str = None,
    ):
        self.type = type
        self.refer_pos = refer_pos
        self.dx = dx
        self.width = width
        self.height = height
        self.input_file = input_file
        self.water_mark_template_id = water_mark_template_id
        self.dy = dy

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.dy is not None:
            result['Dy'] = self.dy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        return self


class QueryJobListResponseBodyJobListJobOutputWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        size_support: bool = None,
        md_5support: bool = None,
    ):
        self.size_support = size_support
        self.md_5support = md_5support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        return self


class QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryJobListResponseBodyJobListJobOutputAudioVolume(TeaModel):
    def __init__(
        self,
        method: str = None,
        level: str = None,
    ):
        self.method = method
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryJobListResponseBodyJobListJobOutputAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        volume: QueryJobListResponseBodyJobListJobOutputAudioVolume = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.volume = volume
        self.bitrate = bitrate

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Volume') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class QueryJobListResponseBodyJobListJobOutputMergeListMerge(TeaModel):
    def __init__(
        self,
        start: str = None,
        role_arn: str = None,
        merge_url: str = None,
        duration: str = None,
    ):
        self.start = start
        self.role_arn = role_arn
        self.merge_url = merge_url
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryJobListResponseBodyJobListJobOutputMergeList(TeaModel):
    def __init__(
        self,
        merge: List[QueryJobListResponseBodyJobListJobOutputMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryJobListResponseBodyJobListJobOutputMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
        out_subtitle_file: QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile = None,
        success: bool = None,
        message: str = None,
    ):
        self.map = map
        self.out_subtitle_file = out_subtitle_file
        self.success = success
        self.message = message

    def validate(self):
        if self.out_subtitle_file:
            self.out_subtitle_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        if self.out_subtitle_file is not None:
            result['OutSubtitleFile'] = self.out_subtitle_file.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        if m.get('OutSubtitleFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitleOutSubtitleFile()
            self.out_subtitle_file = temp_model.from_map(m['OutSubtitleFile'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class QueryJobListResponseBodyJobListJobOutputOutSubtitleList(TeaModel):
    def __init__(
        self,
        out_subtitle: List[QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle] = None,
    ):
        self.out_subtitle = out_subtitle

    def validate(self):
        if self.out_subtitle:
            for k in self.out_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutSubtitle'] = []
        if self.out_subtitle is not None:
            for k in self.out_subtitle:
                result['OutSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.out_subtitle = []
        if m.get('OutSubtitle') is not None:
            for k in m.get('OutSubtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleListOutSubtitle()
                self.out_subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputOutputFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryJobListResponseBodyJobListJobOutputContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryJobListResponseBodyJobListJobOutputClipTimeSpan(TeaModel):
    def __init__(
        self,
        seek: str = None,
        duration: str = None,
    ):
        self.seek = seek
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seek is not None:
            result['Seek'] = self.seek
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryJobListResponseBodyJobListJobOutputClip(TeaModel):
    def __init__(
        self,
        time_span: QueryJobListResponseBodyJobListJobOutputClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryJobListResponseBodyJobListJobOutputOpeningListOpening(TeaModel):
    def __init__(
        self,
        open_url: str = None,
        start: str = None,
        width: str = None,
        height: str = None,
    ):
        self.open_url = open_url
        self.start = start
        self.width = width
        self.height = height

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_url is not None:
            result['openUrl'] = self.open_url
        if self.start is not None:
            result['Start'] = self.start
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('openUrl') is not None:
            self.open_url = m.get('openUrl')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        return self


class QueryJobListResponseBodyJobListJobOutputOpeningList(TeaModel):
    def __init__(
        self,
        opening: List[QueryJobListResponseBodyJobListJobOutputOpeningListOpening] = None,
    ):
        self.opening = opening

    def validate(self):
        if self.opening:
            for k in self.opening:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Opening'] = []
        if self.opening is not None:
            for k in self.opening:
                result['Opening'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.opening = []
        if m.get('Opening') is not None:
            for k in m.get('Opening'):
                temp_model = QueryJobListResponseBodyJobListJobOutputOpeningListOpening()
                self.opening.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigWebp(TeaModel):
    def __init__(
        self,
        loop: str = None,
    ):
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryJobListResponseBodyJobListJobOutputMuxConfig(TeaModel):
    def __init__(
        self,
        webp: QueryJobListResponseBodyJobListJobOutputMuxConfigWebp = None,
        gif: QueryJobListResponseBodyJobListJobOutputMuxConfigGif = None,
        segment: QueryJobListResponseBodyJobListJobOutputMuxConfigSegment = None,
    ):
        self.webp = webp
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.webp:
            self.webp.validate()
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Webp') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        if m.get('Gif') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate(TeaModel):
    def __init__(
        self,
        start: str = None,
        bg_color: str = None,
        is_merge_audio: bool = None,
        width: str = None,
        height: str = None,
        blend_duration: str = None,
        tail_url: str = None,
    ):
        self.start = start
        self.bg_color = bg_color
        self.is_merge_audio = is_merge_audio
        self.width = width
        self.height = height
        self.blend_duration = blend_duration
        self.tail_url = tail_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.is_merge_audio is not None:
            result['IsMergeAudio'] = self.is_merge_audio
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.blend_duration is not None:
            result['BlendDuration'] = self.blend_duration
        if self.tail_url is not None:
            result['TailUrl'] = self.tail_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('IsMergeAudio') is not None:
            self.is_merge_audio = m.get('IsMergeAudio')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('BlendDuration') is not None:
            self.blend_duration = m.get('BlendDuration')
        if m.get('TailUrl') is not None:
            self.tail_url = m.get('TailUrl')
        return self


class QueryJobListResponseBodyJobListJobOutputTailSlateList(TeaModel):
    def __init__(
        self,
        tail_slate: List[QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate] = None,
    ):
        self.tail_slate = tail_slate

    def validate(self):
        if self.tail_slate:
            for k in self.tail_slate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TailSlate'] = []
        if self.tail_slate is not None:
            for k in self.tail_slate:
                result['TailSlate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tail_slate = []
        if m.get('TailSlate') is not None:
            for k in m.get('TailSlate'):
                temp_model = QueryJobListResponseBodyJobListJobOutputTailSlateListTailSlate()
                self.tail_slate.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList = None,
        subtitle_list: QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo(TeaModel):
    def __init__(
        self,
        source: str = None,
    ):
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos(TeaModel):
    def __init__(
        self,
        source_logo: List[QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo] = None,
    ):
        self.source_logo = source_logo

    def validate(self):
        if self.source_logo:
            for k in self.source_logo:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SourceLogo'] = []
        if self.source_logo is not None:
            for k in self.source_logo:
                result['SourceLogo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.source_logo = []
        if m.get('SourceLogo') is not None:
            for k in m.get('SourceLogo'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogosSourceLogo()
                self.source_logo.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        preload_time: str = None,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
    ):
        self.preload_time = preload_time
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        timebase: str = None,
        avg_fps: str = None,
        pix_fmt: str = None,
        sar: str = None,
        lang: str = None,
        codec_long_name: str = None,
        height: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        has_bframes: str = None,
        profile: str = None,
        start_time: str = None,
        network_cost: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        dar: str = None,
        codec_name: str = None,
        width: str = None,
        duration: str = None,
        fps: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
        level: str = None,
    ):
        self.index = index
        self.timebase = timebase
        self.avg_fps = avg_fps
        self.pix_fmt = pix_fmt
        self.sar = sar
        self.lang = lang
        self.codec_long_name = codec_long_name
        self.height = height
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.has_bframes = has_bframes
        self.profile = profile
        self.start_time = start_time
        self.network_cost = network_cost
        self.dar = dar
        self.codec_name = codec_name
        self.width = width
        self.duration = duration
        self.fps = fps
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base
        self.level = level

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.height is not None:
            result['Height'] = self.height
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NetworkCost') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        timebase: str = None,
        index: str = None,
        sample_fmt: str = None,
        channel_layout: str = None,
        lang: str = None,
        samplerate: str = None,
        codec_long_name: str = None,
        channels: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        start_time: str = None,
        codec_name: str = None,
        duration: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
    ):
        self.timebase = timebase
        self.index = index
        self.sample_fmt = sample_fmt
        self.channel_layout = channel_layout
        self.lang = lang
        self.samplerate = samplerate
        self.codec_long_name = codec_long_name
        self.channels = channels
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.start_time = start_time
        self.codec_name = codec_name
        self.duration = duration
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.index is not None:
            result['Index'] = self.index
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesStreams(TeaModel):
    def __init__(
        self,
        video_stream_list: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList = None,
        audio_stream_list: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList = None,
    ):
        self.video_stream_list = video_stream_list
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list

    def validate(self):
        if self.video_stream_list:
            self.video_stream_list.validate()
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        if m.get('AudioStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        return self


class QueryJobListResponseBodyJobListJobOutputPropertiesFormat(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        num_programs: str = None,
        size: str = None,
        num_streams: str = None,
        format_long_name: str = None,
        duration: str = None,
        bitrate: str = None,
        format_name: str = None,
    ):
        self.start_time = start_time
        self.num_programs = num_programs
        self.size = size
        self.num_streams = num_streams
        self.format_long_name = format_long_name
        self.duration = duration
        self.bitrate = bitrate
        self.format_name = format_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.size is not None:
            result['Size'] = self.size
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        return self


class QueryJobListResponseBodyJobListJobOutputProperties(TeaModel):
    def __init__(
        self,
        width: str = None,
        height: str = None,
        source_logos: QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos = None,
        duration: str = None,
        fps: str = None,
        bitrate: str = None,
        file_format: str = None,
        streams: QueryJobListResponseBodyJobListJobOutputPropertiesStreams = None,
        format: QueryJobListResponseBodyJobListJobOutputPropertiesFormat = None,
        file_size: str = None,
    ):
        self.width = width
        self.height = height
        self.source_logos = source_logos
        self.duration = duration
        self.fps = fps
        self.bitrate = bitrate
        self.file_format = file_format
        self.streams = streams
        self.format = format
        self.file_size = file_size

    def validate(self):
        if self.source_logos:
            self.source_logos.validate()
        if self.streams:
            self.streams.validate()
        if self.format:
            self.format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.source_logos is not None:
            result['SourceLogos'] = self.source_logos.to_map()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('SourceLogos') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesSourceLogos()
            self.source_logos = temp_model.from_map(m['SourceLogos'])
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Streams') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Format') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class QueryJobListResponseBodyJobListJobOutput(TeaModel):
    def __init__(
        self,
        video: QueryJobListResponseBodyJobListJobOutputVideo = None,
        trans_config: QueryJobListResponseBodyJobListJobOutputTransConfig = None,
        encryption: QueryJobListResponseBodyJobListJobOutputEncryption = None,
        water_mark_list: QueryJobListResponseBodyJobListJobOutputWaterMarkList = None,
        water_mark_config_url: str = None,
        de_watermark: str = None,
        m_3u8non_standard_support: QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport = None,
        priority: str = None,
        audio: QueryJobListResponseBodyJobListJobOutputAudio = None,
        audio_stream_map: str = None,
        merge_list: QueryJobListResponseBodyJobListJobOutputMergeList = None,
        super_reso: QueryJobListResponseBodyJobListJobOutputSuperReso = None,
        user_data: str = None,
        out_subtitle_list: QueryJobListResponseBodyJobListJobOutputOutSubtitleList = None,
        video_stream_map: str = None,
        output_file: QueryJobListResponseBodyJobListJobOutputOutputFile = None,
        rotate: str = None,
        container: QueryJobListResponseBodyJobListJobOutputContainer = None,
        clip: QueryJobListResponseBodyJobListJobOutputClip = None,
        merge_config_url: str = None,
        opening_list: QueryJobListResponseBodyJobListJobOutputOpeningList = None,
        mux_config: QueryJobListResponseBodyJobListJobOutputMuxConfig = None,
        tail_slate_list: QueryJobListResponseBodyJobListJobOutputTailSlateList = None,
        template_id: str = None,
        subtitle_config: QueryJobListResponseBodyJobListJobOutputSubtitleConfig = None,
        properties: QueryJobListResponseBodyJobListJobOutputProperties = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.encryption = encryption
        self.water_mark_list = water_mark_list
        self.water_mark_config_url = water_mark_config_url
        self.de_watermark = de_watermark
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.priority = priority
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.merge_list = merge_list
        self.super_reso = super_reso
        self.user_data = user_data
        self.out_subtitle_list = out_subtitle_list
        self.video_stream_map = video_stream_map
        self.output_file = output_file
        self.rotate = rotate
        self.container = container
        self.clip = clip
        self.merge_config_url = merge_config_url
        self.opening_list = opening_list
        self.mux_config = mux_config
        self.tail_slate_list = tail_slate_list
        self.template_id = template_id
        self.subtitle_config = subtitle_config
        self.properties = properties

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.encryption:
            self.encryption.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.audio:
            self.audio.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.out_subtitle_list:
            self.out_subtitle_list.validate()
        if self.output_file:
            self.output_file.validate()
        if self.container:
            self.container.validate()
        if self.clip:
            self.clip.validate()
        if self.opening_list:
            self.opening_list.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.tail_slate_list:
            self.tail_slate_list.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.out_subtitle_list is not None:
            result['OutSubtitleList'] = self.out_subtitle_list.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.opening_list is not None:
            result['OpeningList'] = self.opening_list.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.tail_slate_list is not None:
            result['TailSlateList'] = self.tail_slate_list.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Encryption') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('WaterMarkList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Audio') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('MergeList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('SuperReso') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('OutSubtitleList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutSubtitleList()
            self.out_subtitle_list = temp_model.from_map(m['OutSubtitleList'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('OutputFile') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Container') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Clip') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('OpeningList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputOpeningList()
            self.opening_list = temp_model.from_map(m['OpeningList'])
        if m.get('MuxConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('TailSlateList') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputTailSlateList()
            self.tail_slate_list = temp_model.from_map(m['TailSlateList'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('Properties') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutputProperties()
            self.properties = temp_model.from_map(m['Properties'])
        return self


class QueryJobListResponseBodyJobListJobInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class QueryJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        finish_time: str = None,
        state: str = None,
        job_id: str = None,
        code: str = None,
        message: str = None,
        output: QueryJobListResponseBodyJobListJobOutput = None,
        pipeline_id: str = None,
        input: QueryJobListResponseBodyJobListJobInput = None,
        mnsmessage_result: QueryJobListResponseBodyJobListJobMNSMessageResult = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.code = code
        self.message = message
        self.output = output
        self.pipeline_id = pipeline_id
        self.input = input
        self.mnsmessage_result = mnsmessage_result

    def validate(self):
        if self.output:
            self.output.validate()
        if self.input:
            self.input.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            temp_model = QueryJobListResponseBodyJobListJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Input') is not None:
            temp_model = QueryJobListResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        return self


class QueryJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryJobListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_job_ids: QueryJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
        job_list: QueryJobListResponseBodyJobList = None,
    ):
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id
        self.job_list = job_list

    def validate(self):
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobList') is not None:
            temp_model = QueryJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class QueryJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SearchMediaWorkflowRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state_list: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state_list = state_list
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state_list is not None:
            result['StateList'] = self.state_list
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('StateList') is not None:
            self.state_list = m.get('StateList')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SearchMediaWorkflowResponseBodyMediaWorkflowListMediaWorkflow(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        media_workflow_id: str = None,
        state: str = None,
        trigger_mode: str = None,
        name: str = None,
        topology: str = None,
    ):
        self.creation_time = creation_time
        self.media_workflow_id = media_workflow_id
        self.state = state
        self.trigger_mode = trigger_mode
        self.name = name
        self.topology = topology

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_workflow_id is not None:
            result['MediaWorkflowId'] = self.media_workflow_id
        if self.state is not None:
            result['State'] = self.state
        if self.trigger_mode is not None:
            result['TriggerMode'] = self.trigger_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.topology is not None:
            result['Topology'] = self.topology
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaWorkflowId') is not None:
            self.media_workflow_id = m.get('MediaWorkflowId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TriggerMode') is not None:
            self.trigger_mode = m.get('TriggerMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Topology') is not None:
            self.topology = m.get('Topology')
        return self


class SearchMediaWorkflowResponseBodyMediaWorkflowList(TeaModel):
    def __init__(
        self,
        media_workflow: List[SearchMediaWorkflowResponseBodyMediaWorkflowListMediaWorkflow] = None,
    ):
        self.media_workflow = media_workflow

    def validate(self):
        if self.media_workflow:
            for k in self.media_workflow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaWorkflow'] = []
        if self.media_workflow is not None:
            for k in self.media_workflow:
                result['MediaWorkflow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_workflow = []
        if m.get('MediaWorkflow') is not None:
            for k in m.get('MediaWorkflow'):
                temp_model = SearchMediaWorkflowResponseBodyMediaWorkflowListMediaWorkflow()
                self.media_workflow.append(temp_model.from_map(k))
        return self


class SearchMediaWorkflowResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        media_workflow_list: SearchMediaWorkflowResponseBodyMediaWorkflowList = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.media_workflow_list = media_workflow_list
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.media_workflow_list:
            self.media_workflow_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.media_workflow_list is not None:
            result['MediaWorkflowList'] = self.media_workflow_list.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MediaWorkflowList') is not None:
            temp_model = SearchMediaWorkflowResponseBodyMediaWorkflowList()
            self.media_workflow_list = temp_model.from_map(m['MediaWorkflowList'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class SearchMediaWorkflowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SearchMediaWorkflowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SearchMediaWorkflowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCoverPipelineListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        pipeline_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.pipeline_ids = pipeline_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.pipeline_ids is not None:
            result['PipelineIds'] = self.pipeline_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PipelineIds') is not None:
            self.pipeline_ids = m.get('PipelineIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        topic: str = None,
        queue: str = None,
    ):
        self.topic = topic
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class QueryCoverPipelineListResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        role: str = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.role = role
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.role is not None:
            result['Role'] = self.role
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = QueryCoverPipelineListResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryCoverPipelineListResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[QueryCoverPipelineListResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = QueryCoverPipelineListResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class QueryCoverPipelineListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCoverPipelineListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        pipeline_list: QueryCoverPipelineListResponseBodyPipelineList = None,
        non_exist_ids: QueryCoverPipelineListResponseBodyNonExistIds = None,
    ):
        self.request_id = request_id
        self.pipeline_list = pipeline_list
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PipelineList') is not None:
            temp_model = QueryCoverPipelineListResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryCoverPipelineListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryCoverPipelineListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCoverPipelineListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCoverPipelineListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFpShotJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        next_page_token: str = None,
        maximum_page_size: int = None,
        state: str = None,
        start_of_job_created_time_range: str = None,
        end_of_job_created_time_range: str = None,
        primary_key_list: str = None,
        pipeline_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.next_page_token = next_page_token
        self.maximum_page_size = maximum_page_size
        self.state = state
        self.start_of_job_created_time_range = start_of_job_created_time_range
        self.end_of_job_created_time_range = end_of_job_created_time_range
        self.primary_key_list = primary_key_list
        self.pipeline_id = pipeline_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.state is not None:
            result['State'] = self.state
        if self.start_of_job_created_time_range is not None:
            result['StartOfJobCreatedTimeRange'] = self.start_of_job_created_time_range
        if self.end_of_job_created_time_range is not None:
            result['EndOfJobCreatedTimeRange'] = self.end_of_job_created_time_range
        if self.primary_key_list is not None:
            result['PrimaryKeyList'] = self.primary_key_list
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StartOfJobCreatedTimeRange') is not None:
            self.start_of_job_created_time_range = m.get('StartOfJobCreatedTimeRange')
        if m.get('EndOfJobCreatedTimeRange') is not None:
            self.end_of_job_created_time_range = m.get('EndOfJobCreatedTimeRange')
        if m.get('PrimaryKeyList') is not None:
            self.primary_key_list = m.get('PrimaryKeyList')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryFpShotJobListResponseBodyNonExistPrimaryKeys(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(
        self,
        start: str = None,
        duration: str = None,
    ):
        self.start = start
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(
        self,
        start: str = None,
        duration: str = None,
    ):
        self.start = start
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(
        self,
        duplication: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication = None,
        similarity: str = None,
        input: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput = None,
    ):
        self.duplication = duplication
        self.similarity = similarity
        self.input = input

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(
        self,
        fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice] = None,
    ):
        self.fp_shot_slice = fp_shot_slice

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot(TeaModel):
    def __init__(
        self,
        primary_key: str = None,
        fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices = None,
        similarity: str = None,
    ):
        self.primary_key = primary_key
        self.fp_shot_slices = fp_shot_slices
        self.similarity = similarity

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots(TeaModel):
    def __init__(
        self,
        fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot] = None,
    ):
        self.fp_shot = fp_shot

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication(TeaModel):
    def __init__(
        self,
        start: str = None,
        duration: str = None,
    ):
        self.start = start
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput(TeaModel):
    def __init__(
        self,
        start: str = None,
        duration: str = None,
    ):
        self.start = start
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice(TeaModel):
    def __init__(
        self,
        duplication: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication = None,
        similarity: str = None,
        input: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput = None,
    ):
        self.duplication = duplication
        self.similarity = similarity
        self.input = input

    def validate(self):
        if self.duplication:
            self.duplication.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duplication is not None:
            result['Duplication'] = self.duplication.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duplication') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceDuplication()
            self.duplication = temp_model.from_map(m['Duplication'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('Input') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSliceInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices(TeaModel):
    def __init__(
        self,
        fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice] = None,
    ):
        self.fp_shot_slice = fp_shot_slice

    def validate(self):
        if self.fp_shot_slice:
            for k in self.fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotSlice'] = []
        if self.fp_shot_slice is not None:
            for k in self.fp_shot_slice:
                result['FpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_slice = []
        if m.get('FpShotSlice') is not None:
            for k in m.get('FpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlicesFpShotSlice()
                self.fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot(TeaModel):
    def __init__(
        self,
        primary_key: str = None,
        fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices = None,
        similarity: str = None,
    ):
        self.primary_key = primary_key
        self.fp_shot_slices = fp_shot_slices
        self.similarity = similarity

    def validate(self):
        if self.fp_shot_slices:
            self.fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.fp_shot_slices is not None:
            result['FpShotSlices'] = self.fp_shot_slices.to_map()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('FpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShotFpShotSlices()
            self.fp_shot_slices = temp_model.from_map(m['FpShotSlices'])
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots(TeaModel):
    def __init__(
        self,
        fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot] = None,
    ):
        self.fp_shot = fp_shot

    def validate(self):
        if self.fp_shot:
            for k in self.fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShot'] = []
        if self.fp_shot is not None:
            for k in self.fp_shot:
                result['FpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot = []
        if m.get('FpShot') is not None:
            for k in m.get('FpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShotsFpShot()
                self.fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment(TeaModel):
    def __init__(
        self,
        start: str = None,
        duration: str = None,
    ):
        self.start = start
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice(TeaModel):
    def __init__(
        self,
        similarity: str = None,
        input_text: str = None,
        duplication_text: str = None,
        input_fragment: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment = None,
    ):
        self.similarity = similarity
        self.input_text = input_text
        self.duplication_text = duplication_text
        self.input_fragment = input_fragment

    def validate(self):
        if self.input_fragment:
            self.input_fragment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.input_text is not None:
            result['InputText'] = self.input_text
        if self.duplication_text is not None:
            result['DuplicationText'] = self.duplication_text
        if self.input_fragment is not None:
            result['InputFragment'] = self.input_fragment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('InputText') is not None:
            self.input_text = m.get('InputText')
        if m.get('DuplicationText') is not None:
            self.duplication_text = m.get('DuplicationText')
        if m.get('InputFragment') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSliceInputFragment()
            self.input_fragment = temp_model.from_map(m['InputFragment'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices(TeaModel):
    def __init__(
        self,
        text_fp_shot_slice: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice] = None,
    ):
        self.text_fp_shot_slice = text_fp_shot_slice

    def validate(self):
        if self.text_fp_shot_slice:
            for k in self.text_fp_shot_slice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TextFpShotSlice'] = []
        if self.text_fp_shot_slice is not None:
            for k in self.text_fp_shot_slice:
                result['TextFpShotSlice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.text_fp_shot_slice = []
        if m.get('TextFpShotSlice') is not None:
            for k in m.get('TextFpShotSlice'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlicesTextFpShotSlice()
                self.text_fp_shot_slice.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot(TeaModel):
    def __init__(
        self,
        primary_key: str = None,
        similarity: str = None,
        text_fp_shot_slices: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices = None,
    ):
        self.primary_key = primary_key
        self.similarity = similarity
        self.text_fp_shot_slices = text_fp_shot_slices

    def validate(self):
        if self.text_fp_shot_slices:
            self.text_fp_shot_slices.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.similarity is not None:
            result['Similarity'] = self.similarity
        if self.text_fp_shot_slices is not None:
            result['TextFpShotSlices'] = self.text_fp_shot_slices.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('Similarity') is not None:
            self.similarity = m.get('Similarity')
        if m.get('TextFpShotSlices') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShotTextFpShotSlices()
            self.text_fp_shot_slices = temp_model.from_map(m['TextFpShotSlices'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots(TeaModel):
    def __init__(
        self,
        text_fp_shot: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot] = None,
    ):
        self.text_fp_shot = text_fp_shot

    def validate(self):
        if self.text_fp_shot:
            for k in self.text_fp_shot:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TextFpShot'] = []
        if self.text_fp_shot is not None:
            for k in self.text_fp_shot:
                result['TextFpShot'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.text_fp_shot = []
        if m.get('TextFpShot') is not None:
            for k in m.get('TextFpShot'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShotsTextFpShot()
                self.text_fp_shot.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult(TeaModel):
    def __init__(
        self,
        audio_fp_shots: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots = None,
        fp_shots: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots = None,
        text_fp_shots: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots = None,
    ):
        self.audio_fp_shots = audio_fp_shots
        self.fp_shots = fp_shots
        self.text_fp_shots = text_fp_shots

    def validate(self):
        if self.audio_fp_shots:
            self.audio_fp_shots.validate()
        if self.fp_shots:
            self.fp_shots.validate()
        if self.text_fp_shots:
            self.text_fp_shots.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_fp_shots is not None:
            result['AudioFpShots'] = self.audio_fp_shots.to_map()
        if self.fp_shots is not None:
            result['FpShots'] = self.fp_shots.to_map()
        if self.text_fp_shots is not None:
            result['TextFpShots'] = self.text_fp_shots.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioFpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultAudioFpShots()
            self.audio_fp_shots = temp_model.from_map(m['AudioFpShots'])
        if m.get('FpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultFpShots()
            self.fp_shots = temp_model.from_map(m['FpShots'])
        if m.get('TextFpShots') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResultTextFpShots()
            self.text_fp_shots = temp_model.from_map(m['TextFpShots'])
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig(TeaModel):
    def __init__(
        self,
        primary_key: str = None,
        save_type: str = None,
        notary: str = None,
        fp_dbid: str = None,
    ):
        self.primary_key = primary_key
        self.save_type = save_type
        self.notary = notary
        self.fp_dbid = fp_dbid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_key is not None:
            result['PrimaryKey'] = self.primary_key
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        if self.notary is not None:
            result['Notary'] = self.notary
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryKey') is not None:
            self.primary_key = m.get('PrimaryKey')
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        if m.get('Notary') is not None:
            self.notary = m.get('Notary')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryFpShotJobListResponseBodyFpShotJobListFpShotJob(TeaModel):
    def __init__(
        self,
        fp_shot_result: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult = None,
        creation_time: str = None,
        finish_time: str = None,
        state: str = None,
        message: str = None,
        tx_hash: str = None,
        transaction_id: str = None,
        fp_shot_config: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig = None,
        file_id: str = None,
        user_data: str = None,
        code: str = None,
        input_file: QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile = None,
        pipeline_id: str = None,
        id: str = None,
    ):
        self.fp_shot_result = fp_shot_result
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.state = state
        self.message = message
        self.tx_hash = tx_hash
        self.transaction_id = transaction_id
        self.fp_shot_config = fp_shot_config
        self.file_id = file_id
        self.user_data = user_data
        self.code = code
        self.input_file = input_file
        self.pipeline_id = pipeline_id
        self.id = id

    def validate(self):
        if self.fp_shot_result:
            self.fp_shot_result.validate()
        if self.fp_shot_config:
            self.fp_shot_config.validate()
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fp_shot_result is not None:
            result['FpShotResult'] = self.fp_shot_result.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.message is not None:
            result['Message'] = self.message
        if self.tx_hash is not None:
            result['TxHash'] = self.tx_hash
        if self.transaction_id is not None:
            result['TransactionId'] = self.transaction_id
        if self.fp_shot_config is not None:
            result['FpShotConfig'] = self.fp_shot_config.to_map()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.code is not None:
            result['Code'] = self.code
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FpShotResult') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotResult()
            self.fp_shot_result = temp_model.from_map(m['FpShotResult'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TxHash') is not None:
            self.tx_hash = m.get('TxHash')
        if m.get('TransactionId') is not None:
            self.transaction_id = m.get('TransactionId')
        if m.get('FpShotConfig') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobFpShotConfig()
            self.fp_shot_config = temp_model.from_map(m['FpShotConfig'])
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InputFile') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJobInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryFpShotJobListResponseBodyFpShotJobList(TeaModel):
    def __init__(
        self,
        fp_shot_job: List[QueryFpShotJobListResponseBodyFpShotJobListFpShotJob] = None,
    ):
        self.fp_shot_job = fp_shot_job

    def validate(self):
        if self.fp_shot_job:
            for k in self.fp_shot_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotJob'] = []
        if self.fp_shot_job is not None:
            for k in self.fp_shot_job:
                result['FpShotJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_job = []
        if m.get('FpShotJob') is not None:
            for k in m.get('FpShotJob'):
                temp_model = QueryFpShotJobListResponseBodyFpShotJobListFpShotJob()
                self.fp_shot_job.append(temp_model.from_map(k))
        return self


class QueryFpShotJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryFpShotJobListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        next_page_token: str = None,
        non_exist_primary_keys: QueryFpShotJobListResponseBodyNonExistPrimaryKeys = None,
        fp_shot_job_list: QueryFpShotJobListResponseBodyFpShotJobList = None,
        non_exist_ids: QueryFpShotJobListResponseBodyNonExistIds = None,
    ):
        self.request_id = request_id
        self.next_page_token = next_page_token
        self.non_exist_primary_keys = non_exist_primary_keys
        self.fp_shot_job_list = fp_shot_job_list
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.non_exist_primary_keys:
            self.non_exist_primary_keys.validate()
        if self.fp_shot_job_list:
            self.fp_shot_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.non_exist_primary_keys is not None:
            result['NonExistPrimaryKeys'] = self.non_exist_primary_keys.to_map()
        if self.fp_shot_job_list is not None:
            result['FpShotJobList'] = self.fp_shot_job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NonExistPrimaryKeys') is not None:
            temp_model = QueryFpShotJobListResponseBodyNonExistPrimaryKeys()
            self.non_exist_primary_keys = temp_model.from_map(m['NonExistPrimaryKeys'])
        if m.get('FpShotJobList') is not None:
            temp_model = QueryFpShotJobListResponseBodyFpShotJobList()
            self.fp_shot_job_list = temp_model.from_map(m['FpShotJobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryFpShotJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryFpShotJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryFpShotJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryFpShotJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaTagRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        media_id: str = None,
        tag: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.media_id = media_id
        self.tag = tag
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteMediaTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMediaTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMediaTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        pipeline_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.pipeline_id = pipeline_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        pipeline_id: str = None,
    ):
        self.request_id = request_id
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateSmarttagTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        template_id: str = None,
        template_name: str = None,
        industry: str = None,
        scene: str = None,
        analyse_types: str = None,
        face_category_ids: str = None,
        is_default: bool = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.template_id = template_id
        self.template_name = template_name
        self.industry = industry
        self.scene = scene
        self.analyse_types = analyse_types
        self.face_category_ids = face_category_ids
        self.is_default = is_default

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.industry is not None:
            result['Industry'] = self.industry
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.analyse_types is not None:
            result['AnalyseTypes'] = self.analyse_types
        if self.face_category_ids is not None:
            result['FaceCategoryIds'] = self.face_category_ids
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Industry') is not None:
            self.industry = m.get('Industry')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('AnalyseTypes') is not None:
            self.analyse_types = m.get('AnalyseTypes')
        if m.get('FaceCategoryIds') is not None:
            self.face_category_ids = m.get('FaceCategoryIds')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        return self


class UpdateSmarttagTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateSmarttagTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateSmarttagTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateSmarttagTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateAsrPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        pipeline_id: str = None,
        name: str = None,
        state: str = None,
        priority: int = None,
        notify_config: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.pipeline_id = pipeline_id
        self.name = name
        self.state = state
        self.priority = priority
        self.notify_config = notify_config
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('NotifyConfig') is not None:
            self.notify_config = m.get('NotifyConfig')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UpdateAsrPipelineResponseBodyPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        queue_name: str = None,
        topic: str = None,
    ):
        self.queue_name = queue_name
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class UpdateAsrPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: UpdateAsrPipelineResponseBodyPipelineNotifyConfig = None,
        priority: int = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = UpdateAsrPipelineResponseBodyPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class UpdateAsrPipelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        pipeline: UpdateAsrPipelineResponseBodyPipeline = None,
    ):
        self.request_id = request_id
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Pipeline') is not None:
            temp_model = UpdateAsrPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        return self


class UpdateAsrPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateAsrPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateAsrPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryVideoQualityJobRequest(TeaModel):
    def __init__(
        self,
        user_id: int = None,
        job_id: str = None,
    ):
        self.user_id = user_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryVideoQualityJobResponseBodyJob(TeaModel):
    def __init__(
        self,
        status: str = None,
        job_id: str = None,
        user_id: int = None,
        video_quality_results: str = None,
        message: str = None,
        output: str = None,
    ):
        self.status = status
        self.job_id = job_id
        self.user_id = user_id
        self.video_quality_results = video_quality_results
        self.message = message
        self.output = output

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.video_quality_results is not None:
            result['VideoQualityResults'] = self.video_quality_results
        if self.message is not None:
            result['Message'] = self.message
        if self.output is not None:
            result['Output'] = self.output
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('VideoQualityResults') is not None:
            self.video_quality_results = m.get('VideoQualityResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        return self


class QueryVideoQualityJobResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        job: QueryVideoQualityJobResponseBodyJob = None,
        code: str = None,
    ):
        self.message = message
        self.request_id = request_id
        self.job = job
        self.code = code

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Job') is not None:
            temp_model = QueryVideoQualityJobResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class QueryVideoQualityJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryVideoQualityJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryVideoQualityJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecryptKeyRequest(TeaModel):
    def __init__(
        self,
        owner_id: str = None,
        resource_owner_id: str = None,
        resource_owner_account: str = None,
        owner_account: str = None,
        ciphertext_blob: str = None,
        rand: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_id = resource_owner_id
        self.resource_owner_account = resource_owner_account
        self.owner_account = owner_account
        self.ciphertext_blob = ciphertext_blob
        self.rand = rand

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.ciphertext_blob is not None:
            result['CiphertextBlob'] = self.ciphertext_blob
        if self.rand is not None:
            result['Rand'] = self.rand
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('CiphertextBlob') is not None:
            self.ciphertext_blob = m.get('CiphertextBlob')
        if m.get('Rand') is not None:
            self.rand = m.get('Rand')
        return self


class DecryptKeyResponseBody(TeaModel):
    def __init__(
        self,
        rand: str = None,
        request_id: str = None,
        plaintext: str = None,
    ):
        self.rand = rand
        self.request_id = request_id
        self.plaintext = plaintext

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rand is not None:
            result['Rand'] = self.rand
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rand') is not None:
            self.rand = m.get('Rand')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        return self


class DecryptKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DecryptKeyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DecryptKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTemplateListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_ids = template_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryTemplateListResponseBodyNonExistTids(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        long_short_mode: str = None,
        degrain: str = None,
        bitrate_bnd: QueryTemplateListResponseBodyTemplateListTemplateVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        remove: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
        reso_priority: str = None,
    ):
        self.bufsize = bufsize
        self.long_short_mode = long_short_mode
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.remove = remove
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode
        self.reso_priority = reso_priority

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.reso_priority is not None:
            result['ResoPriority'] = self.reso_priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('ResoPriority') is not None:
            self.reso_priority = m.get('ResoPriority')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        trans_mode: str = None,
        is_check_reso: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.trans_mode = trans_mode
        self.is_check_reso = is_check_reso
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateMuxConfigWebp(TeaModel):
    def __init__(
        self,
        loop: str = None,
    ):
        self.loop = loop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.loop is not None:
            result['Loop'] = self.loop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateMuxConfig(TeaModel):
    def __init__(
        self,
        webp: QueryTemplateListResponseBodyTemplateListTemplateMuxConfigWebp = None,
        gif: QueryTemplateListResponseBodyTemplateListTemplateMuxConfigGif = None,
        segment: QueryTemplateListResponseBodyTemplateListTemplateMuxConfigSegment = None,
    ):
        self.webp = webp
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.webp:
            self.webp.validate()
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webp is not None:
            result['Webp'] = self.webp.to_map()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Webp') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateMuxConfigWebp()
            self.webp = temp_model.from_map(m['Webp'])
        if m.get('Gif') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryTemplateListResponseBodyTemplateListTemplateAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        remove: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.remove = remove
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.bitrate = bitrate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class QueryTemplateListResponseBodyTemplateListTemplateContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryTemplateListResponseBodyTemplateListTemplate(TeaModel):
    def __init__(
        self,
        video: QueryTemplateListResponseBodyTemplateListTemplateVideo = None,
        trans_config: QueryTemplateListResponseBodyTemplateListTemplateTransConfig = None,
        state: str = None,
        mux_config: QueryTemplateListResponseBodyTemplateListTemplateMuxConfig = None,
        name: str = None,
        audio: QueryTemplateListResponseBodyTemplateListTemplateAudio = None,
        id: str = None,
        container: QueryTemplateListResponseBodyTemplateListTemplateContainer = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.state = state
        self.mux_config = mux_config
        self.name = name
        self.audio = audio
        self.id = id
        self.container = container

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.container is not None:
            result['Container'] = self.container.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('MuxConfig') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Audio') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Container') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateListTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        return self


class QueryTemplateListResponseBodyTemplateList(TeaModel):
    def __init__(
        self,
        template: List[QueryTemplateListResponseBodyTemplateListTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = QueryTemplateListResponseBodyTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class QueryTemplateListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_tids: QueryTemplateListResponseBodyNonExistTids = None,
        template_list: QueryTemplateListResponseBodyTemplateList = None,
        request_id: str = None,
    ):
        self.non_exist_tids = non_exist_tids
        self.template_list = template_list
        self.request_id = request_id

    def validate(self):
        if self.non_exist_tids:
            self.non_exist_tids.validate()
        if self.template_list:
            self.template_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_tids is not None:
            result['NonExistTids'] = self.non_exist_tids.to_map()
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistTids') is not None:
            temp_model = QueryTemplateListResponseBodyNonExistTids()
            self.non_exist_tids = temp_model.from_map(m['NonExistTids'])
        if m.get('TemplateList') is not None:
            temp_model = QueryTemplateListResponseBodyTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryTemplateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryTemplateListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryTemplateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportFacerecogJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        facerecog: str = None,
        details: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.facerecog = facerecog
        self.details = details
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.facerecog is not None:
            result['Facerecog'] = self.facerecog
        if self.details is not None:
            result['Details'] = self.details
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Facerecog') is not None:
            self.facerecog = m.get('Facerecog')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportFacerecogJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportFacerecogJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportFacerecogJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportFacerecogJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMCTemplateListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_ids = template_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryMCTemplateListResponseBodyNonExistTids(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryMCTemplateListResponseBodyTemplateListTemplate(TeaModel):
    def __init__(
        self,
        logo: str = None,
        abuse: str = None,
        state: str = None,
        terrorism: str = None,
        politics: str = None,
        qrcode: str = None,
        live: str = None,
        spam: str = None,
        contraband: str = None,
        ad: str = None,
        porn: str = None,
        name: str = None,
        template_id: str = None,
    ):
        self.logo = logo
        self.abuse = abuse
        self.state = state
        self.terrorism = terrorism
        self.politics = politics
        self.qrcode = qrcode
        self.live = live
        self.spam = spam
        self.contraband = contraband
        self.ad = ad
        self.porn = porn
        self.name = name
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.state is not None:
            result['State'] = self.state
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.live is not None:
            result['Live'] = self.live
        if self.spam is not None:
            result['Spam'] = self.spam
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.name is not None:
            result['Name'] = self.name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Spam') is not None:
            self.spam = m.get('Spam')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class QueryMCTemplateListResponseBodyTemplateList(TeaModel):
    def __init__(
        self,
        template: List[QueryMCTemplateListResponseBodyTemplateListTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = QueryMCTemplateListResponseBodyTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class QueryMCTemplateListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_tids: QueryMCTemplateListResponseBodyNonExistTids = None,
        template_list: QueryMCTemplateListResponseBodyTemplateList = None,
        request_id: str = None,
    ):
        self.non_exist_tids = non_exist_tids
        self.template_list = template_list
        self.request_id = request_id

    def validate(self):
        if self.non_exist_tids:
            self.non_exist_tids.validate()
        if self.template_list:
            self.template_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_tids is not None:
            result['NonExistTids'] = self.non_exist_tids.to_map()
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistTids') is not None:
            temp_model = QueryMCTemplateListResponseBodyNonExistTids()
            self.non_exist_tids = temp_model.from_map(m['NonExistTids'])
        if m.get('TemplateList') is not None:
            temp_model = QueryMCTemplateListResponseBodyTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMCTemplateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryMCTemplateListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryMCTemplateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateMediaRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        media_id: str = None,
        title: str = None,
        description: str = None,
        cover_url: str = None,
        cate_id: int = None,
        tags: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.media_id = media_id
        self.title = title
        self.description = description
        self.cover_url = cover_url
        self.cate_id = cate_id
        self.tags = tags
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.title is not None:
            result['Title'] = self.title
        if self.description is not None:
            result['Description'] = self.description
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UpdateMediaResponseBodyMediaTags(TeaModel):
    def __init__(
        self,
        tag: List[str] = None,
    ):
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class UpdateMediaResponseBodyMediaFile(TeaModel):
    def __init__(
        self,
        state: str = None,
        url: str = None,
    ):
        self.state = state
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.url is not None:
            result['URL'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('URL') is not None:
            self.url = m.get('URL')
        return self


class UpdateMediaResponseBodyMediaRunIdList(TeaModel):
    def __init__(
        self,
        run_id: List[str] = None,
    ):
        self.run_id = run_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.run_id is not None:
            result['RunId'] = self.run_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RunId') is not None:
            self.run_id = m.get('RunId')
        return self


class UpdateMediaResponseBodyMedia(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        cate_id: int = None,
        height: str = None,
        censor_state: str = None,
        tags: UpdateMediaResponseBodyMediaTags = None,
        bitrate: str = None,
        media_id: str = None,
        file: UpdateMediaResponseBodyMediaFile = None,
        publish_state: str = None,
        description: str = None,
        width: str = None,
        size: str = None,
        cover_url: str = None,
        run_id_list: UpdateMediaResponseBodyMediaRunIdList = None,
        duration: str = None,
        fps: str = None,
        title: str = None,
        format: str = None,
    ):
        self.creation_time = creation_time
        self.cate_id = cate_id
        self.height = height
        self.censor_state = censor_state
        self.tags = tags
        self.bitrate = bitrate
        self.media_id = media_id
        self.file = file
        self.publish_state = publish_state
        self.description = description
        self.width = width
        self.size = size
        self.cover_url = cover_url
        self.run_id_list = run_id_list
        self.duration = duration
        self.fps = fps
        self.title = title
        self.format = format

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.file:
            self.file.validate()
        if self.run_id_list:
            self.run_id_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.height is not None:
            result['Height'] = self.height
        if self.censor_state is not None:
            result['CensorState'] = self.censor_state
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.description is not None:
            result['Description'] = self.description
        if self.width is not None:
            result['Width'] = self.width
        if self.size is not None:
            result['Size'] = self.size
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.run_id_list is not None:
            result['RunIdList'] = self.run_id_list.to_map()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.title is not None:
            result['Title'] = self.title
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('CensorState') is not None:
            self.censor_state = m.get('CensorState')
        if m.get('Tags') is not None:
            temp_model = UpdateMediaResponseBodyMediaTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('File') is not None:
            temp_model = UpdateMediaResponseBodyMediaFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('RunIdList') is not None:
            temp_model = UpdateMediaResponseBodyMediaRunIdList()
            self.run_id_list = temp_model.from_map(m['RunIdList'])
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class UpdateMediaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        media: UpdateMediaResponseBodyMedia = None,
    ):
        self.request_id = request_id
        self.media = media

    def validate(self):
        if self.media:
            self.media.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.media is not None:
            result['Media'] = self.media.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Media') is not None:
            temp_model = UpdateMediaResponseBodyMedia()
            self.media = temp_model.from_map(m['Media'])
        return self


class UpdateMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateMediaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCensorPipelineRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state = state
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state is not None:
            result['State'] = self.state
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig(TeaModel):
    def __init__(
        self,
        topic: str = None,
        queue: str = None,
    ):
        self.topic = topic
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class ListCensorPipelineResponseBodyPipelineListPipeline(TeaModel):
    def __init__(
        self,
        state: str = None,
        notify_config: ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig = None,
        priority: str = None,
        name: str = None,
        id: str = None,
    ):
        self.state = state
        self.notify_config = notify_config
        self.priority = priority
        self.name = name
        self.id = id

    def validate(self):
        if self.notify_config:
            self.notify_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.state is not None:
            result['State'] = self.state
        if self.notify_config is not None:
            result['NotifyConfig'] = self.notify_config.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('NotifyConfig') is not None:
            temp_model = ListCensorPipelineResponseBodyPipelineListPipelineNotifyConfig()
            self.notify_config = temp_model.from_map(m['NotifyConfig'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListCensorPipelineResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        pipeline: List[ListCensorPipelineResponseBodyPipelineListPipeline] = None,
    ):
        self.pipeline = pipeline

    def validate(self):
        if self.pipeline:
            for k in self.pipeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Pipeline'] = []
        if self.pipeline is not None:
            for k in self.pipeline:
                result['Pipeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline = []
        if m.get('Pipeline') is not None:
            for k in m.get('Pipeline'):
                temp_model = ListCensorPipelineResponseBodyPipelineListPipeline()
                self.pipeline.append(temp_model.from_map(k))
        return self


class ListCensorPipelineResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        pipeline_list: ListCensorPipelineResponseBodyPipelineList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.pipeline_list = pipeline_list

    def validate(self):
        if self.pipeline_list:
            self.pipeline_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.pipeline_list is not None:
            result['PipelineList'] = self.pipeline_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PipelineList') is not None:
            temp_model = ListCensorPipelineResponseBodyPipelineList()
            self.pipeline_list = temp_model.from_map(m['PipelineList'])
        return self


class ListCensorPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCensorPipelineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCensorPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySubtitleJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QuerySubtitleJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QuerySubtitleJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class QuerySubtitleJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        output_config: str = None,
        state: str = None,
        job_id: str = None,
        user_data: str = None,
        input_config: str = None,
        mnsmessage_result: QuerySubtitleJobListResponseBodyJobListJobMNSMessageResult = None,
    ):
        self.output_config = output_config
        self.state = state
        self.job_id = job_id
        self.user_data = user_data
        self.input_config = input_config
        self.mnsmessage_result = mnsmessage_result

    def validate(self):
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.input_config is not None:
            result['InputConfig'] = self.input_config
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputConfig') is not None:
            self.output_config = m.get('OutputConfig')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('InputConfig') is not None:
            self.input_config = m.get('InputConfig')
        if m.get('MNSMessageResult') is not None:
            temp_model = QuerySubtitleJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        return self


class QuerySubtitleJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QuerySubtitleJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QuerySubtitleJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QuerySubtitleJobListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_job_ids: QuerySubtitleJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
        job_list: QuerySubtitleJobListResponseBodyJobList = None,
    ):
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id
        self.job_list = job_list

    def validate(self):
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistJobIds') is not None:
            temp_model = QuerySubtitleJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobList') is not None:
            temp_model = QuerySubtitleJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class QuerySubtitleJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QuerySubtitleJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QuerySubtitleJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryVideoGifJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryVideoGifJobListResponseBodyJobListJobVideoGifResultOutputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryVideoGifJobListResponseBodyJobListJobVideoGifResult(TeaModel):
    def __init__(
        self,
        output_file: QueryVideoGifJobListResponseBodyJobListJobVideoGifResultOutputFile = None,
    ):
        self.output_file = output_file

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputFile') is not None:
            temp_model = QueryVideoGifJobListResponseBodyJobListJobVideoGifResultOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        return self


class QueryVideoGifJobListResponseBodyJobListJobInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryVideoGifJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        state: str = None,
        user_data: str = None,
        code: str = None,
        video_gif_result: QueryVideoGifJobListResponseBodyJobListJobVideoGifResult = None,
        message: str = None,
        pipeline_id: str = None,
        input: QueryVideoGifJobListResponseBodyJobListJobInput = None,
        id: str = None,
    ):
        self.creation_time = creation_time
        self.state = state
        self.user_data = user_data
        self.code = code
        self.video_gif_result = video_gif_result
        self.message = message
        self.pipeline_id = pipeline_id
        self.input = input
        self.id = id

    def validate(self):
        if self.video_gif_result:
            self.video_gif_result.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.code is not None:
            result['Code'] = self.code
        if self.video_gif_result is not None:
            result['VideoGifResult'] = self.video_gif_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('VideoGifResult') is not None:
            temp_model = QueryVideoGifJobListResponseBodyJobListJobVideoGifResult()
            self.video_gif_result = temp_model.from_map(m['VideoGifResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Input') is not None:
            temp_model = QueryVideoGifJobListResponseBodyJobListJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryVideoGifJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryVideoGifJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryVideoGifJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryVideoGifJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryVideoGifJobListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_list: QueryVideoGifJobListResponseBodyJobList = None,
        non_exist_ids: QueryVideoGifJobListResponseBodyNonExistIds = None,
    ):
        self.request_id = request_id
        self.job_list = job_list
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.job_list:
            self.job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobList') is not None:
            temp_model = QueryVideoGifJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryVideoGifJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryVideoGifJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryVideoGifJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryVideoGifJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryEditingJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_ids = job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryEditingJobListResponseBodyNonExistJobIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig(TeaModel):
    def __init__(
        self,
        is_normal_sar: str = None,
        deinterlace_method: str = None,
    ):
        self.is_normal_sar = is_normal_sar
        self.deinterlace_method = deinterlace_method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_normal_sar is not None:
            result['IsNormalSar'] = self.is_normal_sar
        if self.deinterlace_method is not None:
            result['DeinterlaceMethod'] = self.deinterlace_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsNormalSar') is not None:
            self.is_normal_sar = m.get('IsNormalSar')
        if m.get('DeinterlaceMethod') is not None:
            self.deinterlace_method = m.get('DeinterlaceMethod')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput(TeaModel):
    def __init__(
        self,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile = None,
        input_config: QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig = None,
        id: str = None,
    ):
        self.input_file = input_file
        self.input_config = input_config
        self.id = id

    def validate(self):
        if self.input_file:
            self.input_file.validate()
        if self.input_config:
            self.input_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('InputConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInputInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingInputs(TeaModel):
    def __init__(
        self,
        editing_input: List[QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput] = None,
    ):
        self.editing_input = editing_input

    def validate(self):
        if self.editing_input:
            for k in self.editing_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EditingInput'] = []
        if self.editing_input is not None:
            for k in self.editing_input:
                result['EditingInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.editing_input = []
        if m.get('EditingInput') is not None:
            for k in m.get('EditingInput'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputsEditingInput()
                self.editing_input.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        is_check_reso: str = None,
        trans_mode: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        duration: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_reso = is_check_reso
        self.trans_mode = trans_mode
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.duration = duration
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption(TeaModel):
    def __init__(
        self,
        type: str = None,
        key: str = None,
        key_type: str = None,
        id: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
    ):
        self.type = type
        self.key = key
        self.key_type = key_type
        self.id = id
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.id is not None:
            result['Id'] = self.id
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        refer_pos: str = None,
        dx: str = None,
        width: str = None,
        height: str = None,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile = None,
        water_mark_template_id: str = None,
        dy: str = None,
    ):
        self.type = type
        self.refer_pos = refer_pos
        self.dx = dx
        self.width = width
        self.height = height
        self.input_file = input_file
        self.water_mark_template_id = water_mark_template_id
        self.dy = dy

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.dy is not None:
            result['Dy'] = self.dy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        size_support: bool = None,
        md_5support: bool = None,
    ):
        self.size_support = size_support
        self.md_5support = md_5support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume(TeaModel):
    def __init__(
        self,
        method: str = None,
        level: str = None,
    ):
        self.method = method
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        volume: QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.volume = volume
        self.bitrate = bitrate

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Volume') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge(TeaModel):
    def __init__(
        self,
        start: str = None,
        role_arn: str = None,
        merge_url: str = None,
        duration: str = None,
    ):
        self.start = start
        self.role_arn = role_arn
        self.merge_url = merge_url
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList(TeaModel):
    def __init__(
        self,
        merge: List[QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        alpha: str = None,
        input_file: QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile = None,
    ):
        self.type = type
        self.alpha = alpha
        self.input_file = input_file

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.alpha is not None:
            result['Alpha'] = self.alpha
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Alpha') is not None:
            self.alpha = m.get('Alpha')
        if m.get('InputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo(TeaModel):
    def __init__(
        self,
        t: str = None,
        l: str = None,
    ):
        self.t = t
        self.l = l

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.t is not None:
            result['T'] = self.t
        if self.l is not None:
            result['L'] = self.l
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('T') is not None:
            self.t = m.get('T')
        if m.get('L') is not None:
            self.l = m.get('L')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig(TeaModel):
    def __init__(
        self,
        clips_config_video: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo = None,
    ):
        self.clips_config_video = clips_config_video

    def validate(self):
        if self.clips_config_video:
            self.clips_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config_video is not None:
            result['ClipsConfigVideo'] = self.clips_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfigVideo') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo()
            self.clips_config_video = temp_model.from_map(m['ClipsConfigVideo'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip(TeaModel):
    def __init__(
        self,
        clips_config: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig = None,
        out: str = None,
        in_: str = None,
        clip_id: str = None,
    ):
        self.clips_config = clips_config
        self.out = out
        self.in_ = in_
        self.clip_id = clip_id

    def validate(self):
        if self.clips_config:
            self.clips_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config is not None:
            result['ClipsConfig'] = self.clips_config.to_map()
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.clip_id is not None:
            result['clipID'] = self.clip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig()
            self.clips_config = temp_model.from_map(m['ClipsConfig'])
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('clipID') is not None:
            self.clip_id = m.get('clipID')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips(TeaModel):
    def __init__(
        self,
        clip: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClipsClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack(TeaModel):
    def __init__(
        self,
        type: str = None,
        order: str = None,
        id: str = None,
        clips: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips = None,
    ):
        self.type = type
        self.order = order
        self.id = id
        self.clips = clips

    def validate(self):
        if self.clips:
            self.clips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.order is not None:
            result['Order'] = self.order
        if self.id is not None:
            result['Id'] = self.id
        if self.clips is not None:
            result['Clips'] = self.clips.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Clips') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrackClips()
            self.clips = temp_model.from_map(m['Clips'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList(TeaModel):
    def __init__(
        self,
        track: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack] = None,
    ):
        self.track = track

    def validate(self):
        if self.track:
            for k in self.track:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Track'] = []
        if self.track is not None:
            for k in self.track:
                result['Track'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track = []
        if m.get('Track') is not None:
            for k in m.get('Track'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackListTrack()
                self.track.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio(TeaModel):
    def __init__(
        self,
        channel_layout: str = None,
        samplerate: str = None,
        channels: str = None,
    ):
        self.channel_layout = channel_layout
        self.samplerate = samplerate
        self.channels = channels

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.channels is not None:
            result['Channels'] = self.channels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        width: str = None,
        render_ratio: str = None,
        is_gpu_data: str = None,
        height: str = None,
        is_one_track_data: str = None,
        fps: str = None,
        reclose_prec: str = None,
    ):
        self.bg_color = bg_color
        self.width = width
        self.render_ratio = render_ratio
        self.is_gpu_data = is_gpu_data
        self.height = height
        self.is_one_track_data = is_one_track_data
        self.fps = fps
        self.reclose_prec = reclose_prec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.width is not None:
            result['Width'] = self.width
        if self.render_ratio is not None:
            result['RenderRatio'] = self.render_ratio
        if self.is_gpu_data is not None:
            result['IsGpuData'] = self.is_gpu_data
        if self.height is not None:
            result['Height'] = self.height
        if self.is_one_track_data is not None:
            result['IsOneTrackData'] = self.is_one_track_data
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.reclose_prec is not None:
            result['ReclosePrec'] = self.reclose_prec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('RenderRatio') is not None:
            self.render_ratio = m.get('RenderRatio')
        if m.get('IsGpuData') is not None:
            self.is_gpu_data = m.get('IsGpuData')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsOneTrackData') is not None:
            self.is_one_track_data = m.get('IsOneTrackData')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('ReclosePrec') is not None:
            self.reclose_prec = m.get('ReclosePrec')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig(TeaModel):
    def __init__(
        self,
        timeline_config_audio: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio = None,
        timeline_config_video: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo = None,
    ):
        self.timeline_config_audio = timeline_config_audio
        self.timeline_config_video = timeline_config_video

    def validate(self):
        if self.timeline_config_audio:
            self.timeline_config_audio.validate()
        if self.timeline_config_video:
            self.timeline_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config_audio is not None:
            result['TimelineConfigAudio'] = self.timeline_config_audio.to_map()
        if self.timeline_config_video is not None:
            result['TimelineConfigVideo'] = self.timeline_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfigAudio') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio()
            self.timeline_config_audio = temp_model.from_map(m['TimelineConfigAudio'])
        if m.get('TimelineConfigVideo') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo()
            self.timeline_config_video = temp_model.from_map(m['TimelineConfigVideo'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline(TeaModel):
    def __init__(
        self,
        track_list: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList = None,
        timeline_config: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig = None,
    ):
        self.track_list = track_list
        self.timeline_config = timeline_config

    def validate(self):
        if self.track_list:
            self.track_list.validate()
        if self.timeline_config:
            self.timeline_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.track_list is not None:
            result['TrackList'] = self.track_list.to_map()
        if self.timeline_config is not None:
            result['TimelineConfig'] = self.timeline_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TrackList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTrackList()
            self.track_list = temp_model.from_map(m['TrackList'])
        if m.get('TimelineConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimelineTimelineConfig()
            self.timeline_config = temp_model.from_map(m['TimelineConfig'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect(TeaModel):
    def __init__(
        self,
        effect: str = None,
        effect_config: str = None,
    ):
        self.effect = effect
        self.effect_config = effect_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('EffectConfig') is not None:
            self.effect_config = m.get('EffectConfig')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects(TeaModel):
    def __init__(
        self,
        effect: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect] = None,
    ):
        self.effect = effect

    def validate(self):
        if self.effect:
            for k in self.effect:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Effect'] = []
        if self.effect is not None:
            for k in self.effect:
                result['Effect'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effect = []
        if m.get('Effect') is not None:
            for k in m.get('Effect'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffectsEffect()
                self.effect.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip(TeaModel):
    def __init__(
        self,
        type: str = None,
        source_id: str = None,
        effects: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects = None,
        source_type: str = None,
        source_strm_map: str = None,
        out: str = None,
        in_: str = None,
        id: str = None,
    ):
        self.type = type
        self.source_id = source_id
        self.effects = effects
        self.source_type = source_type
        self.source_strm_map = source_strm_map
        self.out = out
        self.in_ = in_
        self.id = id

    def validate(self):
        if self.effects:
            self.effects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.source_id is not None:
            result['SourceID'] = self.source_id
        if self.effects is not None:
            result['Effects'] = self.effects.to_map()
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_strm_map is not None:
            result['SourceStrmMap'] = self.source_strm_map
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SourceID') is not None:
            self.source_id = m.get('SourceID')
        if m.get('Effects') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClipEffects()
            self.effects = temp_model.from_map(m['Effects'])
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceStrmMap') is not None:
            self.source_strm_map = m.get('SourceStrmMap')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList(TeaModel):
    def __init__(
        self,
        clip: List[QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipListClip()
                self.clip.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigEditing(TeaModel):
    def __init__(
        self,
        timeline: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline = None,
        clip_list: QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList = None,
    ):
        self.timeline = timeline
        self.clip_list = clip_list

    def validate(self):
        if self.timeline:
            self.timeline.validate()
        if self.clip_list:
            self.clip_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.clip_list is not None:
            result['ClipList'] = self.clip_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timeline') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('ClipList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditingClipList()
            self.clip_list = temp_model.from_map(m['ClipList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan(TeaModel):
    def __init__(
        self,
        seek: str = None,
        duration: str = None,
    ):
        self.seek = seek
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seek is not None:
            result['Seek'] = self.seek
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigClip(TeaModel):
    def __init__(
        self,
        time_span: QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig(TeaModel):
    def __init__(
        self,
        gif: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif = None,
        segment: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList = None,
        subtitle_list: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        preload_time: str = None,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
    ):
        self.preload_time = preload_time
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        timebase: str = None,
        avg_fps: str = None,
        pix_fmt: str = None,
        sar: str = None,
        lang: str = None,
        codec_long_name: str = None,
        height: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        has_bframes: str = None,
        profile: str = None,
        start_time: str = None,
        network_cost: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        dar: str = None,
        codec_name: str = None,
        width: str = None,
        duration: str = None,
        fps: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
        level: str = None,
    ):
        self.index = index
        self.timebase = timebase
        self.avg_fps = avg_fps
        self.pix_fmt = pix_fmt
        self.sar = sar
        self.lang = lang
        self.codec_long_name = codec_long_name
        self.height = height
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.has_bframes = has_bframes
        self.profile = profile
        self.start_time = start_time
        self.network_cost = network_cost
        self.dar = dar
        self.codec_name = codec_name
        self.width = width
        self.duration = duration
        self.fps = fps
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base
        self.level = level

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.height is not None:
            result['Height'] = self.height
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NetworkCost') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        timebase: str = None,
        index: str = None,
        sample_fmt: str = None,
        channel_layout: str = None,
        lang: str = None,
        samplerate: str = None,
        codec_long_name: str = None,
        channels: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        start_time: str = None,
        codec_name: str = None,
        duration: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
    ):
        self.timebase = timebase
        self.index = index
        self.sample_fmt = sample_fmt
        self.channel_layout = channel_layout
        self.lang = lang
        self.samplerate = samplerate
        self.codec_long_name = codec_long_name
        self.channels = channels
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.start_time = start_time
        self.codec_name = codec_name
        self.duration = duration
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.index is not None:
            result['Index'] = self.index
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams(TeaModel):
    def __init__(
        self,
        video_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList = None,
        audio_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList = None,
    ):
        self.video_stream_list = video_stream_list
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list

    def validate(self):
        if self.video_stream_list:
            self.video_stream_list.validate()
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        if m.get('AudioStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        num_programs: str = None,
        size: str = None,
        num_streams: str = None,
        format_long_name: str = None,
        duration: str = None,
        bitrate: str = None,
        format_name: str = None,
    ):
        self.start_time = start_time
        self.num_programs = num_programs
        self.size = size
        self.num_streams = num_streams
        self.format_long_name = format_long_name
        self.duration = duration
        self.bitrate = bitrate
        self.format_name = format_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.size is not None:
            result['Size'] = self.size
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfigProperties(TeaModel):
    def __init__(
        self,
        width: str = None,
        height: str = None,
        duration: str = None,
        fps: str = None,
        bitrate: str = None,
        file_format: str = None,
        streams: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams = None,
        format: QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat = None,
        file_size: str = None,
    ):
        self.width = width
        self.height = height
        self.duration = duration
        self.fps = fps
        self.bitrate = bitrate
        self.file_format = file_format
        self.streams = streams
        self.format = format
        self.file_size = file_size

    def validate(self):
        if self.streams:
            self.streams.validate()
        if self.format:
            self.format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Streams') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Format') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class QueryEditingJobListResponseBodyJobListJobEditingConfig(TeaModel):
    def __init__(
        self,
        video: QueryEditingJobListResponseBodyJobListJobEditingConfigVideo = None,
        trans_config: QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig = None,
        encryption: QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption = None,
        water_mark_list: QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList = None,
        de_watermark: str = None,
        water_mark_config_url: str = None,
        m_3u8non_standard_support: QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport = None,
        priority: str = None,
        audio: QueryEditingJobListResponseBodyJobListJobEditingConfigAudio = None,
        audio_stream_map: str = None,
        merge_list: QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList = None,
        super_reso: QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso = None,
        user_data: str = None,
        digi_water_mark: QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark = None,
        video_stream_map: str = None,
        output_file: QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile = None,
        rotate: str = None,
        editing: QueryEditingJobListResponseBodyJobListJobEditingConfigEditing = None,
        container: QueryEditingJobListResponseBodyJobListJobEditingConfigContainer = None,
        clip: QueryEditingJobListResponseBodyJobListJobEditingConfigClip = None,
        merge_config_url: str = None,
        mux_config: QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig = None,
        template_id: str = None,
        subtitle_config: QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig = None,
        properties: QueryEditingJobListResponseBodyJobListJobEditingConfigProperties = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.encryption = encryption
        self.water_mark_list = water_mark_list
        self.de_watermark = de_watermark
        self.water_mark_config_url = water_mark_config_url
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.priority = priority
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.merge_list = merge_list
        self.super_reso = super_reso
        self.user_data = user_data
        self.digi_water_mark = digi_water_mark
        self.video_stream_map = video_stream_map
        self.output_file = output_file
        self.rotate = rotate
        self.editing = editing
        self.container = container
        self.clip = clip
        self.merge_config_url = merge_config_url
        self.mux_config = mux_config
        self.template_id = template_id
        self.subtitle_config = subtitle_config
        self.properties = properties

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.encryption:
            self.encryption.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.audio:
            self.audio.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.digi_water_mark:
            self.digi_water_mark.validate()
        if self.output_file:
            self.output_file.validate()
        if self.editing:
            self.editing.validate()
        if self.container:
            self.container.validate()
        if self.clip:
            self.clip.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.digi_water_mark is not None:
            result['DigiWaterMark'] = self.digi_water_mark.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.editing is not None:
            result['Editing'] = self.editing.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Encryption') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('WaterMarkList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Audio') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('MergeList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('SuperReso') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('DigiWaterMark') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigDigiWaterMark()
            self.digi_water_mark = temp_model.from_map(m['DigiWaterMark'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('OutputFile') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Editing') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigEditing()
            self.editing = temp_model.from_map(m['Editing'])
        if m.get('Container') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Clip') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MuxConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('SubtitleConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('Properties') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfigProperties()
            self.properties = temp_model.from_map(m['Properties'])
        return self


class QueryEditingJobListResponseBodyJobListJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class QueryEditingJobListResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        finish_time: str = None,
        state: str = None,
        job_id: str = None,
        code: str = None,
        message: str = None,
        editing_inputs: QueryEditingJobListResponseBodyJobListJobEditingInputs = None,
        pipeline_id: str = None,
        editing_config: QueryEditingJobListResponseBodyJobListJobEditingConfig = None,
        mnsmessage_result: QueryEditingJobListResponseBodyJobListJobMNSMessageResult = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.code = code
        self.message = message
        self.editing_inputs = editing_inputs
        self.pipeline_id = pipeline_id
        self.editing_config = editing_config
        self.mnsmessage_result = mnsmessage_result

    def validate(self):
        if self.editing_inputs:
            self.editing_inputs.validate()
        if self.editing_config:
            self.editing_config.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('EditingInputs') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingInputs()
            self.editing_inputs = temp_model.from_map(m['EditingInputs'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('EditingConfig') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobEditingConfig()
            self.editing_config = temp_model.from_map(m['EditingConfig'])
        if m.get('MNSMessageResult') is not None:
            temp_model = QueryEditingJobListResponseBodyJobListJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        return self


class QueryEditingJobListResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[QueryEditingJobListResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = QueryEditingJobListResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class QueryEditingJobListResponseBody(TeaModel):
    def __init__(
        self,
        non_exist_job_ids: QueryEditingJobListResponseBodyNonExistJobIds = None,
        request_id: str = None,
        job_list: QueryEditingJobListResponseBodyJobList = None,
    ):
        self.non_exist_job_ids = non_exist_job_ids
        self.request_id = request_id
        self.job_list = job_list

    def validate(self):
        if self.non_exist_job_ids:
            self.non_exist_job_ids.validate()
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exist_job_ids is not None:
            result['NonExistJobIds'] = self.non_exist_job_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExistJobIds') is not None:
            temp_model = QueryEditingJobListResponseBodyNonExistJobIds()
            self.non_exist_job_ids = temp_model.from_map(m['NonExistJobIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobList') is not None:
            temp_model = QueryEditingJobListResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class QueryEditingJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryEditingJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryEditingJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateMCTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        template_id: str = None,
        name: str = None,
        porn: str = None,
        terrorism: str = None,
        politics: str = None,
        ad: str = None,
        qrcode: str = None,
        live: str = None,
        logo: str = None,
        abuse: str = None,
        contraband: str = None,
        spam: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.template_id = template_id
        self.name = name
        self.porn = porn
        self.terrorism = terrorism
        self.politics = politics
        self.ad = ad
        self.qrcode = qrcode
        self.live = live
        self.logo = logo
        self.abuse = abuse
        self.contraband = contraband
        self.spam = spam
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.name is not None:
            result['Name'] = self.name
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.live is not None:
            result['Live'] = self.live
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.spam is not None:
            result['spam'] = self.spam
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('spam') is not None:
            self.spam = m.get('spam')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class UpdateMCTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        logo: str = None,
        abuse: str = None,
        state: str = None,
        terrorism: str = None,
        politics: str = None,
        qrcode: str = None,
        live: str = None,
        spam: str = None,
        contraband: str = None,
        ad: str = None,
        porn: str = None,
        name: str = None,
        template_id: str = None,
    ):
        self.logo = logo
        self.abuse = abuse
        self.state = state
        self.terrorism = terrorism
        self.politics = politics
        self.qrcode = qrcode
        self.live = live
        self.spam = spam
        self.contraband = contraband
        self.ad = ad
        self.porn = porn
        self.name = name
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.state is not None:
            result['State'] = self.state
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.live is not None:
            result['Live'] = self.live
        if self.spam is not None:
            result['Spam'] = self.spam
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.name is not None:
            result['Name'] = self.name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Spam') is not None:
            self.spam = m.get('Spam')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class UpdateMCTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: UpdateMCTemplateResponseBodyTemplate = None,
    ):
        self.request_id = request_id
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = UpdateMCTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class UpdateMCTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateMCTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateMCTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportCoverJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        result: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.result = result
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.result is not None:
            result['Result'] = self.result
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportCoverJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportCoverJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportCoverJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportCoverJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitImageQualityJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        input: str = None,
        pipeline_id: str = None,
        user_data: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.input = input
        self.pipeline_id = pipeline_id
        self.user_data = user_data
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.input is not None:
            result['Input'] = self.input
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitImageQualityJobResponseBodyImageQualityJobResult(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        score: str = None,
    ):
        self.code = code
        self.message = message
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.score is not None:
            result['Score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        return self


class SubmitImageQualityJobResponseBodyImageQualityJobInput(TeaModel):
    def __init__(
        self,
        url: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.url = url
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitImageQualityJobResponseBodyImageQualityJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        result: SubmitImageQualityJobResponseBodyImageQualityJobResult = None,
        state: str = None,
        job_id: str = None,
        user_data: str = None,
        pipeline_id: str = None,
        input: SubmitImageQualityJobResponseBodyImageQualityJobInput = None,
    ):
        self.creation_time = creation_time
        self.result = result
        self.state = state
        self.job_id = job_id
        self.user_data = user_data
        self.pipeline_id = pipeline_id
        self.input = input

    def validate(self):
        if self.result:
            self.result.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Result') is not None:
            temp_model = SubmitImageQualityJobResponseBodyImageQualityJobResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Input') is not None:
            temp_model = SubmitImageQualityJobResponseBodyImageQualityJobInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class SubmitImageQualityJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        image_quality_job: SubmitImageQualityJobResponseBodyImageQualityJob = None,
    ):
        self.request_id = request_id
        self.image_quality_job = image_quality_job

    def validate(self):
        if self.image_quality_job:
            self.image_quality_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.image_quality_job is not None:
            result['ImageQualityJob'] = self.image_quality_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ImageQualityJob') is not None:
            temp_model = SubmitImageQualityJobResponseBodyImageQualityJob()
            self.image_quality_job = temp_model.from_map(m['ImageQualityJob'])
        return self


class SubmitImageQualityJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitImageQualityJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitImageQualityJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMCTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        name: str = None,
        porn: str = None,
        terrorism: str = None,
        politics: str = None,
        ad: str = None,
        qrcode: str = None,
        live: str = None,
        logo: str = None,
        abuse: str = None,
        contraband: str = None,
        spam: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.porn = porn
        self.terrorism = terrorism
        self.politics = politics
        self.ad = ad
        self.qrcode = qrcode
        self.live = live
        self.logo = logo
        self.abuse = abuse
        self.contraband = contraband
        self.spam = spam
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.live is not None:
            result['Live'] = self.live
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.spam is not None:
            result['spam'] = self.spam
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('spam') is not None:
            self.spam = m.get('spam')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AddMCTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        logo: str = None,
        abuse: str = None,
        terrorism: str = None,
        politics: str = None,
        qrcode: str = None,
        spam: str = None,
        live: str = None,
        contraband: str = None,
        ad: str = None,
        porn: str = None,
        name: str = None,
        template_id: str = None,
    ):
        self.logo = logo
        self.abuse = abuse
        self.terrorism = terrorism
        self.politics = politics
        self.qrcode = qrcode
        self.spam = spam
        self.live = live
        self.contraband = contraband
        self.ad = ad
        self.porn = porn
        self.name = name
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.abuse is not None:
            result['Abuse'] = self.abuse
        if self.terrorism is not None:
            result['Terrorism'] = self.terrorism
        if self.politics is not None:
            result['Politics'] = self.politics
        if self.qrcode is not None:
            result['Qrcode'] = self.qrcode
        if self.spam is not None:
            result['Spam'] = self.spam
        if self.live is not None:
            result['Live'] = self.live
        if self.contraband is not None:
            result['Contraband'] = self.contraband
        if self.ad is not None:
            result['Ad'] = self.ad
        if self.porn is not None:
            result['Porn'] = self.porn
        if self.name is not None:
            result['Name'] = self.name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('Abuse') is not None:
            self.abuse = m.get('Abuse')
        if m.get('Terrorism') is not None:
            self.terrorism = m.get('Terrorism')
        if m.get('Politics') is not None:
            self.politics = m.get('Politics')
        if m.get('Qrcode') is not None:
            self.qrcode = m.get('Qrcode')
        if m.get('Spam') is not None:
            self.spam = m.get('Spam')
        if m.get('Live') is not None:
            self.live = m.get('Live')
        if m.get('Contraband') is not None:
            self.contraband = m.get('Contraband')
        if m.get('Ad') is not None:
            self.ad = m.get('Ad')
        if m.get('Porn') is not None:
            self.porn = m.get('Porn')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddMCTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: AddMCTemplateResponseBodyTemplate = None,
    ):
        self.request_id = request_id
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddMCTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddMCTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddMCTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddMCTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SearchTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        page_size: int = None,
        page_number: int = None,
        state: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.page_size = page_size
        self.page_number = page_number
        self.state = state
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.state is not None:
            result['State'] = self.state
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SearchTemplateResponseBodyTemplateListTemplateVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class SearchTemplateResponseBodyTemplateListTemplateVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        long_short_mode: str = None,
        degrain: str = None,
        bitrate_bnd: SearchTemplateResponseBodyTemplateListTemplateVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        remove: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
    ):
        self.bufsize = bufsize
        self.long_short_mode = long_short_mode
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.remove = remove
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class SearchTemplateResponseBodyTemplateListTemplateTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        trans_mode: str = None,
        is_check_reso: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.trans_mode = trans_mode
        self.is_check_reso = is_check_reso
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class SearchTemplateResponseBodyTemplateListTemplateMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class SearchTemplateResponseBodyTemplateListTemplateMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class SearchTemplateResponseBodyTemplateListTemplateMuxConfig(TeaModel):
    def __init__(
        self,
        gif: SearchTemplateResponseBodyTemplateListTemplateMuxConfigGif = None,
        segment: SearchTemplateResponseBodyTemplateListTemplateMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class SearchTemplateResponseBodyTemplateListTemplateAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        remove: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.remove = remove
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.bitrate = bitrate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class SearchTemplateResponseBodyTemplateListTemplateContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class SearchTemplateResponseBodyTemplateListTemplate(TeaModel):
    def __init__(
        self,
        video: SearchTemplateResponseBodyTemplateListTemplateVideo = None,
        trans_config: SearchTemplateResponseBodyTemplateListTemplateTransConfig = None,
        state: str = None,
        mux_config: SearchTemplateResponseBodyTemplateListTemplateMuxConfig = None,
        name: str = None,
        audio: SearchTemplateResponseBodyTemplateListTemplateAudio = None,
        id: str = None,
        container: SearchTemplateResponseBodyTemplateListTemplateContainer = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.state = state
        self.mux_config = mux_config
        self.name = name
        self.audio = audio
        self.id = id
        self.container = container

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.container is not None:
            result['Container'] = self.container.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('MuxConfig') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Audio') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Container') is not None:
            temp_model = SearchTemplateResponseBodyTemplateListTemplateContainer()
            self.container = temp_model.from_map(m['Container'])
        return self


class SearchTemplateResponseBodyTemplateList(TeaModel):
    def __init__(
        self,
        template: List[SearchTemplateResponseBodyTemplateListTemplate] = None,
    ):
        self.template = template

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = SearchTemplateResponseBodyTemplateListTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class SearchTemplateResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        template_list: SearchTemplateResponseBodyTemplateList = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.template_list = template_list
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.template_list:
            self.template_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.template_list is not None:
            result['TemplateList'] = self.template_list.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TemplateList') is not None:
            temp_model = SearchTemplateResponseBodyTemplateList()
            self.template_list = temp_model.from_map(m['TemplateList'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class SearchTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SearchTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SearchTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateMcuTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        template_id: str = None,
        template: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.template_id = template_id
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class UpdateMcuTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class UpdateMcuTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateMcuTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateMcuTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFacerecogJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        input: str = None,
        facerecog_config: str = None,
        user_data: str = None,
        pipeline_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.input = input
        self.facerecog_config = facerecog_config
        self.user_data = user_data
        self.pipeline_id = pipeline_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.input is not None:
            result['Input'] = self.input
        if self.facerecog_config is not None:
            result['FacerecogConfig'] = self.facerecog_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('FacerecogConfig') is not None:
            self.facerecog_config = m.get('FacerecogConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitFacerecogJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class SubmitFacerecogJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitFacerecogJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFacerecogJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitEditingJobsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        editing_inputs: str = None,
        editing_job_outputs: str = None,
        output_bucket: str = None,
        output_location: str = None,
        pipeline_id: str = None,
        editing_job_url: str = None,
        editing_job_oss_file_role_arn: str = None,
        editing_job_oss_file_uid: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.editing_inputs = editing_inputs
        self.editing_job_outputs = editing_job_outputs
        self.output_bucket = output_bucket
        self.output_location = output_location
        self.pipeline_id = pipeline_id
        self.editing_job_url = editing_job_url
        self.editing_job_oss_file_role_arn = editing_job_oss_file_role_arn
        self.editing_job_oss_file_uid = editing_job_oss_file_uid
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs
        if self.editing_job_outputs is not None:
            result['EditingJobOutputs'] = self.editing_job_outputs
        if self.output_bucket is not None:
            result['OutputBucket'] = self.output_bucket
        if self.output_location is not None:
            result['OutputLocation'] = self.output_location
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.editing_job_url is not None:
            result['EditingJobURL'] = self.editing_job_url
        if self.editing_job_oss_file_role_arn is not None:
            result['EditingJobOssFileRoleArn'] = self.editing_job_oss_file_role_arn
        if self.editing_job_oss_file_uid is not None:
            result['EditingJobOssFileUid'] = self.editing_job_oss_file_uid
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('EditingInputs') is not None:
            self.editing_inputs = m.get('EditingInputs')
        if m.get('EditingJobOutputs') is not None:
            self.editing_job_outputs = m.get('EditingJobOutputs')
        if m.get('OutputBucket') is not None:
            self.output_bucket = m.get('OutputBucket')
        if m.get('OutputLocation') is not None:
            self.output_location = m.get('OutputLocation')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('EditingJobURL') is not None:
            self.editing_job_url = m.get('EditingJobURL')
        if m.get('EditingJobOssFileRoleArn') is not None:
            self.editing_job_oss_file_role_arn = m.get('EditingJobOssFileRoleArn')
        if m.get('EditingJobOssFileUid') is not None:
            self.editing_job_oss_file_uid = m.get('EditingJobOssFileUid')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputConfig(TeaModel):
    def __init__(
        self,
        is_normal_sar: str = None,
        deinterlace_method: str = None,
    ):
        self.is_normal_sar = is_normal_sar
        self.deinterlace_method = deinterlace_method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_normal_sar is not None:
            result['IsNormalSar'] = self.is_normal_sar
        if self.deinterlace_method is not None:
            result['DeinterlaceMethod'] = self.deinterlace_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsNormalSar') is not None:
            self.is_normal_sar = m.get('IsNormalSar')
        if m.get('DeinterlaceMethod') is not None:
            self.deinterlace_method = m.get('DeinterlaceMethod')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInput(TeaModel):
    def __init__(
        self,
        input_file: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputFile = None,
        input_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputConfig = None,
        id: str = None,
    ):
        self.input_file = input_file
        self.input_config = input_config
        self.id = id

    def validate(self):
        if self.input_file:
            self.input_file.validate()
        if self.input_config:
            self.input_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('InputConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInputInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputs(TeaModel):
    def __init__(
        self,
        editing_input: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInput] = None,
    ):
        self.editing_input = editing_input

    def validate(self):
        if self.editing_input:
            for k in self.editing_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EditingInput'] = []
        if self.editing_input is not None:
            for k in self.editing_input:
                result['EditingInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.editing_input = []
        if m.get('EditingInput') is not None:
            for k in m.get('EditingInput'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputsEditingInput()
                self.editing_input.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideoBitrateBnd(TeaModel):
    def __init__(
        self,
        max: str = None,
        min: str = None,
    ):
        self.max = max
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideo(TeaModel):
    def __init__(
        self,
        bufsize: str = None,
        degrain: str = None,
        bitrate_bnd: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideoBitrateBnd = None,
        pix_fmt: str = None,
        pad: str = None,
        codec: str = None,
        height: str = None,
        qscale: str = None,
        crop: str = None,
        bitrate: str = None,
        maxrate: str = None,
        max_fps: str = None,
        profile: str = None,
        crf: str = None,
        gop: str = None,
        width: str = None,
        fps: str = None,
        preset: str = None,
        scan_mode: str = None,
    ):
        self.bufsize = bufsize
        self.degrain = degrain
        self.bitrate_bnd = bitrate_bnd
        self.pix_fmt = pix_fmt
        self.pad = pad
        self.codec = codec
        self.height = height
        self.qscale = qscale
        self.crop = crop
        self.bitrate = bitrate
        self.maxrate = maxrate
        self.max_fps = max_fps
        self.profile = profile
        self.crf = crf
        self.gop = gop
        self.width = width
        self.fps = fps
        self.preset = preset
        self.scan_mode = scan_mode

    def validate(self):
        if self.bitrate_bnd:
            self.bitrate_bnd.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.degrain is not None:
            result['Degrain'] = self.degrain
        if self.bitrate_bnd is not None:
            result['BitrateBnd'] = self.bitrate_bnd.to_map()
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.height is not None:
            result['Height'] = self.height
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.width is not None:
            result['Width'] = self.width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Degrain') is not None:
            self.degrain = m.get('Degrain')
        if m.get('BitrateBnd') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideoBitrateBnd()
            self.bitrate_bnd = temp_model.from_map(m['BitrateBnd'])
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigTransConfig(TeaModel):
    def __init__(
        self,
        is_check_audio_bitrate: str = None,
        is_check_reso: str = None,
        trans_mode: str = None,
        is_check_video_bitrate_fail: str = None,
        adj_dar_method: str = None,
        duration: str = None,
        is_check_video_bitrate: str = None,
        is_check_reso_fail: str = None,
        is_check_audio_bitrate_fail: str = None,
    ):
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_reso = is_check_reso
        self.trans_mode = trans_mode
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.adj_dar_method = adj_dar_method
        self.duration = duration
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEncryption(TeaModel):
    def __init__(
        self,
        type: str = None,
        key: str = None,
        key_type: str = None,
        id: str = None,
        key_uri: str = None,
        skip_cnt: str = None,
    ):
        self.type = type
        self.key = key
        self.key_type = key_type
        self.id = id
        self.key_uri = key_uri
        self.skip_cnt = skip_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.id is not None:
            result['Id'] = self.id
        if self.key_uri is not None:
            result['KeyUri'] = self.key_uri
        if self.skip_cnt is not None:
            result['SkipCnt'] = self.skip_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('KeyUri') is not None:
            self.key_uri = m.get('KeyUri')
        if m.get('SkipCnt') is not None:
            self.skip_cnt = m.get('SkipCnt')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        refer_pos: str = None,
        dx: str = None,
        width: str = None,
        height: str = None,
        input_file: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMarkInputFile = None,
        water_mark_template_id: str = None,
        dy: str = None,
    ):
        self.type = type
        self.refer_pos = refer_pos
        self.dx = dx
        self.width = width
        self.height = height
        self.input_file = input_file
        self.water_mark_template_id = water_mark_template_id
        self.dy = dy

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.water_mark_template_id is not None:
            result['WaterMarkTemplateId'] = self.water_mark_template_id
        if self.dy is not None:
            result['Dy'] = self.dy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('InputFile') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('WaterMarkTemplateId') is not None:
            self.water_mark_template_id = m.get('WaterMarkTemplateId')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkList(TeaModel):
    def __init__(
        self,
        water_mark: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMark] = None,
    ):
        self.water_mark = water_mark

    def validate(self):
        if self.water_mark:
            for k in self.water_mark:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WaterMark'] = []
        if self.water_mark is not None:
            for k in self.water_mark:
                result['WaterMark'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.water_mark = []
        if m.get('WaterMark') is not None:
            for k in m.get('WaterMark'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkListWaterMark()
                self.water_mark.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupportTS(TeaModel):
    def __init__(
        self,
        size_support: bool = None,
        md_5support: bool = None,
    ):
        self.size_support = size_support
        self.md_5support = md_5support

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size_support is not None:
            result['SizeSupport'] = self.size_support
        if self.md_5support is not None:
            result['Md5Support'] = self.md_5support
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SizeSupport') is not None:
            self.size_support = m.get('SizeSupport')
        if m.get('Md5Support') is not None:
            self.md_5support = m.get('Md5Support')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupport(TeaModel):
    def __init__(
        self,
        ts: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupportTS = None,
    ):
        self.ts = ts

    def validate(self):
        if self.ts:
            self.ts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['TS'] = self.ts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TS') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupportTS()
            self.ts = temp_model.from_map(m['TS'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudioVolume(TeaModel):
    def __init__(
        self,
        method: str = None,
        level: str = None,
    ):
        self.method = method
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudio(TeaModel):
    def __init__(
        self,
        profile: str = None,
        codec: str = None,
        samplerate: str = None,
        qscale: str = None,
        channels: str = None,
        volume: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudioVolume = None,
        bitrate: str = None,
    ):
        self.profile = profile
        self.codec = codec
        self.samplerate = samplerate
        self.qscale = qscale
        self.channels = channels
        self.volume = volume
        self.bitrate = bitrate

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Volume') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeListMerge(TeaModel):
    def __init__(
        self,
        start: str = None,
        role_arn: str = None,
        merge_url: str = None,
        duration: str = None,
    ):
        self.start = start
        self.role_arn = role_arn
        self.merge_url = merge_url
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.merge_url is not None:
            result['MergeURL'] = self.merge_url
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('MergeURL') is not None:
            self.merge_url = m.get('MergeURL')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeList(TeaModel):
    def __init__(
        self,
        merge: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeListMerge] = None,
    ):
        self.merge = merge

    def validate(self):
        if self.merge:
            for k in self.merge:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Merge'] = []
        if self.merge is not None:
            for k in self.merge:
                result['Merge'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.merge = []
        if m.get('Merge') is not None:
            for k in m.get('Merge'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeListMerge()
                self.merge.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSuperReso(TeaModel):
    def __init__(
        self,
        is_half_sample: str = None,
    ):
        self.is_half_sample = is_half_sample

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_half_sample is not None:
            result['IsHalfSample'] = self.is_half_sample
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsHalfSample') is not None:
            self.is_half_sample = m.get('IsHalfSample')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMarkInputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMark(TeaModel):
    def __init__(
        self,
        type: str = None,
        alpha: str = None,
        input_file: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMarkInputFile = None,
    ):
        self.type = type
        self.alpha = alpha
        self.input_file = input_file

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.alpha is not None:
            result['Alpha'] = self.alpha
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Alpha') is not None:
            self.alpha = m.get('Alpha')
        if m.get('InputFile') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMarkInputFile()
            self.input_file = temp_model.from_map(m['InputFile'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigOutputFile(TeaModel):
    def __init__(
        self,
        role_arn: str = None,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.role_arn = role_arn
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo(TeaModel):
    def __init__(
        self,
        t: str = None,
        l: str = None,
    ):
        self.t = t
        self.l = l

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.t is not None:
            result['T'] = self.t
        if self.l is not None:
            result['L'] = self.l
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('T') is not None:
            self.t = m.get('T')
        if m.get('L') is not None:
            self.l = m.get('L')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig(TeaModel):
    def __init__(
        self,
        clips_config_video: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo = None,
    ):
        self.clips_config_video = clips_config_video

    def validate(self):
        if self.clips_config_video:
            self.clips_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config_video is not None:
            result['ClipsConfigVideo'] = self.clips_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfigVideo') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfigClipsConfigVideo()
            self.clips_config_video = temp_model.from_map(m['ClipsConfigVideo'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClip(TeaModel):
    def __init__(
        self,
        clips_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig = None,
        out: str = None,
        in_: str = None,
        clip_id: str = None,
    ):
        self.clips_config = clips_config
        self.out = out
        self.in_ = in_
        self.clip_id = clip_id

    def validate(self):
        if self.clips_config:
            self.clips_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_config is not None:
            result['ClipsConfig'] = self.clips_config.to_map()
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.clip_id is not None:
            result['clipID'] = self.clip_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClipClipsConfig()
            self.clips_config = temp_model.from_map(m['ClipsConfig'])
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('clipID') is not None:
            self.clip_id = m.get('clipID')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClips(TeaModel):
    def __init__(
        self,
        clip: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClipsClip()
                self.clip.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrack(TeaModel):
    def __init__(
        self,
        type: str = None,
        order: str = None,
        id: str = None,
        clips: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClips = None,
    ):
        self.type = type
        self.order = order
        self.id = id
        self.clips = clips

    def validate(self):
        if self.clips:
            self.clips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.order is not None:
            result['Order'] = self.order
        if self.id is not None:
            result['Id'] = self.id
        if self.clips is not None:
            result['Clips'] = self.clips.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Clips') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrackClips()
            self.clips = temp_model.from_map(m['Clips'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackList(TeaModel):
    def __init__(
        self,
        track: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrack] = None,
    ):
        self.track = track

    def validate(self):
        if self.track:
            for k in self.track:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Track'] = []
        if self.track is not None:
            for k in self.track:
                result['Track'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track = []
        if m.get('Track') is not None:
            for k in m.get('Track'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackListTrack()
                self.track.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio(TeaModel):
    def __init__(
        self,
        channel_layout: str = None,
        samplerate: str = None,
        channels: str = None,
    ):
        self.channel_layout = channel_layout
        self.samplerate = samplerate
        self.channels = channels

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.channels is not None:
            result['Channels'] = self.channels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo(TeaModel):
    def __init__(
        self,
        bg_color: str = None,
        width: str = None,
        render_ratio: str = None,
        is_gpu_data: str = None,
        height: str = None,
        is_one_track_data: str = None,
        fps: str = None,
        reclose_prec: str = None,
    ):
        self.bg_color = bg_color
        self.width = width
        self.render_ratio = render_ratio
        self.is_gpu_data = is_gpu_data
        self.height = height
        self.is_one_track_data = is_one_track_data
        self.fps = fps
        self.reclose_prec = reclose_prec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_color is not None:
            result['BgColor'] = self.bg_color
        if self.width is not None:
            result['Width'] = self.width
        if self.render_ratio is not None:
            result['RenderRatio'] = self.render_ratio
        if self.is_gpu_data is not None:
            result['IsGpuData'] = self.is_gpu_data
        if self.height is not None:
            result['Height'] = self.height
        if self.is_one_track_data is not None:
            result['IsOneTrackData'] = self.is_one_track_data
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.reclose_prec is not None:
            result['ReclosePrec'] = self.reclose_prec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BgColor') is not None:
            self.bg_color = m.get('BgColor')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('RenderRatio') is not None:
            self.render_ratio = m.get('RenderRatio')
        if m.get('IsGpuData') is not None:
            self.is_gpu_data = m.get('IsGpuData')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('IsOneTrackData') is not None:
            self.is_one_track_data = m.get('IsOneTrackData')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('ReclosePrec') is not None:
            self.reclose_prec = m.get('ReclosePrec')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfig(TeaModel):
    def __init__(
        self,
        timeline_config_audio: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio = None,
        timeline_config_video: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo = None,
    ):
        self.timeline_config_audio = timeline_config_audio
        self.timeline_config_video = timeline_config_video

    def validate(self):
        if self.timeline_config_audio:
            self.timeline_config_audio.validate()
        if self.timeline_config_video:
            self.timeline_config_video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline_config_audio is not None:
            result['TimelineConfigAudio'] = self.timeline_config_audio.to_map()
        if self.timeline_config_video is not None:
            result['TimelineConfigVideo'] = self.timeline_config_video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimelineConfigAudio') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigAudio()
            self.timeline_config_audio = temp_model.from_map(m['TimelineConfigAudio'])
        if m.get('TimelineConfigVideo') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfigTimelineConfigVideo()
            self.timeline_config_video = temp_model.from_map(m['TimelineConfigVideo'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimeline(TeaModel):
    def __init__(
        self,
        track_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackList = None,
        timeline_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfig = None,
    ):
        self.track_list = track_list
        self.timeline_config = timeline_config

    def validate(self):
        if self.track_list:
            self.track_list.validate()
        if self.timeline_config:
            self.timeline_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.track_list is not None:
            result['TrackList'] = self.track_list.to_map()
        if self.timeline_config is not None:
            result['TimelineConfig'] = self.timeline_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TrackList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTrackList()
            self.track_list = temp_model.from_map(m['TrackList'])
        if m.get('TimelineConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimelineTimelineConfig()
            self.timeline_config = temp_model.from_map(m['TimelineConfig'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffectsEffect(TeaModel):
    def __init__(
        self,
        effect: str = None,
        effect_config: str = None,
    ):
        self.effect = effect
        self.effect_config = effect_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.effect_config is not None:
            result['EffectConfig'] = self.effect_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('EffectConfig') is not None:
            self.effect_config = m.get('EffectConfig')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffects(TeaModel):
    def __init__(
        self,
        effect: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffectsEffect] = None,
    ):
        self.effect = effect

    def validate(self):
        if self.effect:
            for k in self.effect:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Effect'] = []
        if self.effect is not None:
            for k in self.effect:
                result['Effect'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effect = []
        if m.get('Effect') is not None:
            for k in m.get('Effect'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffectsEffect()
                self.effect.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClip(TeaModel):
    def __init__(
        self,
        type: str = None,
        source_id: str = None,
        effects: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffects = None,
        source_type: str = None,
        source_strm_map: str = None,
        out: str = None,
        in_: str = None,
        id: str = None,
    ):
        self.type = type
        self.source_id = source_id
        self.effects = effects
        self.source_type = source_type
        self.source_strm_map = source_strm_map
        self.out = out
        self.in_ = in_
        self.id = id

    def validate(self):
        if self.effects:
            self.effects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.source_id is not None:
            result['SourceID'] = self.source_id
        if self.effects is not None:
            result['Effects'] = self.effects.to_map()
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_strm_map is not None:
            result['SourceStrmMap'] = self.source_strm_map
        if self.out is not None:
            result['Out'] = self.out
        if self.in_ is not None:
            result['In'] = self.in_
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SourceID') is not None:
            self.source_id = m.get('SourceID')
        if m.get('Effects') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClipEffects()
            self.effects = temp_model.from_map(m['Effects'])
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceStrmMap') is not None:
            self.source_strm_map = m.get('SourceStrmMap')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipList(TeaModel):
    def __init__(
        self,
        clip: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClip] = None,
    ):
        self.clip = clip

    def validate(self):
        if self.clip:
            for k in self.clip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clip'] = []
        if self.clip is not None:
            for k in self.clip:
                result['Clip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clip = []
        if m.get('Clip') is not None:
            for k in m.get('Clip'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipListClip()
                self.clip.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditing(TeaModel):
    def __init__(
        self,
        timeline: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimeline = None,
        clip_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipList = None,
    ):
        self.timeline = timeline
        self.clip_list = clip_list

    def validate(self):
        if self.timeline:
            self.timeline.validate()
        if self.clip_list:
            self.clip_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.clip_list is not None:
            result['ClipList'] = self.clip_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timeline') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('ClipList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditingClipList()
            self.clip_list = temp_model.from_map(m['ClipList'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClipTimeSpan(TeaModel):
    def __init__(
        self,
        seek: str = None,
        duration: str = None,
    ):
        self.seek = seek
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.seek is not None:
            result['Seek'] = self.seek
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Seek') is not None:
            self.seek = m.get('Seek')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClip(TeaModel):
    def __init__(
        self,
        time_span: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClipTimeSpan = None,
    ):
        self.time_span = time_span

    def validate(self):
        if self.time_span:
            self.time_span.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_span is not None:
            result['TimeSpan'] = self.time_span.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeSpan') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClipTimeSpan()
            self.time_span = temp_model.from_map(m['TimeSpan'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigGif(TeaModel):
    def __init__(
        self,
        final_delay: str = None,
        dither_mode: str = None,
        loop: str = None,
        is_custom_palette: str = None,
    ):
        self.final_delay = final_delay
        self.dither_mode = dither_mode
        self.loop = loop
        self.is_custom_palette = is_custom_palette

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.final_delay is not None:
            result['FinalDelay'] = self.final_delay
        if self.dither_mode is not None:
            result['DitherMode'] = self.dither_mode
        if self.loop is not None:
            result['Loop'] = self.loop
        if self.is_custom_palette is not None:
            result['IsCustomPalette'] = self.is_custom_palette
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FinalDelay') is not None:
            self.final_delay = m.get('FinalDelay')
        if m.get('DitherMode') is not None:
            self.dither_mode = m.get('DitherMode')
        if m.get('Loop') is not None:
            self.loop = m.get('Loop')
        if m.get('IsCustomPalette') is not None:
            self.is_custom_palette = m.get('IsCustomPalette')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
    ):
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfig(TeaModel):
    def __init__(
        self,
        gif: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigGif = None,
        segment: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigSegment = None,
    ):
        self.gif = gif
        self.segment = segment

    def validate(self):
        if self.gif:
            self.gif.validate()
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gif is not None:
            result['Gif'] = self.gif.to_map()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gif') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigGif()
            self.gif = temp_model.from_map(m['Gif'])
        if m.get('Segment') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        font_name: str = None,
        input: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput = None,
    ):
        self.char_enc = char_enc
        self.font_name = font_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('Input') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitleInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleList(TeaModel):
    def __init__(
        self,
        ext_subtitle: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle] = None,
    ):
        self.ext_subtitle = ext_subtitle

    def validate(self):
        if self.ext_subtitle:
            for k in self.ext_subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExtSubtitle'] = []
        if self.ext_subtitle is not None:
            for k in self.ext_subtitle:
                result['ExtSubtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ext_subtitle = []
        if m.get('ExtSubtitle') is not None:
            for k in m.get('ExtSubtitle'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleListExtSubtitle()
                self.ext_subtitle.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleListSubtitle(TeaModel):
    def __init__(
        self,
        map: str = None,
    ):
        self.map = map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map is not None:
            result['Map'] = self.map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Map') is not None:
            self.map = m.get('Map')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleList(TeaModel):
    def __init__(
        self,
        subtitle: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleListSubtitle] = None,
    ):
        self.subtitle = subtitle

    def validate(self):
        if self.subtitle:
            for k in self.subtitle:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Subtitle'] = []
        if self.subtitle is not None:
            for k in self.subtitle:
                result['Subtitle'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle = []
        if m.get('Subtitle') is not None:
            for k in m.get('Subtitle'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleListSubtitle()
                self.subtitle.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfig(TeaModel):
    def __init__(
        self,
        ext_subtitle_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleList = None,
        subtitle_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleList = None,
    ):
        self.ext_subtitle_list = ext_subtitle_list
        self.subtitle_list = subtitle_list

    def validate(self):
        if self.ext_subtitle_list:
            self.ext_subtitle_list.validate()
        if self.subtitle_list:
            self.subtitle_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_subtitle_list is not None:
            result['ExtSubtitleList'] = self.ext_subtitle_list.to_map()
        if self.subtitle_list is not None:
            result['SubtitleList'] = self.subtitle_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtSubtitleList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigExtSubtitleList()
            self.ext_subtitle_list = temp_model.from_map(m['ExtSubtitleList'])
        if m.get('SubtitleList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfigSubtitleList()
            self.subtitle_list = temp_model.from_map(m['SubtitleList'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost(TeaModel):
    def __init__(
        self,
        preload_time: str = None,
        avg_bitrate: str = None,
        cost_bandwidth: str = None,
    ):
        self.preload_time = preload_time
        self.avg_bitrate = avg_bitrate
        self.cost_bandwidth = cost_bandwidth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preload_time is not None:
            result['PreloadTime'] = self.preload_time
        if self.avg_bitrate is not None:
            result['AvgBitrate'] = self.avg_bitrate
        if self.cost_bandwidth is not None:
            result['CostBandwidth'] = self.cost_bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreloadTime') is not None:
            self.preload_time = m.get('PreloadTime')
        if m.get('AvgBitrate') is not None:
            self.avg_bitrate = m.get('AvgBitrate')
        if m.get('CostBandwidth') is not None:
            self.cost_bandwidth = m.get('CostBandwidth')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        timebase: str = None,
        avg_fps: str = None,
        pix_fmt: str = None,
        sar: str = None,
        lang: str = None,
        codec_long_name: str = None,
        height: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        has_bframes: str = None,
        profile: str = None,
        start_time: str = None,
        network_cost: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost = None,
        dar: str = None,
        codec_name: str = None,
        width: str = None,
        duration: str = None,
        fps: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
        level: str = None,
    ):
        self.index = index
        self.timebase = timebase
        self.avg_fps = avg_fps
        self.pix_fmt = pix_fmt
        self.sar = sar
        self.lang = lang
        self.codec_long_name = codec_long_name
        self.height = height
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.has_bframes = has_bframes
        self.profile = profile
        self.start_time = start_time
        self.network_cost = network_cost
        self.dar = dar
        self.codec_name = codec_name
        self.width = width
        self.duration = duration
        self.fps = fps
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base
        self.level = level

    def validate(self):
        if self.network_cost:
            self.network_cost.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.height is not None:
            result['Height'] = self.height
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.network_cost is not None:
            result['NetworkCost'] = self.network_cost.to_map()
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.width is not None:
            result['Width'] = self.width
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NetworkCost') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStreamNetworkCost()
            self.network_cost = temp_model.from_map(m['NetworkCost'])
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamList(TeaModel):
    def __init__(
        self,
        video_stream: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStream] = None,
    ):
        self.video_stream = video_stream

    def validate(self):
        if self.video_stream:
            for k in self.video_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoStream'] = []
        if self.video_stream is not None:
            for k in self.video_stream:
                result['VideoStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_stream = []
        if m.get('VideoStream') is not None:
            for k in m.get('VideoStream'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamListVideoStream()
                self.video_stream.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamListAudioStream(TeaModel):
    def __init__(
        self,
        timebase: str = None,
        index: str = None,
        sample_fmt: str = None,
        channel_layout: str = None,
        lang: str = None,
        samplerate: str = None,
        codec_long_name: str = None,
        channels: str = None,
        num_frames: str = None,
        bitrate: str = None,
        codec_tag_string: str = None,
        start_time: str = None,
        codec_name: str = None,
        duration: str = None,
        codec_tag: str = None,
        codec_time_base: str = None,
    ):
        self.timebase = timebase
        self.index = index
        self.sample_fmt = sample_fmt
        self.channel_layout = channel_layout
        self.lang = lang
        self.samplerate = samplerate
        self.codec_long_name = codec_long_name
        self.channels = channels
        self.num_frames = num_frames
        self.bitrate = bitrate
        self.codec_tag_string = codec_tag_string
        self.start_time = start_time
        self.codec_name = codec_name
        self.duration = duration
        self.codec_tag = codec_tag
        self.codec_time_base = codec_time_base

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.index is not None:
            result['Index'] = self.index
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamList(TeaModel):
    def __init__(
        self,
        audio_stream: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamListAudioStream] = None,
    ):
        self.audio_stream = audio_stream

    def validate(self):
        if self.audio_stream:
            for k in self.audio_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStream'] = []
        if self.audio_stream is not None:
            for k in self.audio_stream:
                result['AudioStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream = []
        if m.get('AudioStream') is not None:
            for k in m.get('AudioStream'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamListAudioStream()
                self.audio_stream.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream(TeaModel):
    def __init__(
        self,
        index: str = None,
        lang: str = None,
    ):
        self.index = index
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamList(TeaModel):
    def __init__(
        self,
        subtitle_stream: List[SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream] = None,
    ):
        self.subtitle_stream = subtitle_stream

    def validate(self):
        if self.subtitle_stream:
            for k in self.subtitle_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubtitleStream'] = []
        if self.subtitle_stream is not None:
            for k in self.subtitle_stream:
                result['SubtitleStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.subtitle_stream = []
        if m.get('SubtitleStream') is not None:
            for k in m.get('SubtitleStream'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamListSubtitleStream()
                self.subtitle_stream.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreams(TeaModel):
    def __init__(
        self,
        video_stream_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamList = None,
        audio_stream_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamList = None,
        subtitle_stream_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamList = None,
    ):
        self.video_stream_list = video_stream_list
        self.audio_stream_list = audio_stream_list
        self.subtitle_stream_list = subtitle_stream_list

    def validate(self):
        if self.video_stream_list:
            self.video_stream_list.validate()
        if self.audio_stream_list:
            self.audio_stream_list.validate()
        if self.subtitle_stream_list:
            self.subtitle_stream_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_stream_list is not None:
            result['VideoStreamList'] = self.video_stream_list.to_map()
        if self.audio_stream_list is not None:
            result['AudioStreamList'] = self.audio_stream_list.to_map()
        if self.subtitle_stream_list is not None:
            result['SubtitleStreamList'] = self.subtitle_stream_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoStreamList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsVideoStreamList()
            self.video_stream_list = temp_model.from_map(m['VideoStreamList'])
        if m.get('AudioStreamList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsAudioStreamList()
            self.audio_stream_list = temp_model.from_map(m['AudioStreamList'])
        if m.get('SubtitleStreamList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreamsSubtitleStreamList()
            self.subtitle_stream_list = temp_model.from_map(m['SubtitleStreamList'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesFormat(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        num_programs: str = None,
        size: str = None,
        num_streams: str = None,
        format_long_name: str = None,
        duration: str = None,
        bitrate: str = None,
        format_name: str = None,
    ):
        self.start_time = start_time
        self.num_programs = num_programs
        self.size = size
        self.num_streams = num_streams
        self.format_long_name = format_long_name
        self.duration = duration
        self.bitrate = bitrate
        self.format_name = format_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.num_programs is not None:
            result['NumPrograms'] = self.num_programs
        if self.size is not None:
            result['Size'] = self.size
        if self.num_streams is not None:
            result['NumStreams'] = self.num_streams
        if self.format_long_name is not None:
            result['FormatLongName'] = self.format_long_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('NumPrograms') is not None:
            self.num_programs = m.get('NumPrograms')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('NumStreams') is not None:
            self.num_streams = m.get('NumStreams')
        if m.get('FormatLongName') is not None:
            self.format_long_name = m.get('FormatLongName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigProperties(TeaModel):
    def __init__(
        self,
        width: str = None,
        height: str = None,
        duration: str = None,
        fps: str = None,
        bitrate: str = None,
        file_format: str = None,
        streams: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreams = None,
        format: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesFormat = None,
        file_size: str = None,
    ):
        self.width = width
        self.height = height
        self.duration = duration
        self.fps = fps
        self.bitrate = bitrate
        self.file_format = file_format
        self.streams = streams
        self.format = format
        self.file_size = file_size

    def validate(self):
        if self.streams:
            self.streams.validate()
        if self.format:
            self.format.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.width is not None:
            result['Width'] = self.width
        if self.height is not None:
            result['Height'] = self.height
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_format is not None:
            result['FileFormat'] = self.file_format
        if self.streams is not None:
            result['Streams'] = self.streams.to_map()
        if self.format is not None:
            result['Format'] = self.format.to_map()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Width') is not None:
            self.width = m.get('Width')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileFormat') is not None:
            self.file_format = m.get('FileFormat')
        if m.get('Streams') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesStreams()
            self.streams = temp_model.from_map(m['Streams'])
        if m.get('Format') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigPropertiesFormat()
            self.format = temp_model.from_map(m['Format'])
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfig(TeaModel):
    def __init__(
        self,
        video: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideo = None,
        trans_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigTransConfig = None,
        encryption: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEncryption = None,
        water_mark_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkList = None,
        de_watermark: str = None,
        water_mark_config_url: str = None,
        m_3u8non_standard_support: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupport = None,
        priority: str = None,
        audio: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudio = None,
        audio_stream_map: str = None,
        merge_list: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeList = None,
        super_reso: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSuperReso = None,
        user_data: str = None,
        digi_water_mark: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMark = None,
        video_stream_map: str = None,
        output_file: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigOutputFile = None,
        rotate: str = None,
        editing: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditing = None,
        container: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigContainer = None,
        clip: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClip = None,
        merge_config_url: str = None,
        mux_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfig = None,
        template_id: str = None,
        subtitle_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfig = None,
        properties: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigProperties = None,
    ):
        self.video = video
        self.trans_config = trans_config
        self.encryption = encryption
        self.water_mark_list = water_mark_list
        self.de_watermark = de_watermark
        self.water_mark_config_url = water_mark_config_url
        self.m_3u8non_standard_support = m_3u8non_standard_support
        self.priority = priority
        self.audio = audio
        self.audio_stream_map = audio_stream_map
        self.merge_list = merge_list
        self.super_reso = super_reso
        self.user_data = user_data
        self.digi_water_mark = digi_water_mark
        self.video_stream_map = video_stream_map
        self.output_file = output_file
        self.rotate = rotate
        self.editing = editing
        self.container = container
        self.clip = clip
        self.merge_config_url = merge_config_url
        self.mux_config = mux_config
        self.template_id = template_id
        self.subtitle_config = subtitle_config
        self.properties = properties

    def validate(self):
        if self.video:
            self.video.validate()
        if self.trans_config:
            self.trans_config.validate()
        if self.encryption:
            self.encryption.validate()
        if self.water_mark_list:
            self.water_mark_list.validate()
        if self.m_3u8non_standard_support:
            self.m_3u8non_standard_support.validate()
        if self.audio:
            self.audio.validate()
        if self.merge_list:
            self.merge_list.validate()
        if self.super_reso:
            self.super_reso.validate()
        if self.digi_water_mark:
            self.digi_water_mark.validate()
        if self.output_file:
            self.output_file.validate()
        if self.editing:
            self.editing.validate()
        if self.container:
            self.container.validate()
        if self.clip:
            self.clip.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.subtitle_config:
            self.subtitle_config.validate()
        if self.properties:
            self.properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        if self.trans_config is not None:
            result['TransConfig'] = self.trans_config.to_map()
        if self.encryption is not None:
            result['Encryption'] = self.encryption.to_map()
        if self.water_mark_list is not None:
            result['WaterMarkList'] = self.water_mark_list.to_map()
        if self.de_watermark is not None:
            result['DeWatermark'] = self.de_watermark
        if self.water_mark_config_url is not None:
            result['WaterMarkConfigUrl'] = self.water_mark_config_url
        if self.m_3u8non_standard_support is not None:
            result['M3U8NonStandardSupport'] = self.m_3u8non_standard_support.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.audio_stream_map is not None:
            result['AudioStreamMap'] = self.audio_stream_map
        if self.merge_list is not None:
            result['MergeList'] = self.merge_list.to_map()
        if self.super_reso is not None:
            result['SuperReso'] = self.super_reso.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.digi_water_mark is not None:
            result['DigiWaterMark'] = self.digi_water_mark.to_map()
        if self.video_stream_map is not None:
            result['VideoStreamMap'] = self.video_stream_map
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.editing is not None:
            result['Editing'] = self.editing.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.clip is not None:
            result['Clip'] = self.clip.to_map()
        if self.merge_config_url is not None:
            result['MergeConfigUrl'] = self.merge_config_url
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.subtitle_config is not None:
            result['SubtitleConfig'] = self.subtitle_config.to_map()
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Video') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigVideo()
            self.video = temp_model.from_map(m['Video'])
        if m.get('TransConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigTransConfig()
            self.trans_config = temp_model.from_map(m['TransConfig'])
        if m.get('Encryption') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEncryption()
            self.encryption = temp_model.from_map(m['Encryption'])
        if m.get('WaterMarkList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigWaterMarkList()
            self.water_mark_list = temp_model.from_map(m['WaterMarkList'])
        if m.get('DeWatermark') is not None:
            self.de_watermark = m.get('DeWatermark')
        if m.get('WaterMarkConfigUrl') is not None:
            self.water_mark_config_url = m.get('WaterMarkConfigUrl')
        if m.get('M3U8NonStandardSupport') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigM3U8NonStandardSupport()
            self.m_3u8non_standard_support = temp_model.from_map(m['M3U8NonStandardSupport'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Audio') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('AudioStreamMap') is not None:
            self.audio_stream_map = m.get('AudioStreamMap')
        if m.get('MergeList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMergeList()
            self.merge_list = temp_model.from_map(m['MergeList'])
        if m.get('SuperReso') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSuperReso()
            self.super_reso = temp_model.from_map(m['SuperReso'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('DigiWaterMark') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigDigiWaterMark()
            self.digi_water_mark = temp_model.from_map(m['DigiWaterMark'])
        if m.get('VideoStreamMap') is not None:
            self.video_stream_map = m.get('VideoStreamMap')
        if m.get('OutputFile') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Editing') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigEditing()
            self.editing = temp_model.from_map(m['Editing'])
        if m.get('Container') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('Clip') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigClip()
            self.clip = temp_model.from_map(m['Clip'])
        if m.get('MergeConfigUrl') is not None:
            self.merge_config_url = m.get('MergeConfigUrl')
        if m.get('MuxConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('SubtitleConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigSubtitleConfig()
            self.subtitle_config = temp_model.from_map(m['SubtitleConfig'])
        if m.get('Properties') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfigProperties()
            self.properties = temp_model.from_map(m['Properties'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJobMNSMessageResult(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        error_message: str = None,
        error_code: str = None,
    ):
        self.message_id = message_id
        self.error_message = error_message
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResultJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        percent: int = None,
        finish_time: str = None,
        state: str = None,
        job_id: str = None,
        code: str = None,
        message: str = None,
        editing_inputs: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputs = None,
        pipeline_id: str = None,
        editing_config: SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfig = None,
        mnsmessage_result: SubmitEditingJobsResponseBodyJobResultListJobResultJobMNSMessageResult = None,
    ):
        self.creation_time = creation_time
        self.percent = percent
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.code = code
        self.message = message
        self.editing_inputs = editing_inputs
        self.pipeline_id = pipeline_id
        self.editing_config = editing_config
        self.mnsmessage_result = mnsmessage_result

    def validate(self):
        if self.editing_inputs:
            self.editing_inputs.validate()
        if self.editing_config:
            self.editing_config.validate()
        if self.mnsmessage_result:
            self.mnsmessage_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.editing_inputs is not None:
            result['EditingInputs'] = self.editing_inputs.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config.to_map()
        if self.mnsmessage_result is not None:
            result['MNSMessageResult'] = self.mnsmessage_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('EditingInputs') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingInputs()
            self.editing_inputs = temp_model.from_map(m['EditingInputs'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('EditingConfig') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobEditingConfig()
            self.editing_config = temp_model.from_map(m['EditingConfig'])
        if m.get('MNSMessageResult') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJobMNSMessageResult()
            self.mnsmessage_result = temp_model.from_map(m['MNSMessageResult'])
        return self


class SubmitEditingJobsResponseBodyJobResultListJobResult(TeaModel):
    def __init__(
        self,
        job: SubmitEditingJobsResponseBodyJobResultListJobResultJob = None,
        success: bool = None,
        code: str = None,
        message: str = None,
    ):
        self.job = job
        self.success = success
        self.code = code
        self.message = message

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Job') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultListJobResultJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class SubmitEditingJobsResponseBodyJobResultList(TeaModel):
    def __init__(
        self,
        job_result: List[SubmitEditingJobsResponseBodyJobResultListJobResult] = None,
    ):
        self.job_result = job_result

    def validate(self):
        if self.job_result:
            for k in self.job_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JobResult'] = []
        if self.job_result is not None:
            for k in self.job_result:
                result['JobResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job_result = []
        if m.get('JobResult') is not None:
            for k in m.get('JobResult'):
                temp_model = SubmitEditingJobsResponseBodyJobResultListJobResult()
                self.job_result.append(temp_model.from_map(k))
        return self


class SubmitEditingJobsResponseBody(TeaModel):
    def __init__(
        self,
        job_result_list: SubmitEditingJobsResponseBodyJobResultList = None,
        request_id: str = None,
    ):
        self.job_result_list = job_result_list
        self.request_id = request_id

    def validate(self):
        if self.job_result_list:
            self.job_result_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_result_list is not None:
            result['JobResultList'] = self.job_result_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobResultList') is not None:
            temp_model = SubmitEditingJobsResponseBodyJobResultList()
            self.job_result_list = temp_model.from_map(m['JobResultList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SubmitEditingJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitEditingJobsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitEditingJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportVideoSplitJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        result: str = None,
        details: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.result = result
        self.details = details
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.result is not None:
            result['Result'] = self.result
        if self.details is not None:
            result['Details'] = self.details
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportVideoSplitJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportVideoSplitJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportVideoSplitJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportVideoSplitJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaCensorJobDetailRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        owner_account: str = None,
        next_page_token: str = None,
        maximum_page_size: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.owner_account = owner_account
        self.next_page_token = next_page_token
        self.maximum_page_size = maximum_page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults(TeaModel):
    def __init__(
        self,
        result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
        results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket
        self.results = results

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Results') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults(TeaModel):
    def __init__(
        self,
        cover_image_censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult] = None,
    ):
        self.cover_image_censor_result = cover_image_censor_result

    def validate(self):
        if self.cover_image_censor_result:
            for k in self.cover_image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImageCensorResult'] = []
        if self.cover_image_censor_result is not None:
            for k in self.cover_image_censor_result:
                result['CoverImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cover_image_censor_result = []
        if m.get('CoverImageCensorResult') is not None:
            for k in m.get('CoverImageCensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult()
                self.cover_image_censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig(TeaModel):
    def __init__(
        self,
        output_file: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile = None,
        video_censor: str = None,
        biz_type: str = None,
    ):
        self.output_file = output_file
        self.video_censor = video_censor
        self.biz_type = biz_type

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.video_censor is not None:
            result['VideoCensor'] = self.video_censor
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputFile') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('VideoCensor') is not None:
            self.video_censor = m.get('VideoCensor')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults(TeaModel):
    def __init__(
        self,
        censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult] = None,
    ):
        self.censor_result = censor_result

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline(TeaModel):
    def __init__(
        self,
        timestamp: str = None,
        object: str = None,
        censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults = None,
    ):
        self.timestamp = timestamp
        self.object = object
        self.censor_results = censor_results

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.object is not None:
            result['Object'] = self.object
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines(TeaModel):
    def __init__(
        self,
        video_timeline: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline] = None,
    ):
        self.video_timeline = video_timeline

    def validate(self):
        if self.video_timeline:
            for k in self.video_timeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoTimeline'] = []
        if self.video_timeline is not None:
            for k in self.video_timeline:
                result['VideoTimeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_timeline = []
        if m.get('VideoTimeline') is not None:
            for k in m.get('VideoTimeline'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline()
                self.video_timeline.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult(TeaModel):
    def __init__(
        self,
        suggestion: str = None,
        label: str = None,
        scene: str = None,
        rate: str = None,
    ):
        self.suggestion = suggestion
        self.label = label
        self.scene = scene
        self.rate = rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults(TeaModel):
    def __init__(
        self,
        censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult] = None,
    ):
        self.censor_result = censor_result

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult(TeaModel):
    def __init__(
        self,
        video_timelines: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines = None,
        next_page_token: str = None,
        censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults = None,
    ):
        self.video_timelines = video_timelines
        self.next_page_token = next_page_token
        self.censor_results = censor_results

    def validate(self):
        if self.video_timelines:
            self.video_timelines.validate()
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.video_timelines is not None:
            result['VideoTimelines'] = self.video_timelines.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VideoTimelines') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines()
            self.video_timelines = temp_model.from_map(m['VideoTimelines'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        finish_time: str = None,
        suggestion: str = None,
        cover_image_censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults = None,
        state: str = None,
        title_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult = None,
        message: str = None,
        input: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput = None,
        barrage_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult = None,
        desc_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult = None,
        video_censor_config: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig = None,
        job_id: str = None,
        user_data: str = None,
        code: str = None,
        vensor_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult = None,
        pipeline_id: str = None,
    ):
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.suggestion = suggestion
        self.cover_image_censor_results = cover_image_censor_results
        self.state = state
        self.title_censor_result = title_censor_result
        self.message = message
        self.input = input
        self.barrage_censor_result = barrage_censor_result
        self.desc_censor_result = desc_censor_result
        self.video_censor_config = video_censor_config
        self.job_id = job_id
        self.user_data = user_data
        self.code = code
        self.vensor_censor_result = vensor_censor_result
        self.pipeline_id = pipeline_id

    def validate(self):
        if self.cover_image_censor_results:
            self.cover_image_censor_results.validate()
        if self.title_censor_result:
            self.title_censor_result.validate()
        if self.input:
            self.input.validate()
        if self.barrage_censor_result:
            self.barrage_censor_result.validate()
        if self.desc_censor_result:
            self.desc_censor_result.validate()
        if self.video_censor_config:
            self.video_censor_config.validate()
        if self.vensor_censor_result:
            self.vensor_censor_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.cover_image_censor_results is not None:
            result['CoverImageCensorResults'] = self.cover_image_censor_results.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result.to_map()
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result.to_map()
        if self.video_censor_config is not None:
            result['VideoCensorConfig'] = self.video_censor_config.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.code is not None:
            result['Code'] = self.code
        if self.vensor_censor_result is not None:
            result['VensorCensorResult'] = self.vensor_censor_result.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('CoverImageCensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults()
            self.cover_image_censor_results = temp_model.from_map(m['CoverImageCensorResults'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TitleCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult()
            self.title_censor_result = temp_model.from_map(m['TitleCensorResult'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Input') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('BarrageCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult()
            self.barrage_censor_result = temp_model.from_map(m['BarrageCensorResult'])
        if m.get('DescCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult()
            self.desc_censor_result = temp_model.from_map(m['DescCensorResult'])
        if m.get('VideoCensorConfig') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig()
            self.video_censor_config = temp_model.from_map(m['VideoCensorConfig'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('VensorCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult()
            self.vensor_censor_result = temp_model.from_map(m['VensorCensorResult'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class QueryMediaCensorJobDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        media_censor_job_detail: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail = None,
    ):
        self.request_id = request_id
        self.media_censor_job_detail = media_censor_job_detail

    def validate(self):
        if self.media_censor_job_detail:
            self.media_censor_job_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.media_censor_job_detail is not None:
            result['MediaCensorJobDetail'] = self.media_censor_job_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('MediaCensorJobDetail') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail()
            self.media_censor_job_detail = temp_model.from_map(m['MediaCensorJobDetail'])
        return self


class QueryMediaCensorJobDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryMediaCensorJobDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagCustomPersonRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        category_id: str = None,
        category_name: str = None,
        category_description: str = None,
        person_id: str = None,
        person_name: str = None,
        person_description: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.category_id = category_id
        self.category_name = category_name
        self.category_description = category_description
        self.person_id = person_id
        self.person_name = person_name
        self.person_description = person_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.category_description is not None:
            result['CategoryDescription'] = self.category_description
        if self.person_id is not None:
            result['PersonId'] = self.person_id
        if self.person_name is not None:
            result['PersonName'] = self.person_name
        if self.person_description is not None:
            result['PersonDescription'] = self.person_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('CategoryDescription') is not None:
            self.category_description = m.get('CategoryDescription')
        if m.get('PersonId') is not None:
            self.person_id = m.get('PersonId')
        if m.get('PersonName') is not None:
            self.person_name = m.get('PersonName')
        if m.get('PersonDescription') is not None:
            self.person_description = m.get('PersonDescription')
        return self


class TagCustomPersonResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class TagCustomPersonResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: TagCustomPersonResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagCustomPersonResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMcuTemplateRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        template: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateMcuTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        self.request_id = request_id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateMcuTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMcuTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMcuTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFpShotNotaryRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        next_page_token: str = None,
        maximum_page_size: int = None,
        start_of_created_time_range: str = None,
        end_of_created_time_range: str = None,
        fp_dbid: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.next_page_token = next_page_token
        self.maximum_page_size = maximum_page_size
        self.start_of_created_time_range = start_of_created_time_range
        self.end_of_created_time_range = end_of_created_time_range
        self.fp_dbid = fp_dbid
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.start_of_created_time_range is not None:
            result['StartOfCreatedTimeRange'] = self.start_of_created_time_range
        if self.end_of_created_time_range is not None:
            result['EndOfCreatedTimeRange'] = self.end_of_created_time_range
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('StartOfCreatedTimeRange') is not None:
            self.start_of_created_time_range = m.get('StartOfCreatedTimeRange')
        if m.get('EndOfCreatedTimeRange') is not None:
            self.end_of_created_time_range = m.get('EndOfCreatedTimeRange')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        finish_time: str = None,
        job_id: str = None,
        tx_hash: str = None,
        transaction_id: str = None,
        fp_dbid: str = None,
        detail: str = None,
    ):
        self.creation_time = creation_time
        self.finish_time = finish_time
        self.job_id = job_id
        self.tx_hash = tx_hash
        self.transaction_id = transaction_id
        self.fp_dbid = fp_dbid
        self.detail = detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.tx_hash is not None:
            result['TxHash'] = self.tx_hash
        if self.transaction_id is not None:
            result['TransactionId'] = self.transaction_id
        if self.fp_dbid is not None:
            result['FpDBId'] = self.fp_dbid
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TxHash') is not None:
            self.tx_hash = m.get('TxHash')
        if m.get('TransactionId') is not None:
            self.transaction_id = m.get('TransactionId')
        if m.get('FpDBId') is not None:
            self.fp_dbid = m.get('FpDBId')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class ListFpShotNotaryResponseBodyFpShotNotaryList(TeaModel):
    def __init__(
        self,
        fp_shot_notary: List[ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary] = None,
    ):
        self.fp_shot_notary = fp_shot_notary

    def validate(self):
        if self.fp_shot_notary:
            for k in self.fp_shot_notary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FpShotNotary'] = []
        if self.fp_shot_notary is not None:
            for k in self.fp_shot_notary:
                result['FpShotNotary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fp_shot_notary = []
        if m.get('FpShotNotary') is not None:
            for k in m.get('FpShotNotary'):
                temp_model = ListFpShotNotaryResponseBodyFpShotNotaryListFpShotNotary()
                self.fp_shot_notary.append(temp_model.from_map(k))
        return self


class ListFpShotNotaryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        fp_shot_notary_list: ListFpShotNotaryResponseBodyFpShotNotaryList = None,
        next_page_token: str = None,
    ):
        self.request_id = request_id
        self.fp_shot_notary_list = fp_shot_notary_list
        self.next_page_token = next_page_token

    def validate(self):
        if self.fp_shot_notary_list:
            self.fp_shot_notary_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.fp_shot_notary_list is not None:
            result['FpShotNotaryList'] = self.fp_shot_notary_list.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FpShotNotaryList') is not None:
            temp_model = ListFpShotNotaryResponseBodyFpShotNotaryList()
            self.fp_shot_notary_list = temp_model.from_map(m['FpShotNotaryList'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        return self


class ListFpShotNotaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFpShotNotaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFpShotNotaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReportFpShotJobResultRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        job_id: str = None,
        result: str = None,
        details: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.job_id = job_id
        self.result = result
        self.details = details
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.result is not None:
            result['Result'] = self.result
        if self.details is not None:
            result['Details'] = self.details
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class ReportFpShotJobResultResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class ReportFpShotJobResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReportFpShotJobResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReportFpShotJobResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitVideoGifJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        input: str = None,
        pipeline_id: str = None,
        video_gif_config: str = None,
        user_data: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.input = input
        self.pipeline_id = pipeline_id
        self.video_gif_config = video_gif_config
        self.user_data = user_data
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.input is not None:
            result['Input'] = self.input
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.video_gif_config is not None:
            result['VideoGifConfig'] = self.video_gif_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('VideoGifConfig') is not None:
            self.video_gif_config = m.get('VideoGifConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class SubmitVideoGifJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class SubmitVideoGifJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitVideoGifJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitVideoGifJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAnnotationJobListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        annotation_job_ids: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.annotation_job_ids = annotation_job_ids
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.annotation_job_ids is not None:
            result['AnnotationJobIds'] = self.annotation_job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('AnnotationJobIds') is not None:
            self.annotation_job_ids = m.get('AnnotationJobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput(TeaModel):
    def __init__(
        self,
        object: str = None,
        location: str = None,
        bucket: str = None,
    ):
        self.object = object
        self.location = location
        self.bucket = bucket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object is not None:
            result['Object'] = self.object
        if self.location is not None:
            result['Location'] = self.location
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation(TeaModel):
    def __init__(
        self,
        score: str = None,
        label: str = None,
    ):
        self.score = score
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.score is not None:
            result['Score'] = self.score
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations(TeaModel):
    def __init__(
        self,
        annotation: List[QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation] = None,
    ):
        self.annotation = annotation

    def validate(self):
        if self.annotation:
            for k in self.annotation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Annotation'] = []
        if self.annotation is not None:
            for k in self.annotation:
                result['Annotation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.annotation = []
        if m.get('Annotation') is not None:
            for k in m.get('Annotation'):
                temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotationsAnnotation()
                self.annotation.append(temp_model.from_map(k))
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult(TeaModel):
    def __init__(
        self,
        annotations: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations = None,
        details: str = None,
    ):
        self.annotations = annotations
        self.details = details

    def validate(self):
        if self.annotations:
            self.annotations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['Annotations'] = self.annotations.to_map()
        if self.details is not None:
            result['Details'] = self.details
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotations') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResultAnnotations()
            self.annotations = temp_model.from_map(m['Annotations'])
        if m.get('Details') is not None:
            self.details = m.get('Details')
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        state: str = None,
        user_data: str = None,
        code: str = None,
        message: str = None,
        pipeline_id: str = None,
        input: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput = None,
        id: str = None,
        video_annotation_result: QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult = None,
    ):
        self.creation_time = creation_time
        self.state = state
        self.user_data = user_data
        self.code = code
        self.message = message
        self.pipeline_id = pipeline_id
        self.input = input
        self.id = id
        self.video_annotation_result = video_annotation_result

    def validate(self):
        if self.input:
            self.input.validate()
        if self.video_annotation_result:
            self.video_annotation_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.video_annotation_result is not None:
            result['VideoAnnotationResult'] = self.video_annotation_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Input') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('VideoAnnotationResult') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJobVideoAnnotationResult()
            self.video_annotation_result = temp_model.from_map(m['VideoAnnotationResult'])
        return self


class QueryAnnotationJobListResponseBodyAnnotationJobList(TeaModel):
    def __init__(
        self,
        annotation_job: List[QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob] = None,
    ):
        self.annotation_job = annotation_job

    def validate(self):
        if self.annotation_job:
            for k in self.annotation_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnnotationJob'] = []
        if self.annotation_job is not None:
            for k in self.annotation_job:
                result['AnnotationJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.annotation_job = []
        if m.get('AnnotationJob') is not None:
            for k in m.get('AnnotationJob'):
                temp_model = QueryAnnotationJobListResponseBodyAnnotationJobListAnnotationJob()
                self.annotation_job.append(temp_model.from_map(k))
        return self


class QueryAnnotationJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryAnnotationJobListResponseBody(TeaModel):
    def __init__(
        self,
        annotation_job_list: QueryAnnotationJobListResponseBodyAnnotationJobList = None,
        request_id: str = None,
        non_exist_ids: QueryAnnotationJobListResponseBodyNonExistIds = None,
    ):
        self.annotation_job_list = annotation_job_list
        self.request_id = request_id
        self.non_exist_ids = non_exist_ids

    def validate(self):
        if self.annotation_job_list:
            self.annotation_job_list.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation_job_list is not None:
            result['AnnotationJobList'] = self.annotation_job_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnnotationJobList') is not None:
            temp_model = QueryAnnotationJobListResponseBodyAnnotationJobList()
            self.annotation_job_list = temp_model.from_map(m['AnnotationJobList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NonExistIds') is not None:
            temp_model = QueryAnnotationJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        return self


class QueryAnnotationJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAnnotationJobListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAnnotationJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitPornJobRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        input: str = None,
        pipeline_id: str = None,
        porn_config: str = None,
        user_data: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.input = input
        self.pipeline_id = pipeline_id
        self.porn_config = porn_config
        self.user_data = user_data
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.input is not None:
            result['Input'] = self.input
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.porn_config is not None:
            result['PornConfig'] = self.porn_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('PornConfig') is not None:
            self.porn_config =