# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cli_calc']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'cli-calc',
    'version': '0.2.23',
    'description': 'Powerful yet easy command line calculator.',
    'long_description': '![Logo](https://raw.githubusercontent.com/cruisen/cli-calc/4986df3abb3f1871d6669dec27d5e37aba0d11a3/assets/images/Cli-Calc.png)\n\n# cli-calc\n\n[![test](https://github.com/cruisen/cli-calc/actions/workflows/test.yml/badge.svg)](https://github.com/cruisen/cli-calc/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/cruisen/cli-calc/branch/main/graph/badge.svg?token=i9nYZL3MM3)](https://codecov.io/gh/cruisen/cli-calc)\n[![Python Version](https://img.shields.io/pypi/pyversions/cli-calc.svg)](https://pypi.org/project/cli-calc/)\n\n[![pypi](https://img.shields.io/pypi/v/cli-calc)](https://pypi.org/project/cli-calc/)\n[![github release](https://img.shields.io/github/release-date/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/releases)\n[![pypi downloads](https://img.shields.io/pypi/dm/cli-calc?label=pypi%20downloads)](https://pypistats.org/packages/cli-calc)\n\nPowerful yet easy command line calculator.\n\n## Introduction\n\n### python at the comand line (cli)\n\nIt is easy and common to use\n[Python as a Calculator](https://docs.python.org/3/tutorial/introduction.html#using-python-as-a-calculator).\n\n```bash\n$ python\nPython 3.8.5 (default, Aug  2 2020, 16:00:15)\n[Clang 11.0.0 (clang-1100.0.33.17)] on darwin\nType "help", "copyright", "credits" or "license" for more information.\n>>> 2**10\n1024\n>>> _ / 10\n102.4\n>>> import math\n>>> math.pi\n3.141592653589793\n>>> math.sin(math.pi / 2)\n1.0\n>>> exit()\n```\n\nBut:\n[There must be a better way!](https://www.youtube.com/watch?v=UANN2Eu6ZnM)\nAnd there is...\n\n\n### cli-calc\n\n```bash\n$ cli-calc\nhex, int, float,\n0x0, 0, 0.0, : 2**10\n2**10\n0x400, 1024, 1024.0, : _ / 10\n1024.0/10\n0x66, 102, 102.4, : sin(pi / 2)\nsin(pi/2)\n0x1, 1, 1.0, : q\n$\n```\n\n[Batteries included](https://www.python.org/dev/peps/pep-0206/#batteries-included-philosophy):\n\n* ```cli-calc``` adds the standard\n[math](https://docs.python.org/3/library/math.html)\nlibrary to the mix, as well as cmath and others.\n\n* Provides convenience functions for formatted output, like\n[fractions](https://docs.python.org/3.6/library/fractions.html)\nand\n[IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).\n\n* Supports line input from files and unix pipes.\n\n* And some more... :-)\n\n\n## More examples\n\n```bash\ncos(pi/2)\n0xFF ^ 0b10\n2**8-1\nlog(2)\ncomb(49,6)\nfactorial(42)\nrandom()\ncmath.phase(complex(-1.0, 0.0))\n```\n\n## Included Math Libraries\n\nReady to use out of the box:\n\n- [standard operators](https://www.w3schools.com/python/python_operators.asp)\n  ``` -, >>, ...```\n- [standard math library](https://docs.python.org/3/library/math.html)\n  ```cd, log, sin, sinh, gamma, pi, e, tau, inf, nan...```\n\n- [cmath](https://docs.python.org/3/library/cmath.html)\n  ```phase(complex(-1.0, 0.0)), and then most of the above with complex numbers.```\n- [random](https://docs.python.org/3/library/random.html#examples)\n  ```random, choice([\'win\', \'lose\', \'draw\']), mean, ...```\n\n- [built in functions](https://docs.python.org/3/library/functions.html)\n  ```max, help, sum, ...```\n\n\n# Installation\n\n```bash\npip install cli-calc\n```\n\n- [pypi cli-calc](https://pypi.org/project/cli-calc/)\n\n## Configuration\n\nFor convenience, add a shell script in ```~/bin```:\n\n```bash\ncd ~/bin\nvi cli-calc\n```\n\nwith the following lines:\n\n```bash\npath=~/path/to/your/cli-calc/cli_calc\ncd $path\n./main.py\n```\n\nMake it executeable:\n\n```bash\nchmod a+x cli-calc\n```\n\nthen use it anywhere. :-)\n\n```bash\necho "7+8" | cli-calc\ncat foo.bar | cli-calc\ncli-calc\n```\n\n## Help\n\n```bash\ncalc\nh\nInput:\n    "q" for quit, "h" for help\n\n    "_" for last float value\n    "_int_" for last int value\n\n    "sin(pi/2)" for sinus, ...\n\n    "pi", "tau" and "e" for pi, tau and Euler\n\n    "+f" to add display for fraction, "-f" to suppress display for fraction\n        Other letters are:\n        he(x), (o)ctal, (b)inary, (i)nteger,\n        (f)raction, (t)ruth, i(e)ee, ieee_bi(n), f(r)om_ieee\n        "float" is always visible\n\n    See https://docs.python.org/3/library/math.html, use without "math."\n        https://www.w3schools.com/python/python_operators.asp\n\n    Try "cos(pi/2)", XOR: "0xFF ^ 0b10", "2**8-1", "factorial(42)",\n        "help(math)"\n```\n\n* Permalink to this document as a\n[github page](https://cruisen.github.io/cli-calc/)\n\n## Warning\n\n- Use of [```eval```](https://docs.python.org/3/library/functions.html#eval) is evil.\n  However precautions are taken.\n\n\n# Development\n\n## Pull Request\n\nPR\'s are Welcome! See\n[PULL_REQUEST_TEMPLATE](https://github.com/cruisen/cli-calc/blob/main/PULL_REQUEST_TEMPLATE.md)\nand\n[CONTRIBUTING](https://github.com/cruisen/cli-calc/blob/main/CONTRIBUTING.md).\n\n## Metric Dashboard\n\n[![test](https://github.com/cruisen/cli-calc/actions/workflows/test.yml/badge.svg)](https://github.com/cruisen/cli-calc/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/cruisen/cli-calc/branch/main/graph/badge.svg?token=i9nYZL3MM3)](https://codecov.io/gh/cruisen/cli-calc)\n[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/cruisen/cli-calc/main.svg)](https://results.pre-commit.ci/latest/github/cruisen/cli-calc/main)\n[![Documentation Status](https://readthedocs.org/projects/cli-calc/badge/?version=latest)](https://readthedocs.org/projects/cli-calc/builds/)\n[![made-with-sphinx-doc](https://img.shields.io/badge/Made%20with-Sphinx-1f425f.svg)](https://www.sphinx-doc.org/)\n\n[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/cruisen/cli-calc/badges/quality-score.png?b=main)](https://scrutinizer-ci.com/g/cruisen/cli-calc/?branch=main)\n[![CodeQL](https://github.com/cruisen/cli-calc/actions/workflows/codeql-analysis.yml/badge.svg?branch=main)](https://github.com/cruisen/cli-calc/actions/workflows/codeql-analysis.yml)\n[![Requirements Status](https://requires.io/github/cruisen/cli-calc/requirements.svg?branch=main)](https://requires.io/github/cruisen/cli-calc/requirements/?branch=main)\n[![Dependencies](https://img.shields.io/librariesio/release/github/cruisen/cli-calc)](https://libraries.io/github/cruisen/cli-calc)\n\n[![Python Version](https://img.shields.io/pypi/pyversions/cli-calc.svg)](https://pypi.org/project/cli-calc/)\n[![PyPI - Implementation](https://img.shields.io/pypi/implementation/cli-calc)](https://realpython.com/cpython-source-code-guide/)\n[![Python Lang](https://img.shields.io/github/languages/top/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/search?l=python)\n[![Languages](https://img.shields.io/github/languages/count/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/search?l=python)\n[![wemake-python-styleguide](https://img.shields.io/badge/style-wemake-000000.svg)](https://github.com/wemake-services/wemake-python-styleguide)\n\n[![SLOC](https://img.shields.io/endpoint?color=blue&url=https://raw.githubusercontent.com/cruisen/cli-calc/main/dev_tools/meters/cli_calc_shields.json)](https://github.com/cruisen/cli-calc/tree/main/cli_calc)\n[![SLOC Tests](https://img.shields.io/endpoint?color=blue&url=https://raw.githubusercontent.com/cruisen/cli-calc/main/dev_tools/meters/tests_shields.json)](https://github.com/cruisen/cli-calc/tree/main/tests)\n[![SLOC Dev](https://img.shields.io/endpoint?color=blue&url=https://raw.githubusercontent.com/cruisen/cli-calc/main/dev_tools/meters/dev_tools_shields.json)](https://github.com/cruisen/cli-calc/tree/main/dev_tools)\n[![code size](https://img.shields.io/github/languages/code-size/cruisen/cli-calc)](https://github.com/cruisen/cli-calc.git)\n\n[![Maintenance](https://img.shields.io/badge/Maintained-yes-green)](https://GitHub.com/cruisen/cli-calc/graphs/commit-activity)\n[![MIT](https://img.shields.io/pypi/l/cli-calc)](https://github.com/cruisen/cli-calc/blob/main/LICENSE)\n[![pypi status](https://img.shields.io/pypi/status/cli-calc)](https://www.python.org/dev/peps/pep-0301/#distutils-trove-classification)\n[![github stars](https://img.shields.io/github/stars/cruisen/cli-calc?style=social)](https://github.com/cruisen/cli-calc/stargazers)\n\n[![pypi](https://img.shields.io/pypi/v/cli-calc)](https://pypi.org/project/cli-calc/)\n[![github release](https://img.shields.io/github/release-date/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/releases)\n[![pypi wheel](https://img.shields.io/pypi/wheel/cli-calc)](https://pypi.org/project/cli-calc/#files)\n[![pypi downloads](https://img.shields.io/pypi/dm/cli-calc?label=pypi%20downloads)](https://pypistats.org/packages/cli-calc)\n\n[![last commit](https://img.shields.io/github/last-commit/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/commits/main)\n[![GitHub commits since latest release (by SemVer)](https://img.shields.io/github/commits-since/cruisen/cli-calc/latest?sort=semver)](https://github.com/cruisen/cli-calc/releases/latest)\n[![github commits since](https://img.shields.io/github/commits-since/cruisen/cli-calc/v0.1.1)](https://github.com/cruisen/cli-calc/commits/main)\n[![github commits rate](https://img.shields.io/github/commit-activity/m/cruisen/cli-calc?label=commits)](https://github.com/cruisen/cli-calc/commits/main)\n\n[![github issues next milestone](https://img.shields.io/github/milestones/progress-percent/cruisen/cli-calc/6)](https://github.com/cruisen/cli-calc/milestone/6)\n[![github bugs open](https://img.shields.io/github/issues-raw/cruisen/cli-calc/is_Bug?color=red&label=bugs)](https://github.com/cruisen/cli-calc/issues?q=is%3Aopen+is%3Aissue+label%3Ais_Bug)\n[![github bugs closed](https://img.shields.io/github/issues-closed-raw/cruisen/cli-calc/is_Bug?color=green&label=closed)](https://github.com/cruisen/cli-calc/issues?q=is%3Aissue+is%3Aclosed+label%3Ais_Bug)\n[![github issues open](https://img.shields.io/github/issues-raw/cruisen/cli-calc?color=blue)](https://github.com/cruisen/cli-calc/issues)\n[![github now](https://img.shields.io/github/issues-raw/cruisen/cli-calc/1-Now-Important?color=yellow&label=queued)](https://github.com/cruisen/cli-calc/issues?q=is%3Aopen+is%3Aissue+label%3A1-Now-Important)\n[![github issues closed](https://img.shields.io/github/issues-closed-raw/cruisen/cli-calc?color=green&label=closed)](https://github.com/cruisen/cli-calc/issues?q=is%3Aissue+is%3Aclosed)\n[![github help open](https://img.shields.io/github/issues-raw/cruisen/cli-calc/needs_Help?color=yellow&label=need%20help)](https://github.com/cruisen/cli-calc/issues?q=is%3Aopen+is%3Aissue+label%3Aneeds_Help)\n\n[![Pull Requests open](https://img.shields.io/github/issues-pr-raw/cruisen/cli-calc?label=PR)](https://github.com/cruisen/cli-calc/pulls)\n[![Pull Requests closed](https://img.shields.io/github/issues-pr-closed-raw/cruisen/cli-calc?label=closed&color=green)](https://github.com/cruisen/cli-calc/pulls?q=is%3Apr+is%3Aclosed)\n[![Relative date](https://img.shields.io/date/1642071600?label=first%20commit)](https://github.com/cruisen/cli-calc/commit/ac96ed51041c26195840186de1f1fd60375c0736)\n[![github downloads](https://img.shields.io/github/downloads/cruisen/cli-calc/total?label=github%20downloads)](https://github.com/cruisen/cli-calc)\n\n### Note on Shields\n\n1. [![Dependencies](https://img.shields.io/librariesio/release/github/cruisen/cli-calc)](https://libraries.io/github/cruisen/cli-calc)\n   [flake8-commas](https://github.com/PyCQA/flake8-commas)\n   one of the development plugins of the\n   [wemake-python-styleguide 2](https://github.com/wemake-services/wemake-python-styleguide)\n   is marked as *No Maintenance Intended*.\n   Hence the **1 deprecated dependency**.\n   See this\n   [Issue](https://github.com/wemake-services/wemake-python-styleguide/issues/2276).\n   Most probable\n   [wemake 2](https://github.com/wemake-services/wemake-python-styleguide)\n   will replace this dependency with a fork.\n\n## Features\n\n* Fully [typed with annotations](https://mypy.readthedocs.io/en/stable/cheat_sheet_py3.html)\n* Checked with [mypy](https://mypy.readthedocs.io/en/stable/)\n* Packaging [PEP561 compatible](https://www.python.org/dev/peps/pep-0561/)\n\n\n## Tools\n\n### Python Packages\n* [pypi.org ](https://pypi.org/) Python Package Index\n  * [pythonrepo.com](https://pythonrepo.com/catalog/popular/) Popular Python Libraries\n* [poetry add](https://python-poetry.org/docs/cli/#add)\n* [poetry update](https://python-poetry.org/docs/cli/#update)\n\n### Style and type annotations\n* [pylint](https://pylint.pycqa.org/en/latest/) vim linter\n* [isort](https://pycqa.github.io/isort/) sort imports\n* [black](https://black.readthedocs.io/en/stable/) opinionated code formatter\n  * [wemake](https://wemake-python-stylegui.de/en/latest/) strictest and most opinionated Python linter\n* [mypy](https://mypy.readthedocs.io/en/stable/) static type checker\n* [flake8](https://flake8.pycqa.org/en/latest/) Style Guide Enforcement\n  * [nitpick](https://nitpick.readthedocs.io/en/latest/) enforce the same settings across configuration files\n\n### Testing\n* [pytest](https://docs.pytest.org/) test framework\n  * [The Magic Tricks of Testing by Sandi Metz (Talk)](https://www.youtube.com/watch?v=URSWYvyc42M) on what to test, and what not\n\n### Continuous Testing & Integration (CT & CI)\nIntegration as in: Deployment and Integration testing.\n\n* [crontab](https://linux.die.net/man/5/crontab)\n\n* [github actions](https://github.com/features/actions)\n  * [pytest & coverage (yml)](https://github.com/cypress-io/github-action/blob/master/.github/workflows/example-basic.yml)\n    pytest @ python-version: [\'3.7\', \'3.8\', \'3.9\', \'3.10\']\n  * [misspell (yml)](https://github.com/reviewdog/action-misspell)\n  * [codeql-analysis (yml)](https://docs.github.com/en/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/configuring-the-codeql-workflow-for-compiled-languages)\n\n* Alternatives to github actions\n  * [tox](https://tox.wiki/en/latest/) test and deploy\n  * [travis](https://www.travis-ci.com/) test and deploy\n  * [coveralls.io](https://coveralls.io/) coverage\n\n### Build and publish to pypi\n* [make Makefile](https://www.gnu.org/software/make/manual/make.html) automate above\n  * [Managing Projects with GNU Make, 3rd Edition](https://www.oreilly.com/library/view/managing-projects-with/0596006101/ch01.html)\n* [poetry version bump](https://python-poetry.org/docs/cli/#version) bump version\n* [poetry build](https://python-poetry.org/docs/cli/#build) wheel\n* [poetry publish](https://python-poetry.org/docs/cli/#publish) to pypi\n\n### Following Semantic Versioning\n* [Semantic Versioning](https://semver.org/)\n  * [semver](https://pypi.org/project/semver/) Python Package\n\n### Development Environment\n* [poetry](https://python-poetry.org/) python packaging and dependency management\n* [cookiecutter](https://cookiecutter.readthedocs.io/en/latest/README.html) creates projects from project templates\n* [venv](https://docs.python.org/3/library/venv.html) creates projects from project templates\n\n### Version and Issue Management\n* [git](https://git-scm.com/) distributed version control system\n* [github](https://github.com/) online collaborative version control\n  * [gh](https://github.com/cli/cli) GitHub on the command line\n    * [gh Milestones](https://gist.github.com/doi-t/5735f9f0f7f8b7664aa6739bc810a2cc)\n* [tickgit](https://github.com/augmentable-dev/tickgit) Not used, but collects TODO from source code\n\n### IDE\n* [vi](https://www.vim.org/about.php) advanced text editor\n* [VS Code](https://code.visualstudio.com/) source-code editor\n\n### Shell\n* [oh-my-zsh](https://ohmyz.sh/)\n  * [zsh](https://github.com/ohmyzsh/ohmyzsh/wiki/Installing-ZSH#how-to-install-zsh-on-many-platforms)\n  * [MAC config](https://chiamakaikeanyi.dev/how-to-configure-your-macos-terminal-with-zsh-like-a-pro/)\n\n### Documentation\n* [Markdown](https://www.markdownguide.org/basic-syntax/) lightweight markup language\n  * [Markdown to PDF (online)](https://dillinger.io/)\n* [sphinx](https://www.sphinx-doc.org/en/master/) Python documentation Generator\n* [doc8](https://github.com/pycqa/doc8) opinionated style checker for rst\n* [readthedocs](https://readthedocs.org/) document style and service\n\n### Metric\n* [shields](https://shields.io/) for Shields and Badges\n  * [issuehub.pro](http://issuehub.pro/label-guide) Label Guide\n    * [List of Badges](https://naereen.github.io/badges/)\n  * [cloc](https://github.com/AlDanial/cloc) for SLOC\n\n### Jason Query for Makefile and Shields\n* [jq](https://github.com/stedolan/jq/wiki/Cookbook#filter-objects-based-on-the-contents-of-a-keyhttps://stedolan.github.io/jq/)\n  * [Syntax](https://github.com/stedolan/jq/wiki/Cookbook#filter-objects-based-on-the-contents-of-a-key)\n\n## Teaching Python Development\n* [Teaching](https://github.com/cruisen/cli-calc/blob/main/docs/extras/teaching.md)\n\n### cli-calc Examples\n* [github actions (cli-calc)](https://github.com/cruisen/cli-calc/actions)\n  * [pytest & coverage (yml) (cli-calc)](https://github.com/cruisen/cli-calc/blob/main/.github/workflows/test.yml)\n  * [codeql-analysis (yml) (cli-calc)](https://github.com/cruisen/cli-calc/blob/main/.github/workflows/codeql-analysis.yml)\n  * [misspell (yml) (cli-calc)](https://github.com/cruisen/cli-calc/blob/main/.github/workflows/misspell.yml)\n* [make Makefile (cli-calc)](https://github.com/cruisen/cli-calc/blob/main/Makefile) automate above\n* [cli-calc](https://cli-calc.readthedocs.io/en/latest/?badge=latest#)\n\n### NvK Tools\n* [make_shields.py (dev_tool)](https://github.com/cruisen/cli-calc/blob/main/dev_tools/meters/make_shields.py) for SLOC\n* [get_ver_for_rule (dev_tool)](https://github.com/cruisen/cli-calc/blob/main/dev_tools/sem_ver/get_ver_for_rule.py)\n* [Tips](https://github.com/cruisen/cli-calc/blob/main/docs/extras/zsh.md)\n\n# License\n\n[MIT](https://github.com/cruisen/cli-calc/blob/master/LICENSE)\n\n\n## Credits\n\nThis project was generated with [`wemake-python-package`](https://github.com/wemake-services/wemake-python-package). Current template version is: [d06993f12e3ffad79652a2aec86189dee92d94dd](https://github.com/wemake-services/wemake-python-package/tree/d06993f12e3ffad79652a2aec86189dee92d94dd). See what is [updated](https://github.com/wemake-services/wemake-python-package/compare/d06993f12e3ffad79652a2aec86189dee92d94dd...master) since then.\n',
    'author': 'Nikolai von Krusenstiern',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cruisen/cli-calc',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
