import unittest, io

from LaTeXDatax import printvariables
from pint import Quantity

class TestDatax(unittest.TestCase):
    def test_datax(self):
        """
        Test that it writes a number of variables correctly
        """
        f = io.StringIO()
        printvariables(f,
                a = "Literal string",
                b = 3.141592,
                c = (3.141592,"\\meter"),
                d = (3.141592,"\\meter","%.2g"),
                e = (3.141592,"%.2g"),
                f = Quantity(3.141592,"\\meter"),
                )
        f.seek(0)
        written = f.read()
        target ="""\
% File auto-generated by LaTeXDatax.py. Will be overwritten.
\\pgfkeyssetvalue{/datax/a}{Literal string}
\\pgfkeyssetvalue{/datax/b}{\\num{3.142}}
\\pgfkeyssetvalue{/datax/c}{\\qty{3.142}{\\meter}}
\\pgfkeyssetvalue{/datax/d}{\\qty{3.1}{\\meter}}
\\pgfkeyssetvalue{/datax/e}{\\num{3.1}}
\\pgfkeyssetvalue{/datax/f}{\\SI[]{3.141592}{\\meter}}
"""
        self.assertEqual(written,target)

if __name__ == '__main__':
    unittest.main()
