"""Validation, signing, and verification tools for .ds.md workflow files."""

from .core import (
    ChecksumResult,
    ChecksumStatus,
    ParsedDossier,
    ParseError,
    ValidationResult,
    calculate_checksum,
    parse_content,
    parse_file,
    update_checksum,
    validate_content,
    validate_file,
    validate_frontmatter,
    verify_checksum,
    verify_dossier_checksum,
)
from .signing import (
    SignatureInfo,
    SignatureStatus,
    SignatureVerificationResult,
    Signer,
    Verifier,
    ensure_dossier_dir,
    key_exists,
    list_keys,
    load_signer,
    save_key_pair,
    sign_dossier,
    verify_dossier_signature,
)

__version__ = "0.1.0"

__all__ = [
    "ChecksumResult",
    "ChecksumStatus",
    "ParseError",
    "ParsedDossier",
    "SignatureInfo",
    "SignatureStatus",
    "SignatureVerificationResult",
    "Signer",
    "ValidationResult",
    "Verifier",
    "__version__",
    "calculate_checksum",
    "ensure_dossier_dir",
    "key_exists",
    "list_keys",
    "load_signer",
    "parse_content",
    "parse_file",
    "save_key_pair",
    "sign_dossier",
    "update_checksum",
    "validate_content",
    "validate_file",
    "validate_frontmatter",
    "verify_checksum",
    "verify_dossier_checksum",
    "verify_dossier_signature",
]
