# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (21,6,6,6,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        130 194
        58 74
        80 211
        151 4
        47 173
        213 112
        9 30
        170 86
        105 77
        115 38
        1 115
        12 52
        137 193
        122 134
        99 205
        66 71
        18 145
        198 155
        135 61
        168 3
        16 119
        78 169
        150 160
        204 138
        178 195
        124 192
        73 19
        167 81
        189 7
        56 37
        63 90
        64 91
        93 64
        123 65
        141 17
        84 27
        205 94
        136 182
        113 161
        133 73
        57 145
        208 55
        26 100
        123 204
        83 166
        219 187
        141 55
        7 210
        99 120
        172 157
        169 197
        40 126
        122 27
        26 122
        199 20
        200 22
        163 155
        132 83
        117 102
        206 35
        100 47
        92 21
        178 185
        202 90
        82 163
        188 14
        28 134
        131 50
        69 206
        218 22
        45 167
        118 21
        162 35
        116 44
        182 129
        63 57
        111 54
        159 150
        176 162
        11 174
        31 106
        132 206
        212 120
        164 118
        37 20
        0 72
        19 36
        144 70
        166 25
        117 209
        84 14
        58 102
        185 173
        107 111
        2 119
        108 114
        141 142
        51 52
        92 93
        0 184
        135 152
        147 45
        135 126
        48 7
        170 46
        117 191
        143 3
        17 180
        60 96
        6 109
        48 45
        208 203
        185 54
        42 22
        186 210
        28 68
        34 91
        10 86
        193 53
        71 205
        147 165
        79 221
        10 89
        164 64
        164 155
        46 152
        24 203
        185 44
        88 134
        140 93
        87 211
        123 56
        57 46
        211 53
        193 175
        169 76
        12 200
        104 54
        188 122
        125 104
        168 38
        85 174
        127 109
        1 69
        16 74
        150 158
        212 67
        208 162
        148 94
        132 177
        189 215
        87 59
        82 175
        144 65
        153 181
        130 89
        139 121
        181 103
        140 155
        164 192
        187 49
        89 216
        4 83
        26 215
        199 172
        24 110
        124 175
        32 194
        125 212
        157 114
        41 171
        109 161
        13 111
        12 114
        81 134
        159 31
        25 206
        214 202
        56 147
        23 167
        96 192
        1 182
        47 27
        166 180
        10 145
        210 70
        18 161
        118 39
        162 17
        178 95
        138 128
        2 92
        76 80
        90 152
        210 100
        80 191
        11 132
        170 216
        15 41
        18 61
        160 196
        189 65
        28 149
        146 29
        54 99
        33 133
        37 160
        204 108
        207 110
        76 203
        176 129
        172 3
        27 149
        102 197
        141 50
        101 190
        16 220
        188 158
        140 103
        202 113
        69 156
        151 172
        178 88
        51 106
        2 87
        195 116
        43 174
        187 108
        101 36
        139 66
        34 29
        188 186
        62 156
        99 183
        11 9
        30 35
        75 171
        123 48
        71 112
        19 86
        146 207
        37 187
        33 170
        49 196
        24 97
        126 198
        129 156
        127 198
        51 168
        125 213
        16 79
        5 215
        221 53
        220 53
        160 106
        32 202
        116 120
        77 100
        165 70
        39 184
        84 167
        105 67
        154 73
        107 44
        39 163
        104 95
        195 67
        117 55
        58 97
        218 38
        79 39
        119 118
        52 196
        213 98
        201 92
        144 158
        143 11
        189 14
        77 81
        73 139
        48 128
        184 103
        119 91
        75 209
        215 88
        109 214
        209 76
        110 55
        125 68
        121 179
        201 79
        168 108
        116 149
        23 88
        4 182
        143 115
        21 96
        151 218
        191 207
        80 97
        5 77
        52 85
        40 60
        33 101
        43 136
        177 85
        13 33
        75 62
        131 30
        23 7
        15 142
        86 113
        56 158
        42 115
        58 59
        159 14
        104 179
        130 126
        153 90
        78 110
        28 95
        31 165
        219 199
        213 107
        136 200
        94 217
        137 201
        198 181
        128 70
        66 120
        1 177
        194 60
        62 25
        36 145
        5 195
        157 138
        32 61
        204 106
        49 3
        173 183
        6 40
        142 78
        127 61
        221 64
        211 91
        34 191
        154 190
        157 196
        31 65
        13 205
        154 113
        179 94
        143 4
        131 62
        150 128
        15 197
        32 10
        112 36
        15 176
        133 71
        186 81
        12 219
        137 74
        85 38
        135 216
        148 95
        176 166
        127 72
        190 216
        20 165
        146 2
        72 192
        29 193
        148 67
        171 102
        159 45
        98 19
        83 22
        43 219
        59 207
        68 105
        34 74
        142 156
        41 25
        23 47
        30 129
        72 194
        9 136
        43 151
        133 57
        8 35
        105 173
        0 153
        5 84
        89 63
        29 93
        68 44
        212 217
        214 181
        214 60
        41 8
        42 9
        13 98
        217 139
        144 26
        146 220
        17 69
        131 180
        147 186
        169 59
        82 96
        121 111
        42 180
        101 121
        174 49
        51 199
        124 221
        140 175
        40 163
        177 200
        21 103
        24 171
        6 152
        154 63
        8 203
        190 18
        208 197
        183 149
        148 183
        6 0
        218 114
        75 78
        20 138
        82 201
        98 217
        112 179
        66 107
        209 50
        8 50
        124 184
        130 153
        46 161
        137 87
        220 97
        """

        self.waters="""
        0.66922 0.70961 0.68577
        0.33077 0.29039 0.31424
        0.41923 0.20961 0.55512
        0.0 0.0 0.23421
        0.12372 0.87628 0.29514
        0.33589 0.29295 0.0191
        0.87628 0.75256 0.70486
        0.08077 0.54039 0.07423
        0.74744 0.87372 0.40756
        0.70961 0.04039 0.31424
        0.45961 0.91923 0.77788
        0.75256 0.87628 0.29514
        0.66667 0.33333 0.23454
        0.04295 0.70705 0.86606
        0.45961 0.54039 0.07423
        0.12628 0.87372 0.40756
        0.79039 0.58077 0.55512
        0.20961 0.41923 0.37153
        0.87628 0.12372 0.77821
        0.41667 0.08333 0.83333
        0.33333 0.91667 0.16667
        0.41923 0.20961 0.62847
        0.91922 0.45961 0.29062
        0.91411 0.45705 0.0382
        0.62372 0.62628 0.46728
        0.79294 0.58589 0.37604
        0.0 0.0 0.05729
        0.70706 0.66411 0.0191
        0.66411 0.95705 0.9809
        0.20706 0.41411 0.55545
        0.62372 0.99744 0.35243
        0.33589 0.29294 0.13395
        0.54294 0.08589 0.74089
        0.91667 0.58334 0.83333
        0.99744 0.37372 0.53272
        0.58077 0.79039 0.37153
        0.66667 0.08333 0.83333
        0.58333 0.91667 0.16667
        0.20706 0.4141 0.25911
        0.79039 0.58077 0.62847
        0.04038 0.70961 0.68577
        0.87628 0.75256 0.40756
        0.95961 0.29039 0.31424
        0.45706 0.91411 0.25911
        0.33334 0.66667 0.94722
        0.66667 0.33334 0.09912
        0.87628 0.75256 0.77821
        0.95706 0.66411 0.0191
        0.9141 0.45705 0.11154
        0.75256 0.87628 0.22179
        0.87628 0.12372 0.40756
        0.33078 0.29039 0.19939
        0.54039 0.45961 0.22212
        0.58589 0.79295 0.55545
        0.91923 0.45961 0.92577
        0.20961 0.41923 0.44487
        0.70706 0.04295 0.13395
        0.66923 0.70962 0.80061
        0.0 0.75 0.5
        0.25 0.0 0.5
        0.29039 0.95961 0.68577
        0.79295 0.20705 0.74089
        0.66667 0.33334 0.39063
        0.45961 0.54039 0.77788
        0.87372 0.12628 0.59244
        0.12628 0.25256 0.11121
        0.45706 0.54295 0.88846
        0.25256 0.12628 0.95729
        0.45706 0.91411 0.96181
        0.37372 0.37628 0.35243
        0.12628 0.87372 0.11121
        0.66411 0.70705 0.86605
        0.66923 0.95962 0.68577
        0.41667 0.33334 0.83333
        0.99744 0.62372 0.53272
        0.66667 0.33334 0.43213
        0.62372 0.99744 0.46728
        0.33589 0.04295 0.0191
        0.41411 0.20706 0.44455
        0.87372 0.74744 0.59244
        0.75 0.0 0.5
        0.54295 0.0859 0.0382
        0.20705 0.79295 0.62396
        0.95961 0.66923 0.31424
        0.54295 0.45705 0.0382
        0.45706 0.54295 0.25911
        0.29039 0.95961 0.80061
        0.37628 0.00256 0.53272
        0.95706 0.29295 0.0191
        0.33333 0.66667 0.76546
        0.54295 0.45706 0.74089
        0.79039 0.20961 0.55512
        0.25256 0.12628 0.59244
        0.12372 0.24744 0.59244
        0.0 0.0 0.90121
        0.87372 0.12628 0.95729
        0.37628 0.00256 0.64757
        0.75 0.75 0.5
        0.29295 0.95705 0.86606
        0.79039 0.58078 0.92578
        0.12628 0.87372 0.04271
        0.91667 0.33334 0.83333
        0.00256 0.62628 0.46728
        0.37628 0.37372 0.64757
        0.79039 0.20961 0.92578
        0.29295 0.95705 0.9809
        0.33333 0.41667 0.16667
        0.33334 0.66667 0.90088
        0.95961 0.29039 0.19939
        0.0 0.0 0.71944
        0.37372 0.37628 0.46728
        0.0859 0.54295 0.88846
        0.66411 0.95705 0.86605
        0.24744 0.12372 0.77821
        0.91922 0.45961 0.22212
        0.12372 0.24744 0.29514
        0.45706 0.54295 0.96181
        0.00256 0.37628 0.46728
        0.66667 0.33333 0.61389
        0.66667 0.33333 0.56754
        0.54039 0.45962 0.92578
        0.04295 0.3359 0.86606
        0.74744 0.87372 0.04271
        0.95705 0.29294 0.13395
        0.58589 0.79295 0.62396
        0.54039 0.08077 0.92578
        0.08077 0.54039 0.70938
        0.87628 0.12372 0.70486
        0.95705 0.66411 0.13395
        0.37372 0.99744 0.35243
        0.33333 0.66667 0.72396
        0.79294 0.20706 0.37604
        0.70961 0.66923 0.31424
        0.66667 0.58334 0.83333
        0.70705 0.04294 0.0191
        0.91411 0.45706 0.74089
        0.54039 0.08077 0.29062
        0.20706 0.79295 0.55545
        0.08333 0.66667 0.16667
        0.29295 0.3359 0.86606
        0.20705 0.41411 0.62396
        0.12628 0.25256 0.40756
        0.24744 0.12372 0.40756
        0.0 0.0 0.28056
        0.0 0.0 0.0988
        0.66923 0.95961 0.80061
        0.37628 0.37372 0.53272
        0.54295 0.0859 0.11154
        0.0 0.0 0.94271
        0.66411 0.70706 0.9809
        0.70706 0.66411 0.13395
        0.20706 0.79295 0.25911
        0.79294 0.5859 0.74089
        0.45961 0.54039 0.70938
        0.29039 0.33078 0.80061
        0.99744 0.37372 0.64757
        0.41411 0.20706 0.37604
        0.95961 0.66923 0.19939
        0.74744 0.87372 0.11121
        0.54295 0.45705 0.11154
        0.58333 0.66667 0.16667
        0.0 0.0 0.76579
        0.33333 0.66667 0.38611
        0.99744 0.62372 0.64757
        0.79039 0.20962 0.62847
        0.33589 0.04295 0.13395
        0.00256 0.62628 0.35243
        0.66667 0.33334 0.05278
        0.12372 0.24744 0.22179
        0.37372 0.99744 0.46728
        0.04039 0.70961 0.80061
        0.79294 0.58589 0.44455
        0.12372 0.87628 0.22179
        0.04295 0.70706 0.9809
        0.5859 0.79295 0.25911
        0.33333 0.66667 0.60937
        0.20961 0.79039 0.37153
        0.54039 0.45961 0.29062
        0.04295 0.33589 0.9809
        0.87372 0.12628 0.88879
        0.00256 0.37628 0.35243
        0.29039 0.33077 0.68576
        0.33077 0.04039 0.31424
        0.87372 0.74744 0.95729
        0.62628 0.62372 0.64757
        0.0859 0.54295 0.96181
        0.45961 0.91923 0.07423
        0.70961 0.04039 0.19939
        0.58078 0.79039 0.07423
        0.20961 0.41922 0.07423
        0.04039 0.33078 0.80061
        0.0 0.25 0.5
        0.62628 0.00256 0.64757
        0.33334 0.66667 0.56787
        0.45961 0.91923 0.70938
        0.29295 0.33589 0.9809
        0.70961 0.66923 0.19939
        0.20961 0.79039 0.44487
        0.04039 0.33078 0.68577
        0.33078 0.04039 0.19939
        0.66667 0.33333 0.27604
        0.12372 0.87628 0.59244
        0.4141 0.20705 0.74089
        0.58077 0.79039 0.44488
        0.08333 0.41667 0.16667
        0.87372 0.74744 0.88879
        0.62372 0.62628 0.35243
        0.25 0.25 0.5
        0.33333 0.66667 0.43246
        0.79295 0.20706 0.44455
        0.20961 0.79039 0.07423
        0.62628 0.00256 0.53272
        0.41922 0.20961 0.92577
        0.45706 0.9141 0.88846
        0.24744 0.12372 0.70486
        0.12628 0.25256 0.04271
        0.08078 0.54039 0.77788
        0.25256 0.12628 0.88879
        0.08589 0.54295 0.25911
        0.54039 0.08077 0.22212
        0.62628 0.62372 0.53272
        0.75256 0.87628 0.59244
        """

        self.coord= "relative"

        self.cages="""
        14 0.33333333333333337 0.6666666666666667 0.12606666666666666
        12 -0.34357 -0.17179 -0.07639
        12 0.33333 0.66667 -0.33333
        16 0.9999966666666668 2.0000033333333334 1.3513933333333334
        12 0.34357 0.17179 0.07639
        12 0.6769033333333333 0.8384566666666667 0.7430566666666667
        12 -0.6769033333333333 -0.8384566666666667 -0.7430566666666667
        15 0.33333333333333337 0.6666666666666667 0.8326766666666667
        15 0.0 0.0 -0.16601
        14 0.0 0.0 0.5406
        16 0.66667 0.33333 -0.01806
        12 -0.010236666666666666 0.49487666666666663 0.5902766666666667
        12 -0.17178 -0.34357 0.07639
        12 0.17178 -0.17179 -0.07639
        12 0.5051233333333334 1.0102366666666667 0.5902766666666667
        14 0.33333333333333337 0.6666666666666667 1.2072666666666667
        14 0.6666666666666667 1.3333333333333335 1.8739333333333335
        16 0.6666633333333333 1.3333366666666666 0.6847266666666667
        12 0.5051133333333333 0.49487666666666663 0.5902766666666667
        15 0.6666666666666667 0.33333333333333337 -0.8326766666666667
        12 1.0102366666666667 1.5051233333333334 1.4097233333333334
        16 1.3333366666666666 0.6666633333333333 -0.6847266666666667
        12 -0.17179 0.17178 0.07639
        12 0.17179 0.34357 -0.07639
        12 1.0000033333333334 0.9999966666666668 0.9999966666666668
        12 0.16154333333333334 0.8384466666666667 0.7430566666666667
        12 0.8384466666666667 0.16154333333333334 -0.7430566666666667
        16 0.33333 0.66667 0.01806
        14 0.0 0.0 -0.5406
        16 1.0000033333333334 0.9999966666666668 0.6486066666666667
        15 0.33333333333333337 0.6666666666666667 0.5006566666666666
        12 0.66667 0.33333 0.33333
        12 -0.5051233333333334 -1.0102366666666667 -0.5902766666666667
        15 0.6666666666666667 1.3333333333333335 1.4993433333333335
        12 0.16155333333333333 0.3230966666666667 0.7430566666666667
        15 0.0 0.0 0.16601
        14 0.6666666666666667 0.33333333333333337 -1.2072666666666667
        12 0.8384566666666667 0.6769033333333333 -0.7430566666666667
        12 0.49487666666666663 1.5051133333333335 1.4097233333333334
        """

        self.bondlen = 3


        self.cell = """
        12.746393818818838 0.0 0.0
        -6.373196909409416 11.038700853738058 0.0
        4.332977656078051e-15 7.504937448387889e-15 70.76289521345811
        """

        self.density = 0.6664596154282791



        self.cell = cellvectors(a=12.746393818818838,
                           b=12.746393818818838,
                           c=70.76289521345811,
                           C=119.99999999999999)
