# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,12,0,8,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        107 177
        128 86
        37 56
        11 223
        203 111
        39 21
        196 54
        23 52
        100 79
        84 23
        199 120
        0 172
        143 33
        106 13
        105 65
        195 72
        74 86
        166 113
        85 12
        89 199
        28 33
        1 79
        25 191
        78 42
        30 98
        7 113
        83 211
        58 53
        172 74
        37 224
        77 78
        29 31
        124 54
        199 113
        202 63
        217 123
        82 4
        66 132
        3 165
        207 142
        25 27
        59 48
        19 215
        190 189
        88 187
        222 197
        203 115
        218 172
        38 205
        115 17
        179 164
        2 187
        3 94
        2 148
        188 152
        72 159
        179 77
        25 198
        87 42
        227 89
        158 70
        59 149
        62 51
        73 221
        131 34
        134 55
        94 32
        147 114
        166 5
        145 33
        81 48
        117 145
        168 15
        140 5
        86 213
        150 135
        24 55
        37 207
        149 38
        182 97
        57 108
        204 144
        122 106
        128 32
        117 128
        220 212
        96 82
        142 159
        116 85
        119 48
        66 115
        163 216
        130 65
        112 86
        40 108
        181 215
        53 69
        119 41
        19 57
        141 216
        225 59
        226 60
        225 133
        118 84
        90 92
        14 201
        47 20
        101 223
        226 102
        154 206
        24 124
        148 224
        134 75
        83 203
        157 13
        35 56
        209 200
        151 98
        204 110
        67 103
        114 31
        182 52
        214 85
        43 40
        47 189
        96 177
        71 12
        167 151
        2 213
        96 211
        16 137
        6 84
        119 202
        196 193
        94 205
        141 9
        95 206
        63 110
        7 103
        135 190
        213 71
        149 146
        144 153
        19 90
        162 27
        197 74
        4 131
        121 114
        204 77
        64 152
        155 52
        32 22
        62 121
        128 187
        223 159
        104 59
        104 131
        0 55
        145 88
        0 72
        117 146
        95 31
        80 185
        167 38
        142 163
        67 46
        142 164
        88 27
        148 76
        138 139
        105 104
        39 69
        167 201
        112 146
        155 10
        158 44
        67 159
        7 73
        85 193
        104 36
        178 162
        155 168
        138 214
        197 32
        192 41
        37 191
        227 10
        36 47
        226 194
        200 127
        168 21
        151 17
        26 127
        219 101
        138 210
        171 185
        129 3
        126 193
        150 1
        135 20
        78 33
        125 50
        64 121
        12 22
        122 96
        158 90
        26 34
        64 206
        184 57
        147 116
        111 133
        223 179
        173 188
        181 176
        130 119
        61 87
        143 48
        156 224
        154 125
        91 71
        60 109
        139 31
        209 13
        219 17
        95 68
        89 52
        116 194
        207 58
        126 136
        69 120
        181 92
        63 81
        175 180
        170 209
        49 200
        8 108
        109 123
        8 109
        175 43
        102 114
        97 193
        97 194
        150 45
        11 46
        126 217
        99 132
        134 74
        184 160
        106 49
        118 60
        25 46
        18 9
        141 172
        11 80
        168 173
        105 41
        50 91
        192 205
        151 111
        73 93
        137 47
        154 35
        14 197
        14 195
        15 93
        186 17
        58 51
        198 210
        18 149
        161 6
        219 80
        122 23
        194 169
        102 184
        116 91
        65 4
        157 153
        173 6
        100 177
        220 148
        70 176
        175 153
        49 176
        40 215
        212 61
        143 146
        125 126
        186 185
        35 121
        93 58
        157 44
        218 174
        101 98
        118 217
        221 207
        210 162
        8 102
        147 156
        9 186
        70 152
        107 183
        208 41
        155 92
        183 217
        21 161
        156 50
        49 84
        95 184
        39 124
        189 79
        190 109
        175 110
        77 185
        100 4
        101 204
        24 222
        82 13
        135 108
        195 103
        167 9
        227 188
        43 20
        183 23
        65 111
        16 19
        107 226
        134 71
        191 164
        8 64
        178 214
        75 120
        208 42
        112 218
        165 213
        56 51
        186 144
        24 195
        106 158
        68 10
        203 82
        30 133
        81 36
        62 188
        198 221
        15 62
        140 198
        165 22
        154 139
        68 152
        117 205
        11 61
        129 212
        171 164
        225 34
        129 192
        2 50
        130 225
        125 214
        123 206
        165 220
        39 93
        129 143
        160 79
        161 169
        140 56
        75 196
        177 127
        178 187
        43 44
        90 68
        173 176
        61 27
        138 147
        73 5
        220 162
        122 92
        16 66
        99 137
        219 132
        221 67
        157 115
        26 190
        0 163
        118 169
        105 38
        103 216
        139 140
        196 222
        3 112
        70 40
        145 87
        91 136
        209 34
        55 69
        53 113
        181 211
        169 136
        171 216
        63 20
        174 98
        28 212
        191 76
        29 10
        89 6
        174 72
        131 189
        88 76
        170 153
        30 144
        21 182
        99 208
        166 227
        178 22
        29 5
        18 218
        202 99
        80 42
        1 137
        200 211
        83 180
        14 141
        182 54
        107 160
        224 210
        110 132
        183 97
        192 87
        170 133
        36 208
        150 202
        81 78
        180 66
        160 123
        222 12
        26 45
        174 201
        75 136
        28 179
        53 163
        28 76
        16 44
        130 45
        170 83
        18 30
        180 215
        29 15
        60 127
        100 45
        199 54
        171 46
        161 120
        35 156
        1 57
        124 7
        166 51
        201 94
        """

        self.waters="""
        0.65594 0.68819 0.41075
        0.14189 0.30871 0.95584
        0.25 0.8096 0.48058
        0.3611 0.5 0.32964
        0.4375 0.18371 0.01304
        0.90667 0.1904 0.60318
        0.64267 0.8096 0.73502
        0.75 0.1904 0.51942
        0.1267 0.68819 0.82021
        0.63941 0.0 0.24734
        0.85733 0.1904 0.73502
        0.95388 0.31181 0.30095
        0.40786 0.375 0.51211
        0.625 0.0 0.97393
        0.59096 0.18681 0.37017
        0.8611 0.5 0.67036
        0.9375 0.18371 0.98697
        0.75 0.18681 0.15584
        0.56172 0.81319 0.22673
        0.9392 0.30871 0.90893
        0.0625 0.81629 0.01304
        0.6389 0.5 0.67036
        0.34665 0.3154 0.45206
        0.56328 0.125 0.79667
        0.59214 0.375 0.4879
        0.00119 0.125 0.42835
        0.35811 0.69129 0.95584
        0.09333 0.1904 0.39682
        0.07888 0.6846 0.31804
        0.92112 0.3154 0.68196
        0.6267 0.68819 0.17979
        0.04612 0.31181 0.69906
        0.40667 0.1904 0.39682
        0.14267 0.8096 0.26498
        0.4375 0.81629 0.01304
        0.09096 0.81319 0.62983
        0.17061 0.0 0.10131
        0.0 0.75 0.5
        0.43672 0.125 0.20333
        0.68621 0.5 0.58903
        0.9392 0.69129 0.90893
        0.25 0.30871 0.16322
        0.06328 0.125 0.20333
        0.9375 0.81629 0.98697
        0.875 0.0 0.97393
        0.3125 0.5 0.99592
        0.90905 0.18681 0.37017
        0.125 0.0 0.02607
        0.25 0.69129 0.16322
        0.6233 0.81629 0.86073
        0.25 0.81319 0.57028
        0.90667 0.8096 0.60318
        0.64267 0.1904 0.73502
        0.75 0.8096 0.51942
        0.59333 0.1904 0.60318
        0.59214 0.625 0.4879
        0.99881 0.875 0.57165
        0.0642 0.375 0.89181
        0.84665 0.6846 0.54795
        0.3767 0.81629 0.13927
        0.3733 0.68819 0.82021
        0.07888 0.3154 0.31804
        0.92112 0.6846 0.68196
        0.0608 0.69129 0.09107
        0.06172 0.81319 0.77327
        0.4392 0.30871 0.09107
        0.85811 0.30871 0.04416
        0.84407 0.31181 0.41075
        0.93672 0.125 0.79667
        0.65335 0.6846 0.54795
        0.8767 0.81629 0.86073
        0.40786 0.625 0.51211
        0.68879 0.5 0.36214
        0.84665 0.3154 0.54795
        0.49881 0.875 0.42835
        0.50119 0.875 0.57165
        0.09333 0.8096 0.39682
        0.93828 0.81319 0.22673
        0.06328 0.875 0.20333
        0.25 0.18371 0.9288
        0.93828 0.18681 0.22673
        0.1233 0.81629 0.13927
        0.5625 0.18371 0.98697
        0.6875 0.5 0.00408
        0.56328 0.875 0.79667
        0.34407 0.31181 0.58925
        0.40667 0.8096 0.39682
        0.14267 0.1904 0.26498
        0.15712 0.0 0.38426
        0.68998 0.0 0.69732
        0.8767 0.18371 0.86073
        0.34407 0.68819 0.58925
        0.75 0.30871 0.83678
        0.81379 0.5 0.58903
        0.42112 0.3154 0.31804
        0.06172 0.18681 0.77327
        0.5608 0.30871 0.90893
        0.45388 0.31181 0.69906
        0.67231 0.5 0.22435
        0.0608 0.30871 0.09107
        0.35811 0.30871 0.95584
        0.82769 0.5 0.22435
        0.17231 0.5 0.77565
        0.75 0.18681 0.42972
        0.32939 0.0 0.10131
        0.3767 0.18371 0.13927
        0.67061 0.0 0.89869
        0.3733 0.31181 0.82021
        0.0642 0.625 0.89181
        0.25 0.81319 0.84416
        0.9358 0.625 0.10819
        0.5642 0.375 0.10819
        0.42112 0.6846 0.31804
        0.75 0.0 0.56305
        0.1111 0.5 0.70455
        0.75 0.18371 0.0712
        0.31121 0.5 0.63787
        0.31002 0.0 0.30268
        0.43828 0.81319 0.77327
        0.25 0.5 0.12806
        0.59333 0.8096 0.60318
        0.04612 0.68819 0.69906
        0.6233 0.18371 0.86073
        0.25 0.0 0.80271
        0.65335 0.3154 0.54795
        0.25 0.0 0.61636
        0.34784 0.0 0.65948
        0.4358 0.625 0.89181
        0.34288 0.0 0.38426
        0.25 0.5 0.27938
        0.35981 0.5 0.07707
        0.375 0.0 0.02607
        0.9358 0.375 0.10819
        0.5642 0.625 0.10819
        0.5 0.75 0.5
        0.14189 0.69129 0.95584
        0.40905 0.81319 0.62983
        0.0625 0.18371 0.01304
        0.15594 0.31181 0.58925
        0.09096 0.18681 0.62983
        0.99881 0.125 0.57165
        0.65216 0.0 0.34052
        0.84407 0.68819 0.41075
        0.25 0.6846 0.23888
        0.75 0.81319 0.15584
        0.18998 0.0 0.30268
        0.35733 0.8096 0.26498
        0.18879 0.5 0.63787
        0.15335 0.6846 0.45206
        0.43672 0.875 0.20333
        0.1875 0.5 0.99592
        0.6267 0.31181 0.17979
        0.93672 0.875 0.79667
        0.75 0.81629 0.0712
        0.15216 0.0 0.65948
        0.75 0.3154 0.76112
        0.15594 0.68819 0.58925
        0.75 0.0 0.02802
        0.82939 0.0 0.89869
        0.81121 0.5 0.36214
        0.25 0.18681 0.84416
        0.57888 0.6846 0.68196
        0.15335 0.3154 0.45206
        0.75 0.81319 0.42972
        0.90905 0.81319 0.37017
        0.31379 0.5 0.41097
        0.84288 0.0 0.61574
        0.56172 0.18681 0.22673
        0.75 0.5 0.72062
        0.45388 0.68819 0.69906
        0.64189 0.69129 0.04416
        0.84784 0.0 0.34052
        0.59096 0.81319 0.37017
        0.75 0.6846 0.76112
        0.6111 0.5 0.29546
        0.85811 0.69129 0.04416
        0.75 0.69129 0.83678
        0.4358 0.375 0.89181
        0.25 0.1904 0.48058
        0.95388 0.68819 0.30095
        0.8125 0.5 0.00408
        0.75 0.5 0.87194
        0.57888 0.3154 0.68196
        0.43828 0.18681 0.77327
        0.1267 0.31181 0.82021
        0.86059 0.0 0.24734
        0.75 0.0 0.19729
        0.25 0.0 0.43695
        0.85733 0.8096 0.73502
        0.25 0.0 0.97199
        0.25 0.81629 0.9288
        0.00119 0.875 0.42835
        0.25 0.3154 0.23888
        0.40905 0.18681 0.62983
        0.3889 0.5 0.70455
        0.65594 0.31181 0.41075
        0.50119 0.125 0.57165
        0.49881 0.125 0.42835
        0.0 0.25 0.5
        0.65712 0.0 0.61574
        0.5608 0.69129 0.90893
        0.54612 0.31181 0.30095
        0.14019 0.5 0.07707
        0.64189 0.30871 0.04416
        0.8733 0.68819 0.17979
        0.35733 0.1904 0.26498
        0.13941 0.0 0.75266
        0.90786 0.625 0.4879
        0.1233 0.18371 0.13927
        0.5625 0.81629 0.98697
        0.09214 0.375 0.51211
        0.64019 0.5 0.92294
        0.1389 0.5 0.32964
        0.34665 0.6846 0.45206
        0.25 0.18681 0.57028
        0.85981 0.5 0.92294
        0.75 0.0 0.38365
        0.36059 0.0 0.75266
        0.54612 0.68819 0.30095
        0.8733 0.31181 0.17979
        0.18621 0.5 0.41097
        0.90786 0.375 0.4879
        0.5 0.25 0.5
        0.8889 0.5 0.29546
        0.09214 0.625 0.51211
        0.4392 0.69129 0.09107
        0.32769 0.5 0.77565
        0.81002 0.0 0.69732
        """

        self.coord= "relative"

        self.cages="""
        12 0.25 0.5 0.5293
        12 0.75 0.5 0.4707
        14 0.11857 0.0 0.51912
        14 0.38143 0.0 0.51912
        14 0.88143 0.0 0.48088
        14 0.61857 0.0 0.48088
        12 0.00992 0.0 0.30837
        12 0.49008 0.0 0.30837
        12 0.99008 0.0 0.69163
        12 0.50992 0.0 0.69163
        12 0.25 0.26159 0.35478
        12 0.25 0.73841 0.35478
        12 0.75 0.26159 0.64522
        12 0.75 0.73841 0.64522
        14 0.00517 0.5 0.59498
        14 0.49483 0.5 0.59498
        14 0.99483 0.5 0.40502
        14 0.50517 0.5 0.40502
        12 0.25 0.23483 0.05214
        12 0.25 0.76517 0.05214
        12 0.75 0.23483 0.94786
        12 0.75 0.76517 0.94786
        16 0.06076 0.5 0.20398
        16 0.43924 0.5 0.20398
        16 0.93924 0.5 0.79602
        16 0.56076 0.5 0.79602
        16 0.56756 0.0 0.10817
        16 0.93244 0.0 0.10817
        16 0.43244 0.0 0.89183
        16 0.06756 0.0 0.89183
        12 0.25 0.0 0.19279
        12 0.75 0.0 0.80721
        12 0.75 0.5 0.1206
        12 0.25 0.5 0.8794
        14 0.25 0.24724 0.71359
        14 0.25 0.75276 0.71359
        14 0.75 0.24724 0.28641
        14 0.75 0.75276 0.28641
        12 0.0 0.5 0.0
        12 0.5 0.5 0.0
        """

        self.bondlen = 3


        self.cell = """
        24.812649581989046 14.39823941190525 38.89584892924532
        """

        self.density = 0.4904342740657932



        self.cell = cellvectors(a=24.812649581989046,
                           b=14.39823941190525,
                           c=38.89584892924532)
