# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (22,4,4,8,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        199 88
        71 180
        95 180
        81 90
        97 174
        136 126
        24 68
        93 66
        181 26
        183 212
        119 102
        132 58
        7 57
        206 149
        114 56
        51 157
        50 125
        99 45
        131 136
        201 77
        90 85
        27 88
        66 109
        1 40
        42 0
        36 178
        155 132
        211 94
        127 32
        31 179
        31 184
        33 201
        42 195
        32 163
        8 84
        185 156
        193 124
        213 16
        113 82
        135 32
        2 28
        26 105
        175 214
        8 143
        125 64
        92 26
        72 67
        31 203
        17 12
        147 207
        40 37
        42 38
        2 19
        40 52
        116 29
        61 154
        55 43
        170 101
        51 75
        6 111
        62 13
        191 22
        45 208
        56 21
        114 112
        116 60
        41 43
        33 47
        72 202
        7 73
        32 20
        33 207
        52 198
        33 69
        7 78
        1 98
        210 70
        34 211
        36 59
        114 95
        145 87
        91 180
        136 203
        138 204
        40 30
        135 143
        101 100
        162 160
        61 201
        120 117
        155 20
        60 144
        133 25
        35 53
        174 165
        115 74
        146 124
        18 111
        117 190
        175 94
        187 95
        89 16
        171 30
        131 159
        68 98
        73 206
        8 163
        149 153
        49 25
        193 85
        181 38
        122 6
        162 14
        141 52
        198 171
        173 151
        44 113
        145 181
        148 3
        133 115
        50 142
        113 108
        140 182
        141 186
        18 175
        54 69
        103 182
        170 16
        7 190
        80 153
        107 17
        115 93
        27 38
        63 173
        25 65
        150 142
        185 83
        34 81
        172 190
        193 104
        194 104
        195 105
        196 105
        150 121
        107 97
        24 58
        22 179
        72 62
        91 194
        103 28
        189 108
        147 77
        48 85
        123 93
        69 195
        23 106
        122 205
        39 168
        39 179
        205 100
        44 184
        50 89
        116 79
        128 178
        128 215
        157 190
        99 101
        28 196
        124 96
        192 53
        185 208
        56 63
        22 136
        128 167
        140 207
        35 125
        54 61
        110 131
        165 199
        46 164
        54 93
        134 171
        23 39
        98 75
        129 20
        164 21
        150 186
        119 17
        206 172
        6 29
        60 83
        205 169
        78 109
        122 152
        1 130
        187 164
        62 94
        70 79
        131 210
        89 13
        157 161
        10 70
        205 210
        139 120
        50 96
        134 125
        43 161
        104 30
        140 181
        169 29
        142 53
        121 4
        141 3
        16 67
        146 52
        42 207
        127 138
        127 21
        98 180
        197 83
        134 121
        212 108
        188 64
        117 153
        158 29
        138 132
        146 15
        147 19
        167 189
        138 71
        118 130
        129 118
        39 0
        2 44
        46 5
        68 37
        164 204
        143 161
        82 19
        34 186
        41 80
        192 197
        122 72
        176 203
        155 172
        192 214
        65 195
        137 11
        153 173
        158 208
        124 64
        107 200
        214 89
        78 84
        83 170
        105 87
        75 112
        152 13
        10 23
        106 22
        183 144
        51 71
        5 15
        88 26
        121 202
        176 168
        17 137
        103 209
        56 80
        59 191
        60 160
        139 84
        133 174
        46 76
        202 111
        41 127
        158 106
        130 112
        88 28
        188 90
        14 215
        109 11
        9 211
        10 212
        0 87
        156 166
        149 12
        100 67
        35 4
        148 24
        133 69
        92 165
        134 62
        210 45
        144 208
        49 200
        27 19
        92 182
        183 99
        158 70
        198 96
        10 159
        55 119
        73 74
        47 182
        48 186
        24 204
        76 193
        77 196
        5 85
        61 103
        123 154
        104 81
        178 184
        145 167
        65 77
        49 201
        74 12
        47 200
        199 209
        84 119
        200 209
        176 159
        23 215
        47 174
        91 204
        31 87
        129 21
        86 109
        9 214
        94 166
        106 110
        51 155
        126 108
        46 118
        115 11
        100 79
        97 57
        49 137
        99 126
        59 215
        165 66
        8 117
        59 212
        41 102
        129 58
        150 198
        86 209
        78 161
        139 107
        3 37
        68 187
        25 199
        82 168
        156 13
        145 176
        146 177
        147 178
        168 38
        151 43
        189 14
        188 15
        187 15
        191 144
        152 170
        63 58
        102 149
        9 96
        110 14
        86 154
        73 55
        57 66
        191 162
        151 132
        206 151
        18 197
        148 118
        123 12
        175 67
        102 163
        101 160
        213 202
        55 11
        63 75
        35 90
        120 57
        80 143
        36 179
        192 156
        36 82
        2 140
        141 5
        3 81
        48 53
        152 45
        44 167
        135 114
        135 71
        27 65
        166 4
        130 177
        189 159
        197 213
        74 97
        160 169
        163 172
        112 20
        1 194
        177 95
        54 92
        126 162
        6 185
        113 203
        34 4
        91 76
        148 194
        123 120
        139 86
        157 173
        211 171
        183 79
        0 128
        18 116
        110 169
        196 184
        188 37
        111 166
        64 30
        9 48
        177 76
        142 213
        154 137
        """

        self.waters="""
        0.3125 0.23047 0.31343
        0.8125 0.73047 0.31343
        0.8125 0.26953 0.68657
        0.3125 0.76953 0.31343
        0.30689 0.88637 0.18843
        0.3125 0.76953 0.68657
        0.375 0.0 0.1779
        0.875 0.5 0.1779
        0.80689 0.53816 0.69711
        0.0 0.86836 0.625
        0.0 0.13164 0.375
        0.375 0.45255 0.0
        0.31812 0.47679 0.5
        0.875 0.95255 0.0
        0.5 0.13237 0.5
        0.5 0.75974 0.81157
        0.69312 0.96184 0.69711
        0.19312 0.46184 0.69711
        0.18189 0.97679 0.5
        0.0 0.25974 0.81157
        0.0 0.63237 0.5
        0.31812 0.6514 0.68657
        0.375 0.13339 0.0
        0.18189 0.1514 0.31343
        0.3125 0.69069 0.18843
        0.125 0.36661 0.0
        0.6875 0.30932 0.18843
        0.0 0.28906 0.0
        0.6875 0.30932 0.81157
        0.30689 0.03816 0.3029
        0.8125 0.80932 0.18843
        0.5 0.21094 0.0
        0.0 0.60434 0.68657
        0.19312 0.33814 0.5
        0.18189 0.8486 0.31343
        0.375 0.86661 0.0
        0.1875 0.19069 0.81157
        0.5 0.75974 0.18843
        0.0 0.25974 0.18843
        0.1875 0.19069 0.18843
        0.6875 0.76953 0.31343
        0.31812 0.57067 0.82211
        0.1875 0.26953 0.31343
        0.375 0.54745 0.0
        0.6875 0.23047 0.68657
        0.875 0.04745 0.0
        0.1875 0.73047 0.68657
        0.0 0.36764 0.5
        0.18189 0.8486 0.68657
        0.19312 0.38637 0.81157
        0.69312 0.88637 0.81157
        0.80689 0.61364 0.18843
        0.625 0.78906 0.5
        0.30689 0.88637 0.81157
        0.5 0.36836 0.375
        0.25 0.5 0.0
        0.5 0.63164 0.625
        0.80689 0.46184 0.3029
        0.31812 0.6514 0.31343
        0.18189 0.1514 0.68657
        0.30689 0.03816 0.69711
        0.5 0.36836 0.625
        0.81812 0.92934 0.1779
        0.5 0.63164 0.375
        0.6875 0.81905 0.0
        0.1875 0.31905 0.0
        0.68189 0.42934 0.1779
        0.81812 0.97679 0.5
        0.5 0.71022 0.125
        0.31812 0.3486 0.31343
        0.0 0.07893 0.3029
        0.875 0.63339 0.0
        0.69312 0.96184 0.3029
        0.125 0.5 0.1779
        0.19312 0.46184 0.3029
        0.68189 0.6514 0.31343
        0.0 0.74026 0.81157
        0.3125 0.30932 0.81157
        0.75 0.5 0.0
        0.0 0.04643 0.5
        0.5 0.57893 0.69711
        0.1875 0.80932 0.18843
        0.0 0.21022 0.875
        0.375 0.0 0.82211
        0.875 0.5 0.82211
        0.1875 0.80932 0.81157
        0.68189 0.42934 0.82211
        0.5 0.24026 0.18843
        0.8125 0.31905 0.0
        0.81812 0.92934 0.82211
        0.3125 0.81905 0.0
        0.0 0.71094 0.0
        0.68189 0.3486 0.31343
        0.5 0.42107 0.3029
        0.0 0.92107 0.3029
        0.6875 0.69069 0.81157
        0.81812 0.8486 0.68657
        0.0 0.43863 0.375
        0.6875 0.69069 0.18843
        0.81812 0.07067 0.82211
        0.81812 0.02321 0.5
        0.69312 0.03816 0.69711
        0.19312 0.53816 0.69711
        0.68189 0.3486 0.68657
        0.0 0.78979 0.125
        0.5 0.28979 0.125
        0.30689 0.11364 0.18843
        0.0 0.43863 0.625
        0.81812 0.1514 0.68657
        0.625 0.45255 0.0
        0.5 0.10434 0.31343
        0.30689 0.96184 0.3029
        0.80689 0.66186 0.5
        0.8125 0.19069 0.81157
        0.68189 0.6514 0.68657
        0.31812 0.42934 0.1779
        0.18189 0.02321 0.5
        0.68189 0.52321 0.5
        0.125 0.71094 0.5
        0.125 0.5 0.82211
        0.68189 0.47679 0.5
        0.5 0.89566 0.31343
        0.625 0.0 0.1779
        0.5 0.45358 0.5
        0.8125 0.80932 0.81157
        0.625 0.86661 0.0
        0.69312 0.11364 0.81157
        0.19312 0.61364 0.81157
        0.375 0.21094 0.5
        0.19312 0.66186 0.5
        0.875 0.71094 0.5
        0.69312 0.11364 0.18843
        0.19312 0.61364 0.18843
        0.19312 0.38637 0.18843
        0.69312 0.88637 0.18843
        0.80689 0.61364 0.81157
        0.625 0.13339 0.0
        0.31812 0.42934 0.82211
        0.125 0.63339 0.0
        0.80689 0.46184 0.69711
        0.875 0.28906 0.5
        0.375 0.78906 0.5
        0.5 0.89566 0.68657
        0.68189 0.57067 0.82211
        0.18189 0.07067 0.82211
        0.6875 0.23047 0.31343
        0.6875 0.76953 0.68657
        0.1875 0.26953 0.68657
        0.1875 0.73047 0.31343
        0.31812 0.52321 0.5
        0.5 0.86764 0.5
        0.31812 0.57067 0.1779
        0.75 0.0 0.0
        0.5 0.54643 0.5
        0.5 0.42107 0.69711
        0.0 0.60434 0.31343
        0.125 0.95255 0.0
        0.68189 0.57067 0.1779
        0.18189 0.07067 0.1779
        0.81812 0.1514 0.31343
        0.5 0.06137 0.625
        0.625 0.54745 0.0
        0.5 0.10434 0.68657
        0.0 0.56137 0.625
        0.3125 0.69069 0.81157
        0.80689 0.38637 0.18843
        0.18189 0.92934 0.1779
        0.625 0.21094 0.5
        0.0 0.21022 0.125
        0.5 0.06137 0.375
        0.625 0.0 0.82211
        0.81812 0.8486 0.31343
        0.0 0.56137 0.375
        0.5 0.57893 0.3029
        0.0 0.39566 0.31343
        0.0 0.95358 0.5
        0.8125 0.19069 0.18843
        0.8125 0.73047 0.68657
        0.3125 0.23047 0.68657
        0.3125 0.18095 0.0
        0.8125 0.68095 0.0
        0.8125 0.26953 0.31343
        0.80689 0.33814 0.5
        0.0 0.07893 0.69711
        0.5 0.24026 0.81157
        0.25 0.0 0.0
        0.30689 0.83814 0.5
        0.5 0.71022 0.875
        0.5 0.78906 0.0
        0.69312 0.16186 0.5
        0.80689 0.53816 0.3029
        0.30689 0.11364 0.81157
        0.18189 0.92934 0.82211
        0.0 0.78979 0.875
        0.0 0.74026 0.18843
        0.3125 0.30932 0.18843
        0.5 0.28979 0.875
        0.30689 0.96184 0.69711
        0.69312 0.83814 0.5
        0.875 0.36661 0.0
        0.0 0.39566 0.68657
        0.31812 0.3486 0.68657
        0.5 0.93863 0.375
        0.6875 0.18095 0.0
        0.1875 0.68095 0.0
        0.69312 0.03816 0.3029
        0.19312 0.53816 0.3029
        0.125 0.28906 0.5
        0.125 0.04745 0.0
        0.80689 0.38637 0.81157
        0.81812 0.07067 0.1779
        0.0 0.86836 0.375
        0.0 0.13164 0.625
        0.5 0.93863 0.625
        0.0 0.92107 0.69711
        0.30689 0.16186 0.5
        """

        self.coord= "relative"

        self.cages="""
        12 0.5 0.17188 0.25372
        12 -0.25 -0.25 0.0
        16 0.5 0.36997 0.0
        12 0.5 0.0 0.5
        14 0.5 0.5 0.21158
        12 -0.22754 -0.09285 0.5
        12 -0.22754 0.09285 -0.5
        12 1.0 0.5 0.5
        14 0.5 0.5 -0.21158
        16 0.0 0.21083 0.5
        12 0.72754 0.59285 0.5
        12 0.0 0.32812 -0.25372
        12 -0.25 0.25 0.0
        12 0.22754 0.09285 0.5
        15 -0.5 -0.05978 0.0
        12 0.5 0.82812 0.25372
        12 0.0 0.32812 0.25372
        15 0.0 0.44022 0.0
        15 1.0 0.55978 0.0
        12 0.72754 0.40715 -0.5
        12 0.25 0.25 0.0
        12 0.0 -0.32812 0.25372
        16 0.0 0.13003 0.0
        12 0.0 -0.32812 -0.25372
        16 0.5 0.28917 0.5
        16 0.0 -0.21083 0.5
        16 0.0 -0.13003 0.0
        15 0.5 0.05978 0.0
        12 0.27246 0.59285 -0.5
        14 0.0 0.0 -0.21158
        16 0.5 0.71083 0.5
        12 0.5 0.82812 -0.25372
        16 0.5 0.63003 0.0
        14 0.0 0.0 0.21158
        12 0.25 -0.25 0.0
        12 0.5 0.17188 -0.25372
        12 0.27246 0.40715 0.5
        12 0.22754 -0.09285 -0.5
        """

        self.bondlen = 3


        self.cell = """
        13.458859951259516 61.21409101252036 13.576684557594195
        """

        self.density = 0.5772076767548375



        self.cell = cellvectors(a=13.458859951259516,
                           b=61.21409101252036,
                           c=13.576684557594195)
