# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (10,16,4,0,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        85 19
        78 160
        92 132
        87 126
        110 117
        64 7
        84 151
        4 160
        167 60
        15 12
        75 43
        146 84
        72 71
        147 149
        48 113
        18 42
        4 125
        44 140
        137 53
        32 3
        109 7
        5 38
        85 126
        122 156
        128 117
        128 31
        169 98
        71 115
        33 65
        30 65
        112 38
        49 119
        14 70
        171 80
        116 74
        44 166
        17 155
        121 120
        148 157
        165 6
        15 34
        138 101
        1 24
        36 171
        69 73
        159 50
        113 9
        68 3
        47 156
        95 106
        33 78
        14 57
        47 88
        33 34
        152 8
        27 100
        170 31
        160 171
        56 88
        24 106
        38 73
        128 153
        134 133
        4 119
        45 2
        42 75
        70 160
        87 140
        116 148
        143 25
        45 131
        62 34
        39 144
        136 64
        82 80
        159 162
        73 77
        153 156
        157 153
        47 65
        58 107
        126 77
        110 63
        1 79
        20 145
        79 60
        1 159
        124 10
        138 18
        61 87
        83 61
        17 12
        147 166
        95 139
        110 107
        55 62
        154 92
        136 141
        48 53
        137 28
        135 40
        15 8
        111 83
        165 92
        159 66
        54 135
        42 35
        134 162
        124 161
        109 125
        37 17
        113 157
        132 171
        127 86
        164 29
        170 74
        14 29
        72 132
        124 103
        30 132
        146 164
        127 87
        85 40
        119 88
        114 14
        36 119
        102 53
        86 54
        74 7
        75 8
        147 59
        25 89
        1 84
        167 68
        45 83
        110 23
        154 67
        44 73
        33 72
        168 156
        99 158
        56 26
        39 90
        99 81
        16 149
        92 19
        143 139
        99 59
        147 101
        114 39
        127 6
        45 97
        35 145
        11 68
        111 150
        112 150
        48 43
        41 166
        67 72
        10 129
        23 158
        94 99
        28 121
        104 164
        32 52
        28 130
        39 53
        167 117
        4 65
        51 12
        63 9
        21 133
        129 59
        56 158
        10 152
        167 130
        28 11
        61 169
        85 29
        5 7
        123 106
        124 107
        79 102
        116 68
        81 150
        46 140
        105 81
        126 98
        125 76
        18 10
        128 116
        31 168
        30 168
        96 115
        112 108
        36 168
        23 141
        151 3
        42 25
        47 55
        108 66
        146 139
        20 75
        0 55
        0 56
        142 100
        58 9
        114 78
        118 6
        151 133
        123 89
        169 97
        162 106
        152 89
        105 138
        36 26
        20 71
        13 158
        114 67
        93 83
        108 3
        127 19
        24 164
        50 52
        133 139
        163 81
        50 149
        64 60
        154 29
        122 131
        108 134
        57 120
        70 40
        121 146
        24 57
        22 155
        86 170
        13 122
        59 103
        23 103
        135 77
        93 69
        94 69
        54 38
        170 76
        96 107
        104 143
        82 2
        27 51
        21 149
        142 169
        165 120
        21 25
        143 142
        141 88
        16 129
        63 153
        78 91
        8 161
        37 93
        157 141
        111 140
        48 161
        58 43
        131 55
        32 46
        145 97
        18 58
        41 163
        105 129
        112 46
        79 144
        136 49
        13 163
        104 98
        95 100
        111 41
        44 52
        15 91
        11 102
        82 145
        40 125
        80 91
        5 52
        27 155
        96 90
        144 130
        113 103
        165 70
        62 97
        19 76
        118 100
        20 34
        13 63
        118 22
        21 138
        135 6
        62 17
        151 50
        152 51
        163 101
        82 12
        98 155
        137 115
        96 130
        94 166
        49 31
        35 51
        91 90
        9 101
        60 66
        30 76
        122 26
        37 2
        93 22
        2 26
        22 77
        136 117
        11 84
        86 46
        32 74
        16 162
        148 102
        71 80
        109 54
        137 67
        104 123
        43 115
        161 90
        105 134
        0 94
        41 131
        27 123
        144 57
        64 148
        16 89
        109 49
        95 120
        69 150
        37 0
        118 61
        35 142
        5 66
        121 154
        """

        self.waters="""
        0.95415 0.95415 0.18598
        0.3934 0.3934 0.125
        0.92429 0.84378 0.5
        0.37002 0.23721 0.68902
        0.63587 0.87047 0.18598
        0.36413 0.12953 0.18598
        0.35659 0.79374 0.5
        0.47526 0.09245 0.125
        0.90756 0.52475 0.125
        0.87002 0.26279 0.81098
        0.97526 0.40756 0.375
        0.50378 0.36354 0.81098
        0.94693 0.68036 0.31098
        0.8934 0.1066 0.625
        0.49622 0.63646 0.18902
        0.87047 0.63587 0.18598
        0.12953 0.36413 0.18598
        0.00498 0.77051 0.18598
        0.97526 0.40756 0.625
        0.44693 0.81964 0.81098
        0.87047 0.63587 0.81402
        0.12953 0.36413 0.81402
        0.18575 0.81425 0.31402
        0.81425 0.18575 0.31402
        0.36354 0.50378 0.18902
        0.09245 0.47526 0.875
        0.84378 0.92429 0.5
        0.13587 0.62953 0.31402
        0.54585 0.45415 0.68598
        0.42429 0.65622 0.0
        0.63587 0.87047 0.81402
        0.59245 0.02475 0.625
        0.36413 0.12953 0.81402
        0.73882 0.73882 0.0
        0.85659 0.70626 0.0
        0.02475 0.59245 0.625
        0.72754 0.89232 0.5
        0.99622 0.86354 0.31098
        0.31964 0.05308 0.31098
        0.63646 0.49622 0.18902
        0.44693 0.81964 0.18902
        0.04585 0.04585 0.81402
        0.0 0.5 0.75
        0.81964 0.44693 0.81098
        0.21081 0.05685 0.0
        0.99622 0.86354 0.68902
        0.31964 0.05308 0.68902
        0.78919 0.94315 0.0
        0.77246 0.39232 0.0
        0.59245 0.02475 0.375
        0.26118 0.26118 0.0
        0.02475 0.59245 0.375
        0.29374 0.14341 0.0
        0.65622 0.42429 0.0
        0.40756 0.97526 0.375
        0.90831 0.90831 0.0
        0.86354 0.99622 0.31098
        0.45415 0.54585 0.31402
        0.86413 0.37047 0.68598
        0.99502 0.22949 0.18598
        0.49502 0.27051 0.31402
        0.18575 0.81425 0.68598
        0.94315 0.78919 0.0
        0.81425 0.18575 0.68598
        0.55308 0.18036 0.18902
        0.70626 0.85659 0.0
        0.37002 0.23721 0.31098
        0.6066 0.6066 0.875
        0.49502 0.27051 0.68598
        0.13646 0.00378 0.31098
        0.50498 0.72949 0.31402
        0.76279 0.62998 0.68902
        0.68575 0.68575 0.81402
        0.22949 0.99502 0.18598
        0.47526 0.09245 0.875
        0.90756 0.52475 0.875
        0.52475 0.90756 0.875
        0.26279 0.87002 0.18902
        0.68575 0.68575 0.18598
        0.50378 0.36354 0.18902
        0.77742 0.69315 0.5
        0.07571 0.15622 0.5
        0.89232 0.72754 0.5
        0.1066 0.8934 0.625
        0.3934 0.3934 0.875
        0.39232 0.77246 0.0
        0.40756 0.97526 0.625
        0.26279 0.87002 0.81098
        0.77051 0.00498 0.18598
        0.09245 0.47526 0.125
        0.72949 0.50498 0.31402
        0.76279 0.62998 0.31098
        0.50498 0.72949 0.68598
        0.1066 0.8934 0.375
        0.04585 0.04585 0.18598
        0.28919 0.55685 0.5
        0.71081 0.44315 0.5
        0.00498 0.77051 0.81402
        0.19315 0.72258 0.0
        0.00378 0.13646 0.31098
        0.20626 0.64341 0.5
        0.99502 0.22949 0.81402
        0.57571 0.34378 0.0
        0.87002 0.26279 0.18902
        0.22754 0.60768 0.0
        0.10768 0.27246 0.5
        0.27051 0.49502 0.31402
        0.79374 0.35659 0.5
        0.30685 0.22258 0.5
        0.5 0.0 0.25
        0.76118 0.23882 0.5
        0.13646 0.00378 0.68902
        0.27246 0.10768 0.5
        0.80685 0.27742 0.0
        0.6066 0.6066 0.125
        0.72949 0.50498 0.68598
        0.55308 0.18036 0.81098
        0.64341 0.20626 0.5
        0.23882 0.76118 0.5
        0.68036 0.94693 0.31098
        0.40831 0.5917 0.5
        0.45415 0.54585 0.68598
        0.86354 0.99622 0.68902
        0.18036 0.55308 0.18902
        0.86413 0.37047 0.31402
        0.52475 0.90756 0.125
        0.27742 0.80685 0.0
        0.37047 0.86413 0.68598
        0.62953 0.13587 0.68598
        0.05308 0.31964 0.31098
        0.5917 0.40831 0.5
        0.95415 0.95415 0.81402
        0.62998 0.76279 0.68902
        0.23721 0.37002 0.68902
        0.22258 0.30685 0.5
        0.37047 0.86413 0.31402
        0.62953 0.13587 0.31402
        0.63646 0.49622 0.81098
        0.05308 0.31964 0.68902
        0.27051 0.49502 0.68598
        0.22949 0.99502 0.81402
        0.73721 0.12998 0.18902
        0.13587 0.62953 0.68598
        0.18036 0.55308 0.81098
        0.54585 0.45415 0.31402
        0.94693 0.68036 0.68902
        0.36354 0.50378 0.81098
        0.05685 0.21081 0.0
        0.60768 0.22754 0.0
        0.14341 0.29374 0.0
        0.15622 0.07571 0.5
        0.31425 0.31425 0.81402
        0.0 0.5 0.25
        0.73721 0.12998 0.81098
        0.49622 0.63646 0.81098
        0.12998 0.73721 0.18902
        0.77051 0.00498 0.81402
        0.72258 0.19315 0.0
        0.8934 0.1066 0.375
        0.31425 0.31425 0.18598
        0.62998 0.76279 0.31098
        0.81964 0.44693 0.18902
        0.23721 0.37002 0.31098
        0.00378 0.13646 0.68902
        0.34378 0.57571 0.0
        0.44315 0.71081 0.5
        0.0917 0.0917 0.0
        0.55685 0.28919 0.5
        0.68036 0.94693 0.68902
        0.12998 0.73721 0.81098
        0.5 0.0 0.75
        0.69315 0.77742 0.5
        """

        self.coord= "relative"

        self.cages="""
        14 0.53504 -0.12789 0.5
        15 0.10434 0.89566 1.0
        14 0.31661 0.68339 0.74391
        14 -0.62789 0.96496 1.0
        12 0.74189 0.06394 0.5
        14 -0.18339 -0.18339 0.24391
        14 0.31661 0.68339 0.25609
        12 -0.24189 -0.43606 0.0
        12 0.0 0.0 0.5
        12 0.24189 0.43606 0.0
        12 -0.43606 0.75811 1.0
        12 0.06394 0.74189 0.5
        14 -0.12789 0.53504 0.5
        14 0.18339 0.18339 0.24391
        12 0.25811 0.93606 0.5
        14 0.18339 0.18339 -0.24391
        15 -0.39566 -0.39566 0.5
        14 0.68339 0.31661 0.25609
        14 0.68339 0.31661 0.74391
        14 0.03504 0.62789 0.0
        14 1.12789 0.46496 0.5
        15 0.89566 0.10434 1.0
        14 0.62789 1.03504 0.0
        14 -0.03504 -0.62789 0.0
        12 0.5 0.5 1.0
        14 0.46496 1.12789 0.5
        14 -0.18339 -0.18339 -0.24391
        15 0.39566 0.39566 0.5
        12 0.43606 1.24189 0.0
        12 0.93606 0.25811 0.5
        """

        self.bondlen = 3


        self.cell = """
        25.11484475090604 25.11484475090604 13.102898929281368
        """

        self.density = 0.6220593382351005



        self.cell = cellvectors(a=25.11484475090604,
                           b=25.11484475090604,
                           c=13.102898929281368)
