# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (14,4,4,4,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        31 116
        27 95
        92 129
        92 127
        72 39
        40 0
        135 101
        18 24
        84 91
        134 100
        27 93
        106 41
        142 111
        142 112
        29 52
        25 69
        23 0
        17 131
        143 91
        103 138
        84 8
        17 78
        87 16
        125 133
        21 46
        56 52
        95 84
        57 53
        14 98
        88 63
        127 111
        17 106
        105 18
        82 96
        126 112
        51 45
        48 73
        68 32
        28 107
        36 24
        136 114
        143 141
        97 90
        13 87
        86 14
        102 15
        69 35
        22 123
        137 35
        64 76
        117 122
        71 140
        6 45
        80 51
        105 22
        11 73
        30 49
        52 121
        5 131
        131 6
        77 92
        0 44
        130 141
        74 54
        144 110
        33 36
        24 138
        64 147
        49 139
        40 125
        32 16
        118 95
        119 90
        129 9
        71 24
        39 22
        98 145
        4 85
        19 85
        130 79
        54 133
        50 107
        13 58
        20 30
        62 1
        27 68
        20 60
        20 61
        102 135
        110 41
        136 103
        103 134
        19 59
        5 99
        99 4
        100 6
        93 132
        68 43
        101 3
        7 97
        67 38
        21 113
        115 85
        74 3
        19 83
        48 13
        54 132
        47 14
        120 144
        68 13
        103 45
        37 12
        42 56
        2 107
        77 31
        16 23
        91 79
        10 99
        89 117
        89 36
        136 106
        147 118
        144 122
        60 33
        50 129
        86 121
        10 19
        17 140
        144 5
        12 15
        94 90
        35 145
        65 107
        75 78
        108 64
        80 139
        60 48
        57 132
        72 124
        113 23
        49 104
        146 9
        104 53
        127 29
        96 2
        114 22
        37 94
        92 2
        120 138
        139 118
        63 65
        129 81
        130 81
        80 131
        42 1
        133 7
        119 145
        66 141
        124 52
        125 53
        7 0
        18 136
        51 147
        66 23
        72 1
        75 100
        130 146
        46 66
        26 8
        49 109
        143 54
        21 102
        51 120
        119 50
        42 75
        11 44
        71 10
        28 88
        116 97
        113 79
        60 147
        34 38
        114 78
        35 94
        34 115
        47 1
        59 140
        119 31
        81 3
        69 29
        59 123
        106 76
        34 14
        88 137
        77 98
        25 2
        40 87
        128 32
        78 55
        11 57
        132 101
        30 41
        105 5
        122 58
        63 9
        137 67
        12 65
        66 116
        11 84
        61 43
        62 38
        93 91
        109 57
        112 55
        56 111
        25 98
        81 116
        113 128
        87 8
        139 122
        142 96
        39 75
        126 114
        69 65
        79 44
        76 45
        48 95
        46 94
        47 96
        82 55
        83 56
        28 47
        27 109
        43 125
        115 123
        71 76
        38 124
        117 104
        26 108
        30 64
        67 29
        80 41
        59 55
        102 90
        82 121
        58 33
        105 140
        120 33
        39 4
        124 85
        86 123
        135 128
        40 73
        126 134
        101 44
        128 93
        61 73
        18 110
        46 70
        74 37
        70 9
        34 142
        88 62
        50 15
        25 121
        32 133
        83 112
        117 43
        61 109
        62 111
        10 6
        108 104
        99 138
        146 12
        143 16
        108 36
        89 20
        72 86
        26 118
        31 70
        126 115
        100 83
        21 146
        63 127
        74 97
        89 110
        137 70
        77 67
        42 82
        135 7
        37 141
        28 145
        3 15
        134 4
        26 58
        8 53
        """

        self.waters="""
        0.0 0.69395 0.875
        0.5 0.30681 0.0
        0.17818 0.39696 0.31835
        0.17818 0.60304 0.31835
        0.6875 0.16554 0.80665
        0.5 0.06895 0.625
        0.67818 0.10304 0.31835
        0.1875 0.66554 0.80665
        0.875 0.80681 0.5
        0.82183 0.5 0.125
        0.80318 0.11542 0.5
        0.0 0.76313 0.19335
        0.5 0.5341 0.31835
        0.6875 0.83446 0.80665
        0.1875 0.33446 0.80665
        0.30318 0.55582 0.19335
        0.6875 0.7216 0.68165
        0.32183 0.10304 0.31835
        0.19683 0.05582 0.80665
        0.875 0.1932 0.5
        0.125 0.91008 0.0
        0.625 0.58992 0.0
        0.3125 0.16554 0.80665
        0.8125 0.66554 0.80665
        0.0 0.0341 0.68165
        0.30318 0.38458 0.5
        0.80318 0.88458 0.5
        0.5 0.80606 0.125
        0.375 0.41008 0.0
        0.69683 0.38458 0.5
        0.19683 0.94418 0.19335
        0.0 0.5 0.75
        0.5 0.73688 0.80665
        0.80318 0.94418 0.80665
        0.0 0.30606 0.875
        0.5 0.4659 0.68165
        0.0 0.9659 0.68165
        0.5 0.5682 0.5
        0.8125 0.33446 0.80665
        0.5 0.19395 0.875
        0.0 0.76313 0.80665
        0.32183 0.0 0.125
        0.5 0.26313 0.19335
        0.3125 0.83446 0.80665
        0.0 0.69395 0.125
        0.80318 0.05582 0.19335
        0.69683 0.55582 0.80665
        0.3125 0.34758 0.0
        0.8125 0.84758 0.0
        0.32183 0.89696 0.31835
        0.17818 0.5 0.125
        0.67818 0.0 0.125
        0.625 0.30681 0.5
        0.125 0.80681 0.5
        0.375 0.6932 0.5
        0.1875 0.2216 0.31835
        0.6875 0.2784 0.31835
        0.1875 0.7784 0.31835
        0.67818 0.89696 0.68165
        0.125 0.1932 0.5
        0.875 0.91008 0.0
        0.1875 0.84758 0.0
        0.6875 0.34758 0.0
        0.69683 0.44418 0.19335
        0.0 0.9659 0.31835
        0.5 0.4659 0.31835
        0.82183 0.60304 0.68165
        0.82183 0.39696 0.68165
        0.5 0.80606 0.875
        0.5 0.43181 0.5
        0.82183 0.5 0.875
        0.0 0.0682 0.5
        0.5 0.26313 0.80665
        0.0 0.80681 0.0
        0.30318 0.61542 0.5
        0.5 0.19395 0.125
        0.0 0.0341 0.31835
        0.0 0.43106 0.625
        0.3125 0.16554 0.19335
        0.8125 0.66554 0.19335
        0.5 0.0 0.25
        0.0 0.56895 0.375
        0.3125 0.2784 0.31835
        0.8125 0.2216 0.31835
        0.8125 0.7784 0.31835
        0.8125 0.2216 0.68165
        0.3125 0.2784 0.68165
        0.8125 0.7784 0.68165
        0.625 0.41008 0.0
        0.19683 0.94418 0.80665
        0.30318 0.55582 0.80665
        0.6875 0.7216 0.31835
        0.0 0.43106 0.375
        0.5 0.73688 0.19335
        0.5 0.5341 0.68165
        0.6875 0.83446 0.19335
        0.1875 0.33446 0.19335
        0.17818 0.60304 0.68165
        0.17818 0.39696 0.68165
        0.67818 0.10304 0.68165
        0.6875 0.16554 0.19335
        0.1875 0.66554 0.19335
        0.375 0.58992 0.0
        0.875 0.08992 0.0
        0.19683 0.88458 0.5
        0.32183 0.10304 0.68165
        0.19683 0.05582 0.19335
        0.30318 0.44418 0.19335
        0.0 0.93181 0.5
        0.3125 0.83446 0.19335
        0.32183 0.0 0.875
        0.8125 0.33446 0.19335
        0.0 0.23688 0.19335
        0.6875 0.65242 0.0
        0.1875 0.15242 0.0
        0.0 0.23688 0.80665
        0.0 0.56895 0.625
        0.32183 0.89696 0.68165
        0.67818 0.89696 0.31835
        0.17818 0.5 0.875
        0.67818 0.0 0.875
        0.375 0.30681 0.5
        0.5 0.93106 0.625
        0.1875 0.2216 0.68165
        0.6875 0.2784 0.68165
        0.1875 0.7784 0.68165
        0.0 0.1932 0.0
        0.82183 0.39696 0.31835
        0.5 0.6932 0.0
        0.0 0.5 0.25
        0.82183 0.60304 0.31835
        0.5 0.06895 0.375
        0.3125 0.7216 0.31835
        0.3125 0.7216 0.68165
        0.8125 0.15242 0.0
        0.3125 0.65242 0.0
        0.125 0.08992 0.0
        0.69683 0.44418 0.80665
        0.80318 0.05582 0.80665
        0.5 0.93106 0.375
        0.19683 0.11542 0.5
        0.69683 0.61542 0.5
        0.0 0.30606 0.125
        0.625 0.6932 0.5
        0.5 0.0 0.75
        0.30318 0.44418 0.80665
        0.69683 0.55582 0.19335
        0.80318 0.94418 0.19335
        """

        self.coord= "relative"

        self.cages="""
        14 0.2127 0.5 0.5
        16 0.5 0.18889 0.5
        12 -0.25 -0.25 0.0
        12 0.0 0.86361 -0.27339
        12 0.25 -0.25 0.0
        12 -0.5 -0.36361 0.27339
        12 0.0 0.0 0.0
        16 0.5 0.81111 0.5
        14 0.7873 0.5 0.5
        15 0.0 -0.41311 0.0
        15 0.0 0.41311 0.0
        15 0.5 0.08689 0.0
        12 1.0 0.86361 0.27339
        12 0.0 0.13639 -0.27339
        14 -0.2873 0.0 0.5
        16 0.0 -0.31111 0.5
        12 0.25 0.25 0.0
        12 -0.5 0.36361 -0.27339
        12 -0.25 0.25 0.0
        14 0.2873 0.0 0.5
        12 0.5 0.5 0.0
        12 0.0 0.13639 0.27339
        16 0.0 0.31111 0.5
        12 -0.5 -0.36361 -0.27339
        15 0.5 0.91311 0.0
        12 0.5 0.36361 0.27339
        """

        self.bondlen = 3


        self.cell = """
        13.57394342524781 42.02206158541215 13.401283360817141
        """

        self.density = 0.578713601239932



        self.cell = cellvectors(a=13.57394342524781,
                           b=42.02206158541215,
                           c=13.401283360817141)
