desc={
    "ref": {
        "PCOD8324623": "Engel 2018",
        "engel30": "Engel 2018"
    },
    "usage": "No options available.",
    "brief": "Hypothetical zeolitic ice"
}
import numpy as np
import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.cell = cellvectors(
            a=21.6701,
            b=17.0625,
            c=21.76874,
            A=90.0,
            B=119.249,
            C=90.0
        )
        self.waters = np.array([
            [-0.299160, 0.041171, 0.096847],
            [-0.715723, 0.325411, -0.486134],
            [-0.486262, 0.408274, -0.264149],
            [-0.278247, 0.075185, 0.485906],
            [-0.104076, 0.358755, 0.096843],
            [-0.513203, 0.158211, 0.264597],
            [-0.263753, 0.491943, -0.277934],
            [-0.736084, 0.241856, 0.277697],
            [0.097104, 0.449357, -0.305402],
            [-0.096700, 0.192054, 0.299581],
            [-0.131777, 0.241399, -0.138583],
            [0.131791, 0.491284, 0.138555],
            [0.139075, 0.074852, -0.499870],
            [-0.506419, 0.158144, -0.138288],
            [-0.493788, 0.408015, 0.138043],
            [-0.138395, 0.324856, 0.493289],
            [-0.701151, 0.291807, -0.097224],
            [0.103850, 0.108747, -0.097163],
            [-0.299160, 0.541172, 0.096847],
            [-0.715723, -0.174589, -0.486134],
            [-0.486262, -0.091726, -0.264149],
            [-0.278247, 0.575185, 0.485906],
            [-0.104076, -0.141245, 0.096843],
            [-0.513203, 0.658210, 0.264597],
            [-0.263753, -0.008057, -0.277934],
            [-0.736085, 0.741855, 0.277697],
            [0.097104, -0.050643, -0.305402],
            [-0.096700, 0.692056, 0.299581],
            [-0.131777, 0.741398, -0.138583],
            [0.131790, -0.008716, 0.138554],
            [0.139075, 0.574852, -0.499870],
            [-0.506419, 0.658145, -0.138288],
            [-0.493788, -0.091985, 0.138043],
            [-0.138395, -0.175144, 0.493289],
            [-0.701151, -0.208192, -0.097224],
            [0.103850, 0.608744, -0.097164],
        ])
        self.coord = 'relative'
