#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""
from setuptools import setup, find_packages

import versioneer

with open("docs/readme.rst") as readme_file:
    readme = readme_file.read()

with open("HISTORY.rst") as history_file:
    history = history_file.read()

requirements = [
    "Click>=6.0",
    "matchms==0.8.2",
    "pandas==1.1.3",
    "requests==2.24.0",
]

setup_requirements = [
    "pytest-runner",
]

test_requirements = ["pytest"]

setup(
    author="Data Revenue GmbH",
    author_email="carlos@datarevenue.com",
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
    ],
    description="A client to access Omigami",
    entry_points={
        "console_scripts": [
            "omigami_client=omigami_client.cli:main",
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + "\n\n" + history,
    include_package_data=True,
    keywords="omigami_client",
    name="omigami_client",
    packages=find_packages(include=["omigami_client"]),
    setup_requires=setup_requirements,
    test_suite="tests",
    tests_require=test_requirements,
    url="https://github.com/datarevenue-berlin/omigami_client",
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    zip_safe=False,
)
