# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ProcedureGenomics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'procedure_id': 'str',
        'hard_hash': 'str',
        'binary_id': 'str',
        'start_ea': 'str',
        'end_ea': 'str',
        'procedure_name': 'str',
        'segment_name': 'str',
        'is_library': 'bool',
        'is_thunk': 'bool',
        'strings': 'list[str]',
        'api_calls': 'list[str]',
        'cfg': 'ControlFlowGraph',
        'block_count': 'int',
        'code_count': 'int',
        'semantics_count': 'int',
        'blocks': 'list[BlockGenomics]'
    }

    attribute_map = {
        'procedure_id': 'procedure_id',
        'hard_hash': 'hard_hash',
        'binary_id': 'binary_id',
        'start_ea': 'startEA',
        'end_ea': 'endEA',
        'procedure_name': 'procedure_name',
        'segment_name': 'segment_name',
        'is_library': 'is_library',
        'is_thunk': 'is_thunk',
        'strings': 'strings',
        'api_calls': 'api_calls',
        'cfg': 'cfg',
        'block_count': 'block_count',
        'code_count': 'code_count',
        'semantics_count': 'semantics_count',
        'blocks': 'blocks'
    }

    def __init__(self, procedure_id=None, hard_hash=None, binary_id=None, start_ea=None, end_ea=None, procedure_name=None, segment_name=None, is_library=None, is_thunk=None, strings=None, api_calls=None, cfg=None, block_count=None, code_count=None, semantics_count=None, blocks=None):  # noqa: E501
        """ProcedureGenomics - a model defined in Swagger"""  # noqa: E501

        self._procedure_id = None
        self._hard_hash = None
        self._binary_id = None
        self._start_ea = None
        self._end_ea = None
        self._procedure_name = None
        self._segment_name = None
        self._is_library = None
        self._is_thunk = None
        self._strings = None
        self._api_calls = None
        self._cfg = None
        self._block_count = None
        self._code_count = None
        self._semantics_count = None
        self._blocks = None
        self.discriminator = None

        if procedure_id is not None:
            self.procedure_id = procedure_id
        if hard_hash is not None:
            self.hard_hash = hard_hash
        if binary_id is not None:
            self.binary_id = binary_id
        if start_ea is not None:
            self.start_ea = start_ea
        if end_ea is not None:
            self.end_ea = end_ea
        if procedure_name is not None:
            self.procedure_name = procedure_name
        if segment_name is not None:
            self.segment_name = segment_name
        if is_library is not None:
            self.is_library = is_library
        if is_thunk is not None:
            self.is_thunk = is_thunk
        if strings is not None:
            self.strings = strings
        if api_calls is not None:
            self.api_calls = api_calls
        if cfg is not None:
            self.cfg = cfg
        if block_count is not None:
            self.block_count = block_count
        if code_count is not None:
            self.code_count = code_count
        if semantics_count is not None:
            self.semantics_count = semantics_count
        if blocks is not None:
            self.blocks = blocks

    @property
    def procedure_id(self):
        """Gets the procedure_id of this ProcedureGenomics.  # noqa: E501

        {binary_id}/{startEA}  # noqa: E501

        :return: The procedure_id of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._procedure_id

    @procedure_id.setter
    def procedure_id(self, procedure_id):
        """Sets the procedure_id of this ProcedureGenomics.

        {binary_id}/{startEA}  # noqa: E501

        :param procedure_id: The procedure_id of this ProcedureGenomics.  # noqa: E501
        :type: str
        """

        self._procedure_id = procedure_id

    @property
    def hard_hash(self):
        """Gets the hard_hash of this ProcedureGenomics.  # noqa: E501

        Hard hash of the blocks hard_hashes. Also called the proc_hash.  # noqa: E501

        :return: The hard_hash of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._hard_hash

    @hard_hash.setter
    def hard_hash(self, hard_hash):
        """Sets the hard_hash of this ProcedureGenomics.

        Hard hash of the blocks hard_hashes. Also called the proc_hash.  # noqa: E501

        :param hard_hash: The hard_hash of this ProcedureGenomics.  # noqa: E501
        :type: str
        """

        self._hard_hash = hard_hash

    @property
    def binary_id(self):
        """Gets the binary_id of this ProcedureGenomics.  # noqa: E501

        SHA1 of the binary this procedure is in  # noqa: E501

        :return: The binary_id of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._binary_id

    @binary_id.setter
    def binary_id(self, binary_id):
        """Sets the binary_id of this ProcedureGenomics.

        SHA1 of the binary this procedure is in  # noqa: E501

        :param binary_id: The binary_id of this ProcedureGenomics.  # noqa: E501
        :type: str
        """

        self._binary_id = binary_id

    @property
    def start_ea(self):
        """Gets the start_ea of this ProcedureGenomics.  # noqa: E501

        A memory address (usually an RVA).  # noqa: E501

        :return: The start_ea of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._start_ea

    @start_ea.setter
    def start_ea(self, start_ea):
        """Sets the start_ea of this ProcedureGenomics.

        A memory address (usually an RVA).  # noqa: E501

        :param start_ea: The start_ea of this ProcedureGenomics.  # noqa: E501
        :type: str
        """
        if start_ea is not None and not re.search(r'0x[a-fA-F0-9]+', start_ea):  # noqa: E501
            raise ValueError(r"Invalid value for `start_ea`, must be a follow pattern or equal to `/0x[a-fA-F0-9]+/`")  # noqa: E501

        self._start_ea = start_ea

    @property
    def end_ea(self):
        """Gets the end_ea of this ProcedureGenomics.  # noqa: E501

        A memory address (usually an RVA).  # noqa: E501

        :return: The end_ea of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._end_ea

    @end_ea.setter
    def end_ea(self, end_ea):
        """Sets the end_ea of this ProcedureGenomics.

        A memory address (usually an RVA).  # noqa: E501

        :param end_ea: The end_ea of this ProcedureGenomics.  # noqa: E501
        :type: str
        """
        if end_ea is not None and not re.search(r'0x[a-fA-F0-9]+', end_ea):  # noqa: E501
            raise ValueError(r"Invalid value for `end_ea`, must be a follow pattern or equal to `/0x[a-fA-F0-9]+/`")  # noqa: E501

        self._end_ea = end_ea

    @property
    def procedure_name(self):
        """Gets the procedure_name of this ProcedureGenomics.  # noqa: E501


        :return: The procedure_name of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._procedure_name

    @procedure_name.setter
    def procedure_name(self, procedure_name):
        """Sets the procedure_name of this ProcedureGenomics.


        :param procedure_name: The procedure_name of this ProcedureGenomics.  # noqa: E501
        :type: str
        """

        self._procedure_name = procedure_name

    @property
    def segment_name(self):
        """Gets the segment_name of this ProcedureGenomics.  # noqa: E501

        The PE segment the procedure appeared in.  # noqa: E501

        :return: The segment_name of this ProcedureGenomics.  # noqa: E501
        :rtype: str
        """
        return self._segment_name

    @segment_name.setter
    def segment_name(self, segment_name):
        """Sets the segment_name of this ProcedureGenomics.

        The PE segment the procedure appeared in.  # noqa: E501

        :param segment_name: The segment_name of this ProcedureGenomics.  # noqa: E501
        :type: str
        """

        self._segment_name = segment_name

    @property
    def is_library(self):
        """Gets the is_library of this ProcedureGenomics.  # noqa: E501

        Was this procedure detected as a well-known library function?  # noqa: E501

        :return: The is_library of this ProcedureGenomics.  # noqa: E501
        :rtype: bool
        """
        return self._is_library

    @is_library.setter
    def is_library(self, is_library):
        """Sets the is_library of this ProcedureGenomics.

        Was this procedure detected as a well-known library function?  # noqa: E501

        :param is_library: The is_library of this ProcedureGenomics.  # noqa: E501
        :type: bool
        """

        self._is_library = is_library

    @property
    def is_thunk(self):
        """Gets the is_thunk of this ProcedureGenomics.  # noqa: E501

        Was this procedure detected as a thunk (jump) function?  # noqa: E501

        :return: The is_thunk of this ProcedureGenomics.  # noqa: E501
        :rtype: bool
        """
        return self._is_thunk

    @is_thunk.setter
    def is_thunk(self, is_thunk):
        """Sets the is_thunk of this ProcedureGenomics.

        Was this procedure detected as a thunk (jump) function?  # noqa: E501

        :param is_thunk: The is_thunk of this ProcedureGenomics.  # noqa: E501
        :type: bool
        """

        self._is_thunk = is_thunk

    @property
    def strings(self):
        """Gets the strings of this ProcedureGenomics.  # noqa: E501

        List of strings found in *this* procedure.  # noqa: E501

        :return: The strings of this ProcedureGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._strings

    @strings.setter
    def strings(self, strings):
        """Sets the strings of this ProcedureGenomics.

        List of strings found in *this* procedure.  # noqa: E501

        :param strings: The strings of this ProcedureGenomics.  # noqa: E501
        :type: list[str]
        """

        self._strings = strings

    @property
    def api_calls(self):
        """Gets the api_calls of this ProcedureGenomics.  # noqa: E501

        List of api calls made by *this* procedure.  # noqa: E501

        :return: The api_calls of this ProcedureGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._api_calls

    @api_calls.setter
    def api_calls(self, api_calls):
        """Sets the api_calls of this ProcedureGenomics.

        List of api calls made by *this* procedure.  # noqa: E501

        :param api_calls: The api_calls of this ProcedureGenomics.  # noqa: E501
        :type: list[str]
        """

        self._api_calls = api_calls

    @property
    def cfg(self):
        """Gets the cfg of this ProcedureGenomics.  # noqa: E501


        :return: The cfg of this ProcedureGenomics.  # noqa: E501
        :rtype: ControlFlowGraph
        """
        return self._cfg

    @cfg.setter
    def cfg(self, cfg):
        """Sets the cfg of this ProcedureGenomics.


        :param cfg: The cfg of this ProcedureGenomics.  # noqa: E501
        :type: ControlFlowGraph
        """

        self._cfg = cfg

    @property
    def block_count(self):
        """Gets the block_count of this ProcedureGenomics.  # noqa: E501

        Number of blocks in the procedure.  # noqa: E501

        :return: The block_count of this ProcedureGenomics.  # noqa: E501
        :rtype: int
        """
        return self._block_count

    @block_count.setter
    def block_count(self, block_count):
        """Sets the block_count of this ProcedureGenomics.

        Number of blocks in the procedure.  # noqa: E501

        :param block_count: The block_count of this ProcedureGenomics.  # noqa: E501
        :type: int
        """

        self._block_count = block_count

    @property
    def code_count(self):
        """Gets the code_count of this ProcedureGenomics.  # noqa: E501

        Number of disassembly instructions in this procedure. The `gen_code` count is equal to the  `code_count` and so not included seperately.  # noqa: E501

        :return: The code_count of this ProcedureGenomics.  # noqa: E501
        :rtype: int
        """
        return self._code_count

    @code_count.setter
    def code_count(self, code_count):
        """Sets the code_count of this ProcedureGenomics.

        Number of disassembly instructions in this procedure. The `gen_code` count is equal to the  `code_count` and so not included seperately.  # noqa: E501

        :param code_count: The code_count of this ProcedureGenomics.  # noqa: E501
        :type: int
        """

        self._code_count = code_count

    @property
    def semantics_count(self):
        """Gets the semantics_count of this ProcedureGenomics.  # noqa: E501

        Number of semantic instructions in this procedure. The `gen_semantics` count is equal to the `semantics_count` and so not included separately.  # noqa: E501

        :return: The semantics_count of this ProcedureGenomics.  # noqa: E501
        :rtype: int
        """
        return self._semantics_count

    @semantics_count.setter
    def semantics_count(self, semantics_count):
        """Sets the semantics_count of this ProcedureGenomics.

        Number of semantic instructions in this procedure. The `gen_semantics` count is equal to the `semantics_count` and so not included separately.  # noqa: E501

        :param semantics_count: The semantics_count of this ProcedureGenomics.  # noqa: E501
        :type: int
        """

        self._semantics_count = semantics_count

    @property
    def blocks(self):
        """Gets the blocks of this ProcedureGenomics.  # noqa: E501

        The blocks contained within the procedure. Blocks are ordered by `block.startEA`.   # noqa: E501

        :return: The blocks of this ProcedureGenomics.  # noqa: E501
        :rtype: list[BlockGenomics]
        """
        return self._blocks

    @blocks.setter
    def blocks(self, blocks):
        """Sets the blocks of this ProcedureGenomics.

        The blocks contained within the procedure. Blocks are ordered by `block.startEA`.   # noqa: E501

        :param blocks: The blocks of this ProcedureGenomics.  # noqa: E501
        :type: list[BlockGenomics]
        """

        self._blocks = blocks

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProcedureGenomics, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcedureGenomics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
