# Generated by Django 4.0.3 on 2022-08-18 13:55

import django.db.models.deletion
from django.db import migrations, models
from django.db.migrations.operations.models import ModelOptionOperation


def move_data(apps, schema_editor):
    db_alias = schema_editor.connection.alias

    app_name = "obapi"
    text_model_fields = ("text_html", "text_plain", "word_count")
    models_and_fields = {
        "OBContentItem": text_model_fields,
        "EssayContentItem": text_model_fields,
        "SpotifyContentItem": ("listen_count", "duration"),
        "YoutubeContentItem": ("view_count", "duration"),
    }

    for model_name, model_fields in models_and_fields.items():
        ContentModel = apps.get_model(app_name, model_name)
        for item in ContentModel.objects.all():
            for field_name in model_fields:
                setattr(item, field_name, getattr(item, f"{field_name}_tmp"))
            item.save(using=db_alias)


class ChangeModelBase(ModelOptionOperation):
    def __init__(self, name, new_bases=(models.Model,)):
        super().__init__(name)
        self.new_bases = new_bases

    def deconstruct(self):
        kwargs = {"name": self.name, "new_bases": self.new_bases}
        return (self.__class__.__qualname__, [], kwargs)

    def state_forwards(self, app_label, state):
        model_state = state.models[app_label, self.name_lower]
        model_state.bases = self.new_bases
        state.reload_model(app_label, self.name_lower, delay=True)

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        pass

    def database_backwards(self, app_label, schema_editor, from_state, to_state):
        pass

    def describe(self):
        return "Change bases for model %s" % self.name

    @property
    def migration_name_fragment(self):
        return "remove_%s_bases" % self.name_lower


class Migration(migrations.Migration):

    dependencies = [
        ("obapi", "0006_alter_sequence_options"),
    ]

    operations = [
        migrations.RenameField(
            model_name="textcontentitem",
            old_name="text_html",
            new_name="text_html_tmp",
        ),
        migrations.RenameField(
            model_name="textcontentitem",
            old_name="text_plain",
            new_name="text_plain_tmp",
        ),
        migrations.RenameField(
            model_name="textcontentitem",
            old_name="word_count",
            new_name="word_count_tmp",
        ),
        migrations.RenameField(
            model_name="audiocontentitem",
            old_name="duration",
            new_name="duration_tmp",
        ),
        migrations.RenameField(
            model_name="audiocontentitem",
            old_name="listen_count",
            new_name="listen_count_tmp",
        ),
        migrations.RenameField(
            model_name="videocontentitem",
            old_name="duration",
            new_name="duration_tmp",
        ),
        migrations.RenameField(
            model_name="videocontentitem",
            old_name="view_count",
            new_name="view_count_tmp",
        ),
        migrations.AddField(
            model_name="essaycontentitem",
            name="text_html",
            field=models.TextField(
                blank=True,
                help_text="Content text HTML.",
                verbose_name="content text HTML",
            ),
        ),
        migrations.AddField(
            model_name="essaycontentitem",
            name="text_plain",
            field=models.TextField(
                blank=True,
                help_text="Content plaintext.",
                verbose_name="content plaintext",
            ),
        ),
        migrations.AddField(
            model_name="essaycontentitem",
            name="word_count",
            field=models.PositiveIntegerField(
                blank=True, help_text="Word count.", null=True
            ),
        ),
        migrations.AddField(
            model_name="obcontentitem",
            name="text_html",
            field=models.TextField(
                blank=True,
                help_text="Content text HTML.",
                verbose_name="content text HTML",
            ),
        ),
        migrations.AddField(
            model_name="obcontentitem",
            name="text_plain",
            field=models.TextField(
                blank=True,
                help_text="Content plaintext.",
                verbose_name="content plaintext",
            ),
        ),
        migrations.AddField(
            model_name="obcontentitem",
            name="word_count",
            field=models.PositiveIntegerField(
                blank=True, help_text="Word count.", null=True
            ),
        ),
        migrations.AddField(
            model_name="spotifycontentitem",
            name="duration",
            field=models.DurationField(
                blank=True, help_text="Duration of episode.", null=True
            ),
        ),
        migrations.AddField(
            model_name="spotifycontentitem",
            name="listen_count",
            field=models.PositiveIntegerField(
                blank=True, help_text="Number of episode listens.", null=True
            ),
        ),
        migrations.AddField(
            model_name="youtubecontentitem",
            name="duration",
            field=models.DurationField(
                blank=True, help_text="Duration of video.", null=True
            ),
        ),
        migrations.AddField(
            model_name="youtubecontentitem",
            name="view_count",
            field=models.PositiveIntegerField(
                blank=True, help_text="Number of video views.", null=True
            ),
        ),
        migrations.RunPython(move_data, migrations.RunPython.noop),
        ChangeModelBase("OBContentItem", (models.Model,)),
        ChangeModelBase("EssayContentItem", (models.Model,)),
        ChangeModelBase("SpotifyContentItem", (models.Model,)),
        ChangeModelBase("YoutubeContentItem", (models.Model,)),
        migrations.RenameField(
            model_name="essaycontentitem",
            old_name="textcontentitem_ptr",
            new_name="contentitem_ptr",
        ),
        migrations.RenameField(
            model_name="obcontentitem",
            old_name="textcontentitem_ptr",
            new_name="contentitem_ptr",
        ),
        migrations.RenameField(
            model_name="spotifycontentitem",
            old_name="audiocontentitem_ptr",
            new_name="contentitem_ptr",
        ),
        migrations.RenameField(
            model_name="youtubecontentitem",
            old_name="videocontentitem_ptr",
            new_name="contentitem_ptr",
        ),
        migrations.AlterField(
            model_name="essaycontentitem",
            name="contentitem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="obapi.contentitem",
            ),
        ),
        migrations.AlterField(
            model_name="obcontentitem",
            name="contentitem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="obapi.contentitem",
            ),
        ),
        migrations.AlterField(
            model_name="spotifycontentitem",
            name="contentitem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="obapi.contentitem",
            ),
        ),
        migrations.AlterField(
            model_name="youtubecontentitem",
            name="contentitem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="obapi.contentitem",
            ),
        ),
        ChangeModelBase("OBContentItem", ("obapi.contentitem",)),
        ChangeModelBase("EssayContentItem", ("obapi.contentitem",)),
        ChangeModelBase("SpotifyContentItem", ("obapi.contentitem",)),
        ChangeModelBase("YoutubeContentItem", ("obapi.contentitem",)),
        migrations.DeleteModel(
            name="TextContentItem",
        ),
        migrations.DeleteModel(
            name="AudioContentItem",
        ),
        migrations.DeleteModel(
            name="VideoContentItem",
        ),
    ]
