**pydaily - Python Daily Utilities**
============
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/8e2dbb9defe6410793beed44f22783d2)](https://app.codacy.com/app/PingjunChen/pydaily?utm_source=github.com&utm_medium=referral&utm_content=PingjunChen/pydaily&utm_campaign=Badge_Grade_Dashboard)
[![codecov](https://codecov.io/gh/PingjunChen/pydaily/branch/master/graph/badge.svg)](https://codecov.io/gh/PingjunChen/pydaily)
[![CircleCI](https://circleci.com/gh/PingjunChen/pydaily.svg?style=svg)](https://circleci.com/gh/PingjunChen/pydaily)
[![Documentation Status](https://readthedocs.org/projects/pydaily/badge/?version=latest)](https://pydaily.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/pydaily.svg)](https://badge.fury.io/py/pydaily)
[![Conda install](https://anaconda.org/conda-forge/pydaily/badges/installer/conda.svg)](https://anaconda.org/conda-forge/pydaily)
[![Downloads](https://pepy.tech/badge/pydaily)](https://pepy.tech/project/pydaily)
![](https://img.shields.io/github/stars/PingjunChen/pydaily.svg)

<a href="https://www.buymeacoffee.com/3yEjAQG" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>

Motivation
------------
We wrote lots of codes with the same or nearly the same functionalities daily. Although writing these codes is trivial, but it takes time and affect the mood. Sometimes we even need to use Google or stackoverflow because of bad memory. Here I put the codes that we almost need to use everyday to avoid reinvent the wheels. The codes here help reduce my coding burden, so that I can focus on core functionalities. Please consider `star` if you benefit from this repo.


Installation
------------
- Using pip:
```alpha
pip install pydaily==0.4.3
```
- Using conda:
```alpha
conda install -c conda-forge pydaily
```

Functionalities
------------

#### IO-filesystem
- finding all files with given extension
- directory overwriting, creating, etc
- batch renaming files

#### FORMAT-format
- dict to csv, h5, json, pickle, etc
- list to txt  

#### MTM-medical text mining
- tokenize text

#### LOG-log
- logging message to file

#### TIC-time
- calculating elapsed time
- getting current time


Documentation
------------
Hosted in [https://pydaily.readthedocs.io](https://pydaily.readthedocs.io), powered by [readthedocs](https://readthedocs.org) and
[Sphinx](http://www.sphinx-doc.org).


Contributing
------------
``pydaily`` is an open source project and anyone is welcome to contribute. An easy way to get started is by suggesting a new enhancement on the [Issues](https://github.com/PingjunChen/pydaily/issues). If you have found a bug, then either report this through [Issues](https://github.com/PingjunChen/pydaily/issues), or even better, make a fork of the repository, fix the bug and then create a [Pull Request](https://github.com/PingjunChen/pydaily/pulls) to get the fix into the master branch.


License
------------
``pydaily`` is free software made available under the Apache License. For details see the [LICENSE](LICENSE) file.
