# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class View(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'created_at': 'str',
        'creator_email': 'str',
        'description': 'str',
        'entities': 'list[str]',
        'modified_at': 'str',
        'name': 'str',
        'owner_email': 'str',
        'path': 'str',
        'query_sql': 'str',
        'state': 'str',
        'workspace': 'str'
    }

    attribute_map = {
        'created_at': 'created_at',
        'creator_email': 'creator_email',
        'description': 'description',
        'entities': 'entities',
        'modified_at': 'modified_at',
        'name': 'name',
        'owner_email': 'owner_email',
        'path': 'path',
        'query_sql': 'query_sql',
        'state': 'state',
        'workspace': 'workspace'
    }

    def __init__(self, created_at=None, creator_email=None, description=None, entities=None, modified_at=None, name=None, owner_email=None, path=None, query_sql=None, state=None, workspace=None, local_vars_configuration=None):  # noqa: E501
        """View - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._created_at = None
        self._creator_email = None
        self._description = None
        self._entities = None
        self._modified_at = None
        self._name = None
        self._owner_email = None
        self._path = None
        self._query_sql = None
        self._state = None
        self._workspace = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if creator_email is not None:
            self.creator_email = creator_email
        if description is not None:
            self.description = description
        if entities is not None:
            self.entities = entities
        if modified_at is not None:
            self.modified_at = modified_at
        if name is not None:
            self.name = name
        if owner_email is not None:
            self.owner_email = owner_email
        if path is not None:
            self.path = path
        if query_sql is not None:
            self.query_sql = query_sql
        if state is not None:
            self.state = state
        if workspace is not None:
            self.workspace = workspace

    @property
    def created_at(self):
        """Gets the created_at of this View.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The created_at of this View.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this View.

        ISO-8601 date  # noqa: E501

        :param created_at: The created_at of this View.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def creator_email(self):
        """Gets the creator_email of this View.  # noqa: E501

        email of the creator  # noqa: E501

        :return: The creator_email of this View.  # noqa: E501
        :rtype: str
        """
        return self._creator_email

    @creator_email.setter
    def creator_email(self, creator_email):
        """Sets the creator_email of this View.

        email of the creator  # noqa: E501

        :param creator_email: The creator_email of this View.  # noqa: E501
        :type creator_email: str
        """

        self._creator_email = creator_email

    @property
    def description(self):
        """Gets the description of this View.  # noqa: E501

        view description  # noqa: E501

        :return: The description of this View.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this View.

        view description  # noqa: E501

        :param description: The description of this View.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entities(self):
        """Gets the entities of this View.  # noqa: E501

        list of entities referenced by view. An entity can be a view, alias or collection  # noqa: E501

        :return: The entities of this View.  # noqa: E501
        :rtype: list[str]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """Sets the entities of this View.

        list of entities referenced by view. An entity can be a view, alias or collection  # noqa: E501

        :param entities: The entities of this View.  # noqa: E501
        :type entities: list[str]
        """

        self._entities = entities

    @property
    def modified_at(self):
        """Gets the modified_at of this View.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The modified_at of this View.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this View.

        ISO-8601 date  # noqa: E501

        :param modified_at: The modified_at of this View.  # noqa: E501
        :type modified_at: str
        """

        self._modified_at = modified_at

    @property
    def name(self):
        """Gets the name of this View.  # noqa: E501

        name of the view  # noqa: E501

        :return: The name of this View.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this View.

        name of the view  # noqa: E501

        :param name: The name of this View.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def owner_email(self):
        """Gets the owner_email of this View.  # noqa: E501

        email of the owner  # noqa: E501

        :return: The owner_email of this View.  # noqa: E501
        :rtype: str
        """
        return self._owner_email

    @owner_email.setter
    def owner_email(self, owner_email):
        """Sets the owner_email of this View.

        email of the owner  # noqa: E501

        :param owner_email: The owner_email of this View.  # noqa: E501
        :type owner_email: str
        """

        self._owner_email = owner_email

    @property
    def path(self):
        """Gets the path of this View.  # noqa: E501


        :return: The path of this View.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this View.


        :param path: The path of this View.  # noqa: E501
        :type path: str
        """

        self._path = path

    @property
    def query_sql(self):
        """Gets the query_sql of this View.  # noqa: E501

        SQL query of the view  # noqa: E501

        :return: The query_sql of this View.  # noqa: E501
        :rtype: str
        """
        return self._query_sql

    @query_sql.setter
    def query_sql(self, query_sql):
        """Sets the query_sql of this View.

        SQL query of the view  # noqa: E501

        :param query_sql: The query_sql of this View.  # noqa: E501
        :type query_sql: str
        """

        self._query_sql = query_sql

    @property
    def state(self):
        """Gets the state of this View.  # noqa: E501

        state of the view  # noqa: E501

        :return: The state of this View.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this View.

        state of the view  # noqa: E501

        :param state: The state of this View.  # noqa: E501
        :type state: str
        """
        allowed_values = ["CREATED", "SYNCING", "DELETED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def workspace(self):
        """Gets the workspace of this View.  # noqa: E501

        name of the workspace  # noqa: E501

        :return: The workspace of this View.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this View.

        name of the workspace  # noqa: E501

        :param workspace: The workspace of this View.  # noqa: E501
        :type workspace: str
        """

        self._workspace = workspace

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, View):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, View):
            return True

        return self.to_dict() != other.to_dict()
