# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class StatusDynamoDb(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'scan_end_time': 'str',
        'scan_records_processed': 'int',
        'scan_start_time': 'str',
        'scan_total_records': 'int',
        'state': 'str',
        'stream_last_processed_at': 'str'
    }

    attribute_map = {
        'scan_end_time': 'scan_end_time',
        'scan_records_processed': 'scan_records_processed',
        'scan_start_time': 'scan_start_time',
        'scan_total_records': 'scan_total_records',
        'state': 'state',
        'stream_last_processed_at': 'stream_last_processed_at'
    }

    def __init__(self, scan_end_time=None, scan_records_processed=None, scan_start_time=None, scan_total_records=None, state=None, stream_last_processed_at=None, local_vars_configuration=None):  # noqa: E501
        """StatusDynamoDb - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._scan_end_time = None
        self._scan_records_processed = None
        self._scan_start_time = None
        self._scan_total_records = None
        self._state = None
        self._stream_last_processed_at = None
        self.discriminator = None

        if scan_end_time is not None:
            self.scan_end_time = scan_end_time
        if scan_records_processed is not None:
            self.scan_records_processed = scan_records_processed
        if scan_start_time is not None:
            self.scan_start_time = scan_start_time
        if scan_total_records is not None:
            self.scan_total_records = scan_total_records
        if state is not None:
            self.state = state
        if stream_last_processed_at is not None:
            self.stream_last_processed_at = stream_last_processed_at

    @property
    def scan_end_time(self):
        """Gets the scan_end_time of this StatusDynamoDb.  # noqa: E501

        DynamoDb scan end time  # noqa: E501

        :return: The scan_end_time of this StatusDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._scan_end_time

    @scan_end_time.setter
    def scan_end_time(self, scan_end_time):
        """Sets the scan_end_time of this StatusDynamoDb.

        DynamoDb scan end time  # noqa: E501

        :param scan_end_time: The scan_end_time of this StatusDynamoDb.  # noqa: E501
        :type scan_end_time: str
        """

        self._scan_end_time = scan_end_time

    @property
    def scan_records_processed(self):
        """Gets the scan_records_processed of this StatusDynamoDb.  # noqa: E501

        Number of records inserted using scan  # noqa: E501

        :return: The scan_records_processed of this StatusDynamoDb.  # noqa: E501
        :rtype: int
        """
        return self._scan_records_processed

    @scan_records_processed.setter
    def scan_records_processed(self, scan_records_processed):
        """Sets the scan_records_processed of this StatusDynamoDb.

        Number of records inserted using scan  # noqa: E501

        :param scan_records_processed: The scan_records_processed of this StatusDynamoDb.  # noqa: E501
        :type scan_records_processed: int
        """

        self._scan_records_processed = scan_records_processed

    @property
    def scan_start_time(self):
        """Gets the scan_start_time of this StatusDynamoDb.  # noqa: E501

        DynamoDB scan start time  # noqa: E501

        :return: The scan_start_time of this StatusDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._scan_start_time

    @scan_start_time.setter
    def scan_start_time(self, scan_start_time):
        """Sets the scan_start_time of this StatusDynamoDb.

        DynamoDB scan start time  # noqa: E501

        :param scan_start_time: The scan_start_time of this StatusDynamoDb.  # noqa: E501
        :type scan_start_time: str
        """

        self._scan_start_time = scan_start_time

    @property
    def scan_total_records(self):
        """Gets the scan_total_records of this StatusDynamoDb.  # noqa: E501

        Number of records in DynamoDB table at time of scan  # noqa: E501

        :return: The scan_total_records of this StatusDynamoDb.  # noqa: E501
        :rtype: int
        """
        return self._scan_total_records

    @scan_total_records.setter
    def scan_total_records(self, scan_total_records):
        """Sets the scan_total_records of this StatusDynamoDb.

        Number of records in DynamoDB table at time of scan  # noqa: E501

        :param scan_total_records: The scan_total_records of this StatusDynamoDb.  # noqa: E501
        :type scan_total_records: int
        """

        self._scan_total_records = scan_total_records

    @property
    def state(self):
        """Gets the state of this StatusDynamoDb.  # noqa: E501

        state of current ingest for this table  # noqa: E501

        :return: The state of this StatusDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this StatusDynamoDb.

        state of current ingest for this table  # noqa: E501

        :param state: The state of this StatusDynamoDb.  # noqa: E501
        :type state: str
        """
        allowed_values = ["INITIALIZING", "SCANNING_TABLE", "PROCESSING_STREAM"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def stream_last_processed_at(self):
        """Gets the stream_last_processed_at of this StatusDynamoDb.  # noqa: E501

        ISO-8601 date when source was last processed  # noqa: E501

        :return: The stream_last_processed_at of this StatusDynamoDb.  # noqa: E501
        :rtype: str
        """
        return self._stream_last_processed_at

    @stream_last_processed_at.setter
    def stream_last_processed_at(self, stream_last_processed_at):
        """Sets the stream_last_processed_at of this StatusDynamoDb.

        ISO-8601 date when source was last processed  # noqa: E501

        :param stream_last_processed_at: The stream_last_processed_at of this StatusDynamoDb.  # noqa: E501
        :type stream_last_processed_at: str
        """

        self._stream_last_processed_at = stream_last_processed_at

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusDynamoDb):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatusDynamoDb):
            return True

        return self.to_dict() != other.to_dict()
