# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class QueryLambda(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collections': 'list[str]',
        'last_updated': 'str',
        'last_updated_by': 'str',
        'latest_version': 'QueryLambdaVersion',
        'name': 'str',
        'version_count': 'int',
        'workspace': 'str'
    }

    attribute_map = {
        'collections': 'collections',
        'last_updated': 'last_updated',
        'last_updated_by': 'last_updated_by',
        'latest_version': 'latest_version',
        'name': 'name',
        'version_count': 'version_count',
        'workspace': 'workspace'
    }

    def __init__(self, collections=None, last_updated=None, last_updated_by=None, latest_version=None, name=None, version_count=None, workspace=None, local_vars_configuration=None):  # noqa: E501
        """QueryLambda - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._collections = None
        self._last_updated = None
        self._last_updated_by = None
        self._latest_version = None
        self._name = None
        self._version_count = None
        self._workspace = None
        self.discriminator = None

        if collections is not None:
            self.collections = collections
        if last_updated is not None:
            self.last_updated = last_updated
        if last_updated_by is not None:
            self.last_updated_by = last_updated_by
        if latest_version is not None:
            self.latest_version = latest_version
        if name is not None:
            self.name = name
        if version_count is not None:
            self.version_count = version_count
        if workspace is not None:
            self.workspace = workspace

    @property
    def collections(self):
        """Gets the collections of this QueryLambda.  # noqa: E501

        collections/aliases queried by underlying SQL query  # noqa: E501

        :return: The collections of this QueryLambda.  # noqa: E501
        :rtype: list[str]
        """
        return self._collections

    @collections.setter
    def collections(self, collections):
        """Sets the collections of this QueryLambda.

        collections/aliases queried by underlying SQL query  # noqa: E501

        :param collections: The collections of this QueryLambda.  # noqa: E501
        :type collections: list[str]
        """

        self._collections = collections

    @property
    def last_updated(self):
        """Gets the last_updated of this QueryLambda.  # noqa: E501

        ISO-8601 date of when Query Lambda was last updated  # noqa: E501

        :return: The last_updated of this QueryLambda.  # noqa: E501
        :rtype: str
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this QueryLambda.

        ISO-8601 date of when Query Lambda was last updated  # noqa: E501

        :param last_updated: The last_updated of this QueryLambda.  # noqa: E501
        :type last_updated: str
        """

        self._last_updated = last_updated

    @property
    def last_updated_by(self):
        """Gets the last_updated_by of this QueryLambda.  # noqa: E501

        user that created this Query Lambda  # noqa: E501

        :return: The last_updated_by of this QueryLambda.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """Sets the last_updated_by of this QueryLambda.

        user that created this Query Lambda  # noqa: E501

        :param last_updated_by: The last_updated_by of this QueryLambda.  # noqa: E501
        :type last_updated_by: str
        """

        self._last_updated_by = last_updated_by

    @property
    def latest_version(self):
        """Gets the latest_version of this QueryLambda.  # noqa: E501


        :return: The latest_version of this QueryLambda.  # noqa: E501
        :rtype: QueryLambdaVersion
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """Sets the latest_version of this QueryLambda.


        :param latest_version: The latest_version of this QueryLambda.  # noqa: E501
        :type latest_version: QueryLambdaVersion
        """

        self._latest_version = latest_version

    @property
    def name(self):
        """Gets the name of this QueryLambda.  # noqa: E501

        Query Lambda name  # noqa: E501

        :return: The name of this QueryLambda.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QueryLambda.

        Query Lambda name  # noqa: E501

        :param name: The name of this QueryLambda.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def version_count(self):
        """Gets the version_count of this QueryLambda.  # noqa: E501

        number of Query Lambda versions  # noqa: E501

        :return: The version_count of this QueryLambda.  # noqa: E501
        :rtype: int
        """
        return self._version_count

    @version_count.setter
    def version_count(self, version_count):
        """Sets the version_count of this QueryLambda.

        number of Query Lambda versions  # noqa: E501

        :param version_count: The version_count of this QueryLambda.  # noqa: E501
        :type version_count: int
        """

        self._version_count = version_count

    @property
    def workspace(self):
        """Gets the workspace of this QueryLambda.  # noqa: E501

        workspace of this Query Lambda  # noqa: E501

        :return: The workspace of this QueryLambda.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this QueryLambda.

        workspace of this Query Lambda  # noqa: E501

        :param workspace: The workspace of this QueryLambda.  # noqa: E501
        :type workspace: str
        """

        self._workspace = workspace

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryLambda):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryLambda):
            return True

        return self.to_dict() != other.to_dict()
