# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class InvertedIndexGroupEncodingOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'doc_id_codec': 'str',
        'event_time_codec': 'str',
        'format_version': 'int',
        'group_size': 'int',
        'restart_length': 'int'
    }

    attribute_map = {
        'doc_id_codec': 'doc_id_codec',
        'event_time_codec': 'event_time_codec',
        'format_version': 'format_version',
        'group_size': 'group_size',
        'restart_length': 'restart_length'
    }

    def __init__(self, doc_id_codec=None, event_time_codec=None, format_version=None, group_size=None, restart_length=None, local_vars_configuration=None):  # noqa: E501
        """InvertedIndexGroupEncodingOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._doc_id_codec = None
        self._event_time_codec = None
        self._format_version = None
        self._group_size = None
        self._restart_length = None
        self.discriminator = None

        if doc_id_codec is not None:
            self.doc_id_codec = doc_id_codec
        if event_time_codec is not None:
            self.event_time_codec = event_time_codec
        if format_version is not None:
            self.format_version = format_version
        if group_size is not None:
            self.group_size = group_size
        if restart_length is not None:
            self.restart_length = restart_length

    @property
    def doc_id_codec(self):
        """Gets the doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: str
        """
        return self._doc_id_codec

    @doc_id_codec.setter
    def doc_id_codec(self, doc_id_codec):
        """Sets the doc_id_codec of this InvertedIndexGroupEncodingOptions.


        :param doc_id_codec: The doc_id_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type doc_id_codec: str
        """

        self._doc_id_codec = doc_id_codec

    @property
    def event_time_codec(self):
        """Gets the event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: str
        """
        return self._event_time_codec

    @event_time_codec.setter
    def event_time_codec(self, event_time_codec):
        """Sets the event_time_codec of this InvertedIndexGroupEncodingOptions.


        :param event_time_codec: The event_time_codec of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type event_time_codec: str
        """

        self._event_time_codec = event_time_codec

    @property
    def format_version(self):
        """Gets the format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._format_version

    @format_version.setter
    def format_version(self, format_version):
        """Sets the format_version of this InvertedIndexGroupEncodingOptions.


        :param format_version: The format_version of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type format_version: int
        """

        self._format_version = format_version

    @property
    def group_size(self):
        """Gets the group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._group_size

    @group_size.setter
    def group_size(self, group_size):
        """Sets the group_size of this InvertedIndexGroupEncodingOptions.


        :param group_size: The group_size of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type group_size: int
        """

        self._group_size = group_size

    @property
    def restart_length(self):
        """Gets the restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501


        :return: The restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :rtype: int
        """
        return self._restart_length

    @restart_length.setter
    def restart_length(self, restart_length):
        """Sets the restart_length of this InvertedIndexGroupEncodingOptions.


        :param restart_length: The restart_length of this InvertedIndexGroupEncodingOptions.  # noqa: E501
        :type restart_length: int
        """

        self._restart_length = restart_length

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvertedIndexGroupEncodingOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InvertedIndexGroupEncodingOptions):
            return True

        return self.to_dict() != other.to_dict()
