# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class FieldOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'column_index_mode': 'str',
        'index_mode': 'str',
        'range_index_mode': 'str',
        'type_index_mode': 'str'
    }

    attribute_map = {
        'column_index_mode': 'column_index_mode',
        'index_mode': 'index_mode',
        'range_index_mode': 'range_index_mode',
        'type_index_mode': 'type_index_mode'
    }

    def __init__(self, column_index_mode=None, index_mode=None, range_index_mode=None, type_index_mode=None, local_vars_configuration=None):  # noqa: E501
        """FieldOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._column_index_mode = None
        self._index_mode = None
        self._range_index_mode = None
        self._type_index_mode = None
        self.discriminator = None

        if column_index_mode is not None:
            self.column_index_mode = column_index_mode
        if index_mode is not None:
            self.index_mode = index_mode
        if range_index_mode is not None:
            self.range_index_mode = range_index_mode
        if type_index_mode is not None:
            self.type_index_mode = type_index_mode

    @property
    def column_index_mode(self):
        """Gets the column_index_mode of this FieldOptions.  # noqa: E501

         store or no_store  # noqa: E501

        :return: The column_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._column_index_mode

    @column_index_mode.setter
    def column_index_mode(self, column_index_mode):
        """Sets the column_index_mode of this FieldOptions.

         store or no_store  # noqa: E501

        :param column_index_mode: The column_index_mode of this FieldOptions.  # noqa: E501
        :type column_index_mode: str
        """

        self._column_index_mode = column_index_mode

    @property
    def index_mode(self):
        """Gets the index_mode of this FieldOptions.  # noqa: E501

         index or no_index  # noqa: E501

        :return: The index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._index_mode

    @index_mode.setter
    def index_mode(self, index_mode):
        """Sets the index_mode of this FieldOptions.

         index or no_index  # noqa: E501

        :param index_mode: The index_mode of this FieldOptions.  # noqa: E501
        :type index_mode: str
        """

        self._index_mode = index_mode

    @property
    def range_index_mode(self):
        """Gets the range_index_mode of this FieldOptions.  # noqa: E501

         v1_index or no_index  # noqa: E501

        :return: The range_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._range_index_mode

    @range_index_mode.setter
    def range_index_mode(self, range_index_mode):
        """Sets the range_index_mode of this FieldOptions.

         v1_index or no_index  # noqa: E501

        :param range_index_mode: The range_index_mode of this FieldOptions.  # noqa: E501
        :type range_index_mode: str
        """

        self._range_index_mode = range_index_mode

    @property
    def type_index_mode(self):
        """Gets the type_index_mode of this FieldOptions.  # noqa: E501

         index or no_index  # noqa: E501

        :return: The type_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._type_index_mode

    @type_index_mode.setter
    def type_index_mode(self, type_index_mode):
        """Sets the type_index_mode of this FieldOptions.

         index or no_index  # noqa: E501

        :param type_index_mode: The type_index_mode of this FieldOptions.  # noqa: E501
        :type type_index_mode: str
        """

        self._type_index_mode = type_index_mode

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FieldOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FieldOptions):
            return True

        return self.to_dict() != other.to_dict()
