# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class ErrorModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'column': 'int',
        'error_id': 'str',
        'line': 'int',
        'message': 'str',
        'query_id': 'str',
        'trace_id': 'str',
        'type': 'str'
    }

    attribute_map = {
        'column': 'column',
        'error_id': 'error_id',
        'line': 'line',
        'message': 'message',
        'query_id': 'query_id',
        'trace_id': 'trace_id',
        'type': 'type'
    }

    def __init__(self, column=None, error_id=None, line=None, message=None, query_id=None, trace_id=None, type=None, local_vars_configuration=None):  # noqa: E501
        """ErrorModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._column = None
        self._error_id = None
        self._line = None
        self._message = None
        self._query_id = None
        self._trace_id = None
        self._type = None
        self.discriminator = None

        if column is not None:
            self.column = column
        if error_id is not None:
            self.error_id = error_id
        if line is not None:
            self.line = line
        if message is not None:
            self.message = message
        if query_id is not None:
            self.query_id = query_id
        if trace_id is not None:
            self.trace_id = trace_id
        if type is not None:
            self.type = type

    @property
    def column(self):
        """Gets the column of this ErrorModel.  # noqa: E501

        Column where the error happened (if applicable)  # noqa: E501

        :return: The column of this ErrorModel.  # noqa: E501
        :rtype: int
        """
        return self._column

    @column.setter
    def column(self, column):
        """Sets the column of this ErrorModel.

        Column where the error happened (if applicable)  # noqa: E501

        :param column: The column of this ErrorModel.  # noqa: E501
        :type column: int
        """

        self._column = column

    @property
    def error_id(self):
        """Gets the error_id of this ErrorModel.  # noqa: E501

        ID of the error  # noqa: E501

        :return: The error_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._error_id

    @error_id.setter
    def error_id(self, error_id):
        """Sets the error_id of this ErrorModel.

        ID of the error  # noqa: E501

        :param error_id: The error_id of this ErrorModel.  # noqa: E501
        :type error_id: str
        """

        self._error_id = error_id

    @property
    def line(self):
        """Gets the line of this ErrorModel.  # noqa: E501

        Line where the error happened (if applicable)  # noqa: E501

        :return: The line of this ErrorModel.  # noqa: E501
        :rtype: int
        """
        return self._line

    @line.setter
    def line(self, line):
        """Sets the line of this ErrorModel.

        Line where the error happened (if applicable)  # noqa: E501

        :param line: The line of this ErrorModel.  # noqa: E501
        :type line: int
        """

        self._line = line

    @property
    def message(self):
        """Gets the message of this ErrorModel.  # noqa: E501

        descriptive message about the error  # noqa: E501

        :return: The message of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ErrorModel.

        descriptive message about the error  # noqa: E501

        :param message: The message of this ErrorModel.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def query_id(self):
        """Gets the query_id of this ErrorModel.  # noqa: E501

        ID of the query (if applicable)  # noqa: E501

        :return: The query_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """Sets the query_id of this ErrorModel.

        ID of the query (if applicable)  # noqa: E501

        :param query_id: The query_id of this ErrorModel.  # noqa: E501
        :type query_id: str
        """

        self._query_id = query_id

    @property
    def trace_id(self):
        """Gets the trace_id of this ErrorModel.  # noqa: E501

        Internal trace ID to help with debugging  # noqa: E501

        :return: The trace_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._trace_id

    @trace_id.setter
    def trace_id(self, trace_id):
        """Sets the trace_id of this ErrorModel.

        Internal trace ID to help with debugging  # noqa: E501

        :param trace_id: The trace_id of this ErrorModel.  # noqa: E501
        :type trace_id: str
        """

        self._trace_id = trace_id

    @property
    def type(self):
        """Gets the type of this ErrorModel.  # noqa: E501

        category of the error  # noqa: E501

        :return: The type of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ErrorModel.

        category of the error  # noqa: E501

        :param type: The type of this ErrorModel.  # noqa: E501
        :type type: str
        """
        allowed_values = ["AUTHEXCEPTION", "VERSIONEXCEPTION", "INTERNALERROR", "INVALIDINPUT", "NOTIMPLEMENTEDYET", "RESOURCEEXCEEDED", "ALREADYEXISTS", "NOTALLOWED", "NOTACCEPTABLE", "NOTSUPPORTED", "NOTFOUND", "DEPENDENTRESOURCES", "QUERY_ERROR", "NOT_READY", "FORBIDDEN", "QUERY_TIMEOUT", "ROLE_NOT_FOUND", "CONNECTION_ERROR", "CREATING", "BADREQUEST", "SERVICEUNAVAILABLE", "RATELIMITEXCEEDED", "QUERY_CANCELLED", "CLIENT_CONNECTION_ERROR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ErrorModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ErrorModel):
            return True

        return self.to_dict() != other.to_dict()
