# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class Cluster(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'apiserver_url': 'str',
        'aws_region': 'str',
        'cluster_type': 'str',
        'domain': 'str',
        'id': 'str',
        'top_level_domain': 'str'
    }

    attribute_map = {
        'apiserver_url': 'apiserver_url',
        'aws_region': 'aws_region',
        'cluster_type': 'cluster_type',
        'domain': 'domain',
        'id': 'id',
        'top_level_domain': 'top_level_domain'
    }

    def __init__(self, apiserver_url=None, aws_region=None, cluster_type=None, domain=None, id=None, top_level_domain=None, local_vars_configuration=None):  # noqa: E501
        """Cluster - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._apiserver_url = None
        self._aws_region = None
        self._cluster_type = None
        self._domain = None
        self._id = None
        self._top_level_domain = None
        self.discriminator = None

        if apiserver_url is not None:
            self.apiserver_url = apiserver_url
        if aws_region is not None:
            self.aws_region = aws_region
        if cluster_type is not None:
            self.cluster_type = cluster_type
        if domain is not None:
            self.domain = domain
        if id is not None:
            self.id = id
        if top_level_domain is not None:
            self.top_level_domain = top_level_domain

    @property
    def apiserver_url(self):
        """Gets the apiserver_url of this Cluster.  # noqa: E501

        api server url for cluster  # noqa: E501

        :return: The apiserver_url of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._apiserver_url

    @apiserver_url.setter
    def apiserver_url(self, apiserver_url):
        """Sets the apiserver_url of this Cluster.

        api server url for cluster  # noqa: E501

        :param apiserver_url: The apiserver_url of this Cluster.  # noqa: E501
        :type apiserver_url: str
        """

        self._apiserver_url = apiserver_url

    @property
    def aws_region(self):
        """Gets the aws_region of this Cluster.  # noqa: E501

        aws region  # noqa: E501

        :return: The aws_region of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this Cluster.

        aws region  # noqa: E501

        :param aws_region: The aws_region of this Cluster.  # noqa: E501
        :type aws_region: str
        """

        self._aws_region = aws_region

    @property
    def cluster_type(self):
        """Gets the cluster_type of this Cluster.  # noqa: E501

        cluster type  # noqa: E501

        :return: The cluster_type of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """Sets the cluster_type of this Cluster.

        cluster type  # noqa: E501

        :param cluster_type: The cluster_type of this Cluster.  # noqa: E501
        :type cluster_type: str
        """
        allowed_values = ["PUBLIC", "PRIVATE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and cluster_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `cluster_type` ({0}), must be one of {1}"  # noqa: E501
                .format(cluster_type, allowed_values)
            )

        self._cluster_type = cluster_type

    @property
    def domain(self):
        """Gets the domain of this Cluster.  # noqa: E501

        domain of org using cluster  # noqa: E501

        :return: The domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this Cluster.

        domain of org using cluster  # noqa: E501

        :param domain: The domain of this Cluster.  # noqa: E501
        :type domain: str
        """

        self._domain = domain

    @property
    def id(self):
        """Gets the id of this Cluster.  # noqa: E501

        unique identifier for the cluster  # noqa: E501

        :return: The id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Cluster.

        unique identifier for the cluster  # noqa: E501

        :param id: The id of this Cluster.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def top_level_domain(self):
        """Gets the top_level_domain of this Cluster.  # noqa: E501

        top level domain of org using cluster  # noqa: E501

        :return: The top_level_domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._top_level_domain

    @top_level_domain.setter
    def top_level_domain(self, top_level_domain):
        """Sets the top_level_domain of this Cluster.

        top level domain of org using cluster  # noqa: E501

        :param top_level_domain: The top_level_domain of this Cluster.  # noqa: E501
        :type top_level_domain: str
        """

        self._top_level_domain = top_level_domain

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Cluster):
            return True

        return self.to_dict() != other.to_dict()
