# Generated by Django 2.2.19 on 2021-02-25 12:41

import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inspire_eu', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ApplicationSchema',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=32)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=32)),
                ('link', models.URLField()),
                ('version', models.SmallIntegerField(blank=True, default=0)),
                ('label', models.CharField(max_length=128)),
                ('definition', models.TextField(blank=True)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'verbose_name': 'Application Schema',
                'verbose_name_plural': 'Application Schemes',
                'ordering': ['code', 'label'],
            },
        ),
        migrations.CreateModel(
            name='Building',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.CharField(help_text='A local identifier, assigned by the data provider. The local identifier is unique within the namespace, that is no other spatial object carries the same unique identifier.<br />NOTE It is the responsibility of the data provider to guarantee uniqueness of the local identifier within the namespace.', max_length=32)),
                ('version_id', models.CharField(blank=True, help_text='The identifier of the particular version of the spatial object, with a maximum length of 25 characters. If the specification of a spatial object type with an external object identifier includes life-cycle information, the version identifier is used to distinguish between the different versions of a spatial object. Within the set of all versions of a spatial object, the version identifier is unique.<br />NOTE The maximum length has been selected to allow for time stamps based on ISO 8601, for example, "2007-02-12T12:12:12+05:30" as the version identifier.<br />NOTE 2 The property is void, if the spatial data set does not distinguish between different versions of the spatial object. It is missing, if the spatial object type does not support any life-cycle information.', max_length=25)),
                ('begin_lifespan_version', models.DateTimeField(help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.')),
                ('end_lifespan_version', models.DateTimeField(blank=True, help_text='Date and time at which this version of the spatial object was superseded or retired in the spatial data set.', null=True)),
                ('date_of_construction_beginning', models.DateTimeField(blank=True, help_text='Beginning date of construction', null=True)),
                ('date_of_construction_end', models.DateTimeField(blank=True, help_text='End of date of construction', null=True)),
                ('date_of_construction_any_point', models.DateTimeField(blank=True, help_text='Any point of date of construction', null=True)),
                ('date_of_demolition_beginning', models.DateTimeField(blank=True, help_text='Beginning date of demolition', null=True)),
                ('date_of_demolition_end', models.DateTimeField(blank=True, help_text='End of date of demolition', null=True)),
                ('date_of_demolition_any_point', models.DateTimeField(blank=True, help_text='Any point of date of demolition', null=True)),
                ('date_of_renovation_beginning', models.DateTimeField(blank=True, help_text='Beginning date of last major renovation', null=True)),
                ('date_of_renovation_end', models.DateTimeField(blank=True, help_text='End of date of last major renovation', null=True)),
                ('date_of_renovation_any_point', models.DateTimeField(blank=True, help_text='Any point of date of last major renovation', null=True)),
                ('number_of_dwellings', models.SmallIntegerField(blank=True, help_text='A dwelling is a residential unit which may consist of one or several rooms designed for the occupation of households.<br />NOTE: In the data sets including building units, a dwelling is a residential building unit or, only when that building has no building units, a residential building<br />EXAMPLES: a single building dwelling could be a detached or semi-detached house. A block of flats will contain multiple dwellings determined by the number of individual flats.', null=True)),
                ('number_of_building_units', models.SmallIntegerField(blank=True, help_text='Number of building units in the building. A BuildingUnit is a subdivision of Building with its own lockable access from the outside or from a common area (i.e. not from another BuildingUnit), which is atomic, functionally independent, and may be separately sold, rented out, inherited, etc.<br />Building units are spatial objects aimed at subdividing buildings and/or building parts into smaller parts that are treated as separate entities in daily life. A building unit is homogeneous, regarding management aspects.<br />EXAMPLES: It may be e.g. an apartment in a condominium, a terraced house, or a shop inside a shopping arcade.<br />NOTE 1: According to national regulations, a building unit may be a flat, a cellar, a garage or set of a flat, a cellar and a garage.<br />NOTE 2: According to national regulation, a building that is one entity for daily life (typically, a single family house) may be considered as a Building composed of one BuildingUnit or as a Building composed of zero BuildingUnit.', null=True)),
                ('number_of_floors_above_ground', models.SmallIntegerField(blank=True, help_text='Number of floors above ground.', null=True)),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, help_text='2D or 2.5D geometric representation', null=True, srid=4326)),
                ('reference_geometry', models.BooleanField(help_text='The geometry to be taken into account by view services, for portrayal.<br />NOTE 1: In case of multiple representation by point and by surface, it is generally recommended to provide the surface as reference geometry.<br />NOTE 2: The geometric representation whose referenceGeometry is true may also be used preferably for spatial queries by download services (WFS) or by Geographical Information System (GIS).')),
                ('horizontal_geometry_estimated_accuracy', models.FloatField(blank=True, help_text='The estimated absolute positional accuracy of the (X,Y) coordinates of the building geometry, in the INSPIRE official Coordinate Reference System. Absolute positional accuracy is defined as the mean value of the positional uncertainties for a set of positions where the positional uncertainties are defined as the distance between a measured position and what is considered as the corresponding true position.<br />NOTE: This mean value may come from quality measures on a homogeneous population of buildings or from an estimation based on the knowledge of the production processes and of their accuracy.')),
                ('vertical_geometry_estimated_accuracy', models.CharField(blank=True, help_text='Value of estimatedAccuracy shall be given in meters', max_length=1)),
                ('height_below_ground', models.FloatField(blank=True, null=True)),
                ('number_of_floors_below_ground', models.SmallIntegerField(blank=True, help_text='Number of floors below ground.', null=True)),
                ('is_building_part', models.BooleanField(default=False, help_text='Is it a BuildingPart?')),
            ],
            options={
                'verbose_name': 'Building',
                'verbose_name_plural': 'Buildings',
            },
        ),
        migrations.CreateModel(
            name='CadastralParcel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.CharField(help_text='A local identifier, assigned by the data provider. The local identifier is unique within the namespace, that is no other spatial object carries the same unique identifier.<br />NOTE It is the responsibility of the data provider to guarantee uniqueness of the local identifier within the namespace.', max_length=32)),
                ('version_id', models.CharField(blank=True, help_text='The identifier of the particular version of the spatial object, with a maximum length of 25 characters. If the specification of a spatial object type with an external object identifier includes life-cycle information, the version identifier is used to distinguish between the different versions of a spatial object. Within the set of all versions of a spatial object, the version identifier is unique.<br />NOTE The maximum length has been selected to allow for time stamps based on ISO 8601, for example, "2007-02-12T12:12:12+05:30" as the version identifier.<br />NOTE 2 The property is void, if the spatial data set does not distinguish between different versions of the spatial object. It is missing, if the spatial object type does not support any life-cycle information.', max_length=25)),
                ('begin_lifespan_version', models.DateTimeField(help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.')),
                ('end_lifespan_version', models.DateTimeField(blank=True, help_text='Date and time at which this version of the spatial object was superseded or retired in the spatial data set.', null=True)),
                ('label', models.CharField(blank=True, help_text='Text commonly used to display the cadastral parcel identification.', max_length=32)),
                ('national_cadastal_reference', models.CharField(db_index=True, help_text='Thematic identifier at national level, generally the full national code of the cadastral parcel. Must ensure the link to the national cadastral register or equivalent.', max_length=32)),
                ('area_value', models.IntegerField(blank=True, help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.', null=True)),
                ('valid_from', models.DateTimeField(blank=True, help_text='Official date and time the cadastral parcel was/will be legally established.', null=True)),
                ('valid_to', models.DateTimeField(blank=True, help_text='Date and time at which the cadastral parcel legally ceased/will cease to be used.', null=True)),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, help_text='Geometry of the cadastral parcel.', null=True, srid=4326)),
                ('reference_point', django.contrib.gis.db.models.fields.PointField(blank=True, help_text='A point within the cadastral parcel. EXAMPLE The centroid of the cadastral parcel geometry.', null=True, srid=4326)),
            ],
            options={
                'verbose_name': 'Cadastral Parcel',
                'verbose_name_plural': 'Cadastral Parcels',
            },
        ),
        migrations.CreateModel(
            name='CodeList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=64)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=64)),
                ('link', models.URLField(blank=True)),
                ('label', models.CharField(max_length=128)),
                ('definition', models.TextField(blank=True)),
                ('description', models.TextField(blank=True)),
                ('application_schema', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.ApplicationSchema')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.CodeList')),
            ],
            options={
                'verbose_name': 'Code list',
                'verbose_name_plural': 'Code lists',
                'ordering': ['code', 'label'],
            },
        ),
        migrations.CreateModel(
            name='CodeListValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=96)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=96)),
                ('link', models.URLField()),
                ('label', models.CharField(max_length=200)),
                ('definition', models.TextField(blank=True)),
                ('description', models.TextField(blank=True)),
                ('code_list', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.CodeList')),
            ],
            options={
                'verbose_name': 'Code list value',
                'verbose_name_plural': 'Code list values',
                'ordering': ['code_list__code', 'code', 'label'],
            },
        ),
        migrations.CreateModel(
            name='Namespace',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(help_text='Namespace', max_length=32)),
                ('name', models.CharField(blank=True, max_length=64)),
            ],
            options={
                'verbose_name': 'Namespace',
                'verbose_name_plural': 'Namespaces',
                'ordering': ['code', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=32)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=32)),
                ('label', models.CharField(max_length=128)),
                ('definition', models.TextField(blank=True)),
                ('link', models.URLField()),
                ('is_valid', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Status',
                'verbose_name_plural': 'Status',
                'ordering': ['is_valid', 'label'],
            },
        ),
        migrations.CreateModel(
            name='UnitOfMeasure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='The name(s) of a particular unit of measure. Examples would include the following: 1) for uomArea - square feet <br />2) for uomTime - seconds <br />3) for uomArea - miles<br />4) uomAngle - degrees.', max_length=32)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=32)),
                ('symbol', models.CharField(help_text='The symbol used for this unit of measure, such at "ft" for feet, or "m" for meter.', max_length=8)),
                ('measure_type', models.CharField(choices=[('', 'Unknown'), ('area', 'Area'), ('length', 'Length'), ('angle', 'Angle'), ('time', 'Time'), ('velocity', 'Velocity'), ('volume', 'Volume'), ('scale', 'Scale'), ('weight', 'Weight')], help_text='Measure Type', max_length=8)),
                ('name_standard_unit', models.CharField(blank=True, help_text='Name of the standard units to which this unit of measure can be directly converted. If this variable is NULL, then the standard unit for this measure type given by the local copy of the StandardsUnits code list.', max_length=8)),
                ('scale_to_standard_unit', models.FloatField(blank=True, help_text='If the implementation system used for this object does not support NULL, the  scale set to 0 is equivalent to NULL for both scale and offset.<br />If X is the current unit, and S is the standard one the of two variables scale(ToStandardUnit) and offset(ToStandardUnit) can be used to make the conversion from X to S by:<br />S = offset + scale*X <br />and, conversely, <br />X = (S-offset)/scale', null=True)),
                ('offset_to_standard_unit', models.FloatField(blank=True, help_text='See scaleToStandardUnit for a description. Again, this variable is NULL is no linear conversion is possible. If the two units are only a scale in difference, then this number is zero (0). If the implementation system used for this object does not support NULL, the then scale set to 0 is equivalent to NULL for both scale and offset.', null=True)),
                ('formula', models.CharField(blank=True, help_text='An algebraic formula (probably in some programming language) converting this unit of measure (represented in the formula by its uomSymbol) to the ISO standard (represented by its symbol. This member attribute is not required, but it is a valuable piece of documentation. ', max_length=32)),
            ],
            options={
                'verbose_name': 'Unit Of Measure',
                'verbose_name_plural': 'Units Of Measure',
                'ordering': ['symbol', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Theme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=32)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=32)),
                ('link', models.URLField()),
                ('version', models.SmallIntegerField(blank=True, default=0)),
                ('label', models.CharField(max_length=128)),
                ('definition', models.TextField(blank=True)),
                ('description', models.TextField(blank=True)),
                ('status', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Status')),
            ],
            options={
                'verbose_name': 'Theme',
                'verbose_name_plural': 'Themes',
                'ordering': ['code', 'label'],
            },
        ),
        migrations.CreateModel(
            name='OtherConstruction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.CharField(help_text='A local identifier, assigned by the data provider. The local identifier is unique within the namespace, that is no other spatial object carries the same unique identifier.<br />NOTE It is the responsibility of the data provider to guarantee uniqueness of the local identifier within the namespace.', max_length=32)),
                ('version_id', models.CharField(blank=True, help_text='The identifier of the particular version of the spatial object, with a maximum length of 25 characters. If the specification of a spatial object type with an external object identifier includes life-cycle information, the version identifier is used to distinguish between the different versions of a spatial object. Within the set of all versions of a spatial object, the version identifier is unique.<br />NOTE The maximum length has been selected to allow for time stamps based on ISO 8601, for example, "2007-02-12T12:12:12+05:30" as the version identifier.<br />NOTE 2 The property is void, if the spatial data set does not distinguish between different versions of the spatial object. It is missing, if the spatial object type does not support any life-cycle information.', max_length=25)),
                ('begin_lifespan_version', models.DateTimeField(help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.')),
                ('end_lifespan_version', models.DateTimeField(blank=True, help_text='Date and time at which this version of the spatial object was superseded or retired in the spatial data set.', null=True)),
                ('date_of_construction_beginning', models.DateTimeField(blank=True, help_text='Beginning date of construction', null=True)),
                ('date_of_construction_end', models.DateTimeField(blank=True, help_text='End of date of construction', null=True)),
                ('date_of_construction_any_point', models.DateTimeField(blank=True, help_text='Any point of date of construction', null=True)),
                ('date_of_demolition_beginning', models.DateTimeField(blank=True, help_text='Beginning date of demolition', null=True)),
                ('date_of_demolition_end', models.DateTimeField(blank=True, help_text='End of date of demolition', null=True)),
                ('date_of_demolition_any_point', models.DateTimeField(blank=True, help_text='Any point of date of demolition', null=True)),
                ('date_of_renovation_beginning', models.DateTimeField(blank=True, help_text='Beginning date of last major renovation', null=True)),
                ('date_of_renovation_end', models.DateTimeField(blank=True, help_text='End of date of last major renovation', null=True)),
                ('date_of_renovation_any_point', models.DateTimeField(blank=True, help_text='Any point of date of last major renovation', null=True)),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, help_text='2D or 2.5D geometric representation', null=True, srid=4326)),
                ('building', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('cadastral_parcels', models.ManyToManyField(to='inspire_eu.CadastralParcel')),
                ('condition_of_construction', models.ForeignKey(help_text='Status of the construction.<br />EXAMPLES: functional, projected, ruin', limit_choices_to={'code_list__code': 'ConditionOfConstructionValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_otherconstruction_condition_of_construction', related_query_name='inspire_eu_otherconstruction_condition_of_constructions', to='inspire_eu.CodeListValue')),
                ('namespace', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_otherconstruction_namespace', related_query_name='inspire_eu_otherconstruction_namespaces', to='inspire_eu.Namespace')),
                ('other_construction_nature', models.ForeignKey(blank=True, help_text='Characteristic of the building that makes it generally of interest for mappings applications. The characteristic may be related to the physical aspect and/or to the function of the building.<br />This attribute focuses on the physical aspect of the building; however, this physical aspect is often expressed as a function (e.g. stadium, silo, windmill); this attribute aims to fulfil mainly mapping purposes and addresses only specific, noticeable buildings. ', limit_choices_to={'code_list__code': 'OtherConstructionNatureValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_otherconstruction_other_construction_nature', related_query_name='inspire_eu_otherconstruction_other_construction_natures', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Other Construction',
                'verbose_name_plural': 'Other Constructions',
            },
        ),
        migrations.AddField(
            model_name='codelistvalue',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Status'),
        ),
        migrations.AddField(
            model_name='codelist',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Status'),
        ),
        migrations.AddField(
            model_name='codelist',
            name='themes',
            field=models.ManyToManyField(to='inspire_eu.Theme'),
        ),
        migrations.CreateModel(
            name='CadastralZoning',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.CharField(help_text='A local identifier, assigned by the data provider. The local identifier is unique within the namespace, that is no other spatial object carries the same unique identifier.<br />NOTE It is the responsibility of the data provider to guarantee uniqueness of the local identifier within the namespace.', max_length=32)),
                ('version_id', models.CharField(blank=True, help_text='The identifier of the particular version of the spatial object, with a maximum length of 25 characters. If the specification of a spatial object type with an external object identifier includes life-cycle information, the version identifier is used to distinguish between the different versions of a spatial object. Within the set of all versions of a spatial object, the version identifier is unique.<br />NOTE The maximum length has been selected to allow for time stamps based on ISO 8601, for example, "2007-02-12T12:12:12+05:30" as the version identifier.<br />NOTE 2 The property is void, if the spatial data set does not distinguish between different versions of the spatial object. It is missing, if the spatial object type does not support any life-cycle information.', max_length=25)),
                ('begin_lifespan_version', models.DateTimeField(help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.')),
                ('end_lifespan_version', models.DateTimeField(blank=True, help_text='Date and time at which this version of the spatial object was superseded or retired in the spatial data set.', null=True)),
                ('estimated_accuracy', models.FloatField(blank=True, help_text='The estimated absolute positional accuracy of cadastral parcels within the cadastral zoning in the used INSPIRE coordinate reference system. Absolute positional accuracy is the mean value of the positional uncertainties for a set of positions, where the positional uncertainties are the distance between a measured position and what is considered as the corresponding true position.')),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, help_text='Geometry of the cadastral zoning.', null=True, srid=4326)),
                ('label', models.CharField(blank=True, help_text='Text commonly used to display the cadastral zoning identification.', max_length=32)),
                ('name', models.CharField(blank=True, help_text='Name of the cadastral zoning.', max_length=24)),
                ('national_cadastal_zoning_reference', models.CharField(blank=True, help_text='Text commonly used to display the cadastral zoning identification.', max_length=32)),
                ('area_value', models.IntegerField(blank=True, help_text='Registered area value giving quantification of the area projected on the horizontal plane of the cadastral parcel.', null=True)),
                ('original_map_scale_denominator', models.SmallIntegerField(blank=True, help_text='The denominator in the scale of the original paper map (if any) to whose extent the cadastral zoning corresponds.', null=True)),
                ('valid_from', models.DateTimeField(blank=True, help_text='Official date and time the cadastral zoning was/will be legally established.', null=True)),
                ('valid_to', models.DateTimeField(blank=True, help_text='Date and time at which the cadastral zoning legally ceased/will cease to be used.', null=True)),
                ('reference_point', django.contrib.gis.db.models.fields.PointField(blank=True, help_text='A point within the cadastral zoning. EXAMPLE The centroid of the cadastral zoneing geometry.', null=True, srid=4326)),
                ('area_value_uom', models.ForeignKey(blank=True, limit_choices_to={'measure_type': 'area'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralzoning_area_value_uom', related_query_name='inspire_eu_cadastralzoning_area_value_uoms', to='inspire_eu.UnitOfMeasure')),
                ('estimated_accuracy_uom', models.ForeignKey(blank=True, help_text='Value of estimatedAccuracy shall be given in meters', limit_choices_to={'measure_type': 'area'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralzoning_estimated_accuracy_uom', related_query_name='inspire_eu_cadastralzoning_estimated_accuracy_uoms', to='inspire_eu.UnitOfMeasure')),
                ('level', models.ForeignKey(blank=True, help_text='Level of the cadastral zoning in the national cadastral hierarchy.', limit_choices_to={'code_list__code': 'LevelValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralzoning_level', related_query_name='inspire_eu_cadastralzoning_levels', to='inspire_eu.CodeListValue')),
                ('namespace', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralzoning_namespace', related_query_name='inspire_eu_cadastralzoning_namespaces', to='inspire_eu.Namespace')),
                ('upper_level_unit', models.ForeignKey(blank=True, help_text='Level of the cadastral zoning in the national cadastral hierarchy.', null=True, on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.CadastralZoning')),
            ],
            options={
                'verbose_name': 'Cadastral Zoning',
                'verbose_name_plural': 'Cadastral Zonings',
            },
        ),
        migrations.AddField(
            model_name='cadastralparcel',
            name='area_value_uom',
            field=models.ForeignKey(blank=True, limit_choices_to={'measure_type': 'area'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralparcel_area_value_uom', related_query_name='inspire_eu_cadastralparcel_area_value_uoms', to='inspire_eu.UnitOfMeasure'),
        ),
        migrations.AddField(
            model_name='cadastralparcel',
            name='cadastral_zoning',
            field=models.ForeignKey(blank=True, help_text='Cadastral Zoning', null=True, on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.CadastralZoning'),
        ),
        migrations.AddField(
            model_name='cadastralparcel',
            name='namespace',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_cadastralparcel_namespace', related_query_name='inspire_eu_cadastralparcel_namespaces', to='inspire_eu.Namespace'),
        ),
        migrations.CreateModel(
            name='BuildingNature',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('nature', models.ForeignKey(help_text='Characteristic of the building that makes it generally of interest for mappings applications. The characteristic may be related to the physical aspect and/or to the function of the building.<br />This attribute focuses on the physical aspect of the building; however, this physical aspect is often expressed as a function (e.g. stadium, silo, windmill); this attribute aims to fulfil mainly mapping purposes and addresses only specific, noticeable buildings.', limit_choices_to={'code_list__code': 'BuildingNatureValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingnature_nature', related_query_name='inspire_eu_buildingnature_natures', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Building Nature',
                'verbose_name_plural': 'Building Natures',
                'ordering': ['building', 'nature'],
            },
        ),
        migrations.CreateModel(
            name='BuildingHeightAboveGround',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.SmallIntegerField(help_text='Value of the height above ground')),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('height_reference', models.ForeignKey(help_text='Element used as the high reference.<br />EXAMPLE: The height of the building has been captured up to the top of building.', limit_choices_to={'code_list__code': 'ElevationReferenceValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingheightaboveground_height_reference', related_query_name='inspire_eu_buildingheightaboveground_height_references', to='inspire_eu.CodeListValue')),
                ('low_reference', models.ForeignKey(help_text='Element as the low reference.<br />EXAMPLE: The height of the building has been captured from its the lowest ground point.', limit_choices_to={'code_list__code': 'ElevationReferenceValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingheightaboveground_low_reference', related_query_name='inspire_eu_buildingheightaboveground_low_references', to='inspire_eu.CodeListValue')),
                ('status', models.ForeignKey(help_text='The way the height has been captured.', limit_choices_to={'code_list__code': 'HeightStatusValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingheightaboveground_height_status', related_query_name='inspire_eu_buildingheightaboveground_s_height_statuss', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Building Height Above Ground',
                'verbose_name_plural': 'Building Heights Above Ground',
                'ordering': ['building', 'height_reference'],
            },
        ),
        migrations.CreateModel(
            name='BuildingGeographicalName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(blank=True, help_text='Language of the name, given as a three letters code, in accordance with either ISO 639-3 or ISO 639-5.', max_length=64)),
                ('source_of_name', models.CharField(blank=True, help_text='Original data source from which the geographical name is taken from and integrated in the data set providing/publishing it. For some named spatial objects it might refer again to the publishing data set if no other information is available.', max_length=64)),
                ('pronunciation', models.CharField(blank=True, help_text='Proper, correct or standard (standard within the linguistic community concerned) pronunciation of the geographical name.', max_length=64)),
                ('spelling', models.CharField(blank=True, help_text='A proper way of writing the geographical name.', max_length=64)),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('grammatical_gender', models.ForeignKey(blank=True, help_text='Class of nouns reflected in the behavior of associated words.', limit_choices_to={'code_list__code': 'GrammaticalGenderValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildinggeographicalname_grammatical_gender', related_query_name='inspire_eu_buildinggeographicalname_grammatical_genders', to='inspire_eu.CodeListValue')),
                ('grammatical_number', models.ForeignKey(blank=True, help_text='Grammatical category of nouns that expresses count distinctions.', limit_choices_to={'code_list__code': 'GrammaticalNumberValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildinggeographicalname_grammatical_number', related_query_name='inspire_eu_buildinggeographicalname_grammatical_numbers', to='inspire_eu.CodeListValue')),
                ('name_status', models.ForeignKey(blank=True, help_text='Qualitative information enabling to discern which credit should be given to the name with respect to its standardization and/or its topicality.', limit_choices_to={'code_list__code': 'NameStatusValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildinggeographicalname_name_status', related_query_name='inspire_eu_buildinggeographicalname_name_statuss', to='inspire_eu.CodeListValue')),
                ('nativeness', models.ForeignKey(blank=True, help_text='Information enabling to acknowledge if the name is the one that is/was used in the area where the spatial object is situated at the instant when the name is/was in use.', limit_choices_to={'code_list__code': 'NativenessValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildinggeographicalname_nativeness', related_query_name='inspire_eu_buildinggeographicalname_nativenesss', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Geographical Name',
                'verbose_name_plural': 'Geographical Names',
                'ordering': ['building', 'source_of_name'],
            },
        ),
        migrations.CreateModel(
            name='BuildingExternalReference',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('information_system', models.URLField(help_text='Uniform Resource Identifier of the external information system')),
                ('information_system_name', models.CharField(blank=True, help_text='The name of the external information systemEXAMPLES: Danish Register of Dwellings, Spanish Cadastre', max_length=32)),
                ('reference', models.CharField(help_text='Thematic identifier of the spatial object or of any piece of information related to the spatial object.<br />NOTE: This reference will act as a foreign key to implement the association between the spatial object in the INSPIRE data set and in the external information system<br />EXAMPLE: The cadastral reference of a given building in the national cadastral register.', max_length=24)),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
            ],
            options={
                'verbose_name': 'Building External Reference',
                'verbose_name_plural': 'Building External References',
                'ordering': ['building', 'reference'],
            },
        ),
        migrations.CreateModel(
            name='BuildingElevation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.FloatField(blank=True, help_text='Vertically-constrained dimensional property consisting of an absolute measure referenced to a well-defined surface which is commonly taken as origin (geoïd, water level, etc.).<br />Source: adapted from the definition given in the data specification of the theme Elevation.')),
                ('coordinate', django.contrib.gis.db.models.fields.PointField(blank=True, null=True, srid=4326)),
                ('dimension', models.IntegerField(blank=True, null=True)),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('reference', models.ForeignKey(help_text='Element where the elevation was measured.', limit_choices_to={'code_list__code': 'ElevationReferenceValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingelevation_elevation_reference', related_query_name='inspire_eu_buildingelevation_elevation_references', to='inspire_eu.CodeListValue')),
                ('value_uom', models.ForeignKey(blank=True, help_text='Value of Elevation shall be given in meters', on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingelevation_value_uom', related_query_name='inspire_eu_buildingelevation_value_uoms', to='inspire_eu.UnitOfMeasure')),
            ],
            options={
                'verbose_name': 'Building Elevation',
                'verbose_name_plural': 'Building Elevations',
                'ordering': ['building', 'dimension'],
            },
        ),
        migrations.CreateModel(
            name='BuildingDocument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document_link', models.URLField(help_text='The Internet address where the document may be found.')),
                ('date', models.DateTimeField(blank=True, help_text='Date of validity of the document', null=True)),
                ('document_description', models.TextField(blank=True, help_text='A short text providing overview of the document content. May be just title of the document')),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('source_status', models.ForeignKey(help_text='The status of the document, i.e. this attribute indicates if the document comes from official source or not', limit_choices_to={'code_list__code': 'SourceStatusValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingdocument_source_status', related_query_name='inspire_eu_buildingdocument_source_statuss', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Building Document',
                'verbose_name_plural': 'Building Documents',
                'ordering': ['building', 'document_link'],
            },
        ),
        migrations.CreateModel(
            name='BuildingCurrentUse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('percentage', models.SmallIntegerField(blank=True, help_text='The proportion of the real world object, given as a percentage, devoted to this current use. <br />NOTE: The percentage of use is generally the percentage of floor area dedicated to this given use. If it is not the case, it is recommended to explain what the percentage refers to in metadata (template for additional information)', null=True)),
                ('building', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Building')),
                ('current_use', models.ForeignKey(help_text='Current use', limit_choices_to={'code_list__code': 'CurrentUseValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_buildingcurrentuse_current_use', related_query_name='inspire_eu_buildingcurrentuse_current_uses', to='inspire_eu.CodeListValue')),
            ],
            options={
                'verbose_name': 'Building Current Use',
                'verbose_name_plural': 'Building Current Uses',
                'ordering': ['building', 'current_use'],
            },
        ),
        migrations.AddField(
            model_name='building',
            name='cadastral_parcels',
            field=models.ManyToManyField(to='inspire_eu.CadastralParcel'),
        ),
        migrations.AddField(
            model_name='building',
            name='condition_of_construction',
            field=models.ForeignKey(help_text='Status of the construction.<br />EXAMPLES: functional, projected, ruin', limit_choices_to={'code_list__code': 'ConditionOfConstructionValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_condition_of_construction', related_query_name='inspire_eu_building_condition_of_constructions', to='inspire_eu.CodeListValue'),
        ),
        migrations.AddField(
            model_name='building',
            name='height_below_ground_uom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_height_below_ground_uom', related_query_name='inspire_eu_building_height_below_ground_uoms', to='inspire_eu.UnitOfMeasure'),
        ),
        migrations.AddField(
            model_name='building',
            name='horizontal_geometry_estimated_accuracy_uom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_horizontal_geometry_estimated_accuracy_uom', related_query_name='inspire_eu_building_horizontal_geometry_estimated_accuracy_uoms', to='inspire_eu.UnitOfMeasure'),
        ),
        migrations.AddField(
            model_name='building',
            name='horizontal_geometry_reference',
            field=models.ForeignKey(help_text='Element of the building that was captured by (X,Y) coordinates.', limit_choices_to={'code_list__code': 'HorizontalGeometryReferenceValue'}, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_horizontal_geometry_reference', related_query_name='inspire_eu_building_horizontal_geometry_references', to='inspire_eu.CodeListValue'),
        ),
        migrations.AddField(
            model_name='building',
            name='namespace',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_namespace', related_query_name='inspire_eu_building_namespaces', to='inspire_eu.Namespace'),
        ),
        migrations.AddField(
            model_name='building',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='parts', to='inspire_eu.Building'),
        ),
        migrations.AddField(
            model_name='building',
            name='vertical_geometry_estimated_accuracy_uom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_vertical_geometry_estimated_accuracy_uom', related_query_name='inspire_eu_building_vertical_geometry_estimated_accuracy_uoms', to='inspire_eu.UnitOfMeasure'),
        ),
        migrations.AddField(
            model_name='building',
            name='vertical_geometry_reference',
            field=models.ForeignKey(blank=True, help_text='Element of the building that was captured by vertical coordinates.', limit_choices_to={'code_list__code': 'ElevationReferenceValue'}, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='inspire_eu_building_vertical_geometry_reference', related_query_name='inspire_eu_building_vertical_geometry_references', to='inspire_eu.CodeListValue'),
        ),
        migrations.AddField(
            model_name='applicationschema',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inspire_eu.Status'),
        ),
        migrations.AddField(
            model_name='applicationschema',
            name='themes',
            field=models.ManyToManyField(to='inspire_eu.Theme'),
        ),
    ]
