from datastructures.circular_queue import CircularQueue as CircularQueue
from datastructures.graph_node import Node as Node
from typing import Generator, Iterator, List, Optional, TypeVar

T = TypeVar('T')

class Graph:
    def __init__(self, nodes: Optional[list[Node[T]]]=...) -> None: ...
    def __iter__(self) -> Generator[Node[T], None, None]: ...
    def __getitem__(self, key: int) -> Optional[T]: ...
    def __len__(self) -> int: ...
    def getConnectionsOfNodeAtIndex(self, index: int) -> List[int]: ...
    def setNodeData(self, index: int, newValue: T) -> None: ...
    @staticmethod
    def createGraph(sizeX: int, sizeY: int) -> Graph[T]: ...
    def setNodesFromNodesList(self, nodes: list[Node[T]]) -> None: ...
    def setNodesFromValuesAndConnections(self, values: list[T], connectionsPointers: list[list[int]]) -> None: ...
    def connectionExistsFrom(self, indexA: int, indexB: int) -> bool: ...
    def depthFirstTraversal(self, nodeIndex: Optional[int]=...) -> Iterator[T]: ...
    def breadthFirstTraversal(self) -> Iterator[Optional[T]]: ...
    def removeLinkBetween(self, indexFrom: int, indexTo: int, bidirectional: bool=...) -> None: ...
    def addLinkBetween(self, indexFrom: int, indexTo: int, bidirectional: bool=...) -> None: ...
