from .features import Dictionary, RegexMatches, Stopwords

name = "swedish"

try:
    import enchant
    dictionary = enchant.Dict("sv")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'sv'.  " +
                      "Consider installing 'aspell-sv'.")

dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
`enchant.Dict <https://github.com/rfk/pyenchant>`_ "sv".  Provided by `aspell-sv`
"""

try:
    from nltk.corpus import stopwords as nltk_stopwords
    stopwords = set(nltk_stopwords.words('swedish'))
except LookupError:
    raise ImportError("Could not load stopwords for {0}. ".format(__name__) +
                      "You may need to install the nltk 'stopwords' " +
                      "corpora.  See http://www.nltk.org/data.html")

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features provided by
`nltk.corpus.stopwords <https://www.nltk.org/api/nltk.corpus.html>`_ "swedish"
"""

badword_regexes = [
    r"anal",
    r"analen",
    r"anus",
    r"arslet",
    r"bajs",
    r"bajsa",
    r"bajsade",
    r"bajsar",
    r"bajsat",
    r"bajset",
    r"bajskorv",
    r"bajskorvar",
    r"bajskorven",
    r"balle",
    r"ballen",
    r"blabla",
    r"blattar",
    r"bög",
    r"bögar",
    r"bögarna",
    r"bögarnas",
    r"bögen",
    r"bögig",
    r"bögiga",
    r"bögigaste",
    r"bögigt",
    r"bögjävel",
    r"bööög",
    r"dase",
    r"dildo",
    r"dildos",
    r"dum",
    r"dumma",
    r"efterbliven",
    r"faan",
    r"fan",
    r"fetto",
    r"fis",
    r"fitt",
    r"fitta",
    r"fittan",
    r"fittor",
    r"fjortisar",
    r"fuck",
    r"fuckers",
    r"fucking",
    r"gay",
    r"gubbe",
    r"hacked",
    r"homosexuel",
    r"hora",
    r"horan",
    r"horor",
    r"hororna",
    r"horungar",
    r"horunge",
    r"idiot",
    r"idioter",
    r"heil",
    r"jävel",
    r"jävla",
    r"jävlar",
    r"jävligt",
    r"knull",
    r"knulla",
    r"knullad",
    r"knullade",
    r"knullar",
    r"knullare",
    r"knullat",
    r"kuk",
    r"kukar",
    r"kukarna",
    r"kuken",
    r"kukens",
    r"kuksugar",
    r"kuksugare",
    r"kåt",
    r"kåta",
    r"körv",
    r"meatspin",
    r"mongo",
    r"penis",
    r"penisar",
    r"penisen",
    r"piss",
    r"poop",
    r"pornhub",
    r"porr",
    r"porrstjärna",
    r"prutt",
    r"pung",
    r"pungkula",
    r"pungkulor",
    r"puss",
    r"pussy",
    r"redtube",
    r"tjockis",
    r"tuttar",
    r"snopp",
    r"snoppar",
    r"snoppen",
    r"snubbe",
    r"sucks",
    r"sug",
    r"suga",
    r"sugare",
    r"suger",
    r"swag",
    r"sög",
    r"rumpa",
    r"rumpan",
    r"rumpor",
    r"runk",
    r"runka",
    r"runkade",
    r"runkar",
    r"röv",
    r"röven",
    r"rövhål",
    r"rövhålet",
    r"rövslickare",
    r"sexig",
    r"mamma",
    r"korv",
    r"kossa",
    r"kossor",
    r"luktade",
    r"luktar",
    r"mammas",
    r"mammor",
    r"apa",
    r"apor",
    r"fet",
    r"feta",
    r"fett",
    r"hårig",
    r"håriga",
    r"knark",
    r"tönt",
    r"töntar",
    r"vafan",
    r"morsa",
    r"mycke",
    r"najs",
    r"neger",
    r"negrar",
    r"negrarna",
    r"nigga",
    r"noob",
    r"noobs",
    r"nörd",
    r"nötaland",
    r"ollon",
    r"omg",
    r"oxå",
    r"pedofil",
    r"sebbe",
    r"sjukt",
    r"sket",
    r"skit",
    r"skiten",
    r"skiter",
    r"yolo",
    r"äcklig",
    r"äckliga",
    r"äckligt",
    r"älskar",
    r"våldtagen",
    r"våldtog",
    r"sämst",
    r"slicka",
    r"snygging",
    r"sperma",
    r"svejsan",
    r"särbarn",
    r"snygg",
    r"snygga",
    r"snyggast",
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"adda",
    r"asså",
    r"awesome",
    r"btw",
    r"cool",
    r"coola",
    r"coolaste",
    r"coolt",
    r"din",
    r"ftw",
    r"ful",
    r"fula",
    r"fulaste",
    r"fult",
    r"gillade",
    r"gillar",
    r"gött",
    r"ha(?:ha)+?",
    r"hata",
    r"hatar",
    r"heej",
    r"hehe",
    r"hehehe",
    r"hej",
    r"hejdå",
    r"hejhej",
    r"hejsan",
    r"here",
    r"hihi",
    r"jätte",
    r"killar",
    r"kille",
    r"kolla",
    r"lol",
    r"mkt",
    r"wow",
    r"yeah",
    r"kul",
    r"kompis",
    r"mvh",
    r"suck",
    r"tja",
    r"tjej",
    r"tjejer",
    r"tjena",
    r"snälla",
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
