/* Generated by re2c 2.0.3 on Tue Oct  1 12:40:24 2024 */
#line 1 "lib/parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, int error_code, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	timelib_long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			return sHOUR(strtol(begin, NULL, 10));
			break;
		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}
		case 5: /* HH:MM */
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;
	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1013 "lib/parse_date.re"



#line 892 "lib/parse_date.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   8,  32,  24,  48,   0, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,   0, 
		  0, 192, 192, 192, 224, 192, 192, 192, 
		224, 192, 192, 192, 192, 192, 224, 192, 
		192, 192, 224, 224, 224, 192, 192, 192, 
		192, 192, 192,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case '\t':
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':	goto yy19;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy20;
	case 'D':	goto yy21;
	case 'E':	goto yy22;
	case 'F':	goto yy23;
	case 'G':	goto yy24;
	case 'I':	goto yy25;
	case 'J':	goto yy26;
	case 'L':	goto yy27;
	case 'M':	goto yy28;
	case 'N':	goto yy29;
	case 'O':	goto yy30;
	case 'P':	goto yy31;
	case 'S':	goto yy32;
	case 'T':	goto yy33;
	case 'V':	goto yy34;
	case 'W':	goto yy35;
	case 'X':	goto yy36;
	case 'Y':	goto yy37;
	case 'a':	goto yy38;
	case 'b':	goto yy39;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy40;
	case 'd':	goto yy41;
	case 'e':	goto yy42;
	case 'f':	goto yy43;
	case 'j':	goto yy44;
	case 'l':	goto yy45;
	case 'm':	goto yy46;
	case 'n':	goto yy47;
	case 'o':	goto yy48;
	case 'p':	goto yy49;
	case 's':	goto yy50;
	case 't':	goto yy51;
	case 'w':	goto yy52;
	case 'y':	goto yy53;
	default:	goto yy4;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(3, *YYCURSOR);
#line 1822 "lib/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 1017 "lib/parse_date.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	++YYCURSOR;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1828 "lib/parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1028 "lib/parse_date.c"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy57;
yy7:
	YYDEBUG(7, *YYCURSOR);
#line 1817 "lib/parse_date.re"
	{
		goto std;
	}
#line 1044 "lib/parse_date.c"
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy40;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy40;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy59;
	case '0':
	case '1':	goto yy61;
	case '2':	goto yy62;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy63;
	default:	goto yy5;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	++YYCURSOR;
	goto yy7;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy64;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy66;
					if (yych <= ',') goto yy5;
					goto yy67;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy68;
					if (yych <= '/') goto yy69;
					goto yy70;
				} else {
					if (yych <= '9') goto yy71;
					if (yych <= ':') goto yy72;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy66;
					if (yych <= 'C') goto yy5;
					goto yy66;
				} else {
					if (yych == 'F') goto yy66;
					goto yy5;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy66;
					if (yych <= 'L') goto yy5;
					goto yy66;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy66;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy66;
					if (yych <= 'c') goto yy5;
					goto yy66;
				} else {
					if (yych == 'f') goto yy66;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy66;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy66;
					goto yy90;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy66;
					if (yych <= 'q') goto yy5;
					goto yy91;
				} else {
					if (yych <= 's') goto yy92;
					if (yych <= 't') goto yy93;
					goto yy66;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy66;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy66;
					if (yych == 0xC2) goto yy66;
					goto yy5;
				}
			}
		}
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy95;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy97;
					if (yych <= ',') goto yy5;
					goto yy67;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy98;
					if (yych <= '/') goto yy69;
					goto yy71;
				} else {
					if (yych <= '9') goto yy99;
					if (yych <= ':') goto yy100;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy97;
					if (yych <= 'C') goto yy5;
					goto yy97;
				} else {
					if (yych == 'F') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy97;
					if (yych <= 'L') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy97;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy97;
					if (yych <= 'c') goto yy5;
					goto yy97;
				} else {
					if (yych == 'f') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy97;
					goto yy90;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy97;
					if (yych <= 'q') goto yy5;
					goto yy91;
				} else {
					if (yych <= 's') goto yy92;
					if (yych <= 't') goto yy93;
					goto yy97;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy97;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy97;
					if (yych == 0xC2) goto yy97;
					goto yy5;
				}
			}
		}
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy95;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy97;
					if (yych <= ',') goto yy5;
					goto yy67;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy98;
					if (yych <= '/') goto yy69;
					goto yy99;
				} else {
					if (yych <= '9') goto yy103;
					if (yych <= ':') goto yy100;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy97;
					if (yych <= 'C') goto yy5;
					goto yy97;
				} else {
					if (yych == 'F') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy97;
					if (yych <= 'L') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy97;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy97;
					if (yych <= 'c') goto yy5;
					goto yy97;
				} else {
					if (yych == 'f') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy97;
					goto yy90;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy97;
					if (yych <= 'q') goto yy5;
					goto yy91;
				} else {
					if (yych <= 's') goto yy92;
					if (yych <= 't') goto yy93;
					goto yy97;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy97;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy97;
					if (yych == 0xC2) goto yy97;
					goto yy5;
				}
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy95;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy97;
					if (yych <= ',') goto yy5;
					goto yy67;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy98;
					if (yych <= '/') goto yy69;
					goto yy103;
				} else {
					if (yych <= '9') goto yy104;
					if (yych <= ':') goto yy100;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy97;
					if (yych <= 'C') goto yy5;
					goto yy97;
				} else {
					if (yych == 'F') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy97;
					if (yych <= 'L') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy97;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy97;
					if (yych <= 'c') goto yy5;
					goto yy97;
				} else {
					if (yych == 'f') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy97;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy97;
					goto yy90;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy97;
					if (yych <= 'q') goto yy5;
					goto yy91;
				} else {
					if (yych <= 's') goto yy92;
					if (yych <= 't') goto yy93;
					goto yy97;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy97;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy97;
					if (yych == 0xC2) goto yy97;
					goto yy5;
				}
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy95;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy97;
					if (yych <= ',') goto yy5;
					goto yy67;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy98;
					if (yych <= '/') goto yy69;
					goto yy104;
				} else {
					if (yych <= ':') goto yy100;
					if (yych <= '@') goto yy5;
					goto yy97;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy97;
					goto yy5;
				} else {
					if (yych == 'G') goto yy5;
					goto yy97;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy5;
					if (yych <= 'P') goto yy97;
					goto yy5;
				} else {
					if (yych <= 'Y') goto yy97;
					if (yych <= '`') goto yy5;
					goto yy97;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy97;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy97;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy97;
					goto yy5;
				} else {
					if (yych == 'n') goto yy90;
					goto yy97;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy5;
					if (yych <= 'r') goto yy91;
					goto yy92;
				} else {
					if (yych <= 't') goto yy93;
					if (yych <= 'u') goto yy97;
					goto yy5;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy5;
					goto yy97;
				} else {
					if (yych == 0xC2) goto yy97;
					goto yy5;
				}
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy105;
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy106;
	goto yy5;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy109;
			if (yych >= 'A') goto yy110;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy111;
				goto yy110;
			} else {
				if (yych <= 'P') goto yy112;
				if (yych <= 'T') goto yy110;
				goto yy113;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
			} else {
				if (yych == 'g') goto yy115;
				goto yy114;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy116;
				goto yy114;
			} else {
				if (yych <= 'u') goto yy117;
				if (yych <= 'z') goto yy114;
			}
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
#line 1733 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1593 "lib/parse_date.c"
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy118;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy110;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy119;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy110;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy114;
		goto yy18;
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy120;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy114;
		} else {
			if (yych <= 'e') goto yy121;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'I') goto yy122;
			if (yych <= 'K') goto yy110;
			goto yy123;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy114;
			goto yy124;
		} else {
			if (yych == 'l') goto yy125;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy110;
				goto yy126;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy127;
				goto yy110;
			} else {
				if (yych <= 'O') goto yy128;
				if (yych <= 'Q') goto yy110;
				goto yy129;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy110;
				if (yych <= '`') goto yy18;
				goto yy114;
			} else {
				if (yych <= 'e') goto yy130;
				if (yych <= 'h') goto yy114;
				goto yy131;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy132;
				goto yy114;
			} else {
				if (yych <= 'r') goto yy133;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy110;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy134;
			goto yy110;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy18;
			} else {
				if (yych == '/') goto yy18;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy110;
			} else {
				if (yych <= 'I') goto yy140;
				if (yych <= 'U') goto yy110;
				goto yy141;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy141;
				goto yy110;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy142;
			if (yych <= 'T') goto yy110;
			goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy144;
		} else {
			if (yych == 'u') goto yy145;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy146;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy110;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy147;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy148;
		} else {
			if (yych == 'I') goto yy149;
			if (yych <= 'N') goto yy110;
			goto yy150;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy151;
			goto yy114;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy152;
				goto yy114;
			} else {
				if (yych <= 'o') goto yy153;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy154;
				goto yy110;
			} else {
				if (yych <= 'I') goto yy155;
				if (yych <= 'N') goto yy110;
				goto yy156;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
				goto yy18;
			} else {
				if (yych == 'e') goto yy157;
				goto yy114;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy158;
				goto yy114;
			} else {
				if (yych <= 'o') goto yy159;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy110;
			goto yy160;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy114;
		} else {
			if (yych <= 'c') goto yy161;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy110;
			goto yy162;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy114;
		} else {
			if (yych <= 'r') goto yy163;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy164;
				goto yy110;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy165;
				goto yy110;
			} else {
				if (yych <= 'I') goto yy166;
				if (yych <= 'T') goto yy110;
				goto yy150;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy167;
				if (yych <= 'd') goto yy114;
				goto yy168;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy169;
				goto yy114;
			} else {
				if (yych <= 'u') goto yy153;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy109;
	case '0':
	case '1':	goto yy170;
	case '2':	goto yy171;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy172;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy110;
	case 'E':	goto yy155;
	case 'H':	goto yy173;
	case 'O':	goto yy174;
	case 'U':	goto yy175;
	case 'W':	goto yy176;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy114;
	case 'e':	goto yy158;
	case 'h':	goto yy177;
	case 'o':	goto yy178;
	case 'u':	goto yy179;
	case 'w':	goto yy180;
	default:	goto yy18;
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy18;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy136;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy181;
				goto yy110;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy182;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy114;
		} else {
			if (yych <= 'e') goto yy183;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy18;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy136;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy140;
				goto yy110;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy114;
				goto yy18;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy184;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy114;
		} else {
			if (yych <= 'e') goto yy185;
			if (yych <= 'z') goto yy114;
			goto yy18;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy111;
				goto yy110;
			} else {
				if (yych <= 'P') goto yy112;
				if (yych <= 'T') goto yy110;
				goto yy113;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
				goto yy18;
			} else {
				if (yych == 'g') goto yy111;
				goto yy110;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy112;
				goto yy110;
			} else {
				if (yych <= 'u') goto yy113;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy118;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy110;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy118;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy110;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy110;
		goto yy18;
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy120;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'I') goto yy122;
			if (yych <= 'K') goto yy110;
			goto yy123;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy110;
			goto yy122;
		} else {
			if (yych == 'l') goto yy123;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy110;
				goto yy126;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy127;
				goto yy110;
			} else {
				if (yych <= 'O') goto yy128;
				if (yych <= 'Q') goto yy110;
				goto yy129;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy110;
				if (yych <= '`') goto yy18;
				goto yy110;
			} else {
				if (yych <= 'e') goto yy126;
				if (yych <= 'h') goto yy110;
				goto yy127;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy128;
				goto yy110;
			} else {
				if (yych <= 'r') goto yy129;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy142;
			if (yych <= 'T') goto yy110;
			goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy142;
		} else {
			if (yych == 'u') goto yy143;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy146;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy110;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy146;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy148;
		} else {
			if (yych == 'I') goto yy149;
			if (yych <= 'N') goto yy110;
			goto yy150;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy148;
			goto yy110;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy149;
				goto yy110;
			} else {
				if (yych <= 'o') goto yy150;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy154;
				goto yy110;
			} else {
				if (yych <= 'I') goto yy155;
				if (yych <= 'N') goto yy110;
				goto yy156;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
				goto yy18;
			} else {
				if (yych == 'e') goto yy154;
				goto yy110;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy155;
				goto yy110;
			} else {
				if (yych <= 'o') goto yy156;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy110;
			goto yy160;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'c') goto yy160;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy110;
			goto yy162;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'r') goto yy162;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy164;
				goto yy110;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy165;
				goto yy110;
			} else {
				if (yych <= 'I') goto yy166;
				if (yych <= 'T') goto yy110;
				goto yy150;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy110;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy164;
				if (yych <= 'd') goto yy110;
				goto yy165;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy166;
				goto yy110;
			} else {
				if (yych <= 'u') goto yy150;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy109;
	case '0':
	case '1':	goto yy170;
	case '2':	goto yy171;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy172;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy110;
	case 'E':
	case 'e':	goto yy155;
	case 'H':
	case 'h':	goto yy173;
	case 'O':
	case 'o':	goto yy174;
	case 'U':
	case 'u':	goto yy175;
	case 'W':
	case 'w':	goto yy176;
	default:	goto yy18;
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy182;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy182;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy110;
			goto yy184;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy110;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy184;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy57;
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy7;
						} else {
							goto yy5;
						}
					} else {
						goto yy18;
					}
				} else {
					if (yyaccept == 3) {
						goto yy78;
					} else {
						goto yy108;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy209;
					} else {
						goto yy214;
					}
				} else {
					if (yyaccept == 7) {
						goto yy250;
					} else {
						goto yy280;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy278;
					} else {
						goto yy300;
					}
				} else {
					if (yyaccept == 11) {
						goto yy310;
					} else {
						goto yy336;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy401;
					} else {
						goto yy403;
					}
				} else {
					if (yyaccept == 15) {
						goto yy505;
					} else {
						goto yy545;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy696;
						} else {
							goto yy712;
						}
					} else {
						goto yy725;
					}
				} else {
					if (yyaccept == 20) {
						goto yy748;
					} else {
						goto yy815;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy889;
					} else {
						goto yy577;
					}
				} else {
					if (yyaccept == 24) {
						goto yy904;
					} else {
						goto yy938;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy979;
					} else {
						goto yy997;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1002;
					} else {
						goto yy1055;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1093;
					} else {
						goto yy1116;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1119;
					} else {
						goto yy1246;
					}
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(58, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy56;
				goto yy186;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy188;
				} else {
					if (yych == 'F') goto yy189;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy76;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy190;
					if (yych <= 'R') goto yy56;
					goto yy191;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy84;
					goto yy85;
				} else {
					if (yych == 'W') goto yy87;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy89;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy188;
					if (yych <= 'e') goto yy56;
					goto yy189;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy76;
				} else {
					if (yych == 'm') goto yy190;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy191;
					goto yy84;
				} else {
					if (yych <= 'u') goto yy85;
					if (yych <= 'v') goto yy56;
					goto yy87;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy89;
				} else {
					if (yych == 0xC2) goto yy94;
					goto yy56;
				}
			}
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(60, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy59;
		goto yy56;
	} else {
		if (yych <= '-') goto yy59;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy57;
		goto yy56;
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy192;
				} else {
					if (yych <= ':') goto yy193;
					if (yych <= 'C') goto yy18;
					goto yy187;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy18;
					goto yy187;
				} else {
					if (yych == 'H') goto yy187;
					goto yy18;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy18;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy18;
					goto yy187;
				} else {
					if (yych == ' ') goto yy187;
					goto yy18;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy192;
					goto yy194;
				} else {
					if (yych <= '9') goto yy195;
					if (yych <= ':') goto yy193;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy187;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy187;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych <= 'c') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy194;
				} else {
					if (yych <= '9') goto yy195;
					if (yych <= ':') goto yy193;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy187;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy187;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych <= 'c') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy66;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy66;
yy65:
	YYDEBUG(65, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy66:
	YYDEBUG(66, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy65;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy65;
					if (yych <= ',') goto yy56;
					goto yy196;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy73;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy74;
					if (yych == 'F') goto yy75;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy76;
					if (yych <= 'I') goto yy77;
					goto yy79;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy80;
					goto yy81;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy82;
					if (yych <= 'R') goto yy56;
					goto yy83;
				} else {
					if (yych <= 'T') goto yy84;
					if (yych <= 'U') goto yy85;
					if (yych <= 'V') goto yy86;
					goto yy87;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy88;
					if (yych <= 'Y') goto yy89;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy73;
					if (yych <= 'c') goto yy56;
					goto yy74;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy75;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy76;
					if (yych == 'j') goto yy79;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy80;
					if (yych <= 'n') goto yy81;
					goto yy82;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy83;
					if (yych <= 't') goto yy84;
					goto yy85;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy87;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy89;
					if (yych == 0xC2) goto yy94;
					goto yy56;
				}
			}
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy201;
	if (yych <= '1') goto yy202;
	if (yych <= '9') goto yy203;
	goto yy197;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy197;
		if (yych <= '0') goto yy208;
		goto yy210;
	} else {
		if (yych <= '5') goto yy211;
		if (yych <= '9') goto yy212;
		goto yy197;
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy213;
	case '3':	goto yy215;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy216;
	case 'A':
	case 'a':	goto yy217;
	case 'D':
	case 'd':	goto yy218;
	case 'F':
	case 'f':	goto yy219;
	case 'J':
	case 'j':	goto yy220;
	case 'M':
	case 'm':	goto yy221;
	case 'N':
	case 'n':	goto yy222;
	case 'O':
	case 'o':	goto yy223;
	case 'S':
	case 's':	goto yy224;
	default:	goto yy56;
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy64;
			if (yych <= ',') goto yy66;
			goto yy225;
		} else {
			if (yych <= '.') goto yy68;
			if (yych <= '/') goto yy69;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy72;
			if (yych == 'n') goto yy90;
			goto yy66;
		} else {
			if (yych <= 'r') goto yy91;
			if (yych <= 's') goto yy92;
			if (yych <= 't') goto yy93;
			goto yy66;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy95;
			if (yych <= ',') goto yy97;
			goto yy225;
		} else {
			if (yych <= '.') goto yy98;
			if (yych <= '/') goto yy69;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy100;
			if (yych == 'n') goto yy90;
			goto yy97;
		} else {
			if (yych <= 'r') goto yy91;
			if (yych <= 's') goto yy92;
			if (yych <= 't') goto yy93;
			goto yy97;
		}
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy228;
	if (yych <= '9') goto yy229;
	goto yy56;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy230;
		if (yych <= 'T') goto yy56;
		goto yy231;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy230;
		} else {
			if (yych == 'u') goto yy231;
			goto yy56;
		}
	}
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy232;
		if (yych <= 'D') goto yy56;
		goto yy233;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy232;
		} else {
			if (yych == 'e') goto yy233;
			goto yy56;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy234;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy235;
			if (yych <= 'Q') goto yy56;
			goto yy236;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy234;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy235;
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy237;
	if (yych == 'o') goto yy237;
	goto yy56;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			if (yych <= '.') goto yy238;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy240;
			if (yych == 'I') goto yy242;
		} else {
			if (yych == 'W') goto yy78;
			if (yych <= 'X') goto yy243;
		}
	}
yy78:
	YYDEBUG(78, *YYCURSOR);
#line 1483 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3423 "lib/parse_date.c"
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy244;
		if (yych <= 'T') goto yy56;
		goto yy245;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy244;
		} else {
			if (yych == 'u') goto yy245;
			goto yy56;
		}
	}
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy246;
			if (yych <= 'H') goto yy56;
			goto yy247;
		} else {
			if (yych == 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy246;
			if (yych <= 'h') goto yy56;
			goto yy247;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy248;
			} else {
				if (yych == 's') goto yy249;
				goto yy56;
			}
		}
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy251;
	if (yych == 'o') goto yy251;
	goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy252;
	if (yych == 'c') goto yy252;
	goto yy56;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy254;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy254;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy256;
		if (yych <= 'T') goto yy56;
		goto yy257;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy256;
		} else {
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy258;
	if (yych == 's') goto yy258;
	goto yy56;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy78;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy78;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy78;
			goto yy240;
		} else {
			if (yych == 'I') goto yy88;
			goto yy78;
		}
	}
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy259;
	if (yych == 'e') goto yy259;
	goto yy56;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy78;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy78;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy78;
			goto yy240;
		} else {
			if (yych == 'I') goto yy242;
			goto yy78;
		}
	}
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy260;
	if (yych == 'e') goto yy260;
	goto yy56;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy251;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy261;
		if (yych == 'o') goto yy251;
		goto yy56;
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy261;
	goto yy56;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy254;
			if (yych == 'U') goto yy255;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy253;
			if (yych <= 'd') goto yy56;
			goto yy254;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy261;
			if (yych <= 'u') goto yy255;
			goto yy56;
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy256;
		if (yych <= 'T') goto yy56;
		goto yy257;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy262;
		} else {
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy263;
	goto yy56;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy97;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy97;
yy96:
	YYDEBUG(96, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy97:
	YYDEBUG(97, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy96;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy96;
					if (yych <= ',') goto yy56;
					goto yy196;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy101;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy74;
					if (yych == 'F') goto yy75;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy76;
					if (yych <= 'I') goto yy77;
					goto yy79;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy80;
					if (yych <= 'N') goto yy81;
					goto yy82;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy102;
					if (yych <= 'R') goto yy56;
					goto yy83;
				} else {
					if (yych <= 'T') goto yy84;
					if (yych <= 'U') goto yy85;
					if (yych <= 'V') goto yy86;
					goto yy87;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy88;
					if (yych <= 'Y') goto yy89;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy101;
					if (yych == 'd') goto yy74;
					goto yy56;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy75;
					if (yych <= 'g') goto yy56;
					goto yy76;
				} else {
					if (yych == 'j') goto yy79;
					if (yych <= 'l') goto yy56;
					goto yy80;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy81;
					if (yych <= 'o') goto yy82;
					goto yy102;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy83;
					if (yych <= 't') goto yy84;
					goto yy85;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy87;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy89;
					if (yych == 0xC2) goto yy94;
					goto yy56;
				}
			}
		}
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy197;
		if (yych <= '0') goto yy264;
		goto yy265;
	} else {
		if (yych <= '5') goto yy266;
		if (yych <= '9') goto yy267;
		goto yy197;
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy64;
			if (yych <= ',') goto yy66;
			goto yy225;
		} else {
			if (yych <= '.') goto yy68;
			if (yych <= '/') goto yy268;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy72;
			if (yych == 'n') goto yy90;
			goto yy66;
		} else {
			if (yych <= 'r') goto yy91;
			if (yych <= 's') goto yy92;
			if (yych <= 't') goto yy93;
			goto yy66;
		}
	}
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy269;
	if (yych <= '9') goto yy270;
	goto yy56;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy271;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy272;
			if (yych == 'P') goto yy230;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy231;
			if (yych == 'm') goto yy272;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy230;
			if (yych == 'u') goto yy231;
			goto yy56;
		}
	}
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy271;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy272;
		if (yych == 'm') goto yy272;
		goto yy56;
	}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy64;
			goto yy66;
		} else {
			if (yych <= '-') goto yy225;
			if (yych <= '.') goto yy273;
			if (yych <= '/') goto yy268;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy90;
			goto yy66;
		} else {
			if (yych <= 'r') goto yy91;
			if (yych <= 's') goto yy92;
			if (yych <= 't') goto yy93;
			goto yy66;
		}
	}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy274;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy227;
	goto yy187;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(107, *YYCURSOR);
	if (yych == '.') goto yy275;
	if (yych <= '/') goto yy108;
	if (yych <= '9') goto yy106;
yy108:
	YYDEBUG(108, *YYCURSOR);
#line 1073 "lib/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3901 "lib/parse_date.c"
yy109:
	YYDEBUG(109, *YYCURSOR);
	++YYCURSOR;
	goto yy18;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy276;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy276;
		goto yy18;
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy276;
			goto yy277;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'o') goto yy277;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy276;
			goto yy279;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'r') goto yy279;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy276;
			goto yy281;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'g') goto yy281;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy276;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy283;
			goto yy18;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy277;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'o') goto yy284;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy279;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'r') goto yy285;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy281;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'g') goto yy286;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy276;
			goto yy287;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'c') goto yy287;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy287;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'c') goto yy288;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy276;
			goto yy289;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'c') goto yy289;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy289;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'c') goto yy290;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy276;
			goto yy291;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'g') goto yy291;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy276;
			goto yy292;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'e') goto yy292;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy291;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'g') goto yy293;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy292;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'e') goto yy294;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy276;
			goto yy295;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'b') goto yy295;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'F') goto yy296;
			if (yych <= 'Q') goto yy276;
			goto yy297;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'e') goto yy276;
			goto yy296;
		} else {
			if (yych == 'r') goto yy297;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy276;
			goto yy298;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'u') goto yy298;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'I') goto yy299;
			if (yych <= 'N') goto yy276;
			goto yy301;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy276;
			goto yy299;
		} else {
			if (yych == 'o') goto yy301;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy295;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'b') goto yy302;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'F') goto yy296;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy297;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy303;
				goto yy283;
			} else {
				if (yych <= 'r') goto yy304;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy298;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'u') goto yy305;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'I') goto yy299;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy301;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy306;
				goto yy283;
			} else {
				if (yych <= 'o') goto yy307;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy276;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy308;
			goto yy276;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy136:
	YYDEBUG(136, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy135;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy137;
	if (yych <= '3') goto yy138;
	if (yych <= '9') goto yy139;
	goto yy56;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy313;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy313;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy317;
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy317;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy18;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy136;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy318;
				goto yy276;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy276;
				goto yy18;
			}
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy136;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy276;
			goto yy319;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'n') goto yy319;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'L') goto yy320;
			if (yych <= 'M') goto yy276;
			goto yy321;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'k') goto yy276;
			goto yy320;
		} else {
			if (yych == 'n') goto yy321;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy319;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'n') goto yy322;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'L') goto yy320;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy321;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy323;
				goto yy283;
			} else {
				if (yych <= 'n') goto yy324;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy276;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 's') goto yy325;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy325;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 's') goto yy326;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'R') goto yy327;
			if (yych <= 'X') goto yy276;
			goto yy328;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'q') goto yy276;
			goto yy327;
		} else {
			if (yych == 'y') goto yy328;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy276;
			goto yy329;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'd') goto yy329;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy276;
			goto yy299;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'n') goto yy299;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'R') goto yy327;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy328;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy330;
				goto yy283;
			} else {
				if (yych <= 'y') goto yy331;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy329;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'd') goto yy332;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy299;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'n') goto yy306;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy276;
			goto yy333;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'x') goto yy333;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy276;
			goto yy296;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'n') goto yy296;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'O') goto yy334;
			if (yych <= 'U') goto yy276;
			if (yych <= 'V') goto yy289;
			goto yy335;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy276;
			goto yy334;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy276;
				goto yy289;
			} else {
				if (yych <= 'w') goto yy335;
				if (yych <= 'z') goto yy276;
				goto yy18;
			}
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy333;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'x') goto yy337;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy296;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'n') goto yy303;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy282;
				if (yych <= '@') goto yy18;
				goto yy276;
			} else {
				if (yych <= 'O') goto yy334;
				if (yych <= 'U') goto yy276;
				goto yy289;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy335;
				if (yych <= 'Z') goto yy276;
				goto yy18;
			} else {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy18;
				goto yy283;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy338;
				if (yych <= 'u') goto yy283;
				goto yy290;
			} else {
				if (yych <= 'w') goto yy339;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy276;
			goto yy340;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 't') goto yy340;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy340;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 't') goto yy341;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy276;
			goto yy342;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'e') goto yy342;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy342;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'e') goto yy343;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy276;
			goto yy344;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 't') goto yy344;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy345;
				goto yy276;
			} else {
				if (yych <= 'P') goto yy346;
				if (yych <= 'U') goto yy276;
				goto yy347;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy276;
				goto yy18;
			} else {
				if (yych == 'c') goto yy345;
				goto yy276;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy346;
				goto yy276;
			} else {
				if (yych <= 'v') goto yy347;
				if (yych <= 'z') goto yy276;
				goto yy18;
			}
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy276;
			goto yy296;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'x') goto yy296;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy344;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 't') goto yy348;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy109;
				goto yy18;
			} else {
				if (yych == '.') goto yy18;
				goto yy282;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy18;
				if (yych <= 'B') goto yy276;
				goto yy345;
			} else {
				if (yych == 'P') goto yy346;
				goto yy276;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy347;
				if (yych <= 'Z') goto yy276;
				goto yy18;
			} else {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy18;
				goto yy283;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy349;
				if (yych <= 'o') goto yy283;
				goto yy350;
			} else {
				if (yych == 'v') goto yy351;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy296;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'x') goto yy303;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy72;
		goto yy56;
	} else {
		if (yych <= '9') goto yy352;
		if (yych <= ':') goto yy72;
		goto yy56;
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy72;
		goto yy56;
	} else {
		if (yych <= '4') goto yy352;
		if (yych == ':') goto yy72;
		goto yy56;
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy72;
	if (yych == ':') goto yy72;
	goto yy56;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'I') goto yy353;
			if (yych <= 'T') goto yy276;
			goto yy354;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy276;
			goto yy353;
		} else {
			if (yych == 'u') goto yy354;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == 'D') goto yy355;
			if (yych <= 'L') goto yy276;
			goto yy356;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			if (yych <= 'c') goto yy276;
			goto yy355;
		} else {
			if (yych == 'm') goto yy356;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy276;
			goto yy357;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'e') goto yy357;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy276;
			goto yy358;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'e') goto yy358;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'I') goto yy353;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy354;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy359;
				goto yy283;
			} else {
				if (yych <= 'u') goto yy360;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy109;
			} else {
				if (yych == '-') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy282;
				goto yy18;
			} else {
				if (yych == 'D') goto yy355;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy356;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy361;
				goto yy283;
			} else {
				if (yych <= 'm') goto yy362;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy357;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'e') goto yy363;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy358;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 'e') goto yy364;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy18;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy136;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy365;
				goto yy276;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy276;
				goto yy18;
			}
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'C') goto yy276;
			if (yych <= 'D') goto yy366;
			goto yy367;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 'd') goto yy366;
			if (yych <= 'e') goto yy367;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy18;
				goto yy282;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'C') goto yy276;
				goto yy366;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy367;
				goto yy276;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy283;
				goto yy368;
			} else {
				if (yych <= 'e') goto yy369;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy276;
			goto yy370;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '`') goto yy18;
			goto yy276;
		} else {
			if (yych <= 's') goto yy370;
			if (yych <= 'z') goto yy276;
			goto yy18;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy370;
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy283;
			} else {
				if (yych <= 's') goto yy371;
				if (yych <= 'z') goto yy283;
				goto yy18;
			}
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy187:
	YYDEBUG(187, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy56;
				goto yy186;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
				} else {
					if (yych == 'F') goto yy189;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy76;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy190;
					if (yych <= 'R') goto yy56;
					goto yy191;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy84;
					goto yy85;
				} else {
					if (yych == 'W') goto yy87;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy89;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy188;
					if (yych <= 'e') goto yy56;
					goto yy189;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy76;
				} else {
					if (yych == 'm') goto yy190;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy191;
					goto yy84;
				} else {
					if (yych <= 'u') goto yy85;
					if (yych <= 'v') goto yy56;
					goto yy87;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy89;
				} else {
					if (yych == 0xC2) goto yy94;
					goto yy56;
				}
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy232;
	if (yych == 'a') goto yy232;
	goto yy56;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy235;
		if (yych <= 'Q') goto yy56;
		goto yy236;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy235;
		} else {
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy247;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy247;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy248;
			if (yych == 's') goto yy249;
			goto yy56;
		}
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy372;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy372;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy373;
				} else {
					if (yych <= '9') goto yy374;
					if (yych >= ';') goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy187;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy187;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych <= 'c') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy375;
	if (yych <= '9') goto yy109;
	goto yy18;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy374;
				} else {
					if (yych == 'D') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy187;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy18;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy376;
				} else {
					if (yych == 'D') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy187;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy18;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy197:
	YYDEBUG(197, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy196;
	case 'A':
	case 'a':	goto yy73;
	case 'D':
	case 'd':	goto yy204;
	case 'F':
	case 'f':	goto yy205;
	case 'I':	goto yy77;
	case 'J':
	case 'j':	goto yy79;
	case 'M':
	case 'm':	goto yy206;
	case 'N':
	case 'n':	goto yy81;
	case 'O':
	case 'o':	goto yy82;
	case 'S':
	case 's':	goto yy207;
	case 'V':	goto yy86;
	case 'X':	goto yy88;
	default:	goto yy56;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy377;
		goto yy378;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy200;
		goto yy56;
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy377;
		goto yy378;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy377;
	if (yych <= '.') goto yy378;
	goto yy56;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy377;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy203;
		goto yy56;
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy377;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy379;
	if (yych <= '.') goto yy377;
	goto yy56;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy233;
	if (yych == 'e') goto yy233;
	goto yy56;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy234;
	if (yych == 'e') goto yy234;
	goto yy56;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy246;
	if (yych == 'a') goto yy246;
	goto yy56;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy380;
	if (yych == 'e') goto yy380;
	goto yy56;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy381;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy212;
		if (yych <= ':') goto yy382;
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
#line 1226 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 6560 "lib/parse_date.c"
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		if (yych <= '.') goto yy381;
		goto yy209;
	} else {
		if (yych <= '2') goto yy212;
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy382;
		goto yy209;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy381;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy382;
		goto yy209;
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy381;
	} else {
		if (yych == ':') goto yy382;
		goto yy209;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy383;
		} else {
			if (yych <= '9') goto yy216;
			if (yych >= 'n') goto yy384;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy384;
		} else {
			if (yych <= 's') goto yy385;
			if (yych <= 't') goto yy386;
		}
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
#line 1318 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 6638 "lib/parse_date.c"
yy215:
	YYDEBUG(215, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy214;
			goto yy383;
		} else {
			if (yych <= '1') goto yy216;
			if (yych <= 'm') goto yy214;
			goto yy384;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy214;
			goto yy384;
		} else {
			if (yych <= 's') goto yy385;
			if (yych <= 't') goto yy386;
			goto yy214;
		}
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy383;
		if (yych <= 'm') goto yy214;
		goto yy384;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy214;
			goto yy384;
		} else {
			if (yych <= 's') goto yy385;
			if (yych <= 't') goto yy386;
			goto yy214;
		}
	}
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy387;
		if (yych <= 'T') goto yy56;
		goto yy388;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy387;
		} else {
			if (yych == 'u') goto yy388;
			goto yy56;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy389;
	if (yych == 'e') goto yy389;
	goto yy56;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy390;
	if (yych == 'e') goto yy390;
	goto yy56;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy391;
		if (yych <= 'T') goto yy56;
		goto yy392;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy391;
		} else {
			if (yych == 'u') goto yy392;
			goto yy56;
		}
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy393;
	if (yych == 'a') goto yy393;
	goto yy56;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy394;
	if (yych == 'o') goto yy394;
	goto yy56;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy395;
	if (yych == 'c') goto yy395;
	goto yy56;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy396;
	if (yych == 'e') goto yy396;
	goto yy56;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy397;
	if (yych <= '1') goto yy398;
	if (yych <= '9') goto yy203;
	goto yy197;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy399;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy400;
	goto yy187;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy399;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy402;
	goto yy187;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy382;
		goto yy209;
	} else {
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy382;
		goto yy209;
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy382;
	if (yych == ':') goto yy382;
	goto yy209;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy404;
	if (yych == 'r') goto yy404;
	goto yy56;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy405;
	if (yych == 'g') goto yy405;
	goto yy56;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy406;
	if (yych == 'y') goto yy406;
	goto yy56;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy407;
	if (yych == 'c') goto yy407;
	goto yy56;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy408;
	if (yych == 'b') goto yy408;
	goto yy56;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy409;
	if (yych == 'r') goto yy409;
	goto yy56;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy410;
	if (yych == 'i') goto yy410;
	goto yy56;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy411;
	if (yych == 'u') goto yy411;
	goto yy56;
yy238:
	YYDEBUG(238, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(239, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy238;
		if (yych <= 0x1F) goto yy56;
		goto yy238;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy238;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy412;
yy241:
	YYDEBUG(241, *YYCURSOR);
#line 1400 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 6877 "lib/parse_date.c"
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy78;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy78;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy78;
			goto yy240;
		} else {
			if (yych != 'I') goto yy78;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy238;
		if (yych <= 0x1F) goto yy78;
		goto yy238;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy78;
			goto yy238;
		} else {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy413;
	if (yych == 'n') goto yy413;
	goto yy56;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy414;
		if (yych <= 'M') goto yy56;
		goto yy415;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy414;
		} else {
			if (yych == 'n') goto yy415;
			goto yy56;
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy416;
		if (yych <= 'X') goto yy56;
		goto yy243;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy416;
		} else {
			if (yych == 'y') goto yy243;
			goto yy56;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy417;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy418;
			if (yych <= 'M') goto yy56;
			goto yy419;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy417;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy418;
			if (yych == 'n') goto yy419;
			goto yy56;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy420;
	if (yych == 'n') goto yy420;
	goto yy56;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy421;
	if (yych == 'e') goto yy421;
yy250:
	YYDEBUG(250, *YYCURSOR);
#line 1801 "lib/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7006 "lib/parse_date.c"
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy407;
	if (yych == 'v') goto yy407;
	goto yy56;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy422;
	if (yych == 't') goto yy422;
	goto yy56;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy423;
	if (yych == 't') goto yy423;
	goto yy56;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy424;
		if (yych <= 'O') goto yy56;
		goto yy425;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy424;
		} else {
			if (yych == 'p') goto yy425;
			goto yy56;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy410;
	if (yych == 'n') goto yy410;
	goto yy56;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy426;
	if (yych == 'u') goto yy426;
	goto yy56;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy427;
	if (yych == 'e') goto yy427;
	goto yy56;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy421;
	if (yych == 'e') goto yy421;
	goto yy56;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy428;
		goto yy429;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy428;
		if (yych <= 'e') goto yy429;
		goto yy56;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy411;
	if (yych == 'a') goto yy411;
	goto yy56;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy273;
		goto yy197;
	} else {
		if (yych <= '-') goto yy430;
		if (yych <= '.') goto yy273;
		if (yych <= '/') goto yy268;
		goto yy197;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy197;
			goto yy273;
		} else {
			if (yych <= ',') goto yy197;
			if (yych <= '-') goto yy430;
			goto yy273;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy268;
			if (yych <= 'T') goto yy197;
			goto yy426;
		} else {
			if (yych == 'u') goto yy426;
			goto yy197;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy249;
	if (yych == 's') goto yy249;
	goto yy56;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy431;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy432;
		if (yych <= ':') goto yy433;
		goto yy209;
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		if (yych <= '.') goto yy431;
		goto yy209;
	} else {
		if (yych <= '2') goto yy432;
		if (yych <= '9') goto yy434;
		if (yych <= ':') goto yy433;
		goto yy209;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy431;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy434;
		if (yych <= ':') goto yy433;
		goto yy209;
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy377;
		goto yy431;
	} else {
		if (yych == ':') goto yy433;
		goto yy209;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy217;
	case 'D':
	case 'd':	goto yy218;
	case 'F':
	case 'f':	goto yy219;
	case 'J':
	case 'j':	goto yy220;
	case 'M':
	case 'm':	goto yy221;
	case 'N':
	case 'n':	goto yy222;
	case 'O':
	case 'o':	goto yy223;
	case 'S':
	case 's':	goto yy224;
	default:	goto yy56;
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy209;
	} else {
		if (yych <= '9') goto yy435;
		if (yych <= ':') goto yy433;
		goto yy209;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy433;
	if (yych == ':') goto yy433;
	goto yy209;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy272;
	if (yych != 'm') goto yy56;
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy436;
		if (yych == '\t') goto yy436;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy436;
		if (yych == '.') goto yy438;
		goto yy56;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy197;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy439;
	case '1':	goto yy440;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy441;
	case 'A':
	case 'a':	goto yy442;
	case 'D':
	case 'd':	goto yy443;
	case 'F':
	case 'f':	goto yy444;
	case 'J':
	case 'j':	goto yy445;
	case 'M':
	case 'm':	goto yy446;
	case 'N':
	case 'n':	goto yy447;
	case 'O':
	case 'o':	goto yy448;
	case 'S':
	case 's':	goto yy449;
	default:	goto yy56;
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy450;
	goto yy56;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy451;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy451;
		goto yy18;
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
	} else {
		if (yych <= 'Z') goto yy451;
		if (yych <= '`') goto yy278;
		if (yych <= 'z') goto yy451;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
#line 1643 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7327 "lib/parse_date.c"
yy279:
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy136;
			} else {
				if (yych == ' ') goto yy136;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
			} else {
				if (yych == 'I') goto yy453;
				goto yy451;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy451;
			} else {
				if (yych <= 'i') goto yy453;
				if (yych <= 'z') goto yy451;
			}
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
#line 1723 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7375 "lib/parse_date.c"
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'U') goto yy454;
				goto yy451;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'u') goto yy454;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy455;
	}
	goto yy56;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy451;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy457;
			goto yy18;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy278;
		} else {
			if (yych == '.') goto yy278;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy278;
			if (yych <= 'Z') goto yy451;
			goto yy278;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy278;
			if (yych <= 'z') goto yy457;
			goto yy278;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'I') goto yy453;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'i') goto yy459;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'U') goto yy454;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'u') goto yy460;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy451;
			goto yy461;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'k') goto yy461;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy461;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'k') goto yy462;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'E') goto yy463;
				goto yy451;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'e') goto yy463;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'E') goto yy463;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'e') goto yy464;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy451;
			goto yy465;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'h') goto yy465;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy451;
			goto yy466;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'v') goto yy466;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy465;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'h') goto yy467;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy466;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'v') goto yy468;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'R') goto yy469;
				goto yy451;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'r') goto yy469;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy451;
			goto yy470;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 't') goto yy470;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy451;
			goto yy471;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 's') goto yy471;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy451;
			goto yy472;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'r') goto yy472;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy109;
		} else {
			if (yych <= '@') goto yy300;
			if (yych <= 'C') goto yy451;
			goto yy473;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy451;
			if (yych >= 'a') goto yy451;
		} else {
			if (yych <= 'd') goto yy473;
			if (yych <= 'z') goto yy451;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
#line 1664 "lib/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7967 "lib/parse_date.c"
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy451;
			goto yy474;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'n') goto yy474;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'R') goto yy469;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'r') goto yy475;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy470;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 't') goto yy476;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy471;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 's') goto yy477;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy472;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'r') goto yy478;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy300;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy300;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy473;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy300;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy300;
				goto yy457;
			} else {
				if (yych <= 'd') goto yy479;
				if (yych <= 'z') goto yy457;
				goto yy300;
			}
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy474;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'n') goto yy480;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych == '+') goto yy481;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy481;
			if (yych <= '@') goto yy18;
			goto yy451;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych >= '0') goto yy482;
		} else {
			if (yych <= '1') goto yy483;
			if (yych <= '2') goto yy484;
			goto yy485;
		}
	} else {
		if (yych <= 'T') {
			if (yych >= 'T') goto yy486;
		} else {
			if (yych == 't') goto yy486;
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
#line 1469 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 8248 "lib/parse_date.c"
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy312:
	YYDEBUG(312, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy311;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy310;
		if (yych <= '0') goto yy487;
		if (yych <= '1') goto yy488;
		goto yy489;
	} else {
		if (yych <= '9') goto yy490;
		if (yych == 'T') goto yy486;
		goto yy310;
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy491;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy492;
	goto yy312;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy492;
	goto yy312;
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy492;
	goto yy312;
yy317:
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy491;
	goto yy56;
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy136;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'U') goto yy493;
				goto yy451;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'u') goto yy493;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'Y') goto yy494;
				goto yy451;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'y') goto yy494;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'E') goto yy494;
				goto yy451;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'e') goto yy494;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'U') goto yy493;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'u') goto yy495;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'Y') goto yy494;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'y') goto yy496;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'E') goto yy494;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'e') goto yy496;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy451;
			goto yy497;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 't') goto yy497;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy497;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 't') goto yy498;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'C') goto yy499;
				goto yy451;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'c') goto yy499;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy280;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy280;
			goto yy452;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy280;
			if (yych <= '9') goto yy136;
			goto yy280;
		} else {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy280;
			if (yych <= 'z') goto yy451;
			goto yy280;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy451;
			goto yy500;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'n') goto yy500;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'C') goto yy499;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'c') goto yy501;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy280;
			goto yy136;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy280;
				goto yy109;
			} else {
				if (yych <= ',') goto yy280;
				if (yych <= '-') goto yy458;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy282;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy280;
			goto yy451;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy280;
				goto yy282;
			} else {
				if (yych <= '`') goto yy280;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy500;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'n') goto yy502;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy451;
			goto yy503;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 't') goto yy503;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy451;
			goto yy504;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'n') goto yy504;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
	} else {
		if (yych <= 'Z') goto yy451;
		if (yych <= '`') goto yy336;
		if (yych <= 'z') goto yy451;
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
#line 1030 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8950 "lib/parse_date.c"
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy503;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 't') goto yy506;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy504;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'n') goto yy507;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy336;
		} else {
			if (yych == '.') goto yy336;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy336;
			if (yych <= 'Z') goto yy451;
			goto yy336;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy336;
			if (yych <= 'z') goto yy457;
			goto yy336;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'O') goto yy508;
				goto yy451;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'o') goto yy508;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'O') goto yy508;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 'o') goto yy509;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy451;
			goto yy510;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'v') goto yy510;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy510;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'v') goto yy511;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy300;
			goto yy109;
		} else {
			if (yych <= '@') goto yy300;
			if (yych <= 'T') goto yy451;
			goto yy512;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy300;
			goto yy451;
		} else {
			if (yych <= 'u') goto yy512;
			if (yych <= 'z') goto yy451;
			goto yy300;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy451;
			goto yy513;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'o') goto yy513;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'T') goto yy514;
				goto yy451;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy280;
				goto yy451;
			} else {
				if (yych <= 't') goto yy514;
				if (yych <= 'z') goto yy451;
				goto yy280;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy451;
			goto yy515;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'e') goto yy515;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy300;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy300;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy512;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy300;
			goto yy282;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy300;
				goto yy457;
			} else {
				if (yych <= 'u') goto yy516;
				if (yych <= 'z') goto yy457;
				goto yy300;
			}
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy513;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'o') goto yy517;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy280;
				goto yy451;
			} else {
				if (yych <= 'T') goto yy514;
				if (yych <= 'Z') goto yy451;
				goto yy280;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy457;
			} else {
				if (yych <= 't') goto yy518;
				if (yych <= 'z') goto yy457;
				goto yy280;
			}
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy515;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'e') goto yy519;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy72;
		goto yy56;
	} else {
		if (yych <= '5') goto yy520;
		if (yych == ':') goto yy72;
		goto yy56;
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'Q') goto yy451;
			if (yych <= 'R') goto yy521;
			goto yy503;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'r') goto yy521;
			if (yych <= 's') goto yy503;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy300;
			goto yy109;
		} else {
			if (yych <= '@') goto yy300;
			if (yych <= 'Q') goto yy451;
			goto yy522;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy300;
			goto yy451;
		} else {
			if (yych <= 'r') goto yy522;
			if (yych <= 'z') goto yy451;
			goto yy300;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy523;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy451;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy523;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy451;
			goto yy524;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'o') goto yy524;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy300;
			goto yy109;
		} else {
			if (yych <= '@') goto yy300;
			if (yych <= 'R') goto yy451;
			goto yy525;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy300;
			goto yy451;
		} else {
			if (yych <= 's') goto yy525;
			if (yych <= 'z') goto yy451;
			goto yy300;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy451;
			goto yy526;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'l') goto yy526;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy18;
				goto yy282;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'Q') goto yy451;
				goto yy521;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy503;
				goto yy451;
			} else {
				if (yych == '_') goto yy282;
				goto yy18;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy457;
				goto yy527;
			} else {
				if (yych <= 's') goto yy506;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy300;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy300;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy522;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy300;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy300;
				goto yy457;
			} else {
				if (yych <= 'r') goto yy528;
				if (yych <= 'z') goto yy457;
				goto yy300;
			}
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy523;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy529;
			if (yych <= 'z') goto yy457;
			goto yy18;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy524;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'o') goto yy530;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy300;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy300;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy525;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy300;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy300;
				goto yy457;
			} else {
				if (yych <= 's') goto yy531;
				if (yych <= 'z') goto yy457;
				goto yy300;
			}
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy526;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'l') goto yy532;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy18;
			goto yy136;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy136;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy533;
				goto yy451;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy451;
				goto yy18;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy300;
			goto yy109;
		} else {
			if (yych <= '@') goto yy300;
			if (yych <= 'M') goto yy451;
			goto yy534;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy300;
			goto yy451;
		} else {
			if (yych <= 'n') goto yy534;
			if (yych <= 'z') goto yy451;
			goto yy300;
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy451;
			goto yy535;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 'k') goto yy535;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy300;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy300;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy534;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy300;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy300;
				goto yy457;
			} else {
				if (yych <= 'n') goto yy536;
				if (yych <= 'z') goto yy457;
				goto yy300;
			}
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy535;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 'k') goto yy537;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy451;
			goto yy538;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy451;
			if (yych <= '`') goto yy18;
			goto yy451;
		} else {
			if (yych <= 't') goto yy538;
			if (yych <= 'z') goto yy451;
			goto yy18;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy451;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy538;
			if (yych <= 'Z') goto yy451;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy457;
			} else {
				if (yych <= 't') goto yy539;
				if (yych <= 'z') goto yy457;
				goto yy18;
			}
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy424;
	if (yych == 'c') goto yy424;
	goto yy56;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy540;
				} else {
					if (yych == 'D') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy187;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy18;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy541;
				} else {
					if (yych == 'D') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy187;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy18;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy109;
	goto yy18;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy541;
	goto yy187;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy542;
	goto yy56;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy543;
	goto yy56;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy544;
	if (yych <= '3') goto yy546;
	if (yych <= '9') goto yy547;
	goto yy56;
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy425;
	if (yych == 'p') goto yy425;
	goto yy56;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy548;
	if (yych <= '6') goto yy549;
	if (yych <= '9') goto yy550;
	goto yy56;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy551;
	if (yych <= '6') goto yy552;
	if (yych <= '9') goto yy553;
	goto yy56;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy554;
	goto yy56;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy555;
	goto yy56;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy555;
	goto yy56;
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy555;
	goto yy56;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy556;
	if (yych == 'r') goto yy556;
	goto yy56;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy556;
	if (yych == 'g') goto yy556;
	goto yy56;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy556;
	if (yych == 'c') goto yy556;
	goto yy56;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy556;
	if (yych == 'b') goto yy556;
	goto yy56;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy556;
	if (yych == 'n') goto yy556;
	goto yy56;
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy556;
		if (yych <= 'M') goto yy56;
		goto yy556;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy556;
		} else {
			if (yych == 'n') goto yy556;
			goto yy56;
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy556;
		if (yych <= 'X') goto yy56;
		goto yy556;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy556;
		} else {
			if (yych == 'y') goto yy556;
			goto yy56;
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy556;
	if (yych == 'v') goto yy556;
	goto yy56;
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy556;
	if (yych == 't') goto yy556;
	goto yy56;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy557;
	if (yych == 'p') goto yy557;
	goto yy56;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy377;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy558;
		goto yy56;
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy377;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '2') goto yy558;
		goto yy56;
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy559;
	case '1':	goto yy560;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy441;
	case 'A':
	case 'a':	goto yy442;
	case 'D':
	case 'd':	goto yy443;
	case 'F':
	case 'f':	goto yy444;
	case 'J':
	case 'j':	goto yy445;
	case 'M':
	case 'm':	goto yy446;
	case 'N':
	case 'n':	goto yy447;
	case 'O':
	case 'o':	goto yy448;
	case 'S':
	case 's':	goto yy449;
	default:	goto yy56;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy562;
				} else {
					if (yych <= ' ') goto yy562;
					if (yych >= '-') goto yy563;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy564;
					if (yych <= '/') goto yy565;
					goto yy566;
				} else {
					if (yych <= '1') goto yy567;
					if (yych <= '2') goto yy568;
					goto yy569;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy570;
					if (yych <= '6') goto yy571;
					goto yy57;
				} else {
					if (yych <= ':') goto yy572;
					if (yych >= 'A') goto yy562;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy562;
				} else {
					if (yych == 'G') goto yy401;
					if (yych <= 'J') goto yy562;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy562;
					if (yych >= 'S') goto yy562;
				} else {
					if (yych <= 'W') goto yy584;
					if (yych <= 'Y') goto yy562;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy562;
					if (yych >= 'd') goto yy562;
				} else {
					if (yych == 'f') goto yy562;
					if (yych >= 'h') goto yy562;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy562;
				} else {
					if (yych <= 'o') goto yy562;
					if (yych >= 's') goto yy562;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy562;
				} else {
					if (yych <= 'y') goto yy562;
					if (yych == 0xC2) goto yy562;
				}
			}
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
#line 1252 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 10414 "lib/parse_date.c"
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy562;
				} else {
					if (yych <= ' ') goto yy562;
					if (yych >= '-') goto yy563;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy564;
					if (yych <= '/') goto yy565;
					goto yy586;
				} else {
					if (yych <= '1') goto yy587;
					if (yych <= '2') goto yy588;
					goto yy589;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy57;
					if (yych <= ':') goto yy572;
				} else {
					if (yych <= 'A') goto yy562;
					if (yych >= 'D') goto yy562;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy562;
				} else {
					if (yych <= 'J') goto yy562;
					if (yych >= 'M') goto yy562;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy403;
					if (yych <= 'V') goto yy562;
					goto yy584;
				} else {
					if (yych <= 'Y') goto yy562;
					if (yych >= 'a') goto yy562;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy562;
				} else {
					if (yych != 'g') goto yy562;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy562;
				} else {
					if (yych <= 'o') goto yy562;
					if (yych >= 's') goto yy562;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy562;
				} else {
					if (yych <= 'y') goto yy562;
					if (yych == 0xC2) goto yy562;
				}
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
#line 1634 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 10503 "lib/parse_date.c"
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'I') goto yy590;
			if (yych == 'i') goto yy590;
			goto yy78;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'U') goto yy591;
			if (yych == 'u') goto yy591;
			goto yy78;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy592;
	if (yych == 's') goto yy592;
	goto yy250;
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'E') goto yy593;
			if (yych == 'e') goto yy593;
			goto yy78;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'R') goto yy594;
			if (yych == 'r') goto yy594;
			goto yy78;
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy595;
	if (yych == 't') goto yy595;
	goto yy56;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy596;
	if (yych == 'd') goto yy596;
	goto yy250;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy406;
	if (yych == 'r') goto yy406;
	goto yy56;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy597;
	goto yy241;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'U') goto yy598;
			if (yych == 'u') goto yy598;
			goto yy78;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'Y') goto yy243;
			if (yych == 'y') goto yy243;
			goto yy78;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'E') goto yy243;
			if (yych == 'e') goto yy243;
			goto yy78;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'C') goto yy599;
			if (yych == 'c') goto yy599;
			goto yy78;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy600;
	if (yych == 'r') goto yy600;
	goto yy56;
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy601;
	if (yych == 'l') goto yy601;
	goto yy56;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy592;
		if (yych <= 'T') goto yy250;
		goto yy602;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy250;
			goto yy592;
		} else {
			if (yych == 'u') goto yy602;
			goto yy250;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy596;
		if (yych <= 'S') goto yy250;
		goto yy603;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy250;
			goto yy596;
		} else {
			if (yych == 't') goto yy603;
			goto yy250;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy406;
	if (yych == 'c') goto yy406;
	goto yy56;
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'O') goto yy604;
			if (yych == 'o') goto yy604;
			goto yy78;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy605;
	if (yych == 'u') goto yy605;
	goto yy250;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy606;
		if (yych <= 'R') goto yy250;
		goto yy592;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy250;
			goto yy606;
		} else {
			if (yych == 's') goto yy592;
			goto yy250;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy78;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy78;
			goto yy238;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy240;
			goto yy78;
		} else {
			if (yych <= 'T') goto yy407;
			if (yych == 't') goto yy407;
			goto yy78;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy607;
	if (yych == 'r') goto yy607;
	goto yy250;
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy608;
	if (yych == 's') goto yy608;
	goto yy250;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy609;
	if (yych == 'n') goto yy609;
	goto yy250;
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy610;
	if (yych == 'k') goto yy610;
	goto yy56;
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy611;
	if (yych <= '1') goto yy612;
	if (yych <= '9') goto yy613;
	goto yy197;
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy614;
	if (yych <= '6') goto yy615;
	if (yych <= '9') goto yy550;
	goto yy56;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy616;
			if (yych <= 0x1F) goto yy209;
			goto yy616;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy209;
				goto yy377;
			} else {
				if (yych <= '.') goto yy431;
				if (yych <= '9') goto yy209;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy102;
			if (yych <= 'O') goto yy209;
			goto yy102;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy102;
			} else {
				if (yych == 'p') goto yy102;
				goto yy209;
			}
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy618;
	if (yych <= '6') goto yy619;
	if (yych <= '9') goto yy553;
	goto yy56;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy616;
			if (yych <= 0x1F) goto yy209;
			goto yy616;
		} else {
			if (yych == '.') goto yy433;
			if (yych <= '9') goto yy209;
			goto yy433;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy102;
			if (yych <= 'O') goto yy209;
			goto yy102;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy102;
			} else {
				if (yych == 'p') goto yy102;
				goto yy209;
			}
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy616;
			if (yych <= 0x1F) goto yy209;
			goto yy616;
		} else {
			if (yych == '.') goto yy433;
			if (yych <= '9') goto yy209;
			goto yy620;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy102;
			if (yych <= 'O') goto yy209;
			goto yy102;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy102;
			} else {
				if (yych == 'p') goto yy102;
				goto yy209;
			}
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(437, *YYCURSOR);
#line 1189 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 11013 "lib/parse_date.c"
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy436;
		if (yych <= 0x08) goto yy56;
		goto yy436;
	} else {
		if (yych == ' ') goto yy436;
		goto yy56;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy621;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy622;
	goto yy56;
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy621;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy622;
	goto yy56;
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy621;
	goto yy56;
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy623;
		if (yych <= 'T') goto yy56;
		goto yy624;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy623;
		} else {
			if (yych == 'u') goto yy624;
			goto yy56;
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy625;
	if (yych == 'e') goto yy625;
	goto yy56;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy626;
	if (yych == 'e') goto yy626;
	goto yy56;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy627;
		if (yych <= 'T') goto yy56;
		goto yy628;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy627;
		} else {
			if (yych == 'u') goto yy628;
			goto yy56;
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy629;
	if (yych == 'a') goto yy629;
	goto yy56;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy630;
	if (yych == 'o') goto yy630;
	goto yy56;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy631;
	if (yych == 'c') goto yy631;
	goto yy56;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy632;
	if (yych == 'e') goto yy632;
	goto yy56;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy633;
	goto yy56;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy634;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy634;
		goto yy18;
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy136;
	if (yych <= '2') goto yy635;
	if (yych <= '3') goto yy636;
	goto yy136;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy634;
			goto yy637;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'l') goto yy637;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy634;
			goto yy638;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 's') goto yy638;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(456, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy455;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy18;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy18;
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy634;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy639;
			goto yy18;
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy455;
	}
	if (yych <= '/') goto yy136;
	if (yych <= '2') goto yy635;
	if (yych <= '3') goto yy636;
	goto yy136;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy637;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'l') goto yy640;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy638;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 's') goto yy641;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy642;
		if (yych <= '(') goto yy18;
		goto yy109;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			goto yy634;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy642;
			goto yy18;
		} else {
			if (yych <= ')') goto yy109;
			if (yych == '-') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy282;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy634;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy639;
			goto yy18;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy634;
			goto yy643;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'm') goto yy643;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy643;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'm') goto yy644;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy634;
			goto yy645;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 't') goto yy645;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy634;
			goto yy646;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'e') goto yy646;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy645;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 't') goto yy647;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy646;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'e') goto yy648;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy634;
			goto yy649;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'u') goto yy649;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy634;
			goto yy650;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'h') goto yy650;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy634;
			goto yy651;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 't') goto yy651;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy634;
			goto yy652;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 't') goto yy652;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy653;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy634;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy653;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy634;
			goto yy654;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 't') goto yy654;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy649;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'u') goto yy655;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy650;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'h') goto yy656;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy651;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 't') goto yy657;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy652;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 't') goto yy658;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy653;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy659;
			if (yych <= 'z') goto yy639;
			goto yy18;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy654;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 't') goto yy660;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy661;
	if (yych <= '2') goto yy662;
	if (yych <= '9') goto yy663;
	goto yy56;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy664;
		goto yy56;
	} else {
		if (yych <= '0') goto yy665;
		if (yych <= '9') goto yy485;
		if (yych <= ':') goto yy664;
		goto yy56;
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy56;
	} else {
		if (yych <= '2') goto yy485;
		if (yych <= '9') goto yy665;
		if (yych <= ':') goto yy666;
		goto yy56;
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy56;
	} else {
		if (yych <= '4') goto yy665;
		if (yych == ':') goto yy666;
		goto yy56;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy666;
	if (yych == ':') goto yy666;
	goto yy56;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy667;
	if (yych <= '2') goto yy668;
	if (yych <= '9') goto yy665;
	goto yy56;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy664;
		goto yy310;
	} else {
		if (yych <= '0') goto yy669;
		if (yych <= '9') goto yy670;
		if (yych <= ':') goto yy664;
		goto yy310;
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy310;
	} else {
		if (yych <= '2') goto yy670;
		if (yych <= '9') goto yy669;
		if (yych <= ':') goto yy666;
		goto yy310;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy310;
	} else {
		if (yych <= '4') goto yy669;
		if (yych <= '9') goto yy671;
		if (yych <= ':') goto yy666;
		goto yy310;
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy310;
	} else {
		if (yych <= '9') goto yy671;
		if (yych <= ':') goto yy666;
		goto yy310;
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy672;
	goto yy56;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy309;
	goto yy312;
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy674;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy634;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy674;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy280;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy280;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy280;
			if (yych <= '9') goto yy136;
			goto yy280;
		} else {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy280;
			if (yych <= 'z') goto yy634;
			goto yy280;
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy674;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy675;
			if (yych <= 'z') goto yy639;
			goto yy18;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy280;
			goto yy136;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy280;
				goto yy109;
			} else {
				if (yych <= ',') goto yy280;
				if (yych <= '-') goto yy676;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy282;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy280;
			goto yy634;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy280;
				goto yy282;
			} else {
				if (yych <= '`') goto yy280;
				if (yych <= 'z') goto yy639;
				goto yy280;
			}
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy677;
		} else {
			if (yych == ' ') goto yy679;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy634;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy677;
			if (yych <= 0x1F) goto yy18;
			goto yy679;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy282;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy634;
			goto yy637;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'h') goto yy637;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy634;
			goto yy680;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'i') goto yy680;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy637;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'h') goto yy640;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy680;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'i') goto yy681;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy677;
		} else {
			if (yych == ' ') goto yy677;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy634;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
	} else {
		if (yych <= 'Z') goto yy634;
		if (yych <= '`') goto yy505;
		if (yych <= 'z') goto yy634;
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
#line 1039 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12247 "lib/parse_date.c"
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy677;
			if (yych <= 0x1F) goto yy18;
			goto yy677;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy282;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy505;
		} else {
			if (yych == '.') goto yy505;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy505;
			if (yych <= 'Z') goto yy634;
			goto yy505;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy505;
			if (yych <= 'z') goto yy639;
			goto yy505;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy634;
			goto yy682;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'b') goto yy682;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy682;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'b') goto yy683;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy634;
			goto yy684;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'i') goto yy684;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy684;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'i') goto yy685;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy634;
			goto yy686;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'r') goto yy686;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy634;
			goto yy687;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'n') goto yy687;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy280;
			} else {
				if (yych <= '-') goto yy452;
				if (yych <= '.') goto yy136;
				goto yy280;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy136;
				goto yy280;
			} else {
				if (yych == 'E') goto yy688;
				goto yy634;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy280;
				goto yy634;
			} else {
				if (yych <= 'e') goto yy688;
				if (yych <= 'z') goto yy634;
				goto yy280;
			}
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy634;
			goto yy689;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'n') goto yy689;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy686;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'r') goto yy690;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy687;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'n') goto yy691;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy280;
				goto yy136;
			} else {
				if (yych == ' ') goto yy136;
				goto yy280;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy109;
				if (yych <= ',') goto yy280;
				goto yy458;
			} else {
				if (yych == '/') goto yy282;
				goto yy136;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy280;
				goto yy634;
			} else {
				if (yych <= 'E') goto yy688;
				if (yych <= 'Z') goto yy634;
				goto yy280;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy280;
				goto yy639;
			} else {
				if (yych <= 'e') goto yy692;
				if (yych <= 'z') goto yy639;
				goto yy280;
			}
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy689;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'n') goto yy693;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy694;
	goto yy56;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy634;
			goto yy650;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'd') goto yy650;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy634;
			goto yy686;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 's') goto yy686;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy634;
			goto yy695;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'y') goto yy695;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy634;
			goto yy697;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'r') goto yy697;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy634;
			goto yy698;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'd') goto yy698;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy634;
			goto yy689;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'f') goto yy689;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy650;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'd') goto yy656;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy686;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 's') goto yy690;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy695;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'y') goto yy699;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy697;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'r') goto yy700;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy698;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'd') goto yy701;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy689;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'f') goto yy693;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy136;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy634;
			goto yy702;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'e') goto yy702;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy634;
			goto yy703;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'd') goto yy703;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy702;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'e') goto yy704;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy703;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'd') goto yy705;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy634;
			goto yy706;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy634;
			if (yych <= '`') goto yy18;
			goto yy634;
		} else {
			if (yych <= 'e') goto yy706;
			if (yych <= 'z') goto yy634;
			goto yy18;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy634;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy706;
			if (yych <= 'Z') goto yy634;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy639;
			} else {
				if (yych <= 'e') goto yy707;
				if (yych <= 'z') goto yy639;
				goto yy18;
			}
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy18;
				goto yy187;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy18;
					goto yy708;
				} else {
					if (yych <= '/') goto yy18;
					if (yych <= '9') goto yy709;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy187;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy187;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych <= 'c') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy18;
				}
			}
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy708;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy709;
	goto yy187;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy710;
	goto yy56;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy711;
	goto yy56;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy713;
		if (yych >= 'n') goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
#line 1386 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 13307 "lib/parse_date.c"
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy545;
			goto yy713;
		} else {
			if (yych <= '9') goto yy710;
			if (yych <= 'm') goto yy545;
			goto yy714;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy710;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy718;
	goto yy209;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy717;
		goto yy209;
	} else {
		if (yych <= '0') goto yy718;
		if (yych <= '9') goto yy711;
		goto yy209;
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy711;
	goto yy209;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy553;
	goto yy209;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych != '0') goto yy209;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	goto yy209;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy719;
	goto yy214;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy383;
	goto yy214;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy720;
	goto yy56;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy720;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy556;
		if (yych == 't') goto yy556;
		goto yy56;
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy721;
	if (yych <= '.') goto yy377;
	goto yy56;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy621;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy441;
	goto yy56;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy621;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy441;
	goto yy56;
yy561:
	YYDEBUG(561, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy562:
	YYDEBUG(562, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy561;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy561;
					if (yych <= ',') goto yy56;
					goto yy722;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy573;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy574;
					if (yych == 'F') goto yy575;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy76;
					if (yych <= 'I') goto yy576;
					goto yy578;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy579;
					goto yy580;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy581;
					if (yych <= 'R') goto yy56;
					goto yy582;
				} else {
					if (yych <= 'T') goto yy84;
					if (yych <= 'U') goto yy85;
					if (yych <= 'V') goto yy583;
					goto yy87;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy585;
					if (yych <= 'Y') goto yy89;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy573;
					if (yych <= 'c') goto yy56;
					goto yy574;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy575;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy76;
					if (yych == 'j') goto yy578;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy579;
					if (yych <= 'n') goto yy580;
					goto yy581;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy582;
					if (yych <= 't') goto yy84;
					goto yy85;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy87;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy89;
					if (yych == 0xC2) goto yy94;
					goto yy56;
				}
			}
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy724;
	case '1':	goto yy726;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy727;
	case 'A':
	case 'a':	goto yy728;
	case 'D':
	case 'd':	goto yy729;
	case 'F':
	case 'f':	goto yy730;
	case 'J':
	case 'j':	goto yy731;
	case 'M':
	case 'm':	goto yy732;
	case 'N':
	case 'n':	goto yy733;
	case 'O':
	case 'o':	goto yy734;
	case 'S':
	case 's':	goto yy735;
	case 'W':	goto yy736;
	default:	goto yy723;
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy723;
	if (yych <= '0') goto yy737;
	if (yych <= '2') goto yy738;
	if (yych <= '3') goto yy739;
	goto yy723;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy744;
	if (yych <= '1') goto yy745;
	if (yych <= '9') goto yy746;
	goto yy56;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '0') goto yy747;
	if (yych <= '9') goto yy749;
	goto yy187;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '2') goto yy749;
	if (yych <= '9') goto yy750;
	goto yy187;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy750;
	goto yy187;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '5') goto yy750;
	if (yych <= '6') goto yy751;
	if (yych <= '9') goto yy752;
	goto yy187;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy752;
	goto yy187;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '0') goto yy752;
	if (yych <= '9') goto yy57;
	goto yy187;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy753;
	if (yych <= '1') goto yy754;
	goto yy56;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy755;
		if (yych <= 'T') goto yy56;
		goto yy756;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy755;
		} else {
			if (yych == 'u') goto yy756;
			goto yy56;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy232;
		if (yych <= 'D') goto yy56;
		goto yy757;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy232;
		} else {
			if (yych == 'e') goto yy757;
			goto yy56;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy758;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy235;
			if (yych <= 'Q') goto yy56;
			goto yy236;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy758;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy235;
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy759;
	} else {
		if (yych == 'W') goto yy577;
		if (yych <= 'X') goto yy760;
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
#line 1455 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 13720 "lib/parse_date.c"
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy761;
		if (yych <= 'T') goto yy56;
		goto yy762;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy761;
		} else {
			if (yych == 'u') goto yy762;
			goto yy56;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy763;
			if (yych <= 'H') goto yy56;
			goto yy247;
		} else {
			if (yych == 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy763;
			if (yych <= 'h') goto yy56;
			goto yy247;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy248;
			} else {
				if (yych == 's') goto yy249;
				goto yy56;
			}
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy764;
	if (yych == 'o') goto yy764;
	goto yy56;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy765;
	if (yych == 'c') goto yy765;
	goto yy56;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy766;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy766;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy585;
	goto yy577;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy767;
		if (yych <= '4') goto yy768;
		goto yy769;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy259;
		} else {
			if (yych == 'e') goto yy259;
			goto yy56;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy759;
	goto yy577;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '0') goto yy770;
	if (yych <= '9') goto yy771;
	goto yy187;
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '2') goto yy771;
	if (yych <= '9') goto yy772;
	goto yy187;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy772;
	goto yy187;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '5') goto yy772;
	if (yych <= '6') goto yy773;
	if (yych <= '9') goto yy57;
	goto yy187;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy243;
	if (yych == 'l') goto yy243;
	goto yy56;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy774;
	if (yych == 's') goto yy774;
	goto yy56;
yy592:
	YYDEBUG(592, *YYCURSOR);
	++YYCURSOR;
	goto yy250;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy604;
	if (yych == 'm') goto yy604;
	goto yy56;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy598;
	if (yych == 'u') goto yy598;
	goto yy56;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy775;
		if (yych <= 'M') goto yy56;
		goto yy776;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy775;
		} else {
			if (yych == 'n') goto yy776;
			goto yy56;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy777;
	if (yych == 'a') goto yy777;
	goto yy56;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy778;
	goto yy241;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy779;
	if (yych == 'a') goto yy779;
	goto yy56;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy243;
	if (yych == 'h') goto yy243;
	goto yy56;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy780;
	if (yych == 'o') goto yy780;
	goto yy56;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy780;
	if (yych == 'i') goto yy780;
	goto yy56;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy781;
	if (yych == 't') goto yy781;
	goto yy56;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy406;
	if (yych == 'h') goto yy406;
	goto yy56;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy782;
	if (yych == 'b') goto yy782;
	goto yy56;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy608;
	if (yych == 'r') goto yy608;
	goto yy56;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy783;
	if (yych == 'n') goto yy783;
	goto yy56;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy608;
	if (yych != 's') goto yy56;
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy596;
	if (yych == 'd') goto yy596;
	goto yy56;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy607;
	if (yych == 'e') goto yy607;
	goto yy56;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy188;
		if (yych <= 'R') goto yy250;
		goto yy592;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy250;
			goto yy188;
		} else {
			if (yych == 's') goto yy592;
			goto yy250;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy377;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy613;
	goto yy56;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy377;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy377;
	goto yy56;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy784;
	goto yy209;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy717;
		goto yy209;
	} else {
		if (yych <= '0') goto yy784;
		if (yych <= '9') goto yy711;
		goto yy209;
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(617, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy616;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy616;
			if (yych <= '@') goto yy56;
			goto yy102;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy102;
			goto yy56;
		} else {
			if (yych <= 'a') goto yy102;
			if (yych == 'p') goto yy102;
			goto yy56;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy785;
	goto yy209;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych == '0') goto yy785;
	goto yy209;
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy786;
	if (yych <= '6') goto yy787;
	if (yych <= '9') goto yy553;
	goto yy56;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy788;
	if (yych <= '3') goto yy789;
	if (yych <= '9') goto yy790;
	goto yy56;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy791;
	goto yy56;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy792;
	if (yych == 'r') goto yy792;
	goto yy56;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy792;
	if (yych == 'g') goto yy792;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy792;
	if (yych == 'c') goto yy792;
	goto yy56;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy792;
	if (yych == 'b') goto yy792;
	goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy792;
	if (yych == 'n') goto yy792;
	goto yy56;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy792;
		if (yych <= 'M') goto yy56;
		goto yy792;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy792;
		} else {
			if (yych == 'n') goto yy792;
			goto yy56;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy792;
		if (yych <= 'X') goto yy56;
		goto yy792;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy792;
		} else {
			if (yych == 'y') goto yy792;
			goto yy56;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy792;
	if (yych == 'v') goto yy792;
	goto yy56;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy792;
	if (yych == 't') goto yy792;
	goto yy56;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy793;
	if (yych == 'p') goto yy793;
	goto yy56;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy794;
	goto yy56;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy795;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy795;
		goto yy18;
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy796;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy311;
				goto yy56;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy796;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy317;
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy280;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy280;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy280;
			if (yych <= '9') goto yy136;
			goto yy280;
		} else {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy280;
			if (yych <= 'z') goto yy795;
			goto yy280;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy795;
			goto yy797;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 't') goto yy797;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy798;
			goto yy18;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy136;
			if (yych <= 0x1F) goto yy280;
			goto yy136;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy280;
				goto yy109;
			} else {
				if (yych <= ',') goto yy280;
				if (yych <= '-') goto yy676;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy282;
			if (yych <= '9') goto yy136;
			if (yych <= '@') goto yy280;
			goto yy795;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy280;
				goto yy282;
			} else {
				if (yych <= '`') goto yy280;
				if (yych <= 'z') goto yy798;
				goto yy280;
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy797;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 't') goto yy799;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy800;
	if (yych == 'o') goto yy800;
	goto yy56;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy795;
			goto yy801;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'b') goto yy801;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy801;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'b') goto yy802;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy803;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy803;
			if (yych == ')') goto yy109;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy805;
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych == 'h') goto yy805;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy795;
			goto yy806;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'n') goto yy806;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy803;
			} else {
				if (yych == ' ') goto yy803;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy109;
				goto yy18;
			} else {
				if (yych == '.') goto yy18;
				goto yy282;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy18;
				goto yy795;
			} else {
				if (yych <= 'H') goto yy805;
				if (yych <= 'Z') goto yy795;
				goto yy18;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy282;
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'h') goto yy807;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy806;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'n') goto yy808;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy809;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy809;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy803;
		} else {
			if (yych == ' ') goto yy803;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy795;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy803;
		} else {
			if (yych == ' ') goto yy810;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy109;
			if (yych <= '@') goto yy18;
			goto yy795;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy795;
			goto yy805;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'h') goto yy805;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy795;
			goto yy811;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'y') goto yy811;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy642;
		if (yych <= '(') goto yy18;
		goto yy109;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			goto yy795;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy809;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy812;
			if (yych <= 'z') goto yy798;
			goto yy18;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy803;
			if (yych <= 0x1F) goto yy18;
			goto yy803;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy282;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy803;
			if (yych <= 0x1F) goto yy18;
			goto yy810;
		} else {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy282;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy805;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'h') goto yy807;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy811;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'y') goto yy813;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy642;
			goto yy18;
		} else {
			if (yych <= ')') goto yy109;
			if (yych == '-') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy282;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy798;
			goto yy18;
		}
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy663;
	if (yych <= ':') goto yy193;
	goto yy18;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy18;
		if (yych >= '5') goto yy375;
	} else {
		if (yych <= '9') goto yy109;
		if (yych <= ':') goto yy193;
		goto yy18;
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy375;
	if (yych <= '9') goto yy109;
	if (yych <= ':') goto yy193;
	goto yy18;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy814;
	if (yych <= '9') goto yy816;
	goto yy56;
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy664;
	if (yych == ':') goto yy664;
	goto yy56;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy817;
	if (yych <= '9') goto yy818;
	goto yy56;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy664;
		goto yy56;
	} else {
		if (yych <= '9') goto yy665;
		if (yych <= ':') goto yy664;
		goto yy56;
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy664;
		goto yy56;
	} else {
		if (yych <= '4') goto yy665;
		if (yych == ':') goto yy664;
		goto yy56;
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy664;
		goto yy310;
	} else {
		if (yych <= '9') goto yy819;
		if (yych <= ':') goto yy664;
		goto yy310;
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy666;
		goto yy310;
	} else {
		if (yych <= '9') goto yy819;
		if (yych <= ':') goto yy666;
		goto yy310;
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy310;
	if (yych <= '9') goto yy819;
	goto yy310;
yy672:
	YYDEBUG(672, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(673, *YYCURSOR);
#line 1441 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15024 "lib/parse_date.c"
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy795;
			goto yy820;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'r') goto yy820;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy820;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'r') goto yy821;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy455;
	}
	goto yy136;
yy677:
	YYDEBUG(677, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy678:
	YYDEBUG(678, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy677;
				if (yych <= 0x1F) goto yy56;
				goto yy677;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy822;
				} else {
					if (yych == 'F') goto yy823;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy824;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy825;
					if (yych <= 'R') goto yy56;
					goto yy826;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy827;
					goto yy828;
				} else {
					if (yych == 'W') goto yy829;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy830;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy822;
					if (yych <= 'e') goto yy56;
					goto yy823;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy824;
				} else {
					if (yych == 'm') goto yy825;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy826;
					goto yy827;
				} else {
					if (yych <= 'u') goto yy828;
					if (yych <= 'v') goto yy56;
					goto yy829;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy830;
				} else {
					if (yych == 0xC2) goto yy831;
					goto yy56;
				}
			}
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy832;
	if (yych == 'd') goto yy832;
	goto yy678;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy795;
			goto yy833;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'g') goto yy833;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy833;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'g') goto yy834;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy795;
			goto yy835;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'e') goto yy835;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy835;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'e') goto yy836;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy795;
			goto yy837;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'o') goto yy837;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy837;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'o') goto yy838;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy795;
			goto yy839;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'd') goto yy839;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy795;
			goto yy805;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'd') goto yy805;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy795;
			goto yy840;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'm') goto yy840;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy795;
			goto yy841;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 't') goto yy841;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy839;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'd') goto yy842;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy805;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'd') goto yy807;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy840;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'm') goto yy843;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy841;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 't') goto yy844;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy401;
	if (yych <= '5') goto yy845;
	if (yych <= '6') goto yy846;
	goto yy401;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy109;
	} else {
		if (yych <= 'Z') goto yy795;
		if (yych <= '`') goto yy696;
		if (yych <= 'z') goto yy795;
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
#line 1051 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 15582 "lib/parse_date.c"
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy795;
			goto yy847;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'r') goto yy847;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy848;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy848;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy696;
		} else {
			if (yych == '.') goto yy696;
			goto yy282;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy696;
			if (yych <= 'Z') goto yy795;
			goto yy696;
		} else {
			if (yych <= '_') goto yy282;
			if (yych <= '`') goto yy696;
			if (yych <= 'z') goto yy798;
			goto yy696;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy847;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'r') goto yy849;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy848;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy850;
			if (yych <= 'z') goto yy798;
			goto yy18;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy795;
			goto yy851;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 's') goto yy851;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		if (yych <= '@') goto yy18;
		goto yy852;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy795;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy852;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy851;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 's') goto yy853;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy852;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy854;
			if (yych <= 'z') goto yy798;
			goto yy18;
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy109;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy795;
			goto yy855;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy795;
			if (yych <= '`') goto yy18;
			goto yy795;
		} else {
			if (yych <= 'r') goto yy855;
			if (yych <= 'z') goto yy795;
			goto yy18;
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy109;
			if (yych <= ',') goto yy18;
			goto yy282;
		} else {
			if (yych == '/') goto yy282;
			if (yych <= '@') goto yy18;
			goto yy795;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy855;
			if (yych <= 'Z') goto yy795;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy798;
			} else {
				if (yych <= 'r') goto yy856;
				if (yych <= 'z') goto yy798;
				goto yy18;
			}
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy857;
	if (yych <= '1') goto yy858;
	goto yy56;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy860;
	goto yy187;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy861;
	goto yy56;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy712;
	if (yych <= '9') goto yy861;
yy712:
	YYDEBUG(712, *YYCURSOR);
#line 1427 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 15896 "lib/parse_date.c"
yy713:
	YYDEBUG(713, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy861;
		if (yych <= 'm') goto yy545;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy862;
	goto yy56;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy862;
	goto yy56;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy862;
	goto yy56;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy863;
	goto yy56;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy861;
	goto yy209;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy865;
	goto yy214;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy866;
	goto yy56;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy867;
	if (yych <= '3') goto yy868;
	if (yych <= '9') goto yy547;
	goto yy56;
yy722:
	YYDEBUG(722, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy723:
	YYDEBUG(723, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy722;
	case 'A':
	case 'a':	goto yy573;
	case 'D':
	case 'd':	goto yy740;
	case 'F':
	case 'f':	goto yy741;
	case 'I':	goto yy576;
	case 'J':
	case 'j':	goto yy578;
	case 'M':
	case 'm':	goto yy742;
	case 'N':
	case 'n':	goto yy580;
	case 'O':
	case 'o':	goto yy581;
	case 'S':
	case 's':	goto yy743;
	case 'V':	goto yy583;
	case 'X':	goto yy585;
	default:	goto yy56;
	}
yy724:
	YYDEBUG(724, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy869;
	if (yych <= '/') goto yy725;
	if (yych <= '9') goto yy870;
yy725:
	YYDEBUG(725, *YYCURSOR);
#line 1372 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16018 "lib/parse_date.c"
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy869;
	if (yych <= '/') goto yy725;
	if (yych <= '2') goto yy870;
	goto yy725;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy869;
	goto yy725;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy871;
		if (yych <= 'T') goto yy56;
		goto yy872;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy871;
		} else {
			if (yych == 'u') goto yy872;
			goto yy56;
		}
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy873;
	if (yych == 'e') goto yy873;
	goto yy56;
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy874;
	if (yych == 'e') goto yy874;
	goto yy56;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy875;
		if (yych <= 'T') goto yy56;
		goto yy876;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy875;
		} else {
			if (yych == 'u') goto yy876;
			goto yy56;
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy877;
	if (yych == 'a') goto yy877;
	goto yy56;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy878;
	if (yych == 'o') goto yy878;
	goto yy56;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy879;
	if (yych == 'c') goto yy879;
	goto yy56;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy880;
	if (yych == 'e') goto yy880;
	goto yy56;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy767;
	if (yych <= '4') goto yy768;
	if (yych <= '5') goto yy769;
	goto yy56;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy881;
	if (yych <= '9') goto yy882;
	goto yy56;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy882;
	if (yych <= '6') goto yy883;
	goto yy56;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy757;
	if (yych == 'e') goto yy757;
	goto yy56;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy758;
	if (yych == 'e') goto yy758;
	goto yy56;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy763;
	if (yych == 'a') goto yy763;
	goto yy56;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy884;
	if (yych == 'e') goto yy884;
	goto yy56;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy885;
	if (yych <= '9') goto yy886;
	goto yy56;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy885;
	if (yych <= '2') goto yy886;
	goto yy56;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy885;
	goto yy56;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy187;
				} else {
					if (yych == ' ') goto yy187;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy887;
					goto yy888;
				} else {
					if (yych <= '3') goto yy890;
					if (yych <= '9') goto yy891;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
				} else {
					if (yych != 'G') goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy187;
				} else {
					if (yych <= 'R') goto yy748;
					if (yych <= 'U') goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych >= 'd') goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy187;
				} else {
					if (yych == 'h') goto yy187;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
				} else {
					if (yych != 'v') goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
				}
			}
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
#line 1298 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 16262 "lib/parse_date.c"
yy749:
	YYDEBUG(749, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy748;
				goto yy187;
			} else {
				if (yych <= '2') {
					if (yych <= '/') goto yy748;
					goto yy888;
				} else {
					if (yych <= '3') goto yy890;
					if (yych <= '9') goto yy891;
					goto yy748;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy187;
					goto yy748;
				} else {
					if (yych == 'G') goto yy748;
					goto yy187;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy748;
					goto yy187;
				} else {
					if (yych <= 'R') goto yy748;
					if (yych <= 'U') goto yy187;
					goto yy748;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy187;
					goto yy748;
				} else {
					if (yych <= 'Y') goto yy187;
					if (yych <= 'c') goto yy748;
					goto yy187;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy748;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy748;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy748;
				} else {
					if (yych == 'v') goto yy748;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy748;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy748;
				}
			}
		}
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy748;
				goto yy187;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy748;
					goto yy891;
				} else {
					if (yych == 'D') goto yy187;
					goto yy748;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy748;
				if (yych <= 'H') goto yy187;
				goto yy748;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy748;
				} else {
					if (yych == 'V') goto yy748;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy748;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy748;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy748;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy748;
				} else {
					if (yych == 'v') goto yy748;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy748;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy748;
				}
			}
		}
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy748;
				goto yy187;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy748;
					goto yy891;
				} else {
					if (yych <= '9') goto yy57;
					if (yych <= 'C') goto yy748;
					goto yy187;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy748;
					goto yy187;
				} else {
					if (yych == 'H') goto yy187;
					goto yy748;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy748;
				} else {
					if (yych == 'V') goto yy748;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy748;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy748;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy748;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy748;
				} else {
					if (yych == 'v') goto yy748;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy748;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy748;
				}
			}
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy748;
				goto yy187;
			} else {
				if (yych == 'D') goto yy187;
				if (yych <= 'E') goto yy748;
				goto yy187;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy187;
				if (yych <= 'L') goto yy748;
				goto yy187;
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy748;
					goto yy187;
				} else {
					if (yych == 'W') goto yy187;
					goto yy748;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy187;
				if (yych == 'd') goto yy187;
				goto yy748;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy187;
					goto yy748;
				} else {
					if (yych <= 'h') goto yy187;
					if (yych <= 'l') goto yy748;
					goto yy187;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy748;
				if (yych == 'v') goto yy748;
				goto yy187;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy748;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy748;
				}
			}
		}
	}
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy892;
	goto yy56;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy892;
	goto yy56;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy893;
	if (yych == 'r') goto yy893;
	goto yy56;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy894;
	if (yych == 'g') goto yy894;
	goto yy56;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy895;
	if (yych == 'c') goto yy895;
	goto yy56;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy896;
	if (yych == 'b') goto yy896;
	goto yy56;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy577;
yy760:
	YYDEBUG(760, *YYCURSOR);
	++YYCURSOR;
	goto yy577;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy897;
	if (yych == 'n') goto yy897;
	goto yy56;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy898;
		if (yych <= 'M') goto yy56;
		goto yy899;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy898;
		} else {
			if (yych == 'n') goto yy899;
			goto yy56;
		}
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy900;
		if (yych <= 'X') goto yy56;
		goto yy760;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy900;
		} else {
			if (yych == 'y') goto yy760;
			goto yy56;
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy895;
	if (yych == 'v') goto yy895;
	goto yy56;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy901;
	if (yych == 't') goto yy901;
	goto yy56;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy424;
		if (yych <= 'O') goto yy56;
		goto yy902;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy424;
		} else {
			if (yych == 'p') goto yy902;
			goto yy56;
		}
	}
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy903;
	goto yy56;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy903;
	goto yy56;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '3') goto yy903;
	goto yy56;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy187;
		if (yych <= '0') goto yy887;
		goto yy888;
	} else {
		if (yych <= '3') goto yy890;
		if (yych <= '9') goto yy891;
		goto yy187;
	}
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '2') goto yy888;
	if (yych <= '3') goto yy890;
	if (yych <= '9') goto yy891;
	goto yy187;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy891;
	goto yy187;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '6') goto yy891;
	if (yych <= '9') goto yy57;
	goto yy187;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy243;
	if (yych == 't') goto yy243;
	goto yy56;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy776;
	if (yych != 'n') goto yy56;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy905;
	if (yych == 'i') goto yy905;
	goto yy56;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy592;
	if (yych == 'y') goto yy592;
	goto yy56;
yy778:
	YYDEBUG(778, *YYCURSOR);
	++YYCURSOR;
	goto yy241;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy906;
	if (yych == 'r') goto yy906;
	goto yy56;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy907;
	if (yych == 's') goto yy907;
	goto yy56;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy406;
	if (yych == 'e') goto yy406;
	goto yy56;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy908;
	if (yych == 'e') goto yy908;
	goto yy56;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy406;
	if (yych == 'd') goto yy406;
	goto yy56;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy616;
			if (yych <= 0x1F) goto yy209;
			goto yy616;
		} else {
			if (yych == '.') goto yy717;
			if (yych <= '/') goto yy209;
			goto yy861;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy102;
			if (yych <= 'O') goto yy209;
			goto yy102;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy102;
			} else {
				if (yych == 'p') goto yy102;
				goto yy209;
			}
		}
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy616;
			goto yy209;
		} else {
			if (yych <= ' ') goto yy616;
			if (yych == '.') goto yy717;
			goto yy209;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy102;
			if (yych == 'P') goto yy102;
			goto yy209;
		} else {
			if (yych <= 'a') goto yy102;
			if (yych == 'p') goto yy102;
			goto yy209;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy909;
	goto yy209;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy717;
	if (yych == '0') goto yy909;
	goto yy209;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy790;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '1') goto yy790;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy714;
		goto yy545;
	} else {
		if (yych <= 'r') goto yy714;
		if (yych <= 's') goto yy715;
		if (yych <= 't') goto yy716;
		goto yy545;
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy910;
	if (yych <= '3') goto yy911;
	if (yych <= '9') goto yy790;
	goto yy56;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy912;
	goto yy56;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy912;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy792;
		if (yych == 't') goto yy792;
		goto yy56;
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy913;
	goto yy56;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy109;
	goto yy18;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy309;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy311;
				if (yych <= 0x1F) goto yy56;
				goto yy311;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy311;
				goto yy914;
			} else {
				if (yych <= '.') goto yy311;
				if (yych <= '/') goto yy56;
				goto yy491;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy311;
			} else {
				if (yych == 'h') goto yy311;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy314;
				if (yych <= 'q') goto yy56;
				goto yy314;
			} else {
				if (yych <= 's') goto yy315;
				if (yych <= 't') goto yy316;
				goto yy56;
			}
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy280;
			goto yy136;
		} else {
			if (yych == ' ') goto yy136;
			goto yy280;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy109;
			if (yych <= ',') goto yy280;
			goto yy136;
		} else {
			if (yych <= '/') goto yy280;
			if (yych <= '9') goto yy136;
			goto yy280;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy109;
		if (yych <= ',') goto yy18;
		goto yy282;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy18;
			goto yy282;
		} else {
			if (yych == '_') goto yy282;
			goto yy18;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy280;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych == ')') goto yy109;
			goto yy280;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy676;
			if (yych <= '.') goto yy136;
			goto yy282;
		} else {
			if (yych <= '9') goto yy136;
			if (yych == '_') goto yy282;
			goto yy280;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy917;
	if (yych == 'f') goto yy917;
	goto yy56;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy918;
		if (yych == 'e') goto yy918;
		goto yy18;
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy918;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'e') goto yy919;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy804:
	YYDEBUG(804, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy803;
				if (yych <= 0x1F) goto yy56;
				goto yy803;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy822;
				} else {
					if (yych == 'F') goto yy823;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy824;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy825;
					if (yych <= 'R') goto yy56;
					goto yy826;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy827;
					goto yy828;
				} else {
					if (yych == 'W') goto yy920;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy830;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy822;
					if (yych <= 'e') goto yy56;
					goto yy823;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy824;
				} else {
					if (yych == 'm') goto yy825;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy826;
					goto yy827;
				} else {
					if (yych <= 'u') goto yy828;
					if (yych <= 'v') goto yy56;
					goto yy920;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy830;
				} else {
					if (yych == 0xC2) goto yy831;
					goto yy56;
				}
			}
		}
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy803;
		goto yy18;
	} else {
		if (yych <= ' ') goto yy803;
		if (yych == ')') goto yy109;
		goto yy18;
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy921;
		if (yych == 't') goto yy921;
		goto yy18;
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy803;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy803;
			if (yych <= '(') goto yy18;
			goto yy109;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy282;
			goto yy18;
		} else {
			if (yych <= '/') goto yy282;
			if (yych == '_') goto yy282;
			goto yy18;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy921;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 't') goto yy922;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy923;
		if (yych == 'r') goto yy923;
		goto yy18;
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy832;
	if (yych == 'd') goto yy832;
	goto yy804;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy109;
	goto yy300;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy923;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'r') goto yy924;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy109;
		if (yych <= ',') goto yy300;
		goto yy282;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy300;
			goto yy282;
		} else {
			if (yych == '_') goto yy282;
			goto yy300;
		}
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy925;
	} else {
		if (yych <= '9') goto yy816;
		if (yych <= ':') goto yy925;
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
#line 1771 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 17345 "lib/parse_date.c"
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy925;
	if (yych == ':') goto yy925;
	goto yy815;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy926;
		goto yy815;
	} else {
		if (yych <= '9') goto yy927;
		if (yych <= ':') goto yy926;
		goto yy815;
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy926;
	if (yych == ':') goto yy926;
	goto yy815;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy310;
	if (yych <= '9') goto yy928;
	goto yy310;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy929;
		if (yych == 'y') goto yy929;
		goto yy18;
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy929;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'y') goto yy930;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy931;
	if (yych == 'a') goto yy931;
	goto yy56;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy932;
		if (yych <= 'Q') goto yy56;
		goto yy933;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy932;
		} else {
			if (yych == 'r') goto yy933;
			goto yy56;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy934;
	if (yych == 'o') goto yy934;
	goto yy56;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy935;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy936;
			if (yych <= 'R') goto yy56;
			goto yy937;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy935;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy936;
			if (yych == 's') goto yy937;
			goto yy56;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy939;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy940;
			if (yych <= 'T') goto yy56;
			goto yy941;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy939;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy940;
			if (yych == 'u') goto yy941;
			goto yy56;
		}
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy942;
		if (yych <= 'T') goto yy56;
		goto yy943;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy942;
		} else {
			if (yych == 'u') goto yy943;
			goto yy56;
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy944;
	if (yych == 's') goto yy944;
	goto yy56;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy945;
	if (yych == 'e') goto yy945;
	goto yy56;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy946;
	if (yych == 'e') goto yy946;
	goto yy56;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy947;
	goto yy56;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy948;
	if (yych == 'a') goto yy948;
	goto yy56;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy949;
		if (yych == 'h') goto yy949;
		goto yy18;
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy949;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'h') goto yy950;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy929;
		if (yych == 'r') goto yy929;
		goto yy18;
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy929;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'r') goto yy930;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy951;
		if (yych == 'u') goto yy951;
		goto yy18;
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy951;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'u') goto yy952;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy953;
		if (yych == 'a') goto yy953;
		goto yy18;
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'B') goto yy954;
		if (yych == 'b') goto yy954;
		goto yy18;
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy955;
		if (yych == 'h') goto yy955;
		goto yy18;
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy953;
			if (yych <= '^') goto yy18;
			goto yy282;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy956;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy954;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'b') goto yy957;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy955;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'h') goto yy958;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy959;
	goto yy56;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy959;
	goto yy56;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'O') goto yy960;
		if (yych == 'o') goto yy960;
		goto yy18;
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy961;
		if (yych == 'y') goto yy961;
		goto yy18;
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy960;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'o') goto yy962;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy961;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'y') goto yy963;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy851:
	YYDEBUG(851, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy964;
		if (yych == 'd') goto yy964;
		goto yy18;
	}
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy965;
		if (yych == 'y') goto yy965;
		goto yy18;
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy964;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'd') goto yy966;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy965;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'y') goto yy967;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy109;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy968;
		if (yych == 'd') goto yy968;
		goto yy18;
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy109;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy282;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy968;
			if (yych == '_') goto yy282;
			goto yy18;
		} else {
			if (yych == 'd') goto yy969;
			if (yych <= 'z') goto yy915;
			goto yy18;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy970;
	goto yy56;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy970;
	goto yy56;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy971;
	if (yych <= '1') goto yy972;
	goto yy56;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy973;
	goto yy187;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy974;
	goto yy56;
yy862:
	YYDEBUG(862, *YYCURSOR);
	++YYCURSOR;
	goto yy545;
yy863:
	YYDEBUG(863, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(864, *YYCURSOR);
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy863;
	goto yy209;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy976;
	goto yy214;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy977;
	goto yy56;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy978;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy868:
	YYDEBUG(868, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy545;
			goto yy978;
		} else {
			if (yych <= '9') goto yy710;
			if (yych <= 'm') goto yy545;
			goto yy714;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy980;
	if (yych <= '3') goto yy981;
	if (yych <= '9') goto yy982;
	goto yy56;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy983;
	goto yy725;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy984;
	if (yych == 'r') goto yy984;
	goto yy56;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy985;
	if (yych == 'g') goto yy985;
	goto yy56;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy986;
	if (yych == 'c') goto yy986;
	goto yy56;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy987;
	if (yych == 'b') goto yy987;
	goto yy56;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy988;
	if (yych == 'n') goto yy988;
	goto yy56;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy989;
		if (yych <= 'M') goto yy56;
		goto yy990;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy989;
		} else {
			if (yych == 'n') goto yy990;
			goto yy56;
		}
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy991;
		if (yych <= 'X') goto yy56;
		goto yy992;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy991;
		} else {
			if (yych == 'y') goto yy992;
			goto yy56;
		}
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy986;
	if (yych == 'v') goto yy986;
	goto yy56;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy993;
	if (yych == 't') goto yy993;
	goto yy56;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy994;
	if (yych == 'p') goto yy994;
	goto yy56;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy995;
	goto yy56;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy995;
	goto yy56;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy995;
	goto yy56;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy902;
	if (yych == 'p') goto yy902;
	goto yy56;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy996;
	if (yych <= '3') goto yy998;
	if (yych <= '9') goto yy999;
	goto yy56;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy1000;
	goto yy56;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1001;
	goto yy187;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych >= ' ') goto yy187;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy1001;
				} else {
					if (yych == 'D') goto yy187;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy889;
				if (yych <= 'H') goto yy187;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
				} else {
					if (yych != 'V') goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych >= 'd') goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy187;
				} else {
					if (yych == 'h') goto yy187;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
				} else {
					if (yych != 'v') goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
				}
			}
		}
	}
yy889:
	YYDEBUG(889, *YYCURSOR);
#line 1533 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 18242 "lib/parse_date.c"
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy889;
				goto yy187;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy889;
					goto yy1001;
				} else {
					if (yych <= '9') goto yy57;
					if (yych <= 'C') goto yy889;
					goto yy187;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy889;
					goto yy187;
				} else {
					if (yych == 'H') goto yy187;
					goto yy889;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy187;
					goto yy889;
				} else {
					if (yych == 'V') goto yy889;
					goto yy187;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy187;
				if (yych <= 'c') goto yy889;
				goto yy187;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy889;
					goto yy187;
				} else {
					if (yych == 'h') goto yy187;
					goto yy889;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy187;
					goto yy889;
				} else {
					if (yych == 'v') goto yy889;
					goto yy187;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy889;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy889;
				}
			}
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy187;
				if (yych <= 0x1F) goto yy889;
				goto yy187;
			} else {
				if (yych == 'D') goto yy187;
				if (yych <= 'E') goto yy889;
				goto yy187;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy187;
				if (yych <= 'L') goto yy889;
				goto yy187;
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy889;
					goto yy187;
				} else {
					if (yych == 'W') goto yy187;
					goto yy889;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy187;
				if (yych == 'd') goto yy187;
				goto yy889;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy187;
					goto yy889;
				} else {
					if (yych <= 'h') goto yy187;
					if (yych <= 'l') goto yy889;
					goto yy187;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy889;
				if (yych == 'v') goto yy889;
				goto yy187;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy889;
					goto yy187;
				} else {
					if (yych == 0xC2) goto yy187;
					goto yy889;
				}
			}
		}
	}
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1003;
	goto yy56;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1004;
	if (yych == 'i') goto yy1004;
	goto yy577;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1005;
	if (yych == 'u') goto yy1005;
	goto yy577;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1006;
	if (yych == 'e') goto yy1006;
	goto yy577;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1007;
	if (yych == 'r') goto yy1007;
	goto yy577;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1008;
	if (yych == 'u') goto yy1008;
	goto yy577;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy760;
	if (yych == 'y') goto yy760;
	goto yy577;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy760;
	if (yych == 'e') goto yy760;
	goto yy577;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1009;
	if (yych == 'c') goto yy1009;
	goto yy577;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1010;
	if (yych == 'o') goto yy1010;
	goto yy577;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy895;
	if (yych == 't') goto yy895;
	goto yy577;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1011;
	if (yych <= '/') goto yy904;
	if (yych <= '7') goto yy1012;
yy904:
	YYDEBUG(904, *YYCURSOR);
#line 1566 "lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 18481 "lib/parse_date.c"
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1014;
	if (yych == 'g') goto yy1014;
	goto yy56;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy243;
	if (yych == 'y') goto yy243;
	goto yy56;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1015;
	if (yych == 'e') goto yy1015;
	goto yy56;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy243;
	if (yych == 'r') goto yy243;
	goto yy56;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy616;
			if (yych <= 0x1F) goto yy209;
			goto yy616;
		} else {
			if (yych == '.') goto yy1016;
			if (yych <= '9') goto yy209;
			goto yy1017;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy102;
			if (yych <= 'O') goto yy209;
			goto yy102;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy102;
			} else {
				if (yych == 'p') goto yy102;
				goto yy209;
			}
		}
	}
yy910:
	YYDEBUG(910, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '9') goto yy1018;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy545;
		if (yych <= '1') goto yy1018;
		if (yych <= 'm') goto yy545;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
			goto yy545;
		}
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1019;
	if (yych <= '3') goto yy1020;
	goto yy56;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1021;
	goto yy56;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1022;
	goto yy56;
yy915:
	YYDEBUG(915, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy916:
	YYDEBUG(916, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy56;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy56;
	}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1024;
	goto yy56;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy929;
	if (yych == 'r') goto yy929;
	goto yy56;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy929;
	if (yych == 'r') goto yy930;
	goto yy916;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1025;
	if (yych == 'e') goto yy1025;
	goto yy56;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy955;
	if (yych == 'h') goto yy955;
	goto yy56;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy955;
	if (yych == 'h') goto yy958;
	goto yy916;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy929;
	if (yych == 'y') goto yy929;
	goto yy56;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy929;
	if (yych == 'y') goto yy930;
	goto yy916;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1026;
	if (yych <= '6') goto yy1027;
	if (yych <= '9') goto yy1028;
	goto yy56;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1029;
	if (yych <= '6') goto yy1030;
	if (yych <= '9') goto yy1028;
	goto yy56;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1031;
			if (yych <= 0x1F) goto yy815;
			goto yy1031;
		} else {
			if (yych == '.') goto yy926;
			if (yych <= '9') goto yy815;
			goto yy926;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy1033;
			if (yych <= 'O') goto yy815;
			goto yy1033;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy815;
				goto yy1033;
			} else {
				if (yych == 'p') goto yy1033;
				goto yy815;
			}
		}
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	++YYCURSOR;
	goto yy310;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy136;
		if (yych <= 0x1F) goto yy280;
		goto yy136;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy280;
			goto yy136;
		} else {
			if (yych <= '/') goto yy280;
			if (yych <= '9') goto yy136;
			goto yy280;
		}
	}
yy930:
	YYDEBUG(930, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy136;
			goto yy280;
		} else {
			if (yych <= ' ') goto yy136;
			if (yych <= ',') goto yy280;
			goto yy676;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy282;
			goto yy136;
		} else {
			if (yych == '_') goto yy282;
			goto yy280;
		}
	}
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1034;
	if (yych == 'y') goto yy1034;
	goto yy56;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1035;
	if (yych == 'r') goto yy1035;
	goto yy56;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1036;
	if (yych == 'i') goto yy1036;
	goto yy56;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1037;
	if (yych == 'u') goto yy1037;
	goto yy56;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1038;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy1039;
			if (yych <= 'M') goto yy56;
			goto yy1040;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1038;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy1039;
			if (yych == 'n') goto yy1040;
			goto yy56;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1041;
	if (yych == 'n') goto yy1041;
	goto yy56;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1042;
	if (yych == 'e') goto yy1042;
yy938:
	YYDEBUG(938, *YYCURSOR);
#line 1706 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18825 "lib/parse_date.c"
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1043;
	if (yych == 't') goto yy1043;
	goto yy56;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1044;
	if (yych == 'c') goto yy1044;
	goto yy56;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1036;
	if (yych == 'n') goto yy1036;
	goto yy56;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1045;
	if (yych == 'u') goto yy1045;
	goto yy56;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1046;
	if (yych == 'e') goto yy1046;
	goto yy56;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1042;
	if (yych == 'e') goto yy1042;
	goto yy56;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1047;
		goto yy1048;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1047;
		if (yych <= 'e') goto yy1048;
		goto yy56;
	}
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1037;
	if (yych == 'a') goto yy1037;
	goto yy56;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy937;
	if (yych == 's') goto yy937;
	goto yy56;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1049;
	if (yych == 'y') goto yy1049;
	goto yy56;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1050;
	if (yych == 't') goto yy1050;
	goto yy56;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1050;
	if (yych == 't') goto yy1051;
	goto yy916;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1052;
	if (yych == 's') goto yy1052;
	goto yy56;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1052;
	if (yych == 's') goto yy1053;
	goto yy916;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy961;
	if (yych == 'y') goto yy961;
	goto yy56;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy918;
	if (yych == 'e') goto yy918;
	goto yy56;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy803;
	if (yych == ' ') goto yy803;
	goto yy56;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy961;
	if (yych == 'y') goto yy963;
	goto yy916;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy918;
	if (yych == 'e') goto yy919;
	goto yy916;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy803;
	if (yych == ' ') goto yy803;
	goto yy916;
yy959:
	YYDEBUG(959, *YYCURSOR);
	++YYCURSOR;
	goto yy748;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1054;
	if (yych == 'w') goto yy1054;
	goto yy56;
yy961:
	YYDEBUG(961, *YYCURSOR);
	++YYCURSOR;
	goto yy300;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1054;
	if (yych == 'w') goto yy1056;
	goto yy916;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy300;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy300;
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy953;
	if (yych == 'a') goto yy953;
	goto yy56;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy961;
	if (yych == 's') goto yy961;
	goto yy300;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy953;
	if (yych == 'a') goto yy956;
	goto yy916;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy282;
			goto yy300;
		} else {
			if (yych <= '/') goto yy282;
			if (yych <= 'R') goto yy300;
			goto yy961;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy282;
			goto yy300;
		} else {
			if (yych == 's') goto yy963;
			if (yych <= 'z') goto yy915;
			goto yy300;
		}
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1057;
	if (yych == 'a') goto yy1057;
	goto yy56;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1057;
	if (yych == 'a') goto yy1058;
	goto yy916;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1059;
	goto yy56;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1060;
	goto yy56;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1060;
	goto yy56;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1061;
	goto yy187;
yy974:
	YYDEBUG(974, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(975, *YYCURSOR);
#line 1415 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 19080 "lib/parse_date.c"
yy976:
	YYDEBUG(976, *YYCURSOR);
	++YYCURSOR;
	goto yy214;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1062;
	goto yy56;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy979;
		if (yych <= '9') goto yy861;
		if (yych >= 'n') goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy714;
		} else {
			if (yych <= 's') goto yy715;
			if (yych <= 't') goto yy716;
		}
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
#line 1346 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19122 "lib/parse_date.c"
yy980:
	YYDEBUG(980, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy545;
			goto yy982;
		} else {
			if (yych == 'T') goto yy1063;
			goto yy545;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1064;
			if (yych <= 'q') goto yy545;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy545;
		}
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy545;
		} else {
			if (yych == 'T') goto yy1063;
			goto yy545;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1064;
			if (yych <= 'q') goto yy545;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy545;
		}
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1063;
		if (yych <= 'm') goto yy545;
		goto yy1064;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy545;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy545;
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1067;
	if (yych <= '3') goto yy1068;
	if (yych <= '9') goto yy982;
	goto yy56;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'I') goto yy1004;
		if (yych == 'i') goto yy1004;
		goto yy577;
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'U') goto yy1005;
		if (yych == 'u') goto yy1005;
		goto yy577;
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'E') goto yy1006;
		if (yych == 'e') goto yy1006;
		goto yy577;
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'R') goto yy1007;
		if (yych == 'r') goto yy1007;
		goto yy577;
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'U') goto yy1008;
		if (yych == 'u') goto yy1008;
		goto yy577;
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'Y') goto yy760;
		if (yych == 'y') goto yy760;
		goto yy577;
	}
yy990:
	YYDEBUG(990, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'E') goto yy760;
		if (yych == 'e') goto yy760;
		goto yy577;
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'C') goto yy1009;
		if (yych == 'c') goto yy1009;
		goto yy577;
	}
yy992:
	YYDEBUG(992, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy912;
	goto yy577;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'O') goto yy1010;
		if (yych == 'o') goto yy1010;
		goto yy577;
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy912;
		goto yy577;
	} else {
		if (yych <= 'T') goto yy986;
		if (yych == 't') goto yy986;
		goto yy577;
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	++YYCURSOR;
	goto yy889;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy997;
		if (yych <= '9') goto yy999;
		if (yych >= 'n') goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1069;
		} else {
			if (yych <= 's') goto yy1070;
			if (yych <= 't') goto yy1071;
		}
	}
yy997:
	YYDEBUG(997, *YYCURSOR);
#line 1334 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19353 "lib/parse_date.c"
yy998:
	YYDEBUG(998, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy997;
		if (yych <= '1') goto yy999;
		if (yych <= 'm') goto yy997;
		goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy997;
			goto yy1069;
		} else {
			if (yych <= 's') goto yy1070;
			if (yych <= 't') goto yy1071;
			goto yy997;
		}
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1069;
		goto yy997;
	} else {
		if (yych <= 'r') goto yy1069;
		if (yych <= 's') goto yy1070;
		if (yych <= 't') goto yy1071;
		goto yy997;
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1072;
	if (yych <= '3') goto yy1073;
	if (yych <= '9') goto yy999;
	goto yy56;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych >= ' ') goto yy186;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy188;
				} else {
					if (yych == 'F') goto yy189;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy76;
				} else {
					if (yych <= 'M') goto yy190;
					if (yych >= 'S') goto yy191;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1074;
					goto yy85;
				} else {
					if (yych == 'W') goto yy87;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy89;
				} else {
					if (yych <= 'd') goto yy188;
					if (yych >= 'f') goto yy189;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy76;
				} else {
					if (yych == 'm') goto yy190;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy191;
					goto yy1075;
				} else {
					if (yych <= 'u') goto yy85;
					if (yych >= 'w') goto yy87;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy89;
				} else {
					if (yych == 0xC2) goto yy94;
				}
			}
		}
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
#line 1495 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 19477 "lib/parse_date.c"
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1076;
	if (yych <= '3') goto yy1077;
	goto yy56;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy760;
	if (yych == 'l') goto yy760;
	goto yy56;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1078;
	if (yych == 's') goto yy1078;
	goto yy56;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1010;
	if (yych == 'm') goto yy1010;
	goto yy56;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1008;
	if (yych != 'u') goto yy56;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1079;
	if (yych == 'a') goto yy1079;
	goto yy56;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy760;
	if (yych == 'h') goto yy760;
	goto yy56;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1080;
	if (yych == 'b') goto yy1080;
	goto yy56;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1013, *YYCURSOR);
#line 1547 "lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19553 "lib/parse_date.c"
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1081;
	if (yych == 'h') goto yy1081;
	goto yy56;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1082;
	if (yych == 'c') goto yy1082;
	goto yy56;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1083;
	goto yy56;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1085;
	goto yy56;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy714;
		goto yy979;
	} else {
		if (yych <= 'r') goto yy714;
		if (yych <= 's') goto yy715;
		if (yych <= 't') goto yy716;
		goto yy979;
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1087;
	goto yy56;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1087;
	goto yy56;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1089;
	goto yy56;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1023;
	if (yych <= '9') goto yy1091;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
#line 1585 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 19629 "lib/parse_date.c"
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1092;
	if (yych <= '2') goto yy1094;
	if (yych <= '9') goto yy1095;
	goto yy56;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1047;
		goto yy1096;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1047;
		if (yych <= 'e') goto yy1096;
		goto yy56;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '9') goto yy1097;
	goto yy815;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1097;
	goto yy815;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	++YYCURSOR;
	goto yy815;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '9') goto yy1098;
	goto yy815;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1098;
	goto yy815;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1032, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1031;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1031;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1033;
			if (yych != 'p') goto yy56;
		}
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1099;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1100;
		if (yych == 'm') goto yy1100;
		goto yy56;
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1101;
	if (yych == 's') goto yy1101;
	goto yy938;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1102;
	if (yych == 't') goto yy1102;
	goto yy56;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy938;
		goto yy1103;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy938;
			goto yy1105;
		} else {
			if (yych == 'd') goto yy1105;
			goto yy938;
		}
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1034;
	if (yych == 'r') goto yy1034;
	goto yy56;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1106;
	if (yych == 'r') goto yy1106;
	goto yy56;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1107;
	if (yych == 'l') goto yy1107;
	goto yy56;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1101;
		if (yych <= 'T') goto yy938;
		goto yy1108;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy938;
			goto yy1101;
		} else {
			if (yych == 'u') goto yy1108;
			goto yy938;
		}
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1103;
			goto yy938;
		} else {
			if (yych <= ' ') goto yy1103;
			if (yych <= 'C') goto yy938;
			goto yy1105;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1109;
			goto yy938;
		} else {
			if (yych <= 'd') goto yy1105;
			if (yych == 't') goto yy1109;
			goto yy938;
		}
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1034;
	if (yych == 'c') goto yy1034;
	goto yy56;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy938;
		goto yy1103;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy938;
			goto yy1110;
		} else {
			if (yych == 'u') goto yy1110;
			goto yy938;
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1111;
		if (yych <= 'R') goto yy938;
		goto yy1101;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy938;
			goto yy1111;
		} else {
			if (yych == 's') goto yy1101;
			goto yy938;
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy938;
		goto yy1103;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy938;
			goto yy1112;
		} else {
			if (yych == 'r') goto yy1112;
			goto yy938;
		}
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy938;
		goto yy1103;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy938;
			goto yy1113;
		} else {
			if (yych == 's') goto yy1113;
			goto yy938;
		}
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy938;
		goto yy1103;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy938;
			goto yy1114;
		} else {
			if (yych == 'n') goto yy1114;
			goto yy938;
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1115;
	if (yych == 'k') goto yy1115;
	goto yy56;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1117;
		goto yy938;
	} else {
		if (yych <= 'S') goto yy1101;
		if (yych == 's') goto yy1101;
		goto yy938;
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	++YYCURSOR;
	goto yy696;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy696;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy696;
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy677;
	if (yych == ' ') goto yy677;
	goto yy56;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy677;
	if (yych == ' ') goto yy677;
	goto yy916;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	++YYCURSOR;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
#line 1061 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19953 "lib/parse_date.c"
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy1055;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy1055;
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1118;
	if (yych == 'y') goto yy1118;
	goto yy56;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1118;
	if (yych == 'y') goto yy1120;
	goto yy916;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1121;
	if (yych <= '3') goto yy1122;
	goto yy56;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1123;
	goto yy56;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1124;
	goto yy187;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1125;
	goto yy56;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1126;
	if (yych <= '2') goto yy1127;
	if (yych <= '9') goto yy1128;
	goto yy56;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1129;
	goto yy56;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1129;
	goto yy56;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1129;
	goto yy56;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy545;
			goto yy1130;
		} else {
			if (yych == 'T') goto yy1063;
			goto yy545;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1064;
			if (yych <= 'q') goto yy545;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy545;
		}
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy545;
			goto yy1130;
		} else {
			if (yych == 'T') goto yy1063;
			goto yy545;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1064;
			if (yych <= 'q') goto yy545;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy545;
		}
	}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1131;
	goto yy56;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1131;
	goto yy56;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1131;
	goto yy56;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy997;
		if (yych <= '9') goto yy1132;
		if (yych <= 'm') goto yy997;
		goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy997;
			goto yy1069;
		} else {
			if (yych <= 's') goto yy1070;
			if (yych <= 't') goto yy1071;
			goto yy997;
		}
	}
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy997;
		if (yych <= '1') goto yy1132;
		if (yych <= 'm') goto yy997;
		goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy997;
			goto yy1069;
		} else {
			if (yych <= 's') goto yy1070;
			if (yych <= 't') goto yy1071;
			goto yy997;
		}
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy1133;
			goto yy1134;
		} else {
			if (yych <= '9') goto yy1135;
			if (yych <= 'G') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy257;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy256;
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy1136;
			goto yy1137;
		} else {
			if (yych <= '9') goto yy1138;
			if (yych <= 'G') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy257;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy256;
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1139;
	goto yy56;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1139;
	goto yy56;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy760;
	if (yych == 't') goto yy760;
	goto yy56;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1140;
	if (yych == 'r') goto yy1140;
	goto yy56;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1141;
	if (yych == 'e') goto yy1141;
	goto yy56;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy406;
	if (yych == 't') goto yy406;
	goto yy56;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy606;
	if (yych == 'o') goto yy606;
	goto yy56;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1084, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy209;
			goto yy1083;
		} else {
			if (yych == 'A') goto yy1142;
			goto yy209;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1142;
			if (yych <= '`') goto yy209;
			goto yy1142;
		} else {
			if (yych == 'p') goto yy1142;
			goto yy209;
		}
	}
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1086, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy1085;
		} else {
			if (yych == 'A') goto yy1142;
			goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1142;
			if (yych <= '`') goto yy56;
			goto yy1142;
		} else {
			if (yych == 'p') goto yy1142;
			goto yy56;
		}
	}
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1088, *YYCURSOR);
#line 1599 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 20282 "lib/parse_date.c"
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1090, *YYCURSOR);
#line 1099 "lib/parse_date.re"
	{
		timelib_ull i, us;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		us = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20314 "lib/parse_date.c"
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1023;
	if (yych <= '9') goto yy1143;
	goto yy1023;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1144;
		} else {
			if (yych <= ' ') goto yy1144;
			if (yych <= '/') goto yy1093;
			if (yych <= '9') goto yy1095;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1146;
			if (yych == 'P') goto yy1146;
		} else {
			if (yych <= 'a') goto yy1146;
			if (yych == 'p') goto yy1146;
		}
	}
yy1093:
	YYDEBUG(1093, *YYCURSOR);
#line 1144 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 20366 "lib/parse_date.c"
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1144;
			goto yy1093;
		} else {
			if (yych <= ' ') goto yy1144;
			if (yych <= '/') goto yy1093;
			if (yych >= '5') goto yy1093;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1146;
			if (yych == 'P') goto yy1146;
			goto yy1093;
		} else {
			if (yych <= 'a') goto yy1146;
			if (yych == 'p') goto yy1146;
			goto yy1093;
		}
	}
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1144;
			goto yy1093;
		} else {
			if (yych <= ' ') goto yy1144;
			if (yych <= '@') goto yy1093;
			goto yy1146;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1146;
			goto yy1093;
		} else {
			if (yych <= 'a') goto yy1146;
			if (yych == 'p') goto yy1146;
			goto yy1093;
		}
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1147;
	if (yych == 'k') goto yy1147;
	goto yy56;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1149;
			goto yy815;
		} else {
			if (yych <= ' ') goto yy1149;
			if (yych == '(') goto yy1149;
			goto yy815;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy815;
			if (yych <= '-') goto yy1149;
			goto yy815;
		} else {
			if (yych <= 'Z') goto yy1149;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1149;
			goto yy815;
		}
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1156;
			goto yy815;
		} else {
			if (yych <= ' ') goto yy1156;
			if (yych == '(') goto yy1156;
			goto yy815;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy815;
			if (yych <= '-') goto yy1156;
			goto yy815;
		} else {
			if (yych <= 'Z') goto yy1156;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1156;
			goto yy815;
		}
	}
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1100;
	if (yych != 'm') goto yy56;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1159;
		if (yych == '\t') goto yy1159;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1159;
		if (yych == '.') goto yy1161;
		goto yy56;
	}
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	++YYCURSOR;
	goto yy938;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1162;
		if (yych <= 'M') goto yy56;
		goto yy1163;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1162;
		} else {
			if (yych == 'n') goto yy1163;
			goto yy56;
		}
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1104, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1103;
		if (yych <= 0x1F) goto yy56;
		goto yy1103;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1164;
		} else {
			if (yych == 'o') goto yy1164;
			goto yy56;
		}
	}
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1165;
	if (yych == 'a') goto yy1165;
	goto yy56;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1166;
	if (yych == 'o') goto yy1166;
	goto yy56;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1166;
	if (yych == 'i') goto yy1166;
	goto yy56;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1167;
	if (yych == 't') goto yy1167;
	goto yy56;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1034;
	if (yych == 'h') goto yy1034;
	goto yy56;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1113;
	if (yych == 'r') goto yy1113;
	goto yy56;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1168;
	if (yych == 'n') goto yy1168;
	goto yy56;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1113;
	if (yych != 's') goto yy56;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1105;
	if (yych == 'd') goto yy1105;
	goto yy56;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1112;
	if (yych == 'e') goto yy1112;
	goto yy56;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy822;
		if (yych >= 'S') goto yy1101;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy822;
		} else {
			if (yych == 's') goto yy1101;
		}
	}
yy1116:
	YYDEBUG(1116, *YYCURSOR);
#line 1682 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20624 "lib/parse_date.c"
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1169;
	if (yych == 'o') goto yy1169;
	goto yy56;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	++YYCURSOR;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
#line 1018 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20647 "lib/parse_date.c"
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy915;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy282;
		goto yy1119;
	} else {
		if (yych <= '/') goto yy282;
		if (yych == '_') goto yy282;
		goto yy1119;
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1131;
	goto yy56;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1131;
	goto yy56;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1170;
	if (yych <= '3') goto yy1171;
	goto yy56;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1172;
	goto yy187;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1173;
	goto yy56;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1128;
	if (yych <= ':') goto yy1174;
	goto yy56;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1128;
	if (yych == ':') goto yy1174;
	goto yy56;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1174;
	goto yy56;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1063;
	goto yy545;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1175;
		if (yych <= 'm') goto yy997;
		goto yy1064;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy997;
			goto yy1064;
		} else {
			if (yych <= 's') goto yy1065;
			if (yych <= 't') goto yy1066;
			goto yy997;
		}
	}
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	++YYCURSOR;
	goto yy997;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1131;
		if (yych <= 'm') goto yy997;
		goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy997;
			goto yy1069;
		} else {
			if (yych <= 's') goto yy1070;
			if (yych <= 't') goto yy1071;
			goto yy997;
		}
	}
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1176;
	if (yych <= '9') goto yy1135;
	if (yych <= ':') goto yy1177;
	goto yy56;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy1176;
		goto yy1178;
	} else {
		if (yych == ':') goto yy1177;
		goto yy56;
	}
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1178;
	if (yych == ':') goto yy1177;
	goto yy56;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1179;
	if (yych <= '9') goto yy1138;
	goto yy56;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1179;
	if (yych <= '5') goto yy1178;
	goto yy56;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1178;
	goto yy56;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1180;
	goto yy56;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy760;
	if (yych == 'y') goto yy760;
	goto yy56;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy760;
	if (yych == 'r') goto yy760;
	goto yy56;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1181;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1182;
		if (yych == 'm') goto yy1182;
		goto yy56;
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1023;
	if (yych <= '9') goto yy1183;
	goto yy1023;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1145, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1144;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1144;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1146;
			if (yych != 'p') goto yy56;
		}
	}
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1184;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1185;
		if (yych == 'm') goto yy1185;
		goto yy56;
	}
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy822;
		if (yych <= 'R') goto yy56;
		goto yy1101;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy822;
		} else {
			if (yych == 's') goto yy1101;
			goto yy56;
		}
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1148;
			if (yych <= 0x1F) goto yy56;
			goto yy1148;
		} else {
			if (yych == '(') goto yy1150;
			if (yych <= '*') goto yy56;
			goto yy1151;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1151;
			if (yych <= '@') goto yy56;
			goto yy1152;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1153;
				goto yy1152;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy1154;
				goto yy56;
			}
		}
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy1154;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy1154;
	goto yy56;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1186;
	if (yych <= '2') goto yy1187;
	if (yych <= '9') goto yy1188;
	goto yy56;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1189;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1190;
		goto yy815;
	}
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy1028;
		if (yych <= '@') goto yy815;
		goto yy1189;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1191;
			goto yy1189;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1190;
			goto yy815;
		}
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1189;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1189;
		goto yy815;
	}
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy1155;
			} else {
				if (yych == ' ') goto yy1155;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1150;
				if (yych <= '*') goto yy56;
				goto yy1151;
			} else {
				if (yych == '-') goto yy1151;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1157;
				if (yych <= 'F') goto yy1152;
				goto yy1153;
			} else {
				if (yych != 'P') goto yy1152;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy1158;
				goto yy1154;
			} else {
				if (yych <= 'p') goto yy1158;
				if (yych <= 'z') goto yy1154;
				goto yy56;
			}
		}
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych <= '.') goto yy1099;
			if (yych <= '@') goto yy815;
			goto yy1189;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1192;
			if (yych <= 'Z') goto yy1189;
			goto yy815;
		} else {
			if (yych == 'm') goto yy1193;
			if (yych <= 'z') goto yy1190;
			goto yy815;
		}
	}
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych <= '.') goto yy1099;
			if (yych <= '@') goto yy815;
			goto yy1189;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1192;
			if (yych <= 'Z') goto yy1189;
			goto yy815;
		} else {
			if (yych == 'm') goto yy1192;
			if (yych <= 'z') goto yy1189;
			goto yy815;
		}
	}
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1160, *YYCURSOR);
#line 1747 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 21100 "lib/parse_date.c"
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1159;
		if (yych <= 0x08) goto yy56;
		goto yy1159;
	} else {
		if (yych == ' ') goto yy1159;
		goto yy56;
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1163;
	if (yych != 'n') goto yy56;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1194;
	if (yych == 'i') goto yy1194;
	goto yy56;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1195;
	if (yych == 'f') goto yy1195;
	goto yy56;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1197;
	if (yych == 'y') goto yy1197;
	goto yy56;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1198;
	if (yych == 's') goto yy1198;
	goto yy56;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1034;
	if (yych == 'e') goto yy1034;
	goto yy56;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1034;
	if (yych == 'd') goto yy1034;
	goto yy56;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1199;
	if (yych == 'f') goto yy1199;
	goto yy56;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1201;
	goto yy56;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1201;
	goto yy56;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1203;
	goto yy187;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1204;
	if (yych <= '2') goto yy1205;
	goto yy56;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1206;
	if (yych <= '9') goto yy1207;
	goto yy56;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1208;
	if (yych <= '2') goto yy1209;
	if (yych <= '9') goto yy1128;
	goto yy56;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1210;
	if (yych <= '9') goto yy1211;
	if (yych >= ';') goto yy56;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1212;
	goto yy56;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1211;
	goto yy56;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1210;
	if (yych <= '9') goto yy1211;
	goto yy56;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1213;
	if (yych <= '2') goto yy1214;
	goto yy56;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1182;
	if (yych != 'm') goto yy56;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1215;
		if (yych == '\t') goto yy1215;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1215;
		if (yych == '.') goto yy1217;
		goto yy56;
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	++YYCURSOR;
	goto yy1023;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1185;
	if (yych != 'm') goto yy56;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1218;
		if (yych == '\t') goto yy1218;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1218;
		if (yych == '.') goto yy1219;
		goto yy56;
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '9') goto yy1188;
	if (yych <= ':') goto yy1220;
	goto yy815;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy815;
		if (yych >= '5') goto yy1221;
	} else {
		if (yych <= '9') goto yy1028;
		if (yych <= ':') goto yy1220;
		goto yy815;
	}
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '5') goto yy1221;
	if (yych <= '9') goto yy1028;
	if (yych <= ':') goto yy1220;
	goto yy815;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1222;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1222;
		goto yy815;
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych == '.') goto yy815;
			goto yy1223;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy815;
			if (yych <= 'Z') goto yy1222;
			goto yy815;
		} else {
			if (yych <= '_') goto yy1223;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1224;
			goto yy815;
		}
	}
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy1028;
		if (yych <= '@') goto yy815;
		goto yy1222;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1225;
			goto yy1222;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1222;
			goto yy815;
		}
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1159;
			if (yych <= 0x08) goto yy815;
			goto yy1159;
		} else {
			if (yych == ' ') goto yy1159;
			if (yych <= '(') goto yy815;
			goto yy1028;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1161;
			goto yy815;
		} else {
			if (yych <= 'Z') goto yy1222;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1222;
			goto yy815;
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1159;
			if (yych == '\t') goto yy1159;
			goto yy815;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy1159;
				goto yy815;
			} else {
				if (yych <= ')') goto yy1028;
				if (yych <= ',') goto yy815;
				goto yy1223;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1161;
			if (yych <= '/') goto yy1223;
			if (yych <= '@') goto yy815;
			goto yy1222;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy815;
				goto yy1223;
			} else {
				if (yych <= '`') goto yy815;
				if (yych <= 'z') goto yy1224;
				goto yy815;
			}
		}
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1226;
	if (yych == 'g') goto yy1226;
	goto yy56;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1196, *YYCURSOR);
#line 1167 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 21442 "lib/parse_date.c"
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1103;
	if (yych == ' ') goto yy1103;
	goto yy938;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1227;
	if (yych == 'e') goto yy1227;
	goto yy56;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1200, *YYCURSOR);
#line 1127 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 21476 "lib/parse_date.c"
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1202, *YYCURSOR);
#line 1360 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 19);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21492 "lib/parse_date.c"
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1228;
	goto yy187;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1229;
	goto yy56;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1229;
	goto yy56;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1207;
	if (yych <= ':') goto yy1230;
	goto yy56;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1230;
	goto yy56;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1231;
	if (yych <= ':') goto yy1174;
	goto yy56;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1231;
	if (yych == ':') goto yy1174;
	goto yy56;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1230;
	if (yych <= '6') goto yy1232;
	if (yych >= ':') goto yy56;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1233;
	if (yych <= '6') goto yy1234;
	goto yy56;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1235;
	goto yy56;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1236;
	goto yy56;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1236;
	goto yy56;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1216, *YYCURSOR);
#line 1206 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 21593 "lib/parse_date.c"
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1215;
		if (yych <= 0x08) goto yy56;
		goto yy1215;
	} else {
		if (yych == ' ') goto yy1215;
		goto yy56;
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	++YYCURSOR;
	goto yy1093;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1218;
		if (yych <= 0x08) goto yy56;
		goto yy1218;
	} else {
		if (yych == ' ') goto yy1218;
		goto yy56;
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '5') goto yy1221;
	if (yych <= '9') goto yy1028;
	goto yy815;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy815;
	if (yych <= '9') goto yy1028;
	goto yy815;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1237;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1237;
		goto yy815;
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy1238;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy1238;
	goto yy56;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych == '.') goto yy815;
			goto yy1223;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy815;
			if (yych <= 'Z') goto yy1237;
			goto yy815;
		} else {
			if (yych <= '_') goto yy1223;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1240;
			goto yy815;
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy815;
			goto yy1028;
		} else {
			if (yych == '+') goto yy1151;
			goto yy815;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1151;
			if (yych <= '@') goto yy815;
			goto yy1237;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1237;
			goto yy815;
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1241;
	if (yych == 'h') goto yy1241;
	goto yy56;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1242;
	if (yych == 'c') goto yy1242;
	goto yy56;
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1243;
	goto yy187;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1244;
	goto yy56;
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1245;
	if (yych <= '6') goto yy1247;
	if (yych <= '9') goto yy1248;
	goto yy56;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1249;
	goto yy56;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy1245;
	if (yych <= '5') goto yy1233;
	if (yych <= '6') goto yy1234;
	goto yy56;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1248;
	goto yy56;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1248;
	goto yy56;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1211;
	goto yy56;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1177;
	goto yy56;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1250;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1250;
		goto yy815;
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yyaccept = 21;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1239, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy815;
			goto yy1223;
		} else {
			if (yych == '/') goto yy1223;
			goto yy815;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1238;
			if (yych <= '^') goto yy815;
			goto yy1223;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1238;
			goto yy815;
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych == '.') goto yy815;
			goto yy1223;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy815;
			if (yych <= 'Z') goto yy1250;
			goto yy815;
		} else {
			if (yych <= '_') goto yy1223;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1251;
			goto yy815;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1034;
	if (yych == 't') goto yy1034;
	goto yy56;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1111;
	if (yych == 'o') goto yy1111;
	goto yy56;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1252;
	goto yy187;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1253;
	goto yy56;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1246;
	if (yych <= '9') goto yy1248;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
#line 1507 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 21887 "lib/parse_date.c"
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1246;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	++YYCURSOR;
	goto yy1246;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1254;
	if (yych <= '9') goto yy1207;
	goto yy56;
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1028;
		goto yy815;
	} else {
		if (yych <= 'Z') goto yy1255;
		if (yych <= '`') goto yy815;
		if (yych <= 'z') goto yy1255;
		goto yy815;
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1028;
			goto yy815;
		} else {
			if (yych == '.') goto yy815;
			goto yy1223;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy815;
			if (yych <= 'Z') goto yy1255;
			goto yy815;
		} else {
			if (yych <= '_') goto yy1223;
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1256;
			goto yy815;
		}
	}
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1257;
	goto yy187;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1258;
	goto yy56;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1259;
	if (yych <= ':') goto yy1230;
	goto yy56;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy1028;
	goto yy815;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy815;
			goto yy1028;
		} else {
			if (yych == '-') goto yy1223;
			goto yy815;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy1223;
			if (yych <= '^') goto yy815;
			goto yy1223;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1260;
			goto yy815;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1262;
	goto yy187;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1263;
	goto yy56;
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1264;
	goto yy56;
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1261, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1223;
		if (yych <= '.') goto yy56;
		goto yy1223;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy1223;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy1260;
			goto yy56;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1265;
	goto yy187;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1266;
	if (yych <= '6') goto yy1267;
	goto yy56;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1268;
	if (yych <= '6') goto yy1269;
	if (yych <= '9') goto yy1248;
	goto yy56;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1270;
	goto yy187;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1271;
	goto yy56;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1271;
	goto yy56;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1246;
	if (yych <= '9') goto yy1272;
	goto yy1246;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1272;
	goto yy1246;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy859;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy1273;
	goto yy187;
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1274;
	if (yych == ' ') goto yy1274;
	goto yy56;
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1276;
	goto yy1246;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych == '-') goto yy859;
	goto yy187;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1275, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1274;
		} else {
			if (yych == ' ') goto yy1274;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy1277;
		} else {
			if (yych == 'G') goto yy1278;
			goto yy56;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1279;
	goto yy56;
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1281;
	if (yych <= '2') goto yy1283;
	if (yych <= '9') goto yy1284;
	goto yy56;
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1285;
	goto yy56;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yyaccept = 33;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1280, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1286;
		if (yych <= ',') goto yy1246;
		goto yy1286;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1246;
			goto yy1279;
		} else {
			if (yych == 'G') goto yy1287;
			goto yy1246;
		}
	}
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1282;
	if (yych <= '9') goto yy1284;
	if (yych <= ':') goto yy1288;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
#line 1613 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 22192 "lib/parse_date.c"
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1282;
		if (yych >= '5') goto yy1289;
	} else {
		if (yych <= '9') goto yy1290;
		if (yych <= ':') goto yy1288;
		goto yy1282;
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1282;
	if (yych <= '5') goto yy1289;
	if (yych <= '9') goto yy1290;
	if (yych <= ':') goto yy1288;
	goto yy1282;
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1291;
	goto yy56;
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1292;
	if (yych <= '2') goto yy1293;
	if (yych <= '9') goto yy1294;
	goto yy56;
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1295;
	goto yy56;
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1282;
	if (yych <= '5') goto yy1289;
	if (yych <= '9') goto yy1290;
	goto yy1282;
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1282;
	if (yych >= ':') goto yy1282;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	++YYCURSOR;
	goto yy1282;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1277;
	if (yych == '-') goto yy1277;
	goto yy56;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1246;
	if (yych <= '9') goto yy1294;
	if (yych <= ':') goto yy1296;
	goto yy1246;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1246;
		if (yych >= '5') goto yy1245;
	} else {
		if (yych <= '9') goto yy1248;
		if (yych <= ':') goto yy1296;
		goto yy1246;
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1246;
	if (yych <= '5') goto yy1245;
	if (yych <= '9') goto yy1248;
	if (yych <= ':') goto yy1296;
	goto yy1246;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1297;
	goto yy56;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1246;
	if (yych <= '5') goto yy1245;
	if (yych <= '9') goto yy1248;
	goto yy1246;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1286;
	if (yych == '-') goto yy1286;
	goto yy56;
}
#line 1832 "lib/parse_date.re"

}

#define YYMAXFILL 33


timelib_time* timelib_strtotime(char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	char        *fptr = format;
	char        *ptr = string;
	char        *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour can not be higher than 12", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 6 - (ptr - tptr)));
					}
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
					}
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) == TIMELIB_FORMAT_SEPARATOR) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr((char **) &ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
					}
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes((char **) &ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
				}
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Data missing", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
