"""Coriolis matrix for Kinova Gen3 robot

Functions
---------
coriolis(joint_position, joint_velocity)

"""

import math
import numpy as np


def coriolis(joint_position, joint_velocity):
    """The Coriolis term of the Kinova Gen3 robot

    Arguments
    ---------
    joint_position (array_like): The joint angles of the robot [rad]
    joint_velocity (array_like): The joint velocities of the robot [rad/s]

    Returns
    -------
    ndarray:  The Coriolis term of the robot

    """

    x_0 = math.sin(joint_position[1])
    x_1 = joint_velocity[0] ** 2
    x_2 = x_0 * x_1
    x_3 = math.cos(joint_position[1])
    x_4 = 0.09958 * x_0
    x_5 = 4.4e-5 * x_3
    x_6 = -x_5
    x_7 = x_4 + x_6
    x_8 = 0.00628344 * x_1
    x_9 = math.cos(joint_position[2])
    x_10 = x_9**2
    x_11 = 0.2104 * x_10
    x_12 = math.sin(joint_position[2])
    x_13 = 0.0064 * x_3
    x_14 = x_0 * x_12
    x_15 = 0.2104 * x_14
    x_16 = -x_13 + x_15
    x_17 = x_0 * x_11 + x_12 * x_16
    x_18 = joint_velocity[0] * x_3
    x_19 = joint_velocity[1] * x_18
    x_20 = x_0**2
    x_21 = x_1 * x_20
    x_22 = 0.0064 * x_18
    x_23 = 0.2104 * joint_velocity[1] - x_22
    x_24 = joint_velocity[1] * x_23
    x_25 = 0.0032 * x_19 + 0.1052 * x_21 + 0.5 * x_24
    x_26 = 0.0118 * x_0
    x_27 = 0.0043392 * x_19 + 0.1426512 * x_21 + 0.678 * x_24
    x_28 = 0.0236 * x_0
    x_29 = 0.005952 * x_19 + 0.195672 * x_21 + 0.93 * x_24
    x_30 = 0.00744704 * x_19 + 0.24482144 * x_21 + 1.1636 * x_24
    x_31 = x_2 * x_3
    x_32 = 0.5861744 * x_31
    x_33 = x_18 * x_23
    x_34 = 0.0032 * x_1 * x_20 - 0.1052 * x_19 - 0.5 * x_33
    x_35 = 0.2104 * x_0
    x_36 = 0.0043392 * x_1 * x_20 - 0.1426512 * x_19 - 0.678 * x_33
    x_37 = 0.005952 * x_1 * x_20 - 0.195672 * x_19 - 0.93 * x_33
    x_38 = 1.1636 * x_18
    x_39 = 0.00744704 * x_1 * x_20 - 0.24482144 * x_19 - x_23 * x_38
    x_40 = x_0 * x_9
    x_41 = 0.0064 * x_40
    x_42 = 0.0128 * x_40
    x_43 = 0.006641 * x_3
    x_44 = 0.117892 * x_0
    x_45 = x_12 * x_44 + x_43
    x_46 = x_44 * x_9 + x_6
    x_47 = x_12 * x_45 + x_46 * x_9
    x_48 = joint_velocity[0] * x_0
    x_49 = joint_velocity[1] * x_48
    x_50 = 4.4e-5 * joint_velocity[1]
    x_51 = 0.013278 * x_48 - x_50
    x_52 = 1.1636 * joint_velocity[1]
    x_53 = joint_velocity[0] * x_5
    x_54 = -joint_velocity[0] * x_4 + x_53
    x_55 = 0.09958 * joint_velocity[1] - 0.013278 * x_18
    x_56 = 0.24482144 * x_31
    x_57 = 4.4e-5 * x_12
    x_58 = 0.006641 * x_9
    x_59 = -x_0 * x_57 - x_0 * x_58
    x_60 = 0.011255 * joint_velocity[1] - 0.000691 * x_18
    x_61 = 5.0e-6 * x_18 + 0.011088 * x_48
    x_62 = 5.0e-6 * x_48
    x_63 = -0.000691 * joint_velocity[1] + 0.001072 * x_18 + x_62
    x_64 = 5.11984e-5 * joint_velocity[1]
    x_65 = x_48 * x_64
    x_66 = 0.115871288 * joint_velocity[1]
    x_67 = -x_17
    x_68 = 2 * x_36
    x_69 = math.cos(joint_position[3])
    x_70 = math.sin(joint_position[3])
    x_71 = x_13 * x_70
    x_72 = x_40 * x_69
    x_73 = x_71 + 0.0064 * x_72
    x_74 = x_13 * x_69
    x_75 = x_40 * x_70
    x_76 = 0.0064 * x_75
    x_77 = 0.2084 * x_14 - x_74 + x_76
    x_78 = x_69 * x_73 + x_70 * x_77
    x_79 = x_3 * x_70
    x_80 = 0.2084 * x_9
    x_81 = x_0 * x_69
    x_82 = 0.2084 * x_79 + x_80 * x_81
    x_83 = -x_82
    x_84 = x_70 * x_73
    x_85 = x_69 * x_77
    x_86 = x_12 * x_84 - x_12 * x_85 + x_83 * x_9
    x_87 = 0.0100224 * x_1
    x_88 = 2 * x_78
    x_89 = 0.3905024 * x_31
    x_90 = -1.8e-5 * x_14 + 0.015006 * x_72 + 0.015006 * x_79
    x_91 = x_3 * x_69
    x_92 = 0.075478 * x_14 + 0.015006 * x_75 - 0.015006 * x_91
    x_93 = x_69 * x_90 + x_70 * x_92
    x_94 = joint_velocity[1] * x_12
    x_95 = joint_velocity[2] * x_94
    x_96 = x_18 * x_94
    x_97 = x_48 * x_9
    x_98 = joint_velocity[2] * x_97
    x_99 = joint_velocity[2] + x_18
    x_100 = -0.2104 * x_94 + 0.2104 * x_97
    x_101 = x_100 * x_99
    x_102 = joint_velocity[1] * x_9
    x_103 = x_12 * x_48
    x_104 = x_102 + x_103
    x_105 = -x_104
    x_106 = 0.0064 * x_94
    x_107 = -x_106 + 0.0064 * x_97
    x_108 = x_105 * x_107
    x_109 = (
        -0.5 * x_101
        + 0.5 * x_108
        + 0.0032 * x_49
        - 0.1052 * x_95
        + 0.1052 * x_96
        + 0.1052 * x_98
    )
    x_110 = 0.0054 * x_3
    x_111 = x_110 * x_9
    x_112 = (
        -0.678 * x_101
        + 0.678 * x_108
        + 0.0043392 * x_49
        - 0.1426512 * x_95
        + 0.1426512 * x_96
        + 0.1426512 * x_98
    )
    x_113 = x_112 * x_9
    x_114 = 0.0108 * x_3
    x_115 = (
        -0.93 * x_101
        + 0.93 * x_108
        + 0.005952 * x_49
        - 0.195672 * x_95
        + 0.195672 * x_96
        + 0.195672 * x_98
    )
    x_116 = joint_velocity[2] * x_102
    x_117 = joint_velocity[2] * x_103
    x_118 = -x_94 + x_97
    x_119 = -0.0064 * joint_velocity[2] + 0.2104 * x_102 + 0.2104 * x_103 - x_22
    x_120 = (
        0.1052 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        - 0.5 * x_107 * x_118
        - 0.1052 * x_116
        - 0.1052 * x_117
        + 0.5 * x_119 * x_99
    )
    x_121 = 0.2104 * x_40
    x_122 = x_110 * x_12
    x_123 = x_107 * x_118
    x_124 = (
        0.1426512 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        - 0.1426512 * x_116
        - 0.1426512 * x_117
        + 0.678 * x_119 * x_99
        - 0.678 * x_123
    )
    x_125 = 0.4208 * x_40
    x_126 = x_114 * x_12
    x_127 = (
        0.195672 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        - 0.195672 * x_116
        - 0.195672 * x_117
        + 0.93 * x_119 * x_99
        - 0.93 * x_123
    )
    x_128 = (
        0.0032 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        + 0.5 * x_100 * x_118
        - 0.5 * x_105 * x_119
        - 0.0032 * x_116
        - 0.0032 * x_117
    )
    x_129 = x_105 * x_119
    x_130 = (
        0.0043392 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        + 0.678 * x_100 * x_118
        - 0.0043392 * x_116
        - 0.0043392 * x_117
        - 0.678 * x_129
    )
    x_131 = (
        0.005952 * joint_velocity[0] * joint_velocity[1] * x_3 * x_9
        + 0.93 * x_100 * x_118
        - 0.005952 * x_116
        - 0.005952 * x_117
        - 0.93 * x_129
    )
    x_132 = 2 * x_112
    x_133 = -x_13 * x_9 + x_15
    x_134 = x_70 * x_90
    x_135 = x_69 * x_92
    x_136 = 1.8e-5 * x_9
    x_137 = x_136 * x_70
    x_138 = 0.075478 * x_9
    x_139 = x_0 * x_137 + x_138 * x_81 - 1.8e-5 * x_3 * x_69 + 0.075478 * x_79
    x_140 = -x_139
    x_141 = x_12 * x_134 - x_12 * x_135 + x_140 * x_9
    x_142 = 0.005022 * x_1
    x_143 = x_12 * x_13 + x_121
    x_144 = math.cos(joint_position[4])
    x_145 = x_144 * x_9
    x_146 = math.sin(joint_position[4])
    x_147 = x_12 * x_146
    x_148 = x_147 * x_69
    x_149 = -x_145 + x_148
    x_150 = -x_149
    x_151 = x_144 * x_79
    x_152 = x_144 * x_69 * x_9 - x_147
    x_153 = x_0 * x_152
    x_154 = 0.1059 * x_151 + 0.1059 * x_153
    x_155 = x_146 * x_9
    x_156 = x_12 * x_144
    x_157 = x_156 * x_69
    x_158 = x_155 + x_157
    x_159 = x_155 * x_69
    x_160 = x_156 + x_159
    x_161 = -x_160
    x_162 = x_0 * x_161
    x_163 = 0.1059 * x_146 * x_3 * x_70 - 0.1059 * x_162
    x_164 = 0.0063612 * x_1
    x_165 = 2 * x_124
    x_166 = 0.195672 * x_31
    x_167 = x_146 * x_154
    x_168 = x_144 * x_163 * x_70 - x_167 * x_70
    x_169 = 0.2478512 * x_31
    x_170 = 0.1371791312 * joint_velocity[2]
    x_171 = (
        joint_velocity[0] * x_43
        + 0.006641 * joint_velocity[2]
        + 0.117892 * x_102
        + 0.117892 * x_103
    )
    x_172 = 1.1636 * x_99
    x_173 = 0.006641 * joint_velocity[1] * x_12 - x_48 * x_57 - x_48 * x_58 - x_50 * x_9
    x_174 = (
        -x_102 * x_170
        + 0.1371791312 * x_102 * x_18
        - x_103 * x_170
        - 1.1636 * x_118 * x_173
        + x_171 * x_172
        + x_65
    )
    x_175 = x_12 * x_174
    x_176 = (
        0.117892 * joint_velocity[0] * x_0 * x_9
        - 4.4e-5 * joint_velocity[2]
        - x_53
        - 0.117892 * x_94
    )
    x_177 = (
        0.1371791312 * joint_velocity[0] * joint_velocity[1] * x_12 * x_3
        + 0.1371791312 * joint_velocity[0] * joint_velocity[2] * x_0 * x_9
        + 1.1636 * x_105 * x_173
        - x_170 * x_94
        - x_172 * x_176
        - 0.0077274676 * x_49
    )
    x_178 = x_177 * x_9
    x_179 = joint_velocity[2] * x_118
    x_180 = 7.0e-6 * joint_velocity[2]
    x_181 = 7.0e-6 * x_18
    x_182 = 0.010932 * joint_velocity[0] * x_0 * x_9 - x_180 - x_181 - 0.010932 * x_94
    x_183 = (
        0.001043 * joint_velocity[0] * x_3
        + 7.0e-6 * joint_velocity[1] * x_12
        + 0.001043 * joint_velocity[2]
        - 0.000606 * x_102
        - 0.000606 * x_103
        - 7.0e-6 * x_97
    )
    x_184 = (
        -x_118 * x_183
        - 0.011127 * x_179
        + x_182 * x_99
        - 0.000606 * x_49
        - 0.011127 * x_96
    )
    x_185 = x_102 * x_18
    x_186 = joint_velocity[2] * x_105
    x_187 = (
        0.000606 * joint_velocity[0] * x_3
        + 0.000606 * joint_velocity[2]
        - 0.011127 * x_102
        - 0.011127 * x_103
    )
    x_188 = (
        x_105 * x_183
        + 0.010932 * x_185
        + 0.010932 * x_186
        - x_187 * x_99
        + 7.0e-6 * x_49
    )
    x_189 = (
        0.0077274676 * joint_velocity[0] * joint_velocity[2] * x_0 * x_12
        + 5.11984e-5 * joint_velocity[1] * joint_velocity[2] * x_12
        + 0.0077274676 * joint_velocity[1] * joint_velocity[2] * x_9
        - 1.1636 * x_105 * x_171
        + 1.1636 * x_118 * x_176
        - 0.0077274676 * x_185
        - 5.11984e-5 * x_96
        - 5.11984e-5 * x_98
    )
    x_190 = -x_158
    x_191 = x_149 * x_154 + x_163 * x_190
    x_192 = x_69 * x_77 - x_84
    x_193 = x_146 * x_79
    x_194 = x_0 * x_160
    x_195 = 0.1059 * x_193 + 0.1059 * x_194
    x_196 = math.cos(joint_position[5])
    x_197 = x_155 * x_196
    x_198 = math.sin(joint_position[5])
    x_199 = x_198 * x_70
    x_200 = x_144 * x_196 * x_69 - x_199
    x_201 = x_12 * x_200
    x_202 = x_197 + x_201
    x_203 = x_198 * x_69
    x_204 = x_196 * x_70
    x_205 = x_144 * x_204
    x_206 = x_203 + x_205
    x_207 = x_206 * x_3
    x_208 = x_147 * x_196
    x_209 = x_200 * x_9
    x_210 = -x_208 + x_209
    x_211 = x_0 * x_210
    x_212 = 0.1059 * x_207 + 0.1059 * x_211
    x_213 = -x_212
    x_214 = 0.0027 * x_1
    x_215 = x_146 * x_213
    x_216 = x_195 * x_206 + x_215 * x_70
    x_217 = 0.000606 * joint_velocity[2] * x_118
    x_218 = x_105 * x_180
    x_219 = x_105 * x_182
    x_220 = 0.1052 * x_31
    x_221 = x_144 * x_154 + x_146 * x_163
    x_222 = x_144 * x_163 * x_69 - x_167 * x_69
    x_223 = -x_202
    x_224 = x_195 * x_196
    x_225 = x_144 * x_213 - x_146 * x_224
    x_226 = 0.063883 * x_151 + 0.063883 * x_153 - 1.0e-6 * x_75 + 1.0e-6 * x_91
    x_227 = (
        0.063883 * x_146 * x_3 * x_70
        - 0.063883 * x_162
        + 0.009432 * x_3 * x_69
        - 0.009432 * x_75
    )
    x_228 = x_144 * x_226 + x_146 * x_227
    x_229 = 0.009432 * x_144
    x_230 = (
        1.0e-6 * x_146 * x_3 * x_70 - 0.009432 * x_153 - 1.0e-6 * x_162 - x_229 * x_79
    )
    x_231 = x_230 * x_70
    x_232 = x_12 * x_231
    x_233 = 0.0036612 * x_1
    x_234 = x_146 * x_226
    x_235 = x_144 * x_227 * x_70 + x_230 * x_69 - x_234 * x_70
    x_236 = 0.1426512 * x_31
    x_237 = 0.0054 * x_9
    x_238 = x_237 * x_79 + 0.0054 * x_81
    x_239 = joint_velocity[2] * x_69
    x_240 = joint_velocity[3] * x_239
    x_241 = x_102 * x_239
    x_242 = x_70 * x_94
    x_243 = joint_velocity[3] * x_242
    x_244 = joint_velocity[1] * x_0
    x_245 = x_244 * x_70
    x_246 = joint_velocity[0] * (
        joint_velocity[1] * x_3 * x_69 * x_9
        + joint_velocity[3] * x_3 * x_69
        - joint_velocity[3] * x_75
        - x_14 * x_239
        - x_245
    )
    x_247 = joint_velocity[3] + x_104
    x_248 = x_3 * x_69 - x_75
    x_249 = joint_velocity[0] * x_248
    x_250 = (
        0.2084 * joint_velocity[0] * x_0 * x_12
        + 0.2084 * joint_velocity[1] * x_9
        + 0.2084 * joint_velocity[3]
        - x_106 * x_70
        - 0.0064 * x_239
        - 0.0064 * x_249
    )
    x_251 = joint_velocity[2] * x_70
    x_252 = x_69 * x_94
    x_253 = x_72 + x_79
    x_254 = joint_velocity[0] * x_253
    x_255 = x_251 - x_252 + x_254
    x_256 = 0.2084 * joint_velocity[1] * x_12 * x_69 - 0.2084 * x_251 - 0.2084 * x_254
    x_257 = (
        0.0032 * x_240
        - 0.0032 * x_241
        + 0.0032 * x_243
        + 0.0032 * x_246
        + 0.5 * x_247 * x_250
        - 0.5 * x_255 * x_256
    )
    x_258 = 0.678 * x_247
    x_259 = (
        0.0043392 * x_240
        - 0.0043392 * x_241
        + 0.0043392 * x_243
        + 0.0043392 * x_246
        + x_250 * x_258
        - 0.678 * x_255 * x_256
    )
    x_260 = 2 * x_259
    x_261 = -x_106 * x_69 + 0.0064 * x_251 + 0.0064 * x_254
    x_262 = x_239 + x_242 + x_249
    x_263 = (
        0.1412952 * joint_velocity[1] * joint_velocity[2] * x_69 * x_9
        - 0.1412952 * x_240
        - 0.1412952 * x_243
        - 0.1412952 * x_246
        - 0.678 * x_250 * x_262
        + 0.678 * x_255 * x_261
    )
    x_264 = (
        0.1042 * joint_velocity[1] * joint_velocity[2] * x_69 * x_9
        - 0.1042 * x_240
        - 0.1042 * x_243
        - 0.1042 * x_246
        - 0.5 * x_250 * x_262
        + 0.5 * x_255 * x_261
    )
    x_265 = 0.0054 * x_0 * x_70
    x_266 = -x_237 * x_91 + x_265
    x_267 = x_102 * x_251
    x_268 = joint_velocity[3] * x_252
    x_269 = (
        joint_velocity[2] * x_0 * x_12 * x_70
        - joint_velocity[3] * x_72
        - joint_velocity[3] * x_79
        - x_102 * x_79
        - x_244 * x_69
    )
    x_270 = joint_velocity[0] * x_269
    x_271 = (
        0.1042 * joint_velocity[0] * joint_velocity[1] * x_12 * x_3
        + 0.1042 * joint_velocity[0] * joint_velocity[2] * x_0 * x_9
        + 0.0032 * joint_velocity[2] * joint_velocity[3] * x_70
        - 0.5 * x_247 * x_261
        + 0.5 * x_256 * x_262
        - 0.0032 * x_267
        - 0.0032 * x_268
        - 0.0032 * x_270
        - 0.1042 * x_95
    )
    x_272 = -x_15 * x_70 + x_71 * x_9 + 0.0064 * x_81
    x_273 = (
        0.1412952 * joint_velocity[0] * joint_velocity[1] * x_12 * x_3
        + 0.1412952 * joint_velocity[0] * joint_velocity[2] * x_0 * x_9
        + 0.0043392 * joint_velocity[2] * joint_velocity[3] * x_70
        + 0.678 * x_256 * x_262
        - x_258 * x_261
        - 0.0043392 * x_267
        - 0.0043392 * x_268
        - 0.0043392 * x_270
        - 0.1412952 * x_95
    )
    x_274 = 2 * x_273
    x_275 = 0.0064 * x_0 * x_69 * x_9 - x_16 * x_70
    x_276 = -x_143
    x_277 = x_195 * x_198
    x_278 = 2 * x_263
    x_279 = x_16 * x_69
    x_280 = x_279 + x_76
    x_281 = 0.0064 * x_0 * x_70
    x_282 = x_15 * x_69 + x_281 - x_74 * x_9
    x_283 = (
        0.015006 * joint_velocity[0] * x_253
        + 0.015006 * joint_velocity[2] * x_70
        - 1.8e-5 * joint_velocity[3]
        - 1.8e-5 * x_102
        - 1.8e-5 * x_103
        - 0.015006 * x_252
    )
    x_284 = 0.93 * x_247
    x_285 = 1.8e-5 * x_70
    x_286 = 0.075478 * x_69
    x_287 = (
        1.8e-5 * x_239
        + 1.8e-5 * x_249
        - 0.075478 * x_251
        - 0.075478 * x_254
        + x_285 * x_94
        + x_286 * x_94
    )
    x_288 = (
        0.07019454 * joint_velocity[0] * joint_velocity[1] * x_12 * x_3
        + 0.07019454 * joint_velocity[0] * joint_velocity[2] * x_0 * x_9
        + 0.01395558 * joint_velocity[2] * joint_velocity[3] * x_70
        + 0.93 * x_262 * x_287
        - 0.01395558 * x_267
        - 0.01395558 * x_268
        - 0.01395558 * x_270
        - x_283 * x_284
        - 0.07019454 * x_95
    )
    x_289 = (
        0.075478 * joint_velocity[0] * x_0 * x_12
        + 0.075478 * joint_velocity[1] * x_9
        + 0.075478 * joint_velocity[3]
        - 0.015006 * x_239
        - 0.015006 * x_242
        - 0.015006 * x_249
    )
    x_290 = (
        0.01395558 * x_240
        - 0.01395558 * x_241
        + 0.01395558 * x_243
        + 0.01395558 * x_246
        - 0.93 * x_255 * x_287
        + x_284 * x_289
        + 1.674e-5 * x_95
        - 1.674e-5 * x_96
        - 1.674e-5 * x_98
    )
    x_291 = x_144 * x_163 - x_167
    x_292 = joint_velocity[3] * x_146
    x_293 = x_144 * x_251
    x_294 = joint_velocity[1] * x_190
    x_295 = x_151 + x_153
    x_296 = joint_velocity[0] * x_295
    x_297 = -x_292 + x_293 + x_294 + x_296
    x_298 = -0.1059 * x_292 + 0.1059 * x_293 + 0.1059 * x_294 + 0.1059 * x_296
    x_299 = x_297 * x_298
    x_300 = joint_velocity[3] * x_144
    x_301 = x_146 * x_251
    x_302 = joint_velocity[1] * x_149
    x_303 = x_162 - x_193
    x_304 = joint_velocity[0] * x_303
    x_305 = -x_300 - x_301 + x_302 + x_304
    x_306 = (
        0.1059 * joint_velocity[2] * x_146 * x_70
        + 0.1059 * joint_velocity[3] * x_144
        - 0.1059 * x_302
        - 0.1059 * x_304
    )
    x_307 = 0.5 * x_306
    x_308 = 0.5 * x_299 - x_305 * x_307
    x_309 = 0.678 * x_305
    x_310 = 0.678 * x_299 - x_306 * x_309
    x_311 = -x_221
    x_312 = 0.0054 * x_0 * x_144 * x_70 - x_110 * x_152
    x_313 = joint_velocity[4] * x_292
    x_314 = joint_velocity[3] * x_70
    x_315 = (
        joint_velocity[2] * x_156
        + joint_velocity[4] * x_155
        + joint_velocity[4] * x_157
        - x_147 * x_314
        + x_155 * x_239
    )
    x_316 = joint_velocity[1] * x_315
    x_317 = joint_velocity[4] + x_262
    x_318 = x_298 * x_317
    x_319 = x_146 * x_245
    x_320 = x_292 * x_91
    x_321 = joint_velocity[4] * x_151
    x_322 = joint_velocity[1] * x_3
    x_323 = (
        -joint_velocity[2] * x_145
        - joint_velocity[4] * x_145 * x_69
        + joint_velocity[4] * x_147
        + x_147 * x_239
        + x_155 * x_314
    )
    x_324 = joint_velocity[0] * (x_0 * x_323 + x_161 * x_322 + x_319 - x_320 - x_321)
    x_325 = (
        0.0718002 * joint_velocity[2] * joint_velocity[3] * x_146 * x_69
        + 0.0718002 * joint_velocity[2] * joint_velocity[4] * x_144 * x_70
        - 0.0718002 * x_313
        - 0.0718002 * x_316
        - 0.678 * x_318
        - 0.0718002 * x_324
    )
    x_326 = 0.05295 * x_313
    x_327 = (
        0.05295 * joint_velocity[2] * joint_velocity[3] * x_146 * x_69
        + 0.05295 * joint_velocity[2] * joint_velocity[4] * x_144 * x_70
        - 0.05295 * x_316
        - 0.5 * x_318
        - 0.05295 * x_324
        - x_326
    )
    x_328 = joint_velocity[4] * x_300
    x_329 = x_239 * x_300
    x_330 = joint_velocity[4] * x_301
    x_331 = (
        joint_velocity[2] * x_147
        - joint_velocity[4] * x_145
        + joint_velocity[4] * x_148
        - x_145 * x_239
        + x_156 * x_314
    )
    x_332 = 0.05295 * joint_velocity[1]
    x_333 = (
        -joint_velocity[4] * x_193
        + x_0
        * (
            -joint_velocity[2] * x_155
            - joint_velocity[4] * x_156
            - joint_velocity[4] * x_159
            - x_145 * x_314
            - x_156 * x_239
        )
        - x_144 * x_245
        + x_152 * x_322
        + x_300 * x_91
    )
    x_334 = 0.05295 * joint_velocity[0]
    x_335 = (
        x_307 * x_317
        - 0.05295 * x_328
        + 0.05295 * x_329
        - 0.05295 * x_330
        + x_331 * x_332
        + x_333 * x_334
    )
    x_336 = joint_velocity[1] * x_331
    x_337 = 0.678 * x_317
    x_338 = joint_velocity[0] * x_333
    x_339 = (
        x_306 * x_337
        - 0.0718002 * x_328
        + 0.0718002 * x_329
        - 0.0718002 * x_330
        + 0.0718002 * x_336
        + 0.0718002 * x_338
    )
    x_340 = x_146 * x_265
    x_341 = -x_110 * x_161 - x_340
    x_342 = 0.0005 * joint_velocity[3]
    x_343 = 0.0005 * x_102
    x_344 = 1.0e-6 * x_251
    x_345 = (
        0.000631 * joint_velocity[0] * x_248
        + 1.0e-6 * joint_velocity[1] * x_12 * x_69
        + 0.000631 * joint_velocity[1] * x_12 * x_70
        + 0.000631 * joint_velocity[2] * x_69
        - 0.0005 * x_103
        - 1.0e-6 * x_254
        - x_342
        - x_343
        - x_344
    )
    x_346 = 1.0e-6 * x_239
    x_347 = 1.0e-6 * x_242 + 1.0e-6 * x_249 + x_346
    x_348 = (
        0.008147 * joint_velocity[0] * x_253
        + 0.008147 * joint_velocity[2] * x_70
        - 0.008147 * x_252
        - x_347
    )
    x_349 = x_105 * x_251
    x_350 = x_49 * x_69
    x_351 = (
        0.008316 * x_179
        + x_18 * x_343 * x_70
        + x_255 * x_342
        + x_255 * x_345
        - x_262 * x_348
        + 0.0005 * x_349
        + 0.0005 * x_350
    )
    x_352 = x_351 + 0.008316 * x_96
    x_353 = x_144 * x_279 + x_145 * x_281 + x_155 * x_35
    x_354 = joint_velocity[3] * x_251
    x_355 = (
        1.674e-5 * joint_velocity[0] * x_269
        + 0.07019454 * joint_velocity[1] * joint_velocity[2] * x_69 * x_9
        + 1.674e-5 * joint_velocity[1] * joint_velocity[2] * x_70 * x_9
        + 1.674e-5 * joint_velocity[1] * joint_velocity[3] * x_12 * x_69
        - 0.07019454 * x_240
        - 0.07019454 * x_243
        - 0.07019454 * x_246
        + 0.93 * x_255 * x_283
        - 0.93 * x_262 * x_289
        - 1.674e-5 * x_354
    )
    x_356 = -x_145 * x_35 + x_146 * x_279 + x_155 * x_281
    x_357 = -x_356
    x_358 = x_146 * x_83
    x_359 = x_144 * x_77 - x_358
    x_360 = 0.0064 * x_0 * x_144 * x_70 - x_13 * x_152 - x_190 * x_35
    x_361 = x_144 * x_83 + x_146 * x_77
    x_362 = -x_361
    x_363 = x_146 * x_281
    x_364 = -x_13 * x_161 - x_149 * x_35 - x_363
    x_365 = 1.0e-6 * x_69
    x_366 = x_185 * x_70
    x_367 = x_105 * x_239
    x_368 = joint_velocity[3] * x_262
    x_369 = joint_velocity[3] * x_255
    x_370 = (
        0.008316 * joint_velocity[0] * x_0 * x_12
        + 0.008316 * joint_velocity[1] * x_9
        + 0.008316 * joint_velocity[3]
        - 0.0005 * x_239
        - 0.0005 * x_242
        - 0.0005 * x_249
    )
    x_371 = (
        x_105 * x_344
        + 0.008147 * x_185 * x_69
        - x_247 * x_345
        + x_262 * x_370
        + x_365 * x_49
        + 1.0e-6 * x_366
        + 0.008147 * x_367
        + 0.008147 * x_368
        + 1.0e-6 * x_369
        - 0.008147 * x_49 * x_70
    )
    x_372 = x_144 * x_199
    x_373 = x_196 * x_69 - x_372
    x_374 = 1.0e-6 * x_146
    x_375 = 1.0e-6 * x_194 + 0.00965 * x_207 + 0.00965 * x_211 + x_374 * x_79
    x_376 = x_3 * x_373
    x_377 = x_147 * x_198
    x_378 = x_144 * x_203
    x_379 = -x_204 - x_378
    x_380 = x_379 * x_9
    x_381 = x_377 + x_380
    x_382 = x_0 * x_381
    x_383 = (
        0.045483 * x_0 * x_160
        + 0.045483 * x_146 * x_3 * x_70
        - 0.00965 * x_376
        - 0.00965 * x_382
    )
    x_384 = 0.045483 * x_207 + 0.045483 * x_211 + 1.0e-6 * x_376 + 1.0e-6 * x_382
    x_385 = -x_384
    x_386 = x_146 * x_385
    x_387 = x_206 * x_383 + x_373 * x_375 + x_386 * x_70
    x_388 = (
        1.0e-6 * joint_velocity[0] * joint_velocity[1] * x_0 * x_70
        - x_105 * x_346
        - 0.0005 * x_179
        - x_185 * x_365
        + x_247 * x_348
        - x_255 * x_370
        - 0.000631 * x_349
        - 0.000631 * x_350
        - 0.000631 * x_366
        - 1.0e-6 * x_368
        - 0.000631 * x_369
        - 0.0005 * x_96
    )
    x_389 = x_12 * x_379
    x_390 = -x_146 * x_198 * x_9 + x_389
    x_391 = x_196 * x_375 + x_198 * x_383
    x_392 = x_198 * x_375
    x_393 = x_196 * x_383
    x_394 = x_144 * x_385 + x_146 * x_392 - x_146 * x_393
    x_395 = -x_390
    x_396 = joint_velocity[1] * x_150
    x_397 = x_193 + x_194
    x_398 = joint_velocity[0] * x_397
    x_399 = joint_velocity[5] + x_300 + x_301 + x_396 + x_398
    x_400 = (
        0.1059 * joint_velocity[5]
        + 0.1059 * x_300
        + 0.1059 * x_301
        + 0.1059 * x_396
        + 0.1059 * x_398
    )
    x_401 = joint_velocity[4] * x_198
    x_402 = x_196 * x_292
    x_403 = joint_velocity[2] * x_206
    x_404 = joint_velocity[1] * x_223
    x_405 = x_207 + x_211
    x_406 = joint_velocity[0] * x_405
    x_407 = x_401 - x_402 + x_403 + x_404 + x_406
    x_408 = (
        0.1059 * joint_velocity[3] * x_146 * x_196
        - 0.1059 * x_401
        - 0.1059 * x_403
        - 0.1059 * x_404
        - 0.1059 * x_406
    )
    x_409 = 0.5 * x_399 * x_400 - 0.5 * x_407 * x_408
    x_410 = x_163 * x_198
    x_411 = 0.0054 * x_0 * x_373 - x_110 * x_381
    x_412 = x_155 * x_198
    x_413 = x_16 * x_379 - x_35 * x_412 + x_373 * x_41
    x_414 = x_144 * x_77
    x_415 = x_196 * x_73 + x_198 * x_358 - x_198 * x_414
    x_416 = x_239 * x_292
    x_417 = joint_velocity[4] * x_293
    x_418 = -x_315
    x_419 = -x_0 * x_323 + x_160 * x_322 - x_319 + x_320 + x_321
    x_420 = joint_velocity[4] * x_196
    x_421 = x_198 * x_292
    x_422 = joint_velocity[2] * x_373
    x_423 = joint_velocity[1] * x_395
    x_424 = x_376 + x_382
    x_425 = joint_velocity[0] * x_424
    x_426 = x_420 + x_421 + x_422 + x_423 + x_425
    x_427 = 0.5 * x_426
    x_428 = (
        -x_326
        + x_332 * x_418
        + x_334 * x_419
        + x_408 * x_427
        + 0.05295 * x_416
        + 0.05295 * x_417
    )
    x_429 = x_163 * x_196
    x_430 = 0.0064 * x_0 * x_373 - x_13 * x_381 - x_35 * x_395
    x_431 = 0.0054 * x_0 * x_206 - x_110 * x_210
    x_432 = x_16 * x_200 + x_197 * x_35 + x_206 * x_41
    x_433 = x_198 * x_73
    x_434 = -x_196 * x_358 + x_196 * x_414 + x_433
    x_435 = 0.0064 * x_0 * x_206 - x_13 * x_210 - x_223 * x_35
    x_436 = x_144 * x_70
    x_437 = x_262 * x_300
    x_438 = 0.000256 * joint_velocity[4]
    x_439 = 0.000256 * x_239
    x_440 = (
        0.000256 * x_242
        + 0.000256 * x_249
        - 0.001607 * x_300
        - 0.001607 * x_301
        + 0.001607 * x_302
        + 0.001607 * x_304
        + x_438
        + x_439
    )
    x_441 = (
        0.000399 * joint_velocity[4]
        + 0.000399 * x_239
        + 0.000399 * x_242
        + 0.000399 * x_249
        - 0.000256 * x_300
        - 0.000256 * x_301
        + 0.000256 * x_302
        + 0.000256 * x_304
    )
    x_442 = (
        0.001596 * joint_velocity[4] * x_305
        + 0.001596 * x_144 * x_367
        - 0.001596 * x_146 * x_179
        + 0.001596 * x_152 * x_19
        + x_305 * x_441
        - x_317 * x_440
        - 0.001596 * x_436 * x_49
        + 0.001596 * x_437
    )
    x_443 = x_144 * x_179
    x_444 = x_146 * x_367
    x_445 = x_262 * x_292
    x_446 = joint_velocity[4] * x_297
    x_447 = -0.001596 * x_292 + 0.001596 * x_293 + 0.001596 * x_294 + 0.001596 * x_296
    x_448 = (
        0.001607 * joint_velocity[0] * joint_velocity[1] * x_0 * x_146 * x_70
        + 0.001607 * joint_velocity[0] * joint_velocity[1] * x_161 * x_3
        - x_297 * x_441
        + x_317 * x_447
        - 0.000256 * x_349
        - 0.000256 * x_350
        - 0.000256 * x_366
        - 0.000256 * x_369
        - 0.001607 * x_443
        - 0.001607 * x_444
        - 0.001607 * x_445
        - 0.001607 * x_446
    )
    x_449 = math.cos(joint_position[6])
    x_450 = x_203 * x_449
    x_451 = math.sin(joint_position[6])
    x_452 = x_146 * x_451
    x_453 = x_144 * x_196 * x_449 - x_452
    x_454 = x_453 * x_70
    x_455 = x_450 + x_454
    x_456 = x_3 * x_455
    x_457 = x_203 * x_451
    x_458 = x_146 * x_449
    x_459 = x_144 * x_451
    x_460 = x_196 * x_459
    x_461 = -x_458 - x_460
    x_462 = x_461 * x_70
    x_463 = -x_457 + x_462
    x_464 = x_196 * x_458
    x_465 = x_459 + x_464
    x_466 = x_12 * x_465
    x_467 = x_199 * x_449
    x_468 = x_453 * x_69
    x_469 = -x_467 + x_468
    x_470 = x_469 * x_9
    x_471 = -x_466 + x_470
    x_472 = x_0 * x_471
    x_473 = x_196 * x_452
    x_474 = -x_144 * x_449 + x_473
    x_475 = -x_474
    x_476 = x_12 * x_475
    x_477 = x_199 * x_451
    x_478 = x_461 * x_69
    x_479 = x_477 + x_478
    x_480 = x_479 * x_9
    x_481 = -x_476 + x_480
    x_482 = (
        0.000281 * x_0 * x_481
        + 0.000281 * x_3 * x_463
        - 0.011402 * x_456
        - 0.011402 * x_472
    )
    x_483 = 0.000399 * x_350
    x_484 = 0.000399 * x_366
    x_485 = 0.000256 * x_443
    x_486 = 0.000399 * x_349
    x_487 = x_105 * x_146 * x_439
    x_488 = 0.000399 * x_369
    x_489 = 0.000256 * x_445
    x_490 = x_297 * x_438
    x_491 = x_305 * x_447
    x_492 = (
        0.000256 * joint_velocity[0] * joint_velocity[1] * x_0 * x_146 * x_70
        + 0.000256 * joint_velocity[0] * joint_velocity[1] * x_161 * x_3
        + x_297 * x_440
        - x_483
        - x_484
        - x_485
        - x_486
        - x_487
        - x_488
        - x_489
        - x_490
        - x_491
    )
    x_493 = -0.000281 * x_376 - 0.000281 * x_382 + 0.029798 * x_456 + 0.029798 * x_472
    x_494 = x_3 * x_463
    x_495 = x_0 * x_481
    x_496 = (
        0.011402 * x_0 * x_381
        + 0.011402 * x_3 * x_373
        - 0.029798 * x_494
        - 0.029798 * x_495
    )
    x_497 = x_449 * x_493 + x_451 * x_496
    x_498 = x_373 * x_482 + x_455 * x_496 + x_463 * x_493
    x_499 = x_198 * x_482
    x_500 = x_146 * x_499
    x_501 = (
        1.0e-6 * joint_velocity[4]
        - 0.063883 * x_292
        + 0.063883 * x_293
        + 0.063883 * x_294
        + 0.063883 * x_296
        + x_347
    )
    x_502 = (
        1.0e-6 * joint_velocity[2] * x_146 * x_70
        + 1.0e-6 * joint_velocity[3] * x_144
        + 0.009432 * joint_velocity[3] * x_146
        - x_229 * x_251
        - 0.009432 * x_294
        - 0.009432 * x_296
        - 1.0e-6 * x_302
        - 1.0e-6 * x_304
    )
    x_503 = (
        0.006394896 * x_267
        + 0.006394896 * x_268
        + 0.006394896 * x_270
        + x_309 * x_502
        - 0.043312674 * x_313
        - 0.043312674 * x_316
        - 0.678 * x_317 * x_501
        - 0.043312674 * x_324
        - 0.006394896 * x_354
        + 0.043312674 * x_416
        + 0.043312674 * x_417
    )
    x_504 = -x_110 * x_160 + x_340
    x_505 = joint_velocity[5] * x_420
    x_506 = joint_velocity[5] * x_421
    x_507 = joint_velocity[4] * x_146
    x_508 = (
        joint_velocity[3] * x_144 * x_196 * x_69
        - joint_velocity[3] * x_199
        + joint_velocity[5] * x_196 * x_69
        - joint_velocity[5] * x_372
        - x_204 * x_507
    )
    x_509 = joint_velocity[2] * x_508
    x_510 = x_196 * x_69
    x_511 = (
        -joint_velocity[3] * x_203
        - joint_velocity[5] * x_204
        - joint_velocity[5] * x_378
        - x_204 * x_300
        - x_507 * x_510
    )
    x_512 = joint_velocity[1] * (
        joint_velocity[2] * x_12 * x_146 * x_196
        - joint_velocity[2] * x_209
        + joint_velocity[5] * x_146 * x_198 * x_9
        - x_12 * x_511
        - x_145 * x_420
    )
    x_513 = joint_velocity[0] * (
        x_0
        * (
            -joint_velocity[2] * x_197
            - joint_velocity[2] * x_201
            + joint_velocity[5] * x_12 * x_146 * x_198
            - x_156 * x_420
            + x_511 * x_9
        )
        - x_206 * x_244
        + x_210 * x_322
        + x_3 * x_508
    )
    x_514 = (
        0.05295 * joint_velocity[3] * joint_velocity[4] * x_144 * x_196
        - x_400 * x_427
        - 0.05295 * x_505
        - 0.05295 * x_506
        - 0.05295 * x_509
        - 0.05295 * x_512
        - 0.05295 * x_513
    )
    x_515 = (
        0.009432 * joint_velocity[4]
        + 0.009432 * x_239
        + 0.009432 * x_242
        + 0.009432 * x_249
        + 0.063883 * x_300
        + 0.063883 * x_301
        - 0.063883 * x_302
        - 0.063883 * x_304
    )
    x_516 = x_297 * x_502
    x_517 = (
        6.78e-7 * x_267
        + 6.78e-7 * x_268
        + 6.78e-7 * x_270
        - 0.043312674 * x_328
        + 0.043312674 * x_329
        - 0.043312674 * x_330
        + 0.043312674 * x_336
        + x_337 * x_515
        + 0.043312674 * x_338
        - 6.78e-7 * x_354
        - 0.678 * x_516
    )
    x_518 = -x_154
    x_519 = x_475 * x_9
    x_520 = x_12 * x_479
    x_521 = x_519 + x_520
    x_522 = x_465 * x_9
    x_523 = x_12 * x_469
    x_524 = x_522 + x_523
    x_525 = -x_13 * x_160 - x_150 * x_35 + x_363
    x_526 = -x_521
    x_527 = -x_524
    x_528 = x_451 * x_493
    x_529 = x_196 * x_482 + x_198 * x_449 * x_496 - x_198 * x_528
    x_530 = 6.78e-7 * x_313
    x_531 = (
        6.78e-7 * joint_velocity[2] * joint_velocity[3] * x_146 * x_69
        + 6.78e-7 * joint_velocity[2] * joint_velocity[4] * x_144 * x_70
        + 0.006394896 * joint_velocity[2] * joint_velocity[4] * x_146 * x_70
        + 0.006394896 * joint_velocity[3] * joint_velocity[4] * x_144
        + 0.678 * x_297 * x_501
        - x_309 * x_515
        - 6.78e-7 * x_316
        - 6.78e-7 * x_324
        - 0.006394896 * x_329
        - 0.006394896 * x_336
        - 0.006394896 * x_338
        - x_530
    )
    x_532 = -x_465
    x_533 = 0.001641 * x_49
    x_534 = x_146 * x_196
    x_535 = x_305 * x_420
    x_536 = 0.000278 * joint_velocity[5]
    x_537 = 0.000278 * x_300
    x_538 = (
        -0.000278 * x_301
        - 0.000278 * x_396
        - 0.000278 * x_398
        + 0.00041 * x_420
        + 0.00041 * x_421
        + 0.00041 * x_422
        + 0.00041 * x_423
        + 0.00041 * x_425
        - x_536
        - x_537
    )
    x_539 = (
        0.001641 * joint_velocity[0] * x_397
        + 0.001641 * joint_velocity[1] * x_150
        + 0.001641 * joint_velocity[2] * x_146 * x_70
        + 0.001641 * joint_velocity[3] * x_144
        + 0.001641 * joint_velocity[5]
        - 0.000278 * x_420
        - 0.000278 * x_421
        - 0.000278 * x_422
        - 0.000278 * x_423
        - 0.000278 * x_425
    )
    x_540 = (
        0.001641 * joint_velocity[5] * x_426
        - 0.001641 * x_179 * x_534
        + 0.001641 * x_186 * x_200
        + 0.001641 * x_19 * x_210
        + 0.001641 * x_196 * x_262 * x_300
        - 0.001641 * x_198 * x_369
        - x_206 * x_533
        - x_399 * x_538
        + x_426 * x_539
        + 0.001641 * x_535
    )
    x_541 = x_160 * x_19
    x_542 = x_373 * x_49
    x_543 = x_196 * x_369
    x_544 = x_198 * x_437
    x_545 = x_305 * x_401
    x_546 = joint_velocity[5] * x_407
    x_547 = (
        0.001641 * x_401
        - 0.001641 * x_402
        + 0.001641 * x_403
        + 0.001641 * x_404
        + 0.001641 * x_406
    )
    x_548 = (
        0.000278 * joint_velocity[0] * joint_velocity[1] * x_0 * x_146 * x_70
        + 0.00041 * joint_velocity[0] * joint_velocity[1] * x_3 * x_381
        + 0.00041 * joint_velocity[2] * x_105 * x_379
        + 0.00041 * joint_velocity[2] * x_118 * x_146 * x_198
        + x_399 * x_547
        - x_407 * x_539
        - 0.000278 * x_443
        - 0.000278 * x_444
        - 0.000278 * x_445
        - 0.000278 * x_446
        - 0.000278 * x_541
        - 0.00041 * x_542
        - 0.00041 * x_543
        - 0.00041 * x_544
        - 0.00041 * x_545
        - 0.00041 * x_546
    )
    x_549 = x_146 * x_70
    x_550 = x_146 * x_198
    x_551 = x_179 * x_550
    x_552 = x_186 * x_379
    x_553 = x_19 * x_381
    x_554 = (
        x_198 * x_262 * x_537
        + x_407 * x_536
        + x_407 * x_538
        - x_426 * x_547
        + 0.001641 * x_443
        + 0.001641 * x_444
        + 0.001641 * x_445
        + 0.001641 * x_446
        - x_533 * x_549
        + 0.001641 * x_541
        + 0.000278 * x_542
        + 0.000278 * x_543
        + 0.000278 * x_545
        - 0.000278 * x_551
        - 0.000278 * x_552
        - 0.000278 * x_553
    )
    x_555 = x_300 * x_401
    x_556 = joint_velocity[5] * x_402
    x_557 = (
        -joint_velocity[3] * x_204
        + joint_velocity[4] * x_146 * x_198 * x_70
        - joint_velocity[5] * x_203
        - joint_velocity[5] * x_205
        - x_203 * x_300
    )
    x_558 = joint_velocity[2] * x_557
    x_559 = x_144 * x_510
    x_560 = (
        -joint_velocity[3] * x_510
        + joint_velocity[5] * x_199
        - joint_velocity[5] * x_559
        + x_199 * x_300
        + x_203 * x_507
    )
    x_561 = joint_velocity[1] * (
        -joint_velocity[2] * x_377
        - joint_velocity[2] * x_380
        + joint_velocity[4] * x_144 * x_198 * x_9
        + joint_velocity[5] * x_146 * x_196 * x_9
        - x_12 * x_560
    )
    x_562 = joint_velocity[0] * (
        x_0
        * (
            -joint_velocity[2] * x_389
            + joint_velocity[2] * x_412
            + joint_velocity[5] * x_208
            + x_156 * x_401
            + x_560 * x_9
        )
        - x_244 * x_373
        + x_3 * x_557
        + x_322 * x_381
    )
    x_563 = (
        1.0e-6 * joint_velocity[5]
        + x_251 * x_374
        + 1.0e-6 * x_300
        + 1.0e-6 * x_396
        + 1.0e-6 * x_398
        + 0.00965 * x_401
        - 0.00965 * x_402
        + 0.00965 * x_403
        + 0.00965 * x_404
        + 0.00965 * x_406
    )
    x_564 = x_399 * x_563
    x_565 = 1.0e-6 * x_198
    x_566 = (
        0.045483 * joint_velocity[3] * x_146 * x_196
        - x_292 * x_565
        - 0.045483 * x_401
        - 0.045483 * x_403
        - 0.045483 * x_404
        - 0.045483 * x_406
        - 1.0e-6 * x_420
        - 1.0e-6 * x_422
        - 1.0e-6 * x_423
        - 1.0e-6 * x_425
    )
    x_567 = (
        0.030837474 * joint_velocity[0] * x_419
        + 0.030837474 * joint_velocity[1] * x_418
        + 0.030837474 * joint_velocity[2] * joint_velocity[3] * x_146 * x_69
        + 0.030837474 * joint_velocity[2] * joint_velocity[4] * x_144 * x_70
        + 0.0065427 * joint_velocity[4] * joint_velocity[5] * x_198
        - 0.030837474 * x_313
        + 0.678 * x_426 * x_566
        - 0.0065427 * x_555
        - 0.0065427 * x_556
        - 0.0065427 * x_558
        - 0.0065427 * x_561
        - 0.0065427 * x_562
        - 0.678 * x_564
    )
    x_568 = x_300 * x_420
    x_569 = joint_velocity[1] * x_418
    x_570 = joint_velocity[0] * x_419
    x_571 = (
        0.045483 * joint_velocity[0] * x_397
        + 0.045483 * joint_velocity[1] * x_150
        + 0.045483 * joint_velocity[2] * x_146 * x_70
        + 0.045483 * joint_velocity[3] * x_144
        + 0.045483 * joint_velocity[5]
        - 0.00965 * x_420
        - 0.00965 * x_421
        - 0.00965 * x_422
        - 0.00965 * x_423
        - 0.00965 * x_425
    )
    x_572 = 0.678 * x_571
    x_573 = (
        x_399 * x_572
        - 0.678 * x_407 * x_566
        + 6.78e-7 * x_416
        + 6.78e-7 * x_417
        + 0.0065427 * x_505
        + 0.0065427 * x_506
        + 0.0065427 * x_509
        + 0.0065427 * x_512
        + 0.0065427 * x_513
        - x_530
        - 0.0065427 * x_568
        + 6.78e-7 * x_569
        + 6.78e-7 * x_570
    )
    x_574 = (
        0.030837474 * joint_velocity[3] * joint_velocity[4] * x_144 * x_196
        + 6.78e-7 * joint_velocity[4] * joint_velocity[5] * x_198
        + 0.678 * x_407 * x_563
        - x_426 * x_572
        - 0.030837474 * x_505
        - 0.030837474 * x_506
        - 0.030837474 * x_509
        - 0.030837474 * x_512
        - 0.030837474 * x_513
        - 6.78e-7 * x_555
        - 6.78e-7 * x_556
        - 6.78e-7 * x_558
        - 6.78e-7 * x_561
        - 6.78e-7 * x_562
    )
    x_575 = joint_velocity[5] * x_401
    x_576 = joint_velocity[5] * x_451
    x_577 = 0.014899 * joint_velocity[6]
    x_578 = x_401 * x_449
    x_579 = (
        joint_velocity[4] * x_458
        - joint_velocity[5] * x_146 * x_198 * x_451
        + joint_velocity[6] * x_459
        + joint_velocity[6] * x_464
        + x_420 * x_459
    )
    x_580 = x_144 * x_449
    x_581 = joint_velocity[5] * x_198
    x_582 = (
        -joint_velocity[4] * x_580
        - joint_velocity[6] * x_196 * x_580
        + joint_velocity[6] * x_452
        + x_420 * x_452
        + x_459 * x_581
    )
    x_583 = (
        joint_velocity[3] * x_477
        + joint_velocity[3] * x_478
        - joint_velocity[6] * x_450
        - x_510 * x_576
        + x_582 * x_70
    )
    x_584 = -x_579
    x_585 = (
        joint_velocity[3] * x_457
        - joint_velocity[3] * x_462
        + joint_velocity[6] * x_467
        + x_204 * x_576
        + x_582 * x_69
    )
    x_586 = (
        joint_velocity[2] * x_12 * x_475
        - joint_velocity[2] * x_480
        - x_12 * x_585
        - x_584 * x_9
    )
    x_587 = (
        x_0
        * (
            -joint_velocity[2] * x_519
            - joint_velocity[2] * x_520
            - x_12 * x_584
            + x_585 * x_9
        )
        - x_244 * x_463
        + x_3 * x_583
        + x_322 * x_481
    )
    x_588 = x_456 + x_472
    x_589 = (
        0.029798 * joint_velocity[0] * x_588
        + 0.029798 * joint_velocity[1] * x_527
        + 0.029798 * joint_velocity[2] * x_455
        + 0.029798 * joint_velocity[3] * x_532
        + 0.029798 * joint_velocity[4] * x_198 * x_449
        - 0.000281 * joint_velocity[6]
        - 0.000281 * x_420
        - 0.000281 * x_421
        - 0.000281 * x_422
        - 0.000281 * x_423
        - 0.000281 * x_425
        - 0.029798 * x_576
    )
    x_590 = joint_velocity[6] + x_426
    x_591 = joint_velocity[5] * x_449
    x_592 = x_401 * x_451
    x_593 = joint_velocity[3] * x_474
    x_594 = joint_velocity[2] * x_463
    x_595 = joint_velocity[1] * x_526
    x_596 = x_494 + x_495
    x_597 = joint_velocity[0] * x_596
    x_598 = -x_591 - x_592 + x_593 + x_594 + x_595 + x_597
    x_599 = 0.000281 * x_451
    x_600 = 0.011402 * x_449
    x_601 = joint_velocity[3] * x_532
    x_602 = joint_velocity[2] * x_455
    x_603 = joint_velocity[1] * x_527
    x_604 = joint_velocity[0] * x_588
    x_605 = (
        0.000281 * joint_velocity[0] * x_596
        + 0.000281 * joint_velocity[1] * x_526
        + 0.000281 * joint_velocity[2] * x_463
        + 0.000281 * joint_velocity[3] * x_474
        + 0.011402 * joint_velocity[5] * x_451
        - x_401 * x_599
        - x_401 * x_600
        - 0.000281 * x_591
        - 0.011402 * x_601
        - 0.011402 * x_602
        - 0.011402 * x_603
        - 0.011402 * x_604
    )
    x_606 = 0.5 * x_605
    x_607 = (
        -0.014899 * joint_velocity[0] * x_587
        - 0.014899 * joint_velocity[1] * x_586
        - 0.014899 * joint_velocity[2] * x_583
        - 0.014899 * joint_velocity[3] * x_579
        + 0.014899 * x_420 * x_576
        + 0.005701 * x_555
        + 0.005701 * x_556
        + 0.005701 * x_558
        + 0.005701 * x_561
        + 0.005701 * x_562
        - 0.005701 * x_575
        - x_576 * x_577
        + x_577 * x_578
        - 0.5 * x_589 * x_590
        + x_598 * x_606
    )
    x_608 = (
        -joint_velocity[4] * x_144 * x_196 * x_449
        + joint_velocity[4] * x_452
        - joint_velocity[6] * x_144 * x_449
        + joint_velocity[6] * x_473
        + x_458 * x_581
    )
    x_609 = (
        -joint_velocity[4] * x_459
        - joint_velocity[6] * x_458
        - joint_velocity[6] * x_460
        - x_420 * x_458
        - x_580 * x_581
    )
    x_610 = (
        -joint_velocity[3] * x_467
        + joint_velocity[3] * x_468
        - joint_velocity[6] * x_457
        + x_510 * x_591
        + x_609 * x_70
    )
    x_611 = -x_608
    x_612 = (
        -joint_velocity[3] * x_450
        - joint_velocity[3] * x_454
        + joint_velocity[6] * x_198 * x_451 * x_70
        - x_204 * x_591
        + x_609 * x_69
    )
    x_613 = (
        joint_velocity[2] * x_12 * x_465
        - joint_velocity[2] * x_470
        - x_12 * x_612
        - x_611 * x_9
    )
    x_614 = (
        x_0
        * (
            -joint_velocity[2] * x_522
            - joint_velocity[2] * x_523
            - x_12 * x_611
            + x_612 * x_9
        )
        - x_244 * x_455
        + x_3 * x_610
        + x_322 * x_471
    )
    x_615 = (
        0.011402 * joint_velocity[6]
        + 0.011402 * x_420
        + 0.011402 * x_421
        + 0.011402 * x_422
        + 0.011402 * x_423
        + 0.011402 * x_425
        + 0.029798 * x_591
        + 0.029798 * x_592
        - 0.029798 * x_593
        - 0.029798 * x_594
        - 0.029798 * x_595
        - 0.029798 * x_597
    )
    x_616 = -x_576 + x_578 + x_601 + x_602 + x_603 + x_604
    x_617 = (
        0.014899 * joint_velocity[0] * x_614
        + 0.014899 * joint_velocity[1] * x_613
        + 0.014899 * joint_velocity[2] * x_610
        + 0.014899 * joint_velocity[3] * x_608
        + 0.014899 * joint_velocity[4] * joint_velocity[5] * x_196 * x_449
        + 0.0001405 * joint_velocity[4] * joint_velocity[5] * x_198
        - 0.0001405 * x_555
        - 0.0001405 * x_556
        - 0.0001405 * x_558
        - 0.0001405 * x_561
        - 0.0001405 * x_562
        - x_577 * x_591
        - x_577 * x_592
        + 0.5 * x_590 * x_615
        - x_606 * x_616
    )
    x_618 = x_420 * x_576
    x_619 = x_420 * x_591
    x_620 = joint_velocity[6] * x_578
    x_621 = joint_velocity[3] * x_608
    x_622 = joint_velocity[2] * x_610
    x_623 = joint_velocity[1] * x_613
    x_624 = joint_velocity[0] * x_614
    x_625 = (
        0.0001405 * joint_velocity[0] * x_587
        + 0.0001405 * joint_velocity[1] * x_586
        + 0.0001405 * joint_velocity[2] * x_583
        + 0.0001405 * joint_velocity[3] * x_579
        + 0.005701 * joint_velocity[4] * joint_velocity[6] * x_198 * x_451
        + 0.005701 * joint_velocity[5] * joint_velocity[6] * x_449
        + 0.0001405 * joint_velocity[5] * joint_velocity[6] * x_451
        + 0.5 * x_589 * x_616
        - 0.5 * x_598 * x_615
        - 0.0001405 * x_618
        - 0.005701 * x_619
        - 0.0001405 * x_620
        - 0.005701 * x_621
        - 0.005701 * x_622
        - 0.005701 * x_623
        - 0.005701 * x_624
    )
    x_626 = 3.0e-6 * x_576
    x_627 = (
        3.0e-6 * x_578
        + 3.0e-6 * x_601
        + 3.0e-6 * x_602
        + 3.0e-6 * x_603
        + 3.0e-6 * x_604
        - x_626
    )
    x_628 = (
        0.000609 * joint_velocity[6]
        + 0.000609 * x_420
        + 0.000609 * x_421
        + 0.000609 * x_422
        + 0.000609 * x_423
        + 0.000609 * x_425
        - 0.000118 * x_591
        - 0.000118 * x_592
        + 0.000118 * x_593
        + 0.000118 * x_594
        + 0.000118 * x_595
        + 0.000118 * x_597
        + x_627
    )
    x_629 = 3.0e-6 * joint_velocity[6]
    x_630 = 3.0e-6 * x_420
    x_631 = 3.0e-6 * x_591
    x_632 = (
        3.0e-6 * x_421
        + 3.0e-6 * x_422
        + 3.0e-6 * x_423
        + 3.0e-6 * x_425
        - 0.000587 * x_576
        + 0.000587 * x_578
        - 3.0e-6 * x_592
        + 3.0e-6 * x_593
        + 3.0e-6 * x_594
        + 3.0e-6 * x_595
        + 3.0e-6 * x_597
        + 0.000587 * x_601
        + 0.000587 * x_602
        + 0.000587 * x_603
        + 0.000587 * x_604
        + x_629
        + x_630
        - x_631
    )
    x_633 = x_179 * x_475
    x_634 = x_446 * x_449
    x_635 = x_426 * x_576
    x_636 = x_463 * x_49
    x_637 = 3.0e-6 * x_179
    x_638 = x_465 * x_637
    x_639 = 3.0e-6 * x_446
    x_640 = x_451 * x_639
    x_641 = 3.0e-6 * x_49
    x_642 = x_455 * x_641
    x_643 = x_198 * x_449
    x_644 = x_369 * x_643
    x_645 = 3.0e-6 * x_644
    x_646 = (
        -3.0e-6 * joint_velocity[0] * joint_velocity[1] * x_3 * x_471
        - 3.0e-6 * joint_velocity[2] * x_105 * x_469
        - 3.0e-6 * joint_velocity[3] * x_262 * x_453
        - 3.0e-6 * joint_velocity[4] * x_196 * x_305 * x_449
        - 3.0e-6 * joint_velocity[5] * x_426 * x_449
        - 3.0e-6 * joint_velocity[6] * x_598
        + x_638
        + x_640
        + x_642
        + x_645
    )
    x_647 = (
        0.000118 * joint_velocity[0] * joint_velocity[1] * x_3 * x_381
        + 0.000369 * joint_velocity[0] * joint_velocity[1] * x_3 * x_481
        + 0.000118 * joint_velocity[2] * x_105 * x_379
        + 0.000369 * joint_velocity[2] * x_105 * x_479
        + 0.000118 * joint_velocity[2] * x_118 * x_146 * x_198
        + 0.000369 * joint_velocity[3] * x_198 * x_255 * x_451
        + 0.000369 * joint_velocity[3] * x_262 * x_461
        - 0.000369 * joint_velocity[6] * x_616
        - 0.000369 * x_451 * x_535
        - 0.000118 * x_542
        - 0.000118 * x_543
        - 0.000118 * x_544
        - 0.000118 * x_545
        - 0.000118 * x_546
        + x_590 * x_632
        - x_616 * x_628
        - 0.000369 * x_633
        - 0.000369 * x_634
        - 0.000369 * x_635
        - 0.000369 * x_636
        - x_646
    )
    x_648 = x_305 * x_630
    x_649 = 0.000118 * joint_velocity[6]
    x_650 = 0.000118 * x_420
    x_651 = (
        0.000118 * x_421
        + 0.000118 * x_422
        + 0.000118 * x_423
        + 0.000118 * x_425
        - 0.000369 * x_591
        - 0.000369 * x_592
        + 0.000369 * x_593
        + 0.000369 * x_594
        + 0.000369 * x_595
        + 0.000369 * x_597
        + x_627
        + x_649
        + x_650
    )
    x_652 = (
        3.0e-6 * joint_velocity[0] * joint_velocity[1] * x_3 * x_381
        + 0.000587 * joint_velocity[0] * joint_velocity[1] * x_3 * x_471
        + 3.0e-6 * joint_velocity[0] * joint_velocity[1] * x_3 * x_481
        + 3.0e-6 * joint_velocity[2] * x_105 * x_379
        + 0.000587 * joint_velocity[2] * x_105 * x_469
        + 3.0e-6 * joint_velocity[2] * x_105 * x_479
        + 3.0e-6 * joint_velocity[2] * x_118 * x_146 * x_198
        + 3.0e-6 * joint_velocity[3] * x_198 * x_255 * x_451
        + 0.000587 * joint_velocity[3] * x_262 * x_453
        + 3.0e-6 * joint_velocity[3] * x_262 * x_461
        + 0.000587 * joint_velocity[4] * x_196 * x_305 * x_449
        + 0.000587 * joint_velocity[5] * x_426 * x_449
        + 0.000587 * joint_velocity[6] * x_598
        - 0.000587 * x_179 * x_465
        - x_373 * x_641
        - x_426 * x_626
        - 0.000587 * x_446 * x_451
        - x_449 * x_639
        - x_451 * x_648
        - 0.000587 * x_455 * x_49
        - x_463 * x_641
        - x_475 * x_637
        - 3.0e-6 * x_543
        - 3.0e-6 * x_544
        - 3.0e-6 * x_545
        - 3.0e-6 * x_546
        - x_590 * x_651
        + x_598 * x_628
        - x_616 * x_629
        - 0.000587 * x_644
    )
    x_653 = x_598 * x_632
    x_654 = x_616 * x_649
    x_655 = 0.000609 * x_546
    x_656 = 0.000118 * x_633
    x_657 = 0.000118 * x_634
    x_658 = 0.000118 * x_635
    x_659 = 0.000609 * x_543
    x_660 = 0.000609 * x_545
    x_661 = 0.000118 * x_636
    x_662 = x_305 * x_451 * x_650
    x_663 = 0.000609 * x_542
    x_664 = 0.000609 * x_544
    x_665 = (
        0.000609 * joint_velocity[0] * joint_velocity[1] * x_3 * x_381
        + 0.000118 * joint_velocity[0] * joint_velocity[1] * x_3 * x_481
        + 0.000609 * joint_velocity[2] * x_105 * x_379
        + 0.000118 * joint_velocity[2] * x_105 * x_479
        + 0.000609 * joint_velocity[2] * x_118 * x_146 * x_198
        + 0.000118 * joint_velocity[3] * x_198 * x_255 * x_451
        + 0.000118 * joint_velocity[3] * x_262 * x_461
        + x_616 * x_651
        - x_646
        - x_653
        - x_654
        - x_655
        - x_656
        - x_657
        - x_658
        - x_659
        - x_660
        - x_661
        - x_662
        - x_663
        - x_664
    )
    x_666 = x_12**2
    x_667 = 0.0064 * x_12
    x_668 = 0.0128 * x_12
    x_669 = 0.006641 * x_12 - 4.4e-5 * x_9
    x_670 = 0.0064 * x_69
    x_671 = x_12 * x_70
    x_672 = 0.0064 * x_671
    x_673 = -x_672 + 0.2084 * x_9
    x_674 = x_673 * x_69
    x_675 = x_12 * x_674 - 0.2084 * x_12 * x_69 * x_9 + x_666 * x_670 * x_70
    x_676 = 0.2084 * x_69
    x_677 = x_672 * x_69
    x_678 = x_69**2
    x_679 = 0.0064 * x_678
    x_680 = x_12 * x_679
    x_681 = x_673 * x_70 - x_680
    x_682 = 2 * x_681
    x_683 = x_12 * x_285 + x_12 * x_286
    x_684 = x_12 * x_69
    x_685 = -x_136 - 0.015006 * x_684
    x_686 = x_685 * x_70
    x_687 = -0.015006 * x_671 + 0.075478 * x_9
    x_688 = x_687 * x_69
    x_689 = x_12 * x_686 - x_12 * x_688 + x_683 * x_9
    x_690 = x_685 * x_69 + x_687 * x_70
    x_691 = 0.1059 * x_144 * x_9 - 0.1059 * x_148
    x_692 = 0.1059 * x_155 + 0.1059 * x_157
    x_693 = -x_692
    x_694 = -x_675
    x_695 = x_144 * x_691
    x_696 = x_146 * x_693
    x_697 = x_695 * x_70 - x_696 * x_70
    x_698 = 0.4208 * x_9
    x_699 = 0.4208 * x_12
    x_700 = 0.8416 * x_12
    x_701 = 0.2084 * x_684
    x_702 = 0.4168 * x_684
    x_703 = 0.1059 * x_197 + 0.1059 * x_201
    x_704 = -x_683
    x_705 = x_146 * x_703
    x_706 = x_206 * x_691 + x_70 * x_705
    x_707 = x_149 * x_693 + x_190 * x_691
    x_708 = x_674 + x_677
    x_709 = 1.0e-6 * x_145
    x_710 = x_147 * x_365
    x_711 = 0.009432 * x_69
    x_712 = 0.009432 * x_155 + x_156 * x_711 + x_709 - x_710
    x_713 = x_70 * x_712
    x_714 = x_12 * x_713
    x_715 = 0.063883 * x_145 - 0.063883 * x_148 + 0.009432 * x_671
    x_716 = 1.0e-6 * x_12 * x_70 - 0.063883 * x_155 - 0.063883 * x_157
    x_717 = x_146 * x_716
    x_718 = x_144 * x_70 * x_715 + x_69 * x_712 - x_70 * x_717
    x_719 = x_146 * x_691
    x_720 = x_144 * x_693 + x_719
    x_721 = x_69 * x_695 - x_69 * x_696
    x_722 = x_144 * x_716 + x_146 * x_715
    x_723 = x_144 * x_703 - x_196 * x_719
    x_724 = 0.0064 * x_684
    x_725 = 0.2104 * x_9
    x_726 = x_70 * x_725
    x_727 = x_259 * x_70
    x_728 = x_69 * x_725
    x_729 = x_273 * x_69
    x_730 = -x_724 - x_726
    x_731 = -0.00965 * x_197 - 0.00965 * x_201 + x_709 - x_710
    x_732 = 0.045483 * x_145 - 0.045483 * x_148 + 0.00965 * x_389 - 0.00965 * x_412
    x_733 = 0.045483 * x_196
    x_734 = -x_155 * x_565 + x_155 * x_733 + 0.045483 * x_201 + 1.0e-6 * x_389
    x_735 = x_146 * x_734
    x_736 = x_206 * x_732 + x_373 * x_731 + x_70 * x_735
    x_737 = x_198 * x_691
    x_738 = -x_672 + 0.2104 * x_69 * x_9
    x_739 = x_695 - x_696
    x_740 = x_198 * x_731
    x_741 = x_196 * x_732
    x_742 = x_144 * x_734 + x_146 * x_740 - x_146 * x_741
    x_743 = -x_720
    x_744 = -0.2104 * x_144 * x_69 * x_9 + 0.2104 * x_147
    x_745 = -x_744
    x_746 = x_327 * x_691
    x_747 = 0.2104 * x_156 + 0.2104 * x_159
    x_748 = -x_747
    x_749 = x_144 * x_673
    x_750 = -0.2084 * x_148 + x_749
    x_751 = 0.0064 * x_70
    x_752 = -x_156 * x_751 - x_744
    x_753 = x_196 * x_731 + x_198 * x_732
    x_754 = -x_147 * x_751 + x_747
    x_755 = -x_754
    x_756 = x_146 * x_673 + 0.2084 * x_157
    x_757 = -x_756
    x_758 = -x_703
    x_759 = -x_734
    x_760 = -0.011402 * x_389 + 0.011402 * x_412 + 0.029798 * x_519 + 0.029798 * x_520
    x_761 = (
        0.000281 * x_12 * x_379 - 0.000281 * x_412 - 0.029798 * x_522 - 0.029798 * x_523
    )
    x_762 = -0.000281 * x_519 - 0.000281 * x_520 + 0.011402 * x_522 + 0.011402 * x_523
    x_763 = x_373 * x_762 + x_455 * x_760 + x_463 * x_761
    x_764 = x_198 * x_762
    x_765 = x_146 * x_764
    x_766 = 0.2104 * x_377 + 0.2104 * x_380
    x_767 = 0.2084 * x_12 * x_146 * x_198 * x_69 - x_198 * x_749 - x_510 * x_667
    x_768 = -x_373 * x_667 + x_766
    x_769 = x_428 * x_691
    x_770 = 0.2104 * x_208
    x_771 = 0.2104 * x_209 - x_770
    x_772 = x_449 * x_761 + x_451 * x_760
    x_773 = x_144 * x_196 * x_673 - 0.2084 * x_147 * x_510 - x_203 * x_667
    x_774 = 0.2104 * x_200 * x_9 - x_206 * x_667 - x_770
    x_775 = x_451 * x_761
    x_776 = x_196 * x_762 + x_198 * x_449 * x_760 - x_198 * x_775
    x_777 = x_196 * x_567
    x_778 = x_451 * x_691
    x_779 = 0.2104 * x_466
    x_780 = 0.2104 * x_476
    x_781 = x_1 * x_40
    x_782 = x_70**2
    x_783 = 0.0064 * x_782
    x_784 = x_12 * x_783 + x_680 - x_70 * x_80
    x_785 = 0.015006 * x_782
    x_786 = 0.015006 * x_678
    x_787 = -1.8e-5 * x_69 + 0.075478 * x_70
    x_788 = -x_787
    x_789 = x_12 * x_785 + x_12 * x_786 + x_788 * x_9
    x_790 = 0.1059 * x_549
    x_791 = 0.1059 * x_436
    x_792 = 0.1059 * x_203
    x_793 = 0.1059 * x_205
    x_794 = x_792 + x_793
    x_795 = -x_794
    x_796 = x_146 * x_795
    x_797 = x_206 * x_790 + x_70 * x_796
    x_798 = x_149 * x_791 + x_190 * x_790
    x_799 = x_374 * x_70
    x_800 = -x_229 * x_70 + x_799
    x_801 = x_70 * x_800
    x_802 = x_12 * x_801
    x_803 = 0.063883 * x_70
    x_804 = x_146 * x_803 + x_711
    x_805 = x_144 * x_803 + x_365
    x_806 = x_144 * x_804
    x_807 = x_146 * x_805
    x_808 = x_69 * x_800 + x_70 * x_806 - x_70 * x_807
    x_809 = 0.2084 * x_70
    x_810 = 0.4168 * x_70
    x_811 = -x_679 - x_783
    x_812 = x_146**2
    x_813 = 0.1059 * x_812
    x_814 = x_144**2
    x_815 = 0.1059 * x_814
    x_816 = x_70 * x_813 + x_70 * x_815
    x_817 = x_144 * x_805 + x_146 * x_804
    x_818 = x_204 * x_813
    x_819 = x_144 * x_795 - x_818
    x_820 = (
        -1.0e-6 * x_144 * x_198 * x_70
        + 0.045483 * x_144 * x_204
        + 0.045483 * x_203
        + 1.0e-6 * x_510
    )
    x_821 = -x_820
    x_822 = x_146 * x_821
    x_823 = 0.00965 * x_372 - 0.00965 * x_510 + 0.045483 * x_549
    x_824 = 0.00965 * x_203 + 0.00965 * x_205 + x_799
    x_825 = x_206 * x_823 + x_373 * x_824 + x_70 * x_822
    x_826 = x_198 * x_824
    x_827 = x_196 * x_823
    x_828 = x_144 * x_821 + x_146 * x_826 - x_146 * x_827
    x_829 = 0.0128 * x_70
    x_830 = 0.1059 * x_199
    x_831 = x_146 * x_830
    x_832 = -x_816
    x_833 = x_196 * x_824 + x_198 * x_823
    x_834 = (
        0.011402 * x_196 * x_69
        + 0.029798 * x_198 * x_451 * x_69
        - 0.011402 * x_372
        - 0.029798 * x_462
    )
    x_835 = 0.000281 * x_372 + 0.029798 * x_450 + 0.029798 * x_454 - 0.000281 * x_510
    x_836 = x_203 * x_599 + x_203 * x_600 + 0.011402 * x_454 - 0.000281 * x_461 * x_70
    x_837 = -x_836
    x_838 = x_373 * x_837 + x_455 * x_834 + x_463 * x_835
    x_839 = x_198 * x_837
    x_840 = x_146 * x_839
    x_841 = x_144 * x_670
    x_842 = 0.1059 * x_327
    x_843 = x_146 * x_204
    x_844 = x_146 * x_670
    x_845 = 0.2084 * x_549 - x_841
    x_846 = x_144 * x_809 + x_844
    x_847 = x_451 * x_835
    x_848 = x_196 * x_837 + x_198 * x_449 * x_834 - x_198 * x_847
    x_849 = x_449 * x_835 + x_451 * x_834
    x_850 = 0.0064 * x_204 + 0.0064 * x_378
    x_851 = 0.2084 * x_146
    x_852 = -x_199 * x_851 + x_850
    x_853 = 0.1059 * x_843
    x_854 = 0.0064 * x_199 - 0.0064 * x_559
    x_855 = x_204 * x_851 + x_854
    x_856 = -x_846
    x_857 = 0.1059 * x_459
    x_858 = 0.1059 * x_458
    x_859 = 0.1059 * x_452
    x_860 = -0.0064 * x_198 * x_449 * x_70 + 0.0064 * x_468
    x_861 = 0.0064 * x_477 + 0.0064 * x_478
    x_862 = x_813 + x_815
    x_863 = 0.063883 * x_812
    x_864 = 0.063883 * x_814
    x_865 = 1.0e-6 * x_144
    x_866 = 0.009432 * x_146 + x_865
    x_867 = 0.00965 * x_146
    x_868 = -x_196 * x_867 + x_865
    x_869 = 0.045483 * x_144 - x_198 * x_867
    x_870 = x_196 * x_868 + x_198 * x_869
    x_871 = x_196 * x_869
    x_872 = x_198 * x_868
    x_873 = -0.029798 * x_459 - 0.029798 * x_464 - 0.000281 * x_550
    x_874 = x_451 * x_873
    x_875 = -0.029798 * x_473 + 0.011402 * x_550 + 0.029798 * x_580
    x_876 = x_449 * x_873 + x_451 * x_875
    x_877 = 0.000281 * x_196
    x_878 = 0.011402 * x_196
    x_879 = x_452 * x_877 + x_458 * x_878 + 0.011402 * x_459 - 0.000281 * x_580
    x_880 = x_196 * x_879 + x_198 * x_449 * x_875 - x_198 * x_874
    x_881 = x_69 * x_813 + x_69 * x_815
    x_882 = 0.1059 * x_144
    x_883 = x_206 * x_882 + x_818
    x_884 = x_146 * x_150
    x_885 = 0.1059 * x_884
    x_886 = x_146 * x_149
    x_887 = 0.1059 * x_886
    x_888 = 0.1059 * x_144 * x_190 - x_887
    x_889 = -x_146 * x_733 + x_198 * x_374
    x_890 = -x_889
    x_891 = x_69 * x_866 + x_70 * x_863 + x_70 * x_864
    x_892 = x_146 * x_890
    x_893 = x_206 * x_869 + x_373 * x_868 + x_70 * x_892
    x_894 = x_373 * x_879 + x_455 * x_875 + x_463 * x_873
    x_895 = x_198 * x_879
    x_896 = x_146 * x_895
    x_897 = x_144 * x_890 - x_146 * x_871 + x_146 * x_872
    x_898 = x_70 * x_866
    x_899 = x_12 * x_898
    x_900 = 0.3143 * x_144
    x_901 = 0.3143 * x_146
    x_902 = x_198 * x_882
    x_903 = x_196 * x_882
    x_904 = 0.1059 * x_534
    x_905 = x_198 * x_900
    x_906 = x_146 * x_161
    x_907 = x_1 * x_198
    x_908 = -x_800
    x_909 = 0.1059 * x_198
    x_910 = 1.0e-6 * x_196 + 0.045483 * x_198
    x_911 = -x_910
    x_912 = x_146 * x_911
    x_913 = 0.00965 * x_196
    x_914 = 0.00965 * x_198
    x_915 = -x_206 * x_913 + x_373 * x_914 + x_70 * x_912
    x_916 = 0.00965 * x_198**2
    x_917 = 0.00965 * x_196**2
    x_918 = x_144 * x_911 + x_146 * x_916 + x_146 * x_917
    x_919 = x_198 * x_599 + x_198 * x_600
    x_920 = -x_919
    x_921 = 0.029798 * x_198
    x_922 = x_451 * x_921 + x_878
    x_923 = x_449 * x_921 - x_877
    x_924 = x_373 * x_920 + x_455 * x_922 + x_463 * x_923
    x_925 = x_198 * x_920
    x_926 = x_146 * x_925
    x_927 = x_449 * x_922
    x_928 = x_451 * x_923
    x_929 = x_196 * x_920 + x_198 * x_927 - x_198 * x_928
    x_930 = x_449 * x_923 + x_451 * x_922
    x_931 = x_198 * x_451
    x_932 = -0.000281 * x_449 + 0.011402 * x_451
    x_933 = 0.029798 * x_451**2
    x_934 = 0.029798 * x_449**2
    x_935 = x_196 * x_932 + x_198 * x_933 + x_198 * x_934
    x_936 = 0.029798 * x_449
    x_937 = 0.029798 * x_451
    x_938 = x_373 * x_932 + x_455 * x_936 - x_463 * x_937
    x_939 = x_198 * x_932
    x_940 = x_146 * x_939
    return np.array(
        [
            
                -0.4208 * x_0 * x_36
                + 0.018678
                * x_0
                * (0.0154502808 * x_19 - 1.1636 * x_48 * x_54 + x_52 * x_55)
                + x_0
                * (
                    0.011088 * joint_velocity[0] * joint_velocity[1] * x_3
                    + joint_velocity[0] * x_3 * x_60
                    - joint_velocity[1] * x_62
                    - joint_velocity[1] * x_63
                )
                - 0.0150444 * x_1 * x_17
                - x_109 * x_111
                + x_109 * x_133
                + x_109 * x_16
                + x_109 * x_192
                + x_109 * x_222
                + x_109 * (x_195 * x_200 + x_215 * x_69)
                + x_109 * (x_379 * x_482 + x_469 * x_496 + x_479 * x_493)
                + x_110 * x_175
                - x_110 * x_178
                - x_111 * x_115
                + x_112 * x_222
                + x_112 * (x_200 * x_383 + x_375 * x_379 + x_386 * x_69)
                + x_112 * (x_144 * x_227 * x_69 - x_231 - x_234 * x_69)
                - x_113 * x_114
                + x_115 * x_133
                + x_115 * x_16
                + x_115 * (-x_134 + x_69 * x_92)
                + x_120 * x_121
                + x_120 * x_122
                + x_120 * x_143
                + x_120 * x_221
                - x_120 * x_225
                + x_120 * x_82
                + x_120 * (x_465 * x_496 + x_475 * x_493 - x_500)
                + x_121 * x_127
                - x_121 * x_264
                - x_121 * x_355
                + x_122 * x_127
                - x_122 * x_264
                - x_122 * x_355
                + x_124 * x_125
                + x_124 * x_126
                + x_124 * x_221
                + x_124 * x_228
                - x_124 * x_394
                - x_125 * x_263
                - x_126 * x_263
                + x_127 * x_139
                + x_127 * x_143
                + x_128 * x_168
                + x_128 * x_216
                + x_128 * x_26
                + x_128 * x_41
                + x_128 * x_498
                + x_128 * x_78
                + x_130 * x_168
                + x_130 * x_235
                + x_130 * x_28
                + x_130 * x_387
                + x_130 * x_42
                + x_130 * x_88
                + x_131 * x_26
                + x_131 * x_41
                + x_131 * x_93
                + x_132 * x_133
                + x_132 * x_16
                + x_132 * x_192
                + x_133 * x_177
                - x_14 * x_184
                + x_14 * x_352
                + x_140 * x_355
                + x_141 * x_142
                + x_141 * x_37
                + x_143 * x_165
                + x_143 * x_174
                + x_154 * x_335
                + x_154 * x_339
                + x_163 * x_325
                + x_163 * x_327
                - x_164 * (x_150 * x_154 + x_158 * x_163)
                + x_165 * x_82
                - x_166 * (x_12 * x_140 - x_134 * x_9 + x_135 * x_9)
                + x_168 * x_25
                + x_168 * x_27
                - x_169 * (x_152 * x_163 + x_154 * x_161)
                + x_174 * x_46
                + x_177 * x_45
                + x_188 * x_40
                + x_189 * x_26
                + x_189 * x_59
                + x_191 * x_34
                + x_191 * x_36
                + x_195 * x_428
                + 0.009805750912 * x_2 * x_3**2
                - 0.004487377536 * x_2
                + x_212 * x_335
                + x_213 * x_514
                - x_214 * (x_149 * x_213 + x_195 * x_202)
                - x_214 * (x_390 * x_482 + x_493 * x_521 + x_496 * x_524)
                + x_216 * x_25
                - x_220 * (x_160 * x_213 + x_195 * x_210)
                - x_220 * (x_381 * x_482 + x_471 * x_496 + x_481 * x_493)
                + x_224 * x_327
                + x_225 * x_264
                + x_226 * x_517
                + x_227 * x_503
                - x_228 * x_263
                + x_230 * x_259
                + x_230 * x_531
                - x_233 * (x_149 * x_385 + x_202 * x_383 + x_375 * x_390)
                - x_233 * (x_150 * x_226 + x_158 * x_227 - x_232)
                + x_235 * x_27
                - x_236 * (x_152 * x_227 + x_161 * x_226 - x_231 * x_9)
                - x_236 * (x_160 * x_385 + x_210 * x_383 + x_375 * x_381)
                + x_238 * x_257
                + x_238 * x_260
                + x_238 * x_290
                + x_238 * x_308
                + x_238 * x_310
                + x_238 * x_531
                + x_248 * x_388
                + x_248 * x_492
                + x_25 * x_26
                + x_25 * x_41
                + x_25 * x_498
                + x_25 * x_78
                + x_253 * x_371
                + x_257 * x_272
                + x_257 * x_275
                + x_257 * x_277
                + x_257 * x_529
                + x_257 * x_73
                + x_259 * x_391
                + x_26 * x_29
                + x_26 * x_30
                + x_260 * x_272
                + x_260 * x_275
                + x_260 * x_73
                + x_263 * x_311
                + x_263 * x_394
                + x_264 * x_276
                + x_264 * x_311
                + x_264 * x_83
                + x_264 * (x_474 * x_493 + x_496 * x_532 + x_500)
                + x_266 * x_271
                + x_266 * x_274
                + x_266 * x_288
                + x_27 * x_28
                + x_27 * x_387
                + x_27 * x_42
                + x_27 * x_88
                + x_271 * x_280
                + x_271 * x_282
                + x_271 * x_291
                + x_271 * x_77
                + x_271 * (x_144 * x_224 + x_215)
                + x_271 * (-x_144 * x_499 + x_453 * x_496 + x_461 * x_493)
                + x_272 * x_290
                + x_272 * x_308
                + x_272 * x_310
                + x_272 * x_531
                + x_273 * x_291
                + x_273 * (x_144 * x_227 - x_234)
                + x_273 * (-x_144 * x_392 + x_144 * x_393 + x_386)
                + x_274 * x_280
                + x_274 * x_282
                + x_274 * x_77
                + x_275 * x_290
                + x_275 * x_308
                + x_275 * x_310
                + x_275 * x_531
                + x_276 * x_278
                + x_276 * x_355
                + x_277 * x_308
                + x_278 * x_83
                + x_280 * x_288
                + x_282 * x_288
                + x_288 * x_92
                + x_29 * x_41
                + x_29 * x_93
                + x_290 * x_90
                + x_295 * x_442
                - 0.018678 * x_3 * (x_38 * x_54 + 0.0154502808 * x_49 - x_51 * x_52)
                + x_3
                * (
                    5.0e-6 * joint_velocity[0] * joint_velocity[1] * x_3
                    + joint_velocity[1] * x_61
                    - x_48 * x_60
                    - 0.001072 * x_49
                )
                + x_3
                * (
                    -x_102 * x_181
                    + x_118 * x_187
                    - 0.000606 * x_18 * x_94
                    - x_217
                    - x_218
                    - x_219
                    - 0.001043 * x_49
                )
                + x_30 * x_59
                + x_303 * x_448
                + x_308 * x_529
                + x_308 * x_73
                + x_310 * x_391
                + x_310 * x_73
                + x_312 * x_325
                + x_312 * x_327
                + x_312 * x_503
                - x_32 * (-x_15 * x_9 + x_16 * x_9)
                + x_325 * x_353
                + x_325 * x_359
                + x_325 * x_360
                + x_325 * (x_196 * x_383 - x_392)
                + x_327 * x_353
                + x_327 * x_359
                + x_327 * x_360
                + x_327 * (x_196 * x_449 * x_496 - x_196 * x_528 - x_499)
                + x_335 * x_341
                + x_335 * x_357
                + x_335 * x_362
                + x_335 * x_364
                + x_335 * x_497
                + x_339 * x_341
                + x_339 * x_357
                + x_339 * x_362
                + x_339 * x_364
                + x_339 * x_384
                - x_34 * x_35
                + x_34 * x_67
                + x_34 * x_86
                + x_34 * (x_150 * x_213 + x_195 * x_223)
                + x_34 * (x_395 * x_482 + x_493 * x_526 + x_496 * x_527)
                + x_341 * x_517
                - x_35 * x_37
                - x_35 * x_39
                + x_353 * x_503
                + x_356 * x_514
                + x_356 * x_574
                + x_357 * x_517
                + x_359 * x_503
                + x_36 * (x_149 * x_226 + x_190 * x_227 + x_232)
                + x_36 * (x_150 * x_385 + x_223 * x_383 + x_375 * x_395)
                + x_360 * x_503
                + x_361 * x_514
                + x_361 * x_574
                + x_362 * x_517
                + x_364 * x_517
                + x_37 * x_67
                + x_375 * x_573
                + x_383 * x_567
                + x_385 * x_574
                - x_39 * x_47
                + x_397 * x_554
                + x_405 * x_540
                - x_409 * x_410
                + x_409 * x_411
                + x_409 * x_413
                + x_409 * x_415
                + x_409 * x_430
                + x_409 * x_482
                - x_410 * x_573
                - x_410 * x_625
                + x_411 * x_573
                + x_411 * x_625
                + x_413 * x_573
                + x_413 * x_625
                + x_415 * x_573
                + x_415 * x_625
                + x_424 * x_548
                + x_424 * x_665
                + x_428 * x_429
                + x_428 * x_431
                + x_428 * x_432
                + x_428 * x_434
                + x_428 * x_435
                + x_428 * (x_449 * x_496 - x_528)
                + x_429 * x_567
                + x_430 * x_573
                + x_430 * x_625
                + x_431 * x_567
                + x_432 * x_567
                + x_434 * x_567
                + x_435 * x_567
                - x_47 * x_8
                + x_482 * x_625
                + x_493 * x_617
                + x_496 * x_607
                - x_497 * x_514
                + x_504 * x_514
                + x_504 * x_574
                + x_514 * x_518
                + x_514 * x_525
                + x_518 * x_574
                + x_525 * x_574
                + x_531 * x_73
                - x_56 * (-x_12 * x_46 + x_45 * x_9)
                + x_588 * x_652
                + x_596 * x_647
                + x_607 * (0.0054 * x_0 * x_455 - x_110 * x_471)
                + x_607 * (x_154 * x_451 + x_429 * x_449)
                + x_607 * (x_195 * x_449 - x_213 * x_451)
                + x_607 * (0.0064 * x_0 * x_455 - x_13 * x_471 - x_35 * x_527)
                + x_607 * (x_16 * x_469 + x_35 * x_522 + x_41 * x_455)
                + x_607 * (x_433 * x_449 + x_453 * x_77 + x_532 * x_83)
                + x_617 * (0.0054 * x_0 * x_463 - x_110 * x_481)
                + x_617 * (x_154 * x_449 - x_429 * x_451)
                + x_617 * (-x_195 * x_451 - x_213 * x_449)
                + x_617 * (0.0064 * x_0 * x_463 - x_13 * x_481 - x_35 * x_526)
                + x_617 * (x_16 * x_479 + x_35 * x_519 + x_41 * x_463)
                + x_617 * (-x_433 * x_451 + x_461 * x_77 + x_474 * x_83)
                + x_67 * x_68
                + x_68 * x_86
                - x_7 * x_8
                - x_7
                * (
                    1.1636 * joint_velocity[0] * x_0 * x_51
                    - x_18 * x_66
                    - x_38 * x_55
                    - x_65
                )
                + x_86 * x_87
                - x_89 * (x_12 * x_83 - x_84 * x_9 + x_85 * x_9)
            ,
            
                x_109 * x_698
                + x_109 * x_708
                + x_109 * x_721
                + x_109 * (x_200 * x_691 + x_69 * x_705)
                + x_109 * (x_379 * x_762 + x_469 * x_760 + x_479 * x_761)
                + x_112 * x_721
                + x_112 * (x_200 * x_732 + x_379 * x_731 + x_69 * x_735)
                + x_112 * (x_144 * x_69 * x_715 - x_69 * x_717 - x_713)
                + 0.8416 * x_113
                + x_115 * x_698
                + x_115 * (-x_686 + x_688)
                - x_12 * x_188
                - x_120 * x_699
                - x_120 * x_701
                + x_120 * x_720
                - x_120 * x_723
                + x_120 * (x_465 * x_760 + x_475 * x_761 - x_765)
                - x_124 * x_700
                - x_124 * x_702
                + x_124 * x_720
                + x_124 * x_722
                - x_124 * x_742
                - x_127 * x_699
                + x_127 * x_704
                - x_128 * x_667
                + x_128 * x_681
                + x_128 * x_697
                + x_128 * x_706
                + x_128 * x_763
                - x_130 * x_668
                + x_130 * x_682
                + x_130 * x_697
                + x_130 * x_718
                + x_130 * x_736
                - x_131 * x_667
                + x_131 * x_690
                + x_132 * x_708
                + x_142 * x_689
                + x_149 * x_448
                + x_150 * x_554
                - x_164 * (x_150 * x_693 + x_158 * x_691)
                - x_166 * (x_12 * x_683 - x_686 * x_9 + x_688 * x_9)
                - x_169 * (x_152 * x_691 + x_161 * x_693)
                - 0.328292 * x_175
                + 0.328292 * x_178
                + 0.115871288 * x_18 * x_54
                - x_18 * x_61
                - x_184 * x_9
                + x_189 * x_669
                - 6.798123552e-7 * x_19
                + x_190 * x_442
                + x_196 * x_746
                + x_196 * x_769
                - x_214 * (x_149 * x_703 + x_202 * x_691)
                - x_214 * (x_390 * x_762 + x_521 * x_761 + x_524 * x_760)
                - x_220 * (x_160 * x_703 + x_210 * x_691)
                - x_220 * (x_381 * x_762 + x_471 * x_760 + x_481 * x_761)
                + x_223 * x_540
                - x_233 * (x_149 * x_734 + x_202 * x_732 + x_390 * x_731)
                - x_233 * (x_150 * x_716 + x_158 * x_715 - x_714)
                - x_236 * (x_152 * x_715 + x_161 * x_716 - x_713 * x_9)
                - x_236 * (x_160 * x_734 + x_210 * x_732 + x_381 * x_731)
                - x_25 * x_667
                + x_25 * x_681
                + x_25 * x_697
                + x_25 * x_706
                + x_25 * x_763
                - x_257 * x_724
                - x_257 * x_726
                + x_257 * x_730
                + x_257 * x_737
                + x_257 * x_776
                - 0.0128 * x_259 * x_684
                + x_259 * x_712
                + x_259 * x_753
                + x_260 * x_730
                + x_263 * x_700
                + x_263 * x_702
                - x_263 * x_722
                + x_263 * x_742
                + x_263 * x_743
                + x_264 * x_699
                + x_264 * x_701
                + x_264 * x_723
                + x_264 * x_743
                + x_264 * (x_474 * x_761 + x_532 * x_760 + x_765)
                - x_27 * x_668
                + x_27 * x_682
                + x_27 * x_697
                + x_27 * x_718
                + x_27 * x_736
                + x_271 * x_673
                + x_271 * x_728
                + x_271 * x_738
                + x_271 * x_739
                + x_271 * (x_196 * x_695 + x_705)
                + x_271 * (-x_144 * x_764 + x_453 * x_760 + x_461 * x_761)
                + x_273 * x_739
                + x_273 * (x_144 * x_715 - x_717)
                + x_273 * (-x_144 * x_740 + x_144 * x_741 + x_735)
                + x_274 * x_673
                + x_274 * x_738
                + x_288 * x_687
                + x_288 * x_728
                + x_288 * x_738
                - x_29 * x_667
                + x_29 * x_690
                + x_290 * x_685
                - x_290 * x_726
                + x_290 * x_730
                + x_30 * x_669
                - x_308 * x_724
                - x_308 * x_726
                + x_308 * x_730
                + x_308 * x_737
                + x_308 * x_776
                - 0.174841524736 * x_31
                - x_310 * x_724
                - x_310 * x_726
                + x_310 * x_730
                + x_310 * x_753
                - x_32 * (x_11 + 0.2104 * x_666)
                + x_325 * x_691
                + x_325 * x_745
                + x_325 * x_750
                + x_325 * x_752
                + x_325 * (x_196 * x_732 - x_740)
                + x_327 * x_745
                + x_327 * x_750
                + x_327 * x_752
                + x_327 * (x_196 * x_449 * x_760 - x_196 * x_775 - x_764)
                + x_335 * x_693
                + x_335 * x_748
                + x_335 * x_755
                + x_335 * x_757
                + x_335 * x_758
                + x_335 * x_772
                + x_339 * x_693
                + x_339 * x_748
                + x_339 * x_755
                + x_339 * x_757
                + x_339 * x_759
                + x_34 * x_694
                + x_34 * x_707
                + x_34 * (x_150 * x_703 + x_223 * x_691)
                + x_34 * (x_395 * x_762 + x_526 * x_761 + x_527 * x_760)
                + x_352 * x_9
                + x_355 * x_683
                + x_355 * x_699
                + x_36 * x_707
                + x_36 * (x_149 * x_716 + x_190 * x_715 + x_714)
                + x_36 * (x_150 * x_734 + x_223 * x_732 + x_395 * x_731)
                + x_37 * x_689
                - x_371 * x_684
                + x_388 * x_671
                + x_395 * x_548
                + x_395 * x_665
                - x_409 * x_737
                + x_409 * x_762
                + x_409 * x_766
                + x_409 * x_767
                + x_409 * x_768
                + x_428 * x_771
                + x_428 * x_773
                + x_428 * x_774
                + x_428 * (x_449 * x_760 - x_775)
                + 5.11984e-5 * x_48 * x_54
                + x_48 * x_63
                + 0.002229538962064 * x_49
                + x_492 * x_671
                + x_503 * x_715
                + x_503 * x_745
                + x_503 * x_750
                + x_503 * x_752
                - x_51 * x_66
                + x_514 * x_692
                + x_514 * x_703
                + x_514 * x_747
                + x_514 * x_754
                + x_514 * x_756
                - x_514 * x_772
                + x_517 * x_716
                + x_517 * x_748
                + x_517 * x_755
                + x_517 * x_757
                + x_526 * x_647
                + x_527 * x_652
                + x_531 * x_712
                - x_531 * x_724
                - x_531 * x_726
                + x_531 * x_730
                - x_55 * x_64
                - x_56 * (0.117892 * x_10 + 0.117892 * x_666)
                + x_567 * x_732
                + x_567 * x_771
                + x_567 * x_773
                + x_567 * x_774
                + x_573 * x_731
                - x_573 * x_737
                + x_573 * x_766
                + x_573 * x_767
                + x_573 * x_768
                + x_574 * x_692
                + x_574 * x_734
                + x_574 * x_747
                + x_574 * x_754
                + x_574 * x_756
                + x_607 * x_760
                + x_607 * (0.2104 * x_470 - x_779)
                + x_607 * (x_449 * x_691 - x_451 * x_703)
                + x_607 * (x_196 * x_449 * x_691 + x_451 * x_693)
                + x_607 * (-x_450 * x_667 + x_453 * x_673 + x_532 * x_701)
                + x_607 * (-x_455 * x_667 + 0.2104 * x_469 * x_9 - x_779)
                + x_617 * x_761
                + x_617 * (0.2104 * x_480 - x_780)
                + x_617 * (-x_196 * x_778 + x_449 * x_693)
                + x_617 * (-x_449 * x_703 - x_778)
                + x_617 * (x_457 * x_667 + x_461 * x_673 + x_474 * x_701)
                + x_617 * (-x_463 * x_667 + 0.2104 * x_479 * x_9 - x_780)
                - x_625 * x_737
                + x_625 * x_762
                + x_625 * x_766
                + x_625 * x_767
                + x_625 * x_768
                - x_675 * x_87
                + x_68 * x_694
                + x_691 * x_777
                - x_698 * x_727
                + x_698 * x_729
                + x_746
                + x_769
                - x_89 * (x_666 * x_676 + x_674 * x_9 + x_677 * x_9)
            ,
            
                9.628416e-5 * x_1 * x_12
                + 0.0178304 * x_101
                + 0.0077274676 * x_105 * x_173
                - 0.0178304 * x_108
                + x_109 * x_811
                + x_109 * (x_200 * x_790 + x_69 * x_796)
                + x_109 * (x_379 * x_837 + x_469 * x_834 + x_479 * x_835)
                + x_112 * (x_200 * x_823 + x_379 * x_824 + x_69 * x_822)
                + x_112 * (x_144 * x_69 * x_804 - x_69 * x_807 - x_801)
                + x_115 * (-x_785 - x_786)
                + 6.0358817728e-6 * x_116
                + 6.0358817728e-6 * x_117
                + 5.11984e-5 * x_118 * x_173
                + x_118 * x_187
                + x_120 * x_809
                + x_120 * x_816
                - x_120 * x_819
                + x_120 * (x_465 * x_834 + x_475 * x_835 - x_840)
                + x_124 * x_810
                + x_124 * x_816
                + x_124 * x_817
                - x_124 * x_828
                + x_127 * x_787
                + x_128 * x_797
                + x_128 * x_838
                + x_130 * x_808
                + x_130 * x_825
                + x_132 * x_811
                + x_142 * x_789
                - x_164 * (x_150 * x_791 + x_158 * x_790)
                - x_166 * (x_12 * x_788 - x_785 * x_9 - x_786 * x_9)
                - x_169 * (x_152 * x_790 + x_161 * x_791)
                - 5.11984e-5 * x_171 * x_99
                - 0.0077274676 * x_176 * x_99
                - 1.30358817728e-5 * x_185
                + x_206 * x_540
                - x_214 * (x_149 * x_795 + x_202 * x_790)
                - x_214 * (x_390 * x_837 + x_521 * x_835 + x_524 * x_834)
                - x_217
                - x_218
                - x_219
                - x_220 * (x_160 * x_795 + x_210 * x_790)
                - x_220 * (x_381 * x_837 + x_471 * x_834 + x_481 * x_835)
                - x_233 * (x_149 * x_821 + x_202 * x_823 + x_390 * x_824)
                - x_233 * (x_150 * x_805 + x_158 * x_804 - x_802)
                - x_236 * (x_152 * x_804 + x_161 * x_805 - x_801 * x_9)
                - x_236 * (x_160 * x_821 + x_210 * x_823 + x_381 * x_824)
                + x_25 * x_797
                + x_25 * x_838
                + x_257 * x_829
                + x_257 * x_831
                + x_257 * x_848
                + x_259 * x_800
                + x_259 * x_833
                - x_263 * x_810
                - x_263 * x_817
                + x_263 * x_828
                + x_263 * x_832
                - x_264 * x_809
                + x_264 * x_819
                + x_264 * x_832
                + x_264 * (x_474 * x_835 + x_532 * x_834 + x_840)
                + x_27 * x_808
                + x_27 * x_825
                - 0.0128 * x_271 * x_69
                + x_271 * (x_146 * x_793 + x_796)
                + x_271 * (-x_144 * x_839 + x_453 * x_834 + x_461 * x_835)
                + x_273 * (x_806 - x_807)
                + x_273 * (-x_144 * x_826 + x_144 * x_827 + x_822)
                - 0.021406 * x_288 * x_69
                + 0.021406 * x_290 * x_70
                + 0.00375151616 * x_3 * x_781
                + x_308 * x_829
                + x_308 * x_831
                + x_308 * x_848
                + x_310 * x_829
                + x_310 * x_833
                + x_325 * x_790
                - x_325 * x_841
                + x_325 * x_845
                + x_325 * (x_196 * x_823 - x_826)
                - x_327 * x_841
                + x_327 * x_845
                + x_327 * (x_196 * x_449 * x_834 - x_196 * x_847 - x_839)
                + x_335 * x_791
                + x_335 * x_794
                + x_335 * x_844
                + x_335 * x_846
                + x_335 * x_849
                + x_339 * x_791
                + x_339 * x_820
                + x_339 * x_844
                + x_339 * x_846
                + x_34 * x_667
                + x_34 * x_784
                + x_34 * x_798
                + x_34 * (x_150 * x_795 + x_223 * x_790)
                + x_34 * (x_395 * x_837 + x_526 * x_835 + x_527 * x_834)
                + x_355 * x_788
                + x_36 * x_668
                + x_36 * x_798
                + x_36 * (x_149 * x_805 + x_190 * x_804 + x_802)
                + x_36 * (x_150 * x_821 + x_223 * x_823 + x_395 * x_824)
                + x_37 * x_667
                + x_37 * x_789
                + x_371 * x_70
                + x_373 * x_548
                + x_373 * x_665
                + x_388 * x_69
                - x_39 * x_669
                - x_409 * x_831
                + x_409 * x_837
                + x_409 * x_850
                + x_409 * x_852
                + x_428 * x_790
                + x_428 * x_853
                + x_428 * x_854
                + x_428 * x_855
                + x_428 * (x_449 * x_834 - x_847)
                + x_436 * x_442
                - x_448 * x_549
                + x_455 * x_652
                + x_463 * x_647
                - 0.0012084349250612 * x_49
                + x_492 * x_69
                + x_503 * x_804
                - x_503 * x_841
                + x_503 * x_845
                - x_514 * x_791
                + x_514 * x_795
                - x_514 * x_844
                - x_514 * x_849
                + x_514 * x_856
                + x_517 * x_805
                + x_517 * x_844
                + x_517 * x_846
                + x_531 * x_800
                + x_531 * x_829
                + x_549 * x_554
                + x_549 * x_842
                - x_56 * (x_57 + x_58)
                + x_567 * x_823
                + x_567 * x_853
                + x_567 * x_854
                + x_567 * x_855
                + x_573 * x_824
                - x_573 * x_831
                + x_573 * x_850
                + x_573 * x_852
                - x_574 * x_791
                + x_574 * x_821
                - x_574 * x_844
                + x_574 * x_856
                + x_607 * x_834
                - x_607 * x_860
                + x_607 * (x_204 * x_858 + x_70 * x_857)
                + x_607 * (-x_532 * x_809 - x_860)
                + x_607 * (0.1059 * x_146 * x_449 * x_70 - x_451 * x_795)
                + x_617 * x_835
                - x_617 * x_861
                + x_617 * (-x_449 * x_795 - x_70 * x_859)
                + x_617 * (-x_474 * x_809 - x_861)
                + x_617 * (0.1059 * x_144 * x_449 * x_70 - x_204 * x_859)
                - x_625 * x_831
                + x_625 * x_837
                + x_625 * x_850
                + x_625 * x_852
                - x_669 * x_8
                + x_68 * x_784
                + 0.0256 * x_727
                - 0.0256 * x_729
                + x_784 * x_87
                + x_842 * x_843
                - x_89 * (-0.2084 * x_671 - x_679 * x_9 - x_783 * x_9)
                + 0.0028405095497008 * x_95
                - 0.0034465095497008 * x_96
                - 0.0028405095497008 * x_98
            ,
            
                -0.00208866816 * x_1 * x_684
                + x_109 * x_676
                + x_109 * x_881
                + x_109 * (x_200 * x_882 + x_510 * x_813)
                + x_109 * (x_379 * x_879 + x_469 * x_875 + x_479 * x_873)
                + 0.4168 * x_112 * x_69
                + x_112 * x_881
                + x_112 * (x_200 * x_869 + x_379 * x_868 + x_69 * x_892)
                + x_112 * (x_69 * x_863 + x_69 * x_864 - x_898)
                + x_115 * (x_285 + x_286)
                + x_120 * (x_465 * x_875 + x_475 * x_873 - x_896)
                - x_124 * x_897
                + x_128 * x_809
                + x_128 * x_816
                + x_128 * x_883
                + x_128 * x_894
                + x_130 * x_810
                + x_130 * x_816
                + x_130 * x_891
                + x_130 * x_893
                + x_131 * x_787
                - x_142 * x_683
                - x_144 * x_448
                + 0.272283 * x_144 * x_503
                + x_144 * x_554
                - x_146 * x_442
                - 0.272283 * x_146 * x_517
                - x_164 * (0.1059 * x_144 * x_158 - x_885)
                - x_166 * (x_137 + x_138 * x_69)
                - x_169 * (x_152 * x_882 - 0.1059 * x_906)
                + x_196 * x_428 * x_900
                - x_214 * (x_196 * x_887 + x_202 * x_882)
                - x_214 * (x_390 * x_879 + x_521 * x_873 + x_524 * x_875)
                - x_220 * (x_160 * x_904 + x_210 * x_882)
                - x_220 * (x_381 * x_879 + x_471 * x_875 + x_481 * x_873)
                - x_233 * (0.063883 * x_144 * x_158 - 0.063883 * x_884 - x_899)
                - x_233 * (x_149 * x_890 + x_202 * x_869 + x_390 * x_868)
                - x_236 * (0.063883 * x_144 * x_152 - x_898 * x_9 - 0.063883 * x_906)
                - x_236 * (x_160 * x_890 + x_210 * x_869 + x_381 * x_868)
                - 2.5120044e-7 * x_240
                + 2.5120044e-7 * x_241
                - 2.5120044e-7 * x_243
                - 2.5120044e-7 * x_246
                - 0.3867904 * x_247 * x_261
                - 0.07019454 * x_247 * x_283
                - 1.674e-5 * x_247 * x_289
                + x_25 * x_809
                + x_25 * x_816
                + x_25 * x_883
                + x_25 * x_894
                + 1.674e-5 * x_255 * x_287
                + 0.3867904 * x_256 * x_262
                + x_257 * x_880
                + x_257 * x_902
                + x_259 * x_866
                + x_259 * x_870
                + 0.07019454 * x_262 * x_287
                + x_263 * x_897
                + x_264 * (x_474 * x_873 + x_532 * x_875 + x_896)
                - 0.00352879782724 * x_267
                - 0.00352879782724 * x_268
                + x_27 * x_810
                + x_27 * x_816
                + x_27 * x_891
                + x_27 * x_893
                - 0.00352879782724 * x_270
                + x_271 * x_862
                + x_271 * (x_196 * x_813 + x_196 * x_815)
                + x_271 * (-x_144 * x_895 + x_453 * x_875 + x_461 * x_873)
                + x_273 * x_862
                + x_273 * (x_863 + x_864)
                + x_273 * (x_144 * x_871 - x_144 * x_872 + x_892)
                + x_29 * x_787
                + x_308 * x_880
                + x_308 * x_902
                + x_310 * x_870
                + x_325 * x_900
                + x_325 * (x_871 - x_872)
                + x_327 * x_900
                + x_327 * x_903
                + x_327 * (x_196 * x_449 * x_875 - x_196 * x_874 - x_895)
                + x_335 * x_876
                - x_335 * x_901
                - x_335 * x_904
                + x_339 * x_889
                - x_339 * x_901
                - x_34 * x_701
                + x_34 * x_888
                + x_34 * (x_196 * x_885 + x_223 * x_882)
                + x_34 * (x_395 * x_879 + x_526 * x_873 + x_527 * x_875)
                + x_351
                + 0.00352879782724 * x_354
                - x_36 * x_702
                + x_36 * x_888
                + x_36 * (0.063883 * x_144 * x_190 - 0.063883 * x_886 + x_899)
                + x_36 * (x_150 * x_890 + x_223 * x_869 + x_395 * x_868)
                + x_37 * x_704
                + x_409 * x_879
                - x_409 * x_905
                + x_428 * x_882
                + x_428 * (x_449 * x_875 - x_874)
                + x_474 * x_647
                - x_514 * x_876
                + x_514 * x_901
                + x_514 * x_904
                + x_531 * x_866
                + x_532 * x_652
                - x_534 * x_540
                + x_548 * x_550
                + x_550 * x_665
                + x_567 * x_869
                + x_573 * x_868
                - x_573 * x_905
                + x_574 * x_890
                + x_574 * x_901
                + x_607 * x_875
                + x_607 * (0.1059 * x_144 * x_449 - 0.1059 * x_473)
                + x_607 * (0.1059 * x_144 * x_196 * x_449 - x_859)
                + x_607 * (0.2084 * x_144 * x_196 * x_449 - 0.2084 * x_452)
                + x_617 * x_873
                + x_617 * (-0.2084 * x_458 - 0.2084 * x_460)
                + x_617 * (-0.1059 * x_460 - x_858)
                + x_617 * (-0.1059 * x_464 - x_857)
                + x_625 * x_879
                - x_625 * x_905
                + x_777 * x_900
                - 0.08138070016 * x_781 * x_91
                - 0.08590526315144 * x_95
                + 0.09422126315144 * x_96
                + 0.08590526315144 * x_98
            ,
            
                -x_109 * x_146 * x_792
                + x_109 * (x_379 * x_920 + x_469 * x_922 + x_479 * x_923)
                + x_112 * (0.009432 * x_144 * x_69 - x_146 * x_365)
                + x_112 * (-x_200 * x_913 + x_379 * x_914 + x_69 * x_912)
                + x_120 * x_902
                + x_120 * (x_465 * x_922 + x_475 * x_923 - x_926)
                + x_124 * x_866
                - x_124 * x_918
                - x_128 * x_831
                + x_128 * x_924
                + x_130 * x_908
                + x_130 * x_915
                + 0.00028593 * x_149 * x_907
                - x_150 * x_34 * x_909
                + 0.000256 * x_161 * x_19
                + 0.01114068 * x_194 * x_3 * x_907
                + x_196 * x_548
                + x_196 * x_665
                + x_198 * x_540
                - x_214 * (x_390 * x_920 + x_521 * x_923 + x_524 * x_922)
                - x_220 * (x_381 * x_920 + x_471 * x_922 + x_481 * x_923)
                - x_233 * x_712
                - x_233 * (x_149 * x_911 - x_202 * x_913 + x_390 * x_914)
                - x_236 * (x_160 * x_911 - x_210 * x_913 + x_381 * x_914)
                - x_236
                * (
                    0.009432 * x_144 * x_69 * x_9
                    - 0.009432 * x_147
                    - x_155 * x_365
                    - 1.0e-6 * x_156
                )
                - x_25 * x_831
                + x_25 * x_924
                + x_257 * x_929
                - x_263 * x_866
                + x_263 * x_918
                - x_264 * x_902
                + x_264 * (x_474 * x_923 + x_532 * x_922 + x_926)
                + 6.031665975e-5 * x_267
                + 6.031665975e-5 * x_268
                + x_27 * x_908
                + x_27 * x_915
                + 6.031665975e-5 * x_270
                - 0.1059 * x_271 * x_550
                + x_271 * (-x_144 * x_925 + x_453 * x_922 + x_461 * x_923)
                + x_273 * (0.009432 * x_144 - x_374)
                + x_273 * (-x_144 * x_916 - x_144 * x_917 + x_146 * x_911)
                + x_297 * x_440
                + 0.006394896 * x_305 * x_502
                + x_308 * x_929
                - 0.000408525141168 * x_313
                - 0.000408525141168 * x_316
                - 0.006394896 * x_317 * x_501
                + 6.78e-7 * x_317 * x_515
                - 0.000408525141168 * x_324
                + x_325 * (-x_916 - x_917)
                + x_327 * (x_196 * x_449 * x_922 - x_196 * x_928 - x_925)
                - 4.3312674e-8 * x_328
                + 4.3312674e-8 * x_329
                - 4.3312674e-8 * x_330
                + x_335 * x_909
                + x_335 * x_930
                + 4.3312674e-8 * x_336
                + 4.3312674e-8 * x_338
                + x_339 * x_910
                + x_34 * (x_395 * x_920 + x_526 * x_923 + x_527 * x_922)
                - 6.031665975e-5 * x_354
                - x_36 * x_712
                + x_36 * (x_150 * x_911 - x_223 * x_913 + x_395 * x_914)
                + x_409 * x_920
                + 0.000408525141168 * x_416
                + 0.000408525141168 * x_417
                + x_428 * (x_927 - x_928)
                + x_449 * x_617 * x_909
                + x_451 * x_607 * x_909
                - x_483
                - x_484
                - x_485
                - x_486
                - x_487
                - x_488
                - x_489
                + 0.000256 * x_49 * x_549
                - x_490
                - x_491
                - x_514 * x_909
                - x_514 * x_930
                - 6.78e-7 * x_516
                + x_573 * x_914
                + x_574 * x_911
                + x_607 * x_922
                + x_617 * x_923
                + x_625 * x_920
                + x_643 * x_652
                - x_647 * x_931
                - 0.00965 * x_777
            ,
            
                x_109 * (0.1059 * x_144 * x_196 * x_69 - x_830)
                + x_109 * (x_379 * x_932 + x_469 * x_936 - x_479 * x_937)
                + x_112
                * (
                    0.045483 * x_144 * x_196 * x_69
                    - 0.045483 * x_199
                    - x_203 * x_865
                    - 1.0e-6 * x_204
                )
                + x_120 * x_904
                + x_120 * (0.029798 * x_449 * x_465 - x_475 * x_937 - x_940)
                + x_124 * x_890
                + x_128 * x_794
                + x_128 * x_938
                + x_130 * x_820
                + x_196 * x_842
                - x_214 * x_703
                - x_214 * (x_390 * x_932 - x_521 * x_937 + x_524 * x_936)
                - x_220 * (-0.1059 * x_208 + 0.1059 * x_209)
                - x_220 * (x_381 * x_932 + x_471 * x_936 - x_481 * x_937)
                - x_233 * x_734
                - x_236
                * (x_147 * x_565 - x_147 * x_733 + 0.045483 * x_209 + 1.0e-6 * x_380)
                + x_25 * x_794
                + x_25 * x_938
                + x_257 * x_909
                + x_257 * x_935
                + x_259 * x_910
                + x_263 * x_889
                - x_264 * x_904
                + x_264 * (-x_474 * x_937 + x_532 * x_936 + x_940)
                + x_27 * x_820
                + x_271 * x_903
                + x_271 * (-x_144 * x_939 + 0.029798 * x_449 * x_453 - x_461 * x_937)
                + x_273 * (0.045483 * x_144 * x_196 - x_198 * x_865)
                + x_308 * x_909
                + x_308 * x_935
                + x_310 * x_910
                - 0.00700998583062 * x_313
                + x_325 * (0.045483 * x_196 - x_565)
                + x_327 * (x_196 * x_933 + x_196 * x_934 - x_939)
                + x_34 * x_758
                + x_34 * (x_395 * x_932 - x_526 * x_937 + x_527 * x_936)
                + x_36 * x_759
                + 6.78e-7 * x_399 * x_571
                - 6.78e-7 * x_407 * x_566
                + 0.05295 * x_408 * x_426
                + x_409 * x_932
                + 0.00700998583062 * x_416
                + 0.00700998583062 * x_417
                + 0.030837474 * x_426 * x_566
                + x_428 * (x_933 + x_934)
                + 0.135698 * x_449 * x_607
                - x_449 * x_647
                - 0.135698 * x_451 * x_617
                - x_451 * x_652
                + 6.5427e-9 * x_505
                + 6.5427e-9 * x_506
                + 6.5427e-9 * x_509
                + 6.5427e-9 * x_512
                + 6.5427e-9 * x_513
                + x_554
                - 0.0002975816241 * x_555
                - 0.0002975816241 * x_556
                - 0.0002975816241 * x_558
                - 0.0002975816241 * x_561
                - 0.0002975816241 * x_562
                - 0.030837474 * x_564
                - 6.5427e-9 * x_568
                + 0.00700998583062 * x_569
                + 0.00700998583062 * x_570
                + 0.0002975816241 * x_575
                + x_625 * x_932
            ,
            
                -0.000169878398 * joint_velocity[0] * x_587
                - 0.000169878398 * joint_velocity[1] * x_586
                - 0.000169878398 * joint_velocity[2] * x_583
                - 0.000169878398 * joint_velocity[3] * x_579
                - 0.000169878398 * joint_velocity[6] * x_576
                + 4.186619e-6 * joint_velocity[6] * x_591
                + 4.186619e-6 * joint_velocity[6] * x_592
                + x_109
                * (
                    -x_199 * x_599
                    - x_199 * x_600
                    + 0.011402 * x_453 * x_69
                    - 0.000281 * x_478
                )
                + x_120 * x_879
                + x_128 * x_836
                + 3.0e-6 * x_186 * x_469
                + 0.000118 * x_186 * x_479
                + 3.0e-6 * x_19 * x_471
                + 0.000118 * x_19 * x_481
                - x_214 * x_762
                - x_220
                * (
                    -0.011402 * x_466
                    + 0.011402 * x_470
                    + 0.000281 * x_476
                    - 0.000281 * x_480
                )
                + x_25 * x_836
                + x_257 * x_919
                - x_264 * x_879
                + x_271
                * (-0.011402 * x_452 + 0.000281 * x_458 + x_459 * x_877 + x_580 * x_878)
                + x_308 * x_919
                + x_327 * (x_449 * x_878 + x_451 * x_877)
                + x_335 * x_932
                - x_34 * x_762
                + 3.0e-6 * x_368 * x_453
                + 0.000118 * x_368 * x_461
                + 0.000118 * x_369 * x_931
                + x_426 * x_631
                + x_428 * (x_599 + x_600)
                + x_449 * x_648
                - x_514 * x_932
                + 0.000609 * x_551
                + 0.000609 * x_552
                + 0.000609 * x_553
                + 6.50422825e-5 * x_555
                + 6.50422825e-5 * x_556
                + 6.50422825e-5 * x_558
                + 6.50422825e-5 * x_561
                + 6.50422825e-5 * x_562
                - 6.50422825e-5 * x_575
                - 0.005701 * x_589 * x_590
                - 0.0001405 * x_590 * x_615
                + 0.005701 * x_598 * x_605
                + x_598 * x_629
                + 0.0001405 * x_605 * x_616
                + x_616 * x_651
                + 0.000169878398 * x_618
                - 4.186619e-6 * x_619
                + 0.000169878398 * x_620
                - 4.186619e-6 * x_621
                - 4.186619e-6 * x_622
                - 4.186619e-6 * x_623
                - 4.186619e-6 * x_624
                - x_638
                - x_640
                - x_642
                - x_645
                - x_653
                - x_654
                - x_655
                - x_656
                - x_657
                - x_658
                - x_659
                - x_660
                - x_661
                - x_662
                - x_663
                - x_664
            ,
        ]
    )
