# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppImageConfigFileSystemConfig',
    'AppImageConfigKernelGatewayImageConfig',
    'AppImageConfigKernelSpec',
    'AppImageConfigTag',
    'AppResourceSpec',
    'AppTag',
    'CodeRepositoryGitConfig',
    'CodeRepositoryTag',
    'DataQualityJobDefinitionClusterConfig',
    'DataQualityJobDefinitionConstraintsResource',
    'DataQualityJobDefinitionDataQualityAppSpecification',
    'DataQualityJobDefinitionDataQualityBaselineConfig',
    'DataQualityJobDefinitionDataQualityJobInput',
    'DataQualityJobDefinitionEndpointInput',
    'DataQualityJobDefinitionMonitoringOutput',
    'DataQualityJobDefinitionMonitoringOutputConfig',
    'DataQualityJobDefinitionMonitoringResources',
    'DataQualityJobDefinitionNetworkConfig',
    'DataQualityJobDefinitionS3Output',
    'DataQualityJobDefinitionStatisticsResource',
    'DataQualityJobDefinitionStoppingCondition',
    'DataQualityJobDefinitionTag',
    'DataQualityJobDefinitionVpcConfig',
    'Device',
    'DeviceFleetEdgeOutputConfig',
    'DeviceFleetTag',
    'DeviceTag',
    'DomainCustomImage',
    'DomainJupyterServerAppSettings',
    'DomainKernelGatewayAppSettings',
    'DomainResourceSpec',
    'DomainSharingSettings',
    'DomainTag',
    'DomainUserSettings',
    'EndpointAlarm',
    'EndpointAutoRollbackConfig',
    'EndpointBlueGreenUpdatePolicy',
    'EndpointCapacitySize',
    'EndpointConfigAsyncInferenceClientConfig',
    'EndpointConfigAsyncInferenceConfig',
    'EndpointConfigAsyncInferenceNotificationConfig',
    'EndpointConfigAsyncInferenceOutputConfig',
    'EndpointConfigCaptureContentTypeHeader',
    'EndpointConfigCaptureOption',
    'EndpointConfigDataCaptureConfig',
    'EndpointConfigProductionVariant',
    'EndpointConfigServerlessConfig',
    'EndpointConfigTag',
    'EndpointDeploymentConfig',
    'EndpointTag',
    'EndpointTrafficRoutingConfig',
    'EndpointVariantProperty',
    'FeatureGroupDataCatalogConfig',
    'FeatureGroupFeatureDefinition',
    'FeatureGroupOnlineStoreSecurityConfig',
    'FeatureGroupS3StorageConfig',
    'FeatureGroupTag',
    'ImageTag',
    'ModelBiasJobDefinitionClusterConfig',
    'ModelBiasJobDefinitionConstraintsResource',
    'ModelBiasJobDefinitionEndpointInput',
    'ModelBiasJobDefinitionModelBiasAppSpecification',
    'ModelBiasJobDefinitionModelBiasBaselineConfig',
    'ModelBiasJobDefinitionModelBiasJobInput',
    'ModelBiasJobDefinitionMonitoringGroundTruthS3Input',
    'ModelBiasJobDefinitionMonitoringOutput',
    'ModelBiasJobDefinitionMonitoringOutputConfig',
    'ModelBiasJobDefinitionMonitoringResources',
    'ModelBiasJobDefinitionNetworkConfig',
    'ModelBiasJobDefinitionS3Output',
    'ModelBiasJobDefinitionStoppingCondition',
    'ModelBiasJobDefinitionTag',
    'ModelBiasJobDefinitionVpcConfig',
    'ModelContainerDefinition',
    'ModelExplainabilityJobDefinitionClusterConfig',
    'ModelExplainabilityJobDefinitionConstraintsResource',
    'ModelExplainabilityJobDefinitionEndpointInput',
    'ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification',
    'ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig',
    'ModelExplainabilityJobDefinitionModelExplainabilityJobInput',
    'ModelExplainabilityJobDefinitionMonitoringOutput',
    'ModelExplainabilityJobDefinitionMonitoringOutputConfig',
    'ModelExplainabilityJobDefinitionMonitoringResources',
    'ModelExplainabilityJobDefinitionNetworkConfig',
    'ModelExplainabilityJobDefinitionS3Output',
    'ModelExplainabilityJobDefinitionStoppingCondition',
    'ModelExplainabilityJobDefinitionTag',
    'ModelExplainabilityJobDefinitionVpcConfig',
    'ModelImageConfig',
    'ModelInferenceExecutionConfig',
    'ModelMultiModelConfig',
    'ModelPackageGroupTag',
    'ModelQualityJobDefinitionClusterConfig',
    'ModelQualityJobDefinitionConstraintsResource',
    'ModelQualityJobDefinitionEndpointInput',
    'ModelQualityJobDefinitionModelQualityAppSpecification',
    'ModelQualityJobDefinitionModelQualityBaselineConfig',
    'ModelQualityJobDefinitionModelQualityJobInput',
    'ModelQualityJobDefinitionMonitoringGroundTruthS3Input',
    'ModelQualityJobDefinitionMonitoringOutput',
    'ModelQualityJobDefinitionMonitoringOutputConfig',
    'ModelQualityJobDefinitionMonitoringResources',
    'ModelQualityJobDefinitionNetworkConfig',
    'ModelQualityJobDefinitionS3Output',
    'ModelQualityJobDefinitionStoppingCondition',
    'ModelQualityJobDefinitionTag',
    'ModelQualityJobDefinitionVpcConfig',
    'ModelRepositoryAuthConfig',
    'ModelTag',
    'ModelVpcConfig',
    'MonitoringScheduleBaselineConfig',
    'MonitoringScheduleClusterConfig',
    'MonitoringScheduleConfig',
    'MonitoringScheduleConstraintsResource',
    'MonitoringScheduleEndpointInput',
    'MonitoringScheduleMonitoringAppSpecification',
    'MonitoringScheduleMonitoringExecutionSummary',
    'MonitoringScheduleMonitoringInput',
    'MonitoringScheduleMonitoringJobDefinition',
    'MonitoringScheduleMonitoringOutput',
    'MonitoringScheduleMonitoringOutputConfig',
    'MonitoringScheduleMonitoringResources',
    'MonitoringScheduleNetworkConfig',
    'MonitoringScheduleS3Output',
    'MonitoringScheduleScheduleConfig',
    'MonitoringScheduleStatisticsResource',
    'MonitoringScheduleStoppingCondition',
    'MonitoringScheduleTag',
    'MonitoringScheduleVpcConfig',
    'NotebookInstanceLifecycleConfigNotebookInstanceLifecycleHook',
    'NotebookInstanceTag',
    'OfflineStoreConfigProperties',
    'OnlineStoreConfigProperties',
    'ParallelismConfigurationProperties',
    'PipelineTag',
    'ProjectProvisioningParameter',
    'ProjectTag',
    'ServiceCatalogProvisionedProductDetailsProperties',
    'ServiceCatalogProvisioningDetailsProperties',
    'UserProfileCustomImage',
    'UserProfileJupyterServerAppSettings',
    'UserProfileKernelGatewayAppSettings',
    'UserProfileResourceSpec',
    'UserProfileSharingSettings',
    'UserProfileTag',
    'UserProfileUserSettings',
    'WorkteamCognitoMemberDefinition',
    'WorkteamMemberDefinition',
    'WorkteamNotificationConfiguration',
    'WorkteamTag',
]

@pulumi.output_type
class AppImageConfigFileSystemConfig(dict):
    """
    The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultGid":
            suggest = "default_gid"
        elif key == "defaultUid":
            suggest = "default_uid"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_gid: Optional[int] = None,
                 default_uid: Optional[int] = None,
                 mount_path: Optional[str] = None):
        """
        The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        :param int default_gid: The default POSIX group ID (GID). If not specified, defaults to 100.
        :param int default_uid: The default POSIX user ID (UID). If not specified, defaults to 1000.
        :param str mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to /home/sagemaker-user.
        """
        if default_gid is not None:
            pulumi.set(__self__, "default_gid", default_gid)
        if default_uid is not None:
            pulumi.set(__self__, "default_uid", default_uid)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="defaultGid")
    def default_gid(self) -> Optional[int]:
        """
        The default POSIX group ID (GID). If not specified, defaults to 100.
        """
        return pulumi.get(self, "default_gid")

    @property
    @pulumi.getter(name="defaultUid")
    def default_uid(self) -> Optional[int]:
        """
        The default POSIX user ID (UID). If not specified, defaults to 1000.
        """
        return pulumi.get(self, "default_uid")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to /home/sagemaker-user.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class AppImageConfigKernelGatewayImageConfig(dict):
    """
    The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kernelSpecs":
            suggest = "kernel_specs"
        elif key == "fileSystemConfig":
            suggest = "file_system_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelGatewayImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kernel_specs: Sequence['outputs.AppImageConfigKernelSpec'],
                 file_system_config: Optional['outputs.AppImageConfigFileSystemConfig'] = None):
        """
        The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
        :param Sequence['AppImageConfigKernelSpec'] kernel_specs: The specification of the Jupyter kernels in the image.
        :param 'AppImageConfigFileSystemConfig' file_system_config: The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        """
        pulumi.set(__self__, "kernel_specs", kernel_specs)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)

    @property
    @pulumi.getter(name="kernelSpecs")
    def kernel_specs(self) -> Sequence['outputs.AppImageConfigKernelSpec']:
        """
        The specification of the Jupyter kernels in the image.
        """
        return pulumi.get(self, "kernel_specs")

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional['outputs.AppImageConfigFileSystemConfig']:
        """
        The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        """
        return pulumi.get(self, "file_system_config")


@pulumi.output_type
class AppImageConfigKernelSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 display_name: Optional[str] = None):
        """
        :param str name: The name of the kernel.
        :param str display_name: The display name of the kernel.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the kernel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the kernel.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class AppImageConfigTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class AppResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['AppResourceSpecInstanceType'] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'AppResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['AppResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class AppTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CodeRepositoryGitConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeRepositoryGitConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeRepositoryGitConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeRepositoryGitConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str,
                 branch: Optional[str] = None,
                 secret_arn: Optional[str] = None):
        pulumi.set(__self__, "repository_url", repository_url)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        return pulumi.get(self, "repository_url")

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class CodeRepositoryTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DataQualityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class DataQualityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 environment: Optional[Any] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"
        elif key == "statisticsResource":
            suggest = "statistics_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.DataQualityJobDefinitionConstraintsResource'] = None,
                 statistics_resource: Optional['outputs.DataQualityJobDefinitionStatisticsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)
        if statistics_resource is not None:
            pulumi.set(__self__, "statistics_resource", statistics_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.DataQualityJobDefinitionConstraintsResource']:
        return pulumi.get(self, "constraints_resource")

    @property
    @pulumi.getter(name="statisticsResource")
    def statistics_resource(self) -> Optional['outputs.DataQualityJobDefinitionStatisticsResource']:
        return pulumi.get(self, "statistics_resource")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_input: 'outputs.DataQualityJobDefinitionEndpointInput'):
        """
        The inputs for a monitoring job.
        """
        pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> 'outputs.DataQualityJobDefinitionEndpointInput':
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class DataQualityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 s3_data_distribution_type: Optional['DataQualityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['DataQualityJobDefinitionEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param 'DataQualityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'DataQualityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['DataQualityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['DataQualityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.DataQualityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.DataQualityJobDefinitionS3Output':
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.DataQualityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['DataQualityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.DataQualityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.DataQualityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.DataQualityJobDefinitionClusterConfig':
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class DataQualityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.DataQualityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.DataQualityJobDefinitionVpcConfig']:
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class DataQualityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['DataQualityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'DataQualityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['DataQualityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class DataQualityJobDefinitionStatisticsResource(dict):
    """
    The baseline statistics resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionStatisticsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionStatisticsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionStatisticsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline statistics resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class DataQualityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class DataQualityJobDefinitionTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataQualityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class Device(dict):
    """
    Edge device you want to create
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "iotThingName":
            suggest = "iot_thing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Device. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Device.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Device.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 description: Optional[str] = None,
                 iot_thing_name: Optional[str] = None):
        """
        Edge device you want to create
        :param str device_name: The name of the device
        :param str description: Description of the device
        :param str iot_thing_name: AWS Internet of Things (IoT) object name.
        """
        pulumi.set(__self__, "device_name", device_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iot_thing_name is not None:
            pulumi.set(__self__, "iot_thing_name", iot_thing_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The name of the device
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the device
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iotThingName")
    def iot_thing_name(self) -> Optional[str]:
        """
        AWS Internet of Things (IoT) object name.
        """
        return pulumi.get(self, "iot_thing_name")


@pulumi.output_type
class DeviceFleetEdgeOutputConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3OutputLocation":
            suggest = "s3_output_location"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceFleetEdgeOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceFleetEdgeOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceFleetEdgeOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output_location: str,
                 kms_key_id: Optional[str] = None):
        """
        :param str s3_output_location: The Amazon Simple Storage (S3) bucket URI
        :param str kms_key_id: The KMS key id used for encryption on the S3 bucket
        """
        pulumi.set(__self__, "s3_output_location", s3_output_location)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3OutputLocation")
    def s3_output_location(self) -> str:
        """
        The Amazon Simple Storage (S3) bucket URI
        """
        return pulumi.get(self, "s3_output_location")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The KMS key id used for encryption on the S3 bucket
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DeviceFleetTag(dict):
    """
    Key-value pair to associate as a tag for the resource
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Key-value pair to associate as a tag for the resource
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The key value of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The key value of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeviceTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The key value of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The key value of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainCustomImage(dict):
    """
    A custom SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        A custom SageMaker image.
        :param str app_image_config_name: The Name of the AppImageConfig.
        :param str image_name: The name of the CustomImage. Must be unique to your account.
        :param int image_version_number: The version number of the CustomImage.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the CustomImage. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the CustomImage.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class DomainJupyterServerAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None):
        """
        The JupyterServer app settings.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainKernelGatewayAppSettings(dict):
    """
    The kernel gateway app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.DomainCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None):
        """
        The kernel gateway app settings.
        :param Sequence['DomainCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'DomainResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['DomainResourceSpecInstanceType'] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'DomainResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['DomainResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class DomainSharingSettings(dict):
    """
    Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional['DomainSharingSettingsNotebookOutputOption'] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
        :param 'DomainSharingSettingsNotebookOutputOption' notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        :param str s3_kms_key_id: When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional['DomainSharingSettingsNotebookOutputOption']:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class DomainTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainUserSettings(dict):
    """
    A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: Optional[str] = None,
                 jupyter_server_app_settings: Optional['outputs.DomainJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.DomainKernelGatewayAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.DomainSharingSettings'] = None):
        """
        A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
        :param str execution_role: The user profile Amazon Resource Name (ARN).
        :param 'DomainJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'DomainKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param Sequence[str] security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param 'DomainSharingSettings' sharing_settings: The sharing settings.
        """
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[str]:
        """
        The user profile Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.DomainJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.DomainKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.DomainSharingSettings']:
        """
        The sharing settings.
        """
        return pulumi.get(self, "sharing_settings")


@pulumi.output_type
class EndpointAlarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmName":
            suggest = "alarm_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAlarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAlarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAlarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_name: str):
        pulumi.set(__self__, "alarm_name", alarm_name)

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> str:
        return pulumi.get(self, "alarm_name")


@pulumi.output_type
class EndpointAutoRollbackConfig(dict):
    def __init__(__self__, *,
                 alarms: Sequence['outputs.EndpointAlarm']):
        pulumi.set(__self__, "alarms", alarms)

    @property
    @pulumi.getter
    def alarms(self) -> Sequence['outputs.EndpointAlarm']:
        return pulumi.get(self, "alarms")


@pulumi.output_type
class EndpointBlueGreenUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trafficRoutingConfiguration":
            suggest = "traffic_routing_configuration"
        elif key == "maximumExecutionTimeoutInSeconds":
            suggest = "maximum_execution_timeout_in_seconds"
        elif key == "terminationWaitInSeconds":
            suggest = "termination_wait_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointBlueGreenUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointBlueGreenUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointBlueGreenUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 traffic_routing_configuration: 'outputs.EndpointTrafficRoutingConfig',
                 maximum_execution_timeout_in_seconds: Optional[int] = None,
                 termination_wait_in_seconds: Optional[int] = None):
        pulumi.set(__self__, "traffic_routing_configuration", traffic_routing_configuration)
        if maximum_execution_timeout_in_seconds is not None:
            pulumi.set(__self__, "maximum_execution_timeout_in_seconds", maximum_execution_timeout_in_seconds)
        if termination_wait_in_seconds is not None:
            pulumi.set(__self__, "termination_wait_in_seconds", termination_wait_in_seconds)

    @property
    @pulumi.getter(name="trafficRoutingConfiguration")
    def traffic_routing_configuration(self) -> 'outputs.EndpointTrafficRoutingConfig':
        return pulumi.get(self, "traffic_routing_configuration")

    @property
    @pulumi.getter(name="maximumExecutionTimeoutInSeconds")
    def maximum_execution_timeout_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "maximum_execution_timeout_in_seconds")

    @property
    @pulumi.getter(name="terminationWaitInSeconds")
    def termination_wait_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "termination_wait_in_seconds")


@pulumi.output_type
class EndpointCapacitySize(dict):
    def __init__(__self__, *,
                 type: str,
                 value: int):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> int:
        return pulumi.get(self, "value")


@pulumi.output_type
class EndpointConfigAsyncInferenceClientConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentInvocationsPerInstance":
            suggest = "max_concurrent_invocations_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigAsyncInferenceClientConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigAsyncInferenceClientConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigAsyncInferenceClientConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_invocations_per_instance: Optional[int] = None):
        if max_concurrent_invocations_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_invocations_per_instance", max_concurrent_invocations_per_instance)

    @property
    @pulumi.getter(name="maxConcurrentInvocationsPerInstance")
    def max_concurrent_invocations_per_instance(self) -> Optional[int]:
        return pulumi.get(self, "max_concurrent_invocations_per_instance")


@pulumi.output_type
class EndpointConfigAsyncInferenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputConfig":
            suggest = "output_config"
        elif key == "clientConfig":
            suggest = "client_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigAsyncInferenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigAsyncInferenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigAsyncInferenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_config: 'outputs.EndpointConfigAsyncInferenceOutputConfig',
                 client_config: Optional['outputs.EndpointConfigAsyncInferenceClientConfig'] = None):
        pulumi.set(__self__, "output_config", output_config)
        if client_config is not None:
            pulumi.set(__self__, "client_config", client_config)

    @property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> 'outputs.EndpointConfigAsyncInferenceOutputConfig':
        return pulumi.get(self, "output_config")

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> Optional['outputs.EndpointConfigAsyncInferenceClientConfig']:
        return pulumi.get(self, "client_config")


@pulumi.output_type
class EndpointConfigAsyncInferenceNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorTopic":
            suggest = "error_topic"
        elif key == "successTopic":
            suggest = "success_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigAsyncInferenceNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigAsyncInferenceNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigAsyncInferenceNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_topic: Optional[str] = None,
                 success_topic: Optional[str] = None):
        if error_topic is not None:
            pulumi.set(__self__, "error_topic", error_topic)
        if success_topic is not None:
            pulumi.set(__self__, "success_topic", success_topic)

    @property
    @pulumi.getter(name="errorTopic")
    def error_topic(self) -> Optional[str]:
        return pulumi.get(self, "error_topic")

    @property
    @pulumi.getter(name="successTopic")
    def success_topic(self) -> Optional[str]:
        return pulumi.get(self, "success_topic")


@pulumi.output_type
class EndpointConfigAsyncInferenceOutputConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3OutputPath":
            suggest = "s3_output_path"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "notificationConfig":
            suggest = "notification_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigAsyncInferenceOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigAsyncInferenceOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigAsyncInferenceOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output_path: str,
                 kms_key_id: Optional[str] = None,
                 notification_config: Optional['outputs.EndpointConfigAsyncInferenceNotificationConfig'] = None):
        pulumi.set(__self__, "s3_output_path", s3_output_path)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> str:
        return pulumi.get(self, "s3_output_path")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional['outputs.EndpointConfigAsyncInferenceNotificationConfig']:
        return pulumi.get(self, "notification_config")


@pulumi.output_type
class EndpointConfigCaptureContentTypeHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvContentTypes":
            suggest = "csv_content_types"
        elif key == "jsonContentTypes":
            suggest = "json_content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigCaptureContentTypeHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigCaptureContentTypeHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigCaptureContentTypeHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_content_types: Optional[Sequence[str]] = None,
                 json_content_types: Optional[Sequence[str]] = None):
        if csv_content_types is not None:
            pulumi.set(__self__, "csv_content_types", csv_content_types)
        if json_content_types is not None:
            pulumi.set(__self__, "json_content_types", json_content_types)

    @property
    @pulumi.getter(name="csvContentTypes")
    def csv_content_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "csv_content_types")

    @property
    @pulumi.getter(name="jsonContentTypes")
    def json_content_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "json_content_types")


@pulumi.output_type
class EndpointConfigCaptureOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "captureMode":
            suggest = "capture_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigCaptureOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigCaptureOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigCaptureOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capture_mode: str):
        pulumi.set(__self__, "capture_mode", capture_mode)

    @property
    @pulumi.getter(name="captureMode")
    def capture_mode(self) -> str:
        return pulumi.get(self, "capture_mode")


@pulumi.output_type
class EndpointConfigDataCaptureConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "captureOptions":
            suggest = "capture_options"
        elif key == "destinationS3Uri":
            suggest = "destination_s3_uri"
        elif key == "initialSamplingPercentage":
            suggest = "initial_sampling_percentage"
        elif key == "captureContentTypeHeader":
            suggest = "capture_content_type_header"
        elif key == "enableCapture":
            suggest = "enable_capture"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigDataCaptureConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigDataCaptureConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigDataCaptureConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capture_options: Sequence['outputs.EndpointConfigCaptureOption'],
                 destination_s3_uri: str,
                 initial_sampling_percentage: int,
                 capture_content_type_header: Optional['outputs.EndpointConfigCaptureContentTypeHeader'] = None,
                 enable_capture: Optional[bool] = None,
                 kms_key_id: Optional[str] = None):
        pulumi.set(__self__, "capture_options", capture_options)
        pulumi.set(__self__, "destination_s3_uri", destination_s3_uri)
        pulumi.set(__self__, "initial_sampling_percentage", initial_sampling_percentage)
        if capture_content_type_header is not None:
            pulumi.set(__self__, "capture_content_type_header", capture_content_type_header)
        if enable_capture is not None:
            pulumi.set(__self__, "enable_capture", enable_capture)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="captureOptions")
    def capture_options(self) -> Sequence['outputs.EndpointConfigCaptureOption']:
        return pulumi.get(self, "capture_options")

    @property
    @pulumi.getter(name="destinationS3Uri")
    def destination_s3_uri(self) -> str:
        return pulumi.get(self, "destination_s3_uri")

    @property
    @pulumi.getter(name="initialSamplingPercentage")
    def initial_sampling_percentage(self) -> int:
        return pulumi.get(self, "initial_sampling_percentage")

    @property
    @pulumi.getter(name="captureContentTypeHeader")
    def capture_content_type_header(self) -> Optional['outputs.EndpointConfigCaptureContentTypeHeader']:
        return pulumi.get(self, "capture_content_type_header")

    @property
    @pulumi.getter(name="enableCapture")
    def enable_capture(self) -> Optional[bool]:
        return pulumi.get(self, "enable_capture")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class EndpointConfigProductionVariant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialVariantWeight":
            suggest = "initial_variant_weight"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "variantName":
            suggest = "variant_name"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "initialInstanceCount":
            suggest = "initial_instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "serverlessConfig":
            suggest = "serverless_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigProductionVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigProductionVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigProductionVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_variant_weight: float,
                 model_name: str,
                 variant_name: str,
                 accelerator_type: Optional[str] = None,
                 initial_instance_count: Optional[int] = None,
                 instance_type: Optional[str] = None,
                 serverless_config: Optional['outputs.EndpointConfigServerlessConfig'] = None):
        pulumi.set(__self__, "initial_variant_weight", initial_variant_weight)
        pulumi.set(__self__, "model_name", model_name)
        pulumi.set(__self__, "variant_name", variant_name)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if initial_instance_count is not None:
            pulumi.set(__self__, "initial_instance_count", initial_instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if serverless_config is not None:
            pulumi.set(__self__, "serverless_config", serverless_config)

    @property
    @pulumi.getter(name="initialVariantWeight")
    def initial_variant_weight(self) -> float:
        return pulumi.get(self, "initial_variant_weight")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> str:
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="variantName")
    def variant_name(self) -> str:
        return pulumi.get(self, "variant_name")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[str]:
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="initialInstanceCount")
    def initial_instance_count(self) -> Optional[int]:
        return pulumi.get(self, "initial_instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="serverlessConfig")
    def serverless_config(self) -> Optional['outputs.EndpointConfigServerlessConfig']:
        return pulumi.get(self, "serverless_config")


@pulumi.output_type
class EndpointConfigServerlessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrency":
            suggest = "max_concurrency"
        elif key == "memorySizeInMB":
            suggest = "memory_size_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigServerlessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigServerlessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigServerlessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrency: int,
                 memory_size_in_mb: int):
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        pulumi.set(__self__, "memory_size_in_mb", memory_size_in_mb)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> int:
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="memorySizeInMB")
    def memory_size_in_mb(self) -> int:
        return pulumi.get(self, "memory_size_in_mb")


@pulumi.output_type
class EndpointConfigTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class EndpointDeploymentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blueGreenUpdatePolicy":
            suggest = "blue_green_update_policy"
        elif key == "autoRollbackConfiguration":
            suggest = "auto_rollback_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointDeploymentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointDeploymentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointDeploymentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blue_green_update_policy: 'outputs.EndpointBlueGreenUpdatePolicy',
                 auto_rollback_configuration: Optional['outputs.EndpointAutoRollbackConfig'] = None):
        pulumi.set(__self__, "blue_green_update_policy", blue_green_update_policy)
        if auto_rollback_configuration is not None:
            pulumi.set(__self__, "auto_rollback_configuration", auto_rollback_configuration)

    @property
    @pulumi.getter(name="blueGreenUpdatePolicy")
    def blue_green_update_policy(self) -> 'outputs.EndpointBlueGreenUpdatePolicy':
        return pulumi.get(self, "blue_green_update_policy")

    @property
    @pulumi.getter(name="autoRollbackConfiguration")
    def auto_rollback_configuration(self) -> Optional['outputs.EndpointAutoRollbackConfig']:
        return pulumi.get(self, "auto_rollback_configuration")


@pulumi.output_type
class EndpointTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class EndpointTrafficRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canarySize":
            suggest = "canary_size"
        elif key == "linearStepSize":
            suggest = "linear_step_size"
        elif key == "waitIntervalInSeconds":
            suggest = "wait_interval_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointTrafficRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointTrafficRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointTrafficRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 canary_size: Optional['outputs.EndpointCapacitySize'] = None,
                 linear_step_size: Optional['outputs.EndpointCapacitySize'] = None,
                 wait_interval_in_seconds: Optional[int] = None):
        pulumi.set(__self__, "type", type)
        if canary_size is not None:
            pulumi.set(__self__, "canary_size", canary_size)
        if linear_step_size is not None:
            pulumi.set(__self__, "linear_step_size", linear_step_size)
        if wait_interval_in_seconds is not None:
            pulumi.set(__self__, "wait_interval_in_seconds", wait_interval_in_seconds)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="canarySize")
    def canary_size(self) -> Optional['outputs.EndpointCapacitySize']:
        return pulumi.get(self, "canary_size")

    @property
    @pulumi.getter(name="linearStepSize")
    def linear_step_size(self) -> Optional['outputs.EndpointCapacitySize']:
        return pulumi.get(self, "linear_step_size")

    @property
    @pulumi.getter(name="waitIntervalInSeconds")
    def wait_interval_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "wait_interval_in_seconds")


@pulumi.output_type
class EndpointVariantProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variantPropertyType":
            suggest = "variant_property_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointVariantProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointVariantProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointVariantProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 variant_property_type: Optional[str] = None):
        if variant_property_type is not None:
            pulumi.set(__self__, "variant_property_type", variant_property_type)

    @property
    @pulumi.getter(name="variantPropertyType")
    def variant_property_type(self) -> Optional[str]:
        return pulumi.get(self, "variant_property_type")


@pulumi.output_type
class FeatureGroupDataCatalogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupDataCatalogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupDataCatalogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupDataCatalogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: str,
                 database: str,
                 table_name: str):
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def database(self) -> str:
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        return pulumi.get(self, "table_name")


@pulumi.output_type
class FeatureGroupFeatureDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureName":
            suggest = "feature_name"
        elif key == "featureType":
            suggest = "feature_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupFeatureDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_name: str,
                 feature_type: 'FeatureGroupFeatureDefinitionFeatureType'):
        pulumi.set(__self__, "feature_name", feature_name)
        pulumi.set(__self__, "feature_type", feature_type)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> str:
        return pulumi.get(self, "feature_name")

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> 'FeatureGroupFeatureDefinitionFeatureType':
        return pulumi.get(self, "feature_type")


@pulumi.output_type
class FeatureGroupOnlineStoreSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOnlineStoreSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOnlineStoreSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOnlineStoreSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class FeatureGroupS3StorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupS3StorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupS3StorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupS3StorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str,
                 kms_key_id: Optional[str] = None):
        pulumi.set(__self__, "s3_uri", s3_uri)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class FeatureGroupTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ImageTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelBiasJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelBiasJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelBiasJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelBiasJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelBiasJobDefinitionEndpointInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param 'ModelBiasJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelBiasJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelBiasJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelBiasJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configUri":
            suggest = "config_uri"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_uri: str,
                 image_uri: str,
                 environment: Optional[Any] = None):
        """
        Container image configuration object for the monitoring job.
        :param str config_uri: The S3 URI to an analysis configuration file
        :param str image_uri: The container image to be run by the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        """
        pulumi.set(__self__, "config_uri", config_uri)
        pulumi.set(__self__, "image_uri", image_uri)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter(name="configUri")
    def config_uri(self) -> str:
        """
        The S3 URI to an analysis configuration file
        """
        return pulumi.get(self, "config_uri")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelBiasJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelBiasJobDefinitionConstraintsResource']:
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInput":
            suggest = "endpoint_input"
        elif key == "groundTruthS3Input":
            suggest = "ground_truth_s3_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_input: 'outputs.ModelBiasJobDefinitionEndpointInput',
                 ground_truth_s3_input: 'outputs.ModelBiasJobDefinitionMonitoringGroundTruthS3Input'):
        """
        The inputs for a monitoring job.
        """
        pulumi.set(__self__, "endpoint_input", endpoint_input)
        pulumi.set(__self__, "ground_truth_s3_input", ground_truth_s3_input)

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> 'outputs.ModelBiasJobDefinitionEndpointInput':
        return pulumi.get(self, "endpoint_input")

    @property
    @pulumi.getter(name="groundTruthS3Input")
    def ground_truth_s3_input(self) -> 'outputs.ModelBiasJobDefinitionMonitoringGroundTruthS3Input':
        return pulumi.get(self, "ground_truth_s3_input")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringGroundTruthS3Input(dict):
    """
    Ground truth input provided in S3 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringGroundTruthS3Input. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str):
        """
        Ground truth input provided in S3 
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelBiasJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelBiasJobDefinitionS3Output':
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelBiasJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelBiasJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelBiasJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelBiasJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelBiasJobDefinitionClusterConfig':
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelBiasJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelBiasJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelBiasJobDefinitionVpcConfig']:
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelBiasJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelBiasJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelBiasJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelBiasJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelBiasJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelBiasJobDefinitionTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelBiasJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ModelContainerDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerHostname":
            suggest = "container_hostname"
        elif key == "imageConfig":
            suggest = "image_config"
        elif key == "inferenceSpecificationName":
            suggest = "inference_specification_name"
        elif key == "modelDataUrl":
            suggest = "model_data_url"
        elif key == "modelPackageName":
            suggest = "model_package_name"
        elif key == "multiModelConfig":
            suggest = "multi_model_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_hostname: Optional[str] = None,
                 environment: Optional[Any] = None,
                 image: Optional[str] = None,
                 image_config: Optional['outputs.ModelImageConfig'] = None,
                 inference_specification_name: Optional[str] = None,
                 mode: Optional[str] = None,
                 model_data_url: Optional[str] = None,
                 model_package_name: Optional[str] = None,
                 multi_model_config: Optional['outputs.ModelMultiModelConfig'] = None):
        if container_hostname is not None:
            pulumi.set(__self__, "container_hostname", container_hostname)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if inference_specification_name is not None:
            pulumi.set(__self__, "inference_specification_name", inference_specification_name)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)
        if model_package_name is not None:
            pulumi.set(__self__, "model_package_name", model_package_name)
        if multi_model_config is not None:
            pulumi.set(__self__, "multi_model_config", multi_model_config)

    @property
    @pulumi.getter(name="containerHostname")
    def container_hostname(self) -> Optional[str]:
        return pulumi.get(self, "container_hostname")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional['outputs.ModelImageConfig']:
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter(name="inferenceSpecificationName")
    def inference_specification_name(self) -> Optional[str]:
        return pulumi.get(self, "inference_specification_name")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        return pulumi.get(self, "model_data_url")

    @property
    @pulumi.getter(name="modelPackageName")
    def model_package_name(self) -> Optional[str]:
        return pulumi.get(self, "model_package_name")

    @property
    @pulumi.getter(name="multiModelConfig")
    def multi_model_config(self) -> Optional['outputs.ModelMultiModelConfig']:
        return pulumi.get(self, "multi_model_config")


@pulumi.output_type
class ModelExplainabilityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelExplainabilityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelExplainabilityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelExplainabilityJobDefinitionEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param 'ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelExplainabilityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelExplainabilityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configUri":
            suggest = "config_uri"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_uri: str,
                 image_uri: str,
                 environment: Optional[Any] = None):
        """
        Container image configuration object for the monitoring job.
        :param str config_uri: The S3 URI to an analysis configuration file
        :param str image_uri: The container image to be run by the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        """
        pulumi.set(__self__, "config_uri", config_uri)
        pulumi.set(__self__, "image_uri", image_uri)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter(name="configUri")
    def config_uri(self) -> str:
        """
        The S3 URI to an analysis configuration file
        """
        return pulumi.get(self, "config_uri")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelExplainabilityJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelExplainabilityJobDefinitionConstraintsResource']:
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_input: 'outputs.ModelExplainabilityJobDefinitionEndpointInput'):
        """
        The inputs for a monitoring job.
        """
        pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> 'outputs.ModelExplainabilityJobDefinitionEndpointInput':
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelExplainabilityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelExplainabilityJobDefinitionS3Output':
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelExplainabilityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelExplainabilityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelExplainabilityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelExplainabilityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelExplainabilityJobDefinitionClusterConfig':
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelExplainabilityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelExplainabilityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelExplainabilityJobDefinitionVpcConfig']:
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelExplainabilityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelExplainabilityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelExplainabilityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelExplainabilityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelExplainabilityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelExplainabilityJobDefinitionTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelExplainabilityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ModelImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryAccessMode":
            suggest = "repository_access_mode"
        elif key == "repositoryAuthConfig":
            suggest = "repository_auth_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_access_mode: str,
                 repository_auth_config: Optional['outputs.ModelRepositoryAuthConfig'] = None):
        pulumi.set(__self__, "repository_access_mode", repository_access_mode)
        if repository_auth_config is not None:
            pulumi.set(__self__, "repository_auth_config", repository_auth_config)

    @property
    @pulumi.getter(name="repositoryAccessMode")
    def repository_access_mode(self) -> str:
        return pulumi.get(self, "repository_access_mode")

    @property
    @pulumi.getter(name="repositoryAuthConfig")
    def repository_auth_config(self) -> Optional['outputs.ModelRepositoryAuthConfig']:
        return pulumi.get(self, "repository_auth_config")


@pulumi.output_type
class ModelInferenceExecutionConfig(dict):
    def __init__(__self__, *,
                 mode: str):
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")


@pulumi.output_type
class ModelMultiModelConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelCacheSetting":
            suggest = "model_cache_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMultiModelConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMultiModelConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMultiModelConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_cache_setting: Optional[str] = None):
        if model_cache_setting is not None:
            pulumi.set(__self__, "model_cache_setting", model_cache_setting)

    @property
    @pulumi.getter(name="modelCacheSetting")
    def model_cache_setting(self) -> Optional[str]:
        return pulumi.get(self, "model_cache_setting")


@pulumi.output_type
class ModelPackageGroupTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelQualityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelQualityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelQualityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelQualityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelQualityJobDefinitionEndpointInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param 'ModelQualityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelQualityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelQualityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelQualityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "problemType":
            suggest = "problem_type"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 problem_type: 'ModelQualityJobDefinitionProblemType',
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 environment: Optional[Any] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "problem_type", problem_type)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="problemType")
    def problem_type(self) -> 'ModelQualityJobDefinitionProblemType':
        return pulumi.get(self, "problem_type")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelQualityJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelQualityJobDefinitionConstraintsResource']:
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInput":
            suggest = "endpoint_input"
        elif key == "groundTruthS3Input":
            suggest = "ground_truth_s3_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_input: 'outputs.ModelQualityJobDefinitionEndpointInput',
                 ground_truth_s3_input: 'outputs.ModelQualityJobDefinitionMonitoringGroundTruthS3Input'):
        """
        The inputs for a monitoring job.
        """
        pulumi.set(__self__, "endpoint_input", endpoint_input)
        pulumi.set(__self__, "ground_truth_s3_input", ground_truth_s3_input)

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> 'outputs.ModelQualityJobDefinitionEndpointInput':
        return pulumi.get(self, "endpoint_input")

    @property
    @pulumi.getter(name="groundTruthS3Input")
    def ground_truth_s3_input(self) -> 'outputs.ModelQualityJobDefinitionMonitoringGroundTruthS3Input':
        return pulumi.get(self, "ground_truth_s3_input")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringGroundTruthS3Input(dict):
    """
    Ground truth input provided in S3 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringGroundTruthS3Input. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str):
        """
        Ground truth input provided in S3 
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelQualityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelQualityJobDefinitionS3Output':
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelQualityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelQualityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelQualityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelQualityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelQualityJobDefinitionClusterConfig':
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelQualityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelQualityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelQualityJobDefinitionVpcConfig']:
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelQualityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelQualityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelQualityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelQualityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelQualityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelQualityJobDefinitionTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelQualityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ModelRepositoryAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryCredentialsProviderArn":
            suggest = "repository_credentials_provider_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelRepositoryAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelRepositoryAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelRepositoryAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_credentials_provider_arn: str):
        pulumi.set(__self__, "repository_credentials_provider_arn", repository_credentials_provider_arn)

    @property
    @pulumi.getter(name="repositoryCredentialsProviderArn")
    def repository_credentials_provider_arn(self) -> str:
        return pulumi.get(self, "repository_credentials_provider_arn")


@pulumi.output_type
class ModelTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        return pulumi.get(self, "subnets")


@pulumi.output_type
class MonitoringScheduleBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "constraintsResource":
            suggest = "constraints_resource"
        elif key == "statisticsResource":
            suggest = "statistics_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 constraints_resource: Optional['outputs.MonitoringScheduleConstraintsResource'] = None,
                 statistics_resource: Optional['outputs.MonitoringScheduleStatisticsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        """
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)
        if statistics_resource is not None:
            pulumi.set(__self__, "statistics_resource", statistics_resource)

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.MonitoringScheduleConstraintsResource']:
        return pulumi.get(self, "constraints_resource")

    @property
    @pulumi.getter(name="statisticsResource")
    def statistics_resource(self) -> Optional['outputs.MonitoringScheduleStatisticsResource']:
        return pulumi.get(self, "statistics_resource")


@pulumi.output_type
class MonitoringScheduleClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGB":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class MonitoringScheduleConfig(dict):
    """
    The configuration object that specifies the monitoring schedule and defines the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringJobDefinition":
            suggest = "monitoring_job_definition"
        elif key == "monitoringJobDefinitionName":
            suggest = "monitoring_job_definition_name"
        elif key == "monitoringType":
            suggest = "monitoring_type"
        elif key == "scheduleConfig":
            suggest = "schedule_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_job_definition: Optional['outputs.MonitoringScheduleMonitoringJobDefinition'] = None,
                 monitoring_job_definition_name: Optional[str] = None,
                 monitoring_type: Optional['MonitoringScheduleMonitoringType'] = None,
                 schedule_config: Optional['outputs.MonitoringScheduleScheduleConfig'] = None):
        """
        The configuration object that specifies the monitoring schedule and defines the monitoring job.
        :param str monitoring_job_definition_name: Name of the job definition
        """
        if monitoring_job_definition is not None:
            pulumi.set(__self__, "monitoring_job_definition", monitoring_job_definition)
        if monitoring_job_definition_name is not None:
            pulumi.set(__self__, "monitoring_job_definition_name", monitoring_job_definition_name)
        if monitoring_type is not None:
            pulumi.set(__self__, "monitoring_type", monitoring_type)
        if schedule_config is not None:
            pulumi.set(__self__, "schedule_config", schedule_config)

    @property
    @pulumi.getter(name="monitoringJobDefinition")
    def monitoring_job_definition(self) -> Optional['outputs.MonitoringScheduleMonitoringJobDefinition']:
        return pulumi.get(self, "monitoring_job_definition")

    @property
    @pulumi.getter(name="monitoringJobDefinitionName")
    def monitoring_job_definition_name(self) -> Optional[str]:
        """
        Name of the job definition
        """
        return pulumi.get(self, "monitoring_job_definition_name")

    @property
    @pulumi.getter(name="monitoringType")
    def monitoring_type(self) -> Optional['MonitoringScheduleMonitoringType']:
        return pulumi.get(self, "monitoring_type")

    @property
    @pulumi.getter(name="scheduleConfig")
    def schedule_config(self) -> Optional['outputs.MonitoringScheduleScheduleConfig']:
        return pulumi.get(self, "schedule_config")


@pulumi.output_type
class MonitoringScheduleConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class MonitoringScheduleEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 s3_data_distribution_type: Optional['MonitoringScheduleEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['MonitoringScheduleEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param 'MonitoringScheduleEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'MonitoringScheduleEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['MonitoringScheduleEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['MonitoringScheduleEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class MonitoringScheduleMonitoringAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class MonitoringScheduleMonitoringExecutionSummary(dict):
    """
    Summary of information about monitoring job
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "monitoringExecutionStatus":
            suggest = "monitoring_execution_status"
        elif key == "monitoringScheduleName":
            suggest = "monitoring_schedule_name"
        elif key == "scheduledTime":
            suggest = "scheduled_time"
        elif key == "endpointName":
            suggest = "endpoint_name"
        elif key == "failureReason":
            suggest = "failure_reason"
        elif key == "processingJobArn":
            suggest = "processing_job_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringExecutionSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringExecutionSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringExecutionSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 last_modified_time: str,
                 monitoring_execution_status: 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus',
                 monitoring_schedule_name: str,
                 scheduled_time: str,
                 endpoint_name: Optional[str] = None,
                 failure_reason: Optional[str] = None,
                 processing_job_arn: Optional[str] = None):
        """
        Summary of information about monitoring job
        :param str creation_time: The time at which the monitoring job was created.
        :param str last_modified_time: A timestamp that indicates the last time the monitoring job was modified.
        :param 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus' monitoring_execution_status: The status of the monitoring job.
        :param str scheduled_time: The time the monitoring job was scheduled.
        :param str failure_reason: Contains the reason a monitoring job failed, if it failed.
        :param str processing_job_arn: The Amazon Resource Name (ARN) of the monitoring job.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "monitoring_execution_status", monitoring_execution_status)
        pulumi.set(__self__, "monitoring_schedule_name", monitoring_schedule_name)
        pulumi.set(__self__, "scheduled_time", scheduled_time)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if processing_job_arn is not None:
            pulumi.set(__self__, "processing_job_arn", processing_job_arn)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The time at which the monitoring job was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        A timestamp that indicates the last time the monitoring job was modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="monitoringExecutionStatus")
    def monitoring_execution_status(self) -> 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus':
        """
        The status of the monitoring job.
        """
        return pulumi.get(self, "monitoring_execution_status")

    @property
    @pulumi.getter(name="monitoringScheduleName")
    def monitoring_schedule_name(self) -> str:
        return pulumi.get(self, "monitoring_schedule_name")

    @property
    @pulumi.getter(name="scheduledTime")
    def scheduled_time(self) -> str:
        """
        The time the monitoring job was scheduled.
        """
        return pulumi.get(self, "scheduled_time")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[str]:
        """
        Contains the reason a monitoring job failed, if it failed.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="processingJobArn")
    def processing_job_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the monitoring job.
        """
        return pulumi.get(self, "processing_job_arn")


@pulumi.output_type
class MonitoringScheduleMonitoringInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_input: 'outputs.MonitoringScheduleEndpointInput'):
        """
        The inputs for a monitoring job.
        """
        pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> 'outputs.MonitoringScheduleEndpointInput':
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class MonitoringScheduleMonitoringJobDefinition(dict):
    """
    Defines the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringAppSpecification":
            suggest = "monitoring_app_specification"
        elif key == "monitoringInputs":
            suggest = "monitoring_inputs"
        elif key == "monitoringOutputConfig":
            suggest = "monitoring_output_config"
        elif key == "monitoringResources":
            suggest = "monitoring_resources"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "baselineConfig":
            suggest = "baseline_config"
        elif key == "networkConfig":
            suggest = "network_config"
        elif key == "stoppingCondition":
            suggest = "stopping_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringJobDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringJobDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringJobDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_app_specification: 'outputs.MonitoringScheduleMonitoringAppSpecification',
                 monitoring_inputs: Sequence['outputs.MonitoringScheduleMonitoringInput'],
                 monitoring_output_config: 'outputs.MonitoringScheduleMonitoringOutputConfig',
                 monitoring_resources: 'outputs.MonitoringScheduleMonitoringResources',
                 role_arn: str,
                 baseline_config: Optional['outputs.MonitoringScheduleBaselineConfig'] = None,
                 environment: Optional[Any] = None,
                 network_config: Optional['outputs.MonitoringScheduleNetworkConfig'] = None,
                 stopping_condition: Optional['outputs.MonitoringScheduleStoppingCondition'] = None):
        """
        Defines the monitoring job.
        :param str role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param Any environment: Sets the environment variables in the Docker container
        """
        pulumi.set(__self__, "monitoring_app_specification", monitoring_app_specification)
        pulumi.set(__self__, "monitoring_inputs", monitoring_inputs)
        pulumi.set(__self__, "monitoring_output_config", monitoring_output_config)
        pulumi.set(__self__, "monitoring_resources", monitoring_resources)
        pulumi.set(__self__, "role_arn", role_arn)
        if baseline_config is not None:
            pulumi.set(__self__, "baseline_config", baseline_config)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if stopping_condition is not None:
            pulumi.set(__self__, "stopping_condition", stopping_condition)

    @property
    @pulumi.getter(name="monitoringAppSpecification")
    def monitoring_app_specification(self) -> 'outputs.MonitoringScheduleMonitoringAppSpecification':
        return pulumi.get(self, "monitoring_app_specification")

    @property
    @pulumi.getter(name="monitoringInputs")
    def monitoring_inputs(self) -> Sequence['outputs.MonitoringScheduleMonitoringInput']:
        return pulumi.get(self, "monitoring_inputs")

    @property
    @pulumi.getter(name="monitoringOutputConfig")
    def monitoring_output_config(self) -> 'outputs.MonitoringScheduleMonitoringOutputConfig':
        return pulumi.get(self, "monitoring_output_config")

    @property
    @pulumi.getter(name="monitoringResources")
    def monitoring_resources(self) -> 'outputs.MonitoringScheduleMonitoringResources':
        return pulumi.get(self, "monitoring_resources")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="baselineConfig")
    def baseline_config(self) -> Optional['outputs.MonitoringScheduleBaselineConfig']:
        return pulumi.get(self, "baseline_config")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional['outputs.MonitoringScheduleNetworkConfig']:
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="stoppingCondition")
    def stopping_condition(self) -> Optional['outputs.MonitoringScheduleStoppingCondition']:
        return pulumi.get(self, "stopping_condition")


@pulumi.output_type
class MonitoringScheduleMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.MonitoringScheduleS3Output'):
        """
        The output object for a monitoring job.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.MonitoringScheduleS3Output':
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class MonitoringScheduleMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.MonitoringScheduleMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['MonitoringScheduleMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.MonitoringScheduleMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class MonitoringScheduleMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.MonitoringScheduleClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.MonitoringScheduleClusterConfig':
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class MonitoringScheduleNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.MonitoringScheduleVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.MonitoringScheduleVpcConfig']:
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class MonitoringScheduleS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['MonitoringScheduleS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'MonitoringScheduleS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['MonitoringScheduleS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class MonitoringScheduleScheduleConfig(dict):
    """
    Configuration details about the monitoring schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleScheduleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleScheduleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleScheduleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str):
        """
        Configuration details about the monitoring schedule.
        :param str schedule_expression: A cron expression that describes details about the monitoring schedule.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        """
        A cron expression that describes details about the monitoring schedule.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class MonitoringScheduleStatisticsResource(dict):
    """
    The baseline statistics resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleStatisticsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleStatisticsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleStatisticsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline statistics resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class MonitoringScheduleStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class MonitoringScheduleTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MonitoringScheduleVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class NotebookInstanceLifecycleConfigNotebookInstanceLifecycleHook(dict):
    def __init__(__self__, *,
                 content: Optional[str] = None):
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        return pulumi.get(self, "content")


@pulumi.output_type
class NotebookInstanceTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class OfflineStoreConfigProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3StorageConfig":
            suggest = "s3_storage_config"
        elif key == "dataCatalogConfig":
            suggest = "data_catalog_config"
        elif key == "disableGlueTableCreation":
            suggest = "disable_glue_table_creation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfflineStoreConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfflineStoreConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfflineStoreConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_storage_config: 'outputs.FeatureGroupS3StorageConfig',
                 data_catalog_config: Optional['outputs.FeatureGroupDataCatalogConfig'] = None,
                 disable_glue_table_creation: Optional[bool] = None):
        pulumi.set(__self__, "s3_storage_config", s3_storage_config)
        if data_catalog_config is not None:
            pulumi.set(__self__, "data_catalog_config", data_catalog_config)
        if disable_glue_table_creation is not None:
            pulumi.set(__self__, "disable_glue_table_creation", disable_glue_table_creation)

    @property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> 'outputs.FeatureGroupS3StorageConfig':
        return pulumi.get(self, "s3_storage_config")

    @property
    @pulumi.getter(name="dataCatalogConfig")
    def data_catalog_config(self) -> Optional['outputs.FeatureGroupDataCatalogConfig']:
        return pulumi.get(self, "data_catalog_config")

    @property
    @pulumi.getter(name="disableGlueTableCreation")
    def disable_glue_table_creation(self) -> Optional[bool]:
        return pulumi.get(self, "disable_glue_table_creation")


@pulumi.output_type
class OnlineStoreConfigProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOnlineStore":
            suggest = "enable_online_store"
        elif key == "securityConfig":
            suggest = "security_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineStoreConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineStoreConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineStoreConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_online_store: Optional[bool] = None,
                 security_config: Optional['outputs.FeatureGroupOnlineStoreSecurityConfig'] = None):
        if enable_online_store is not None:
            pulumi.set(__self__, "enable_online_store", enable_online_store)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)

    @property
    @pulumi.getter(name="enableOnlineStore")
    def enable_online_store(self) -> Optional[bool]:
        return pulumi.get(self, "enable_online_store")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.FeatureGroupOnlineStoreSecurityConfig']:
        return pulumi.get(self, "security_config")


@pulumi.output_type
class ParallelismConfigurationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelExecutionSteps":
            suggest = "max_parallel_execution_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParallelismConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParallelismConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParallelismConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_parallel_execution_steps: int):
        """
        :param int max_parallel_execution_steps: Maximum parallel execution steps
        """
        pulumi.set(__self__, "max_parallel_execution_steps", max_parallel_execution_steps)

    @property
    @pulumi.getter(name="maxParallelExecutionSteps")
    def max_parallel_execution_steps(self) -> int:
        """
        Maximum parallel execution steps
        """
        return pulumi.get(self, "max_parallel_execution_steps")


@pulumi.output_type
class PipelineTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectProvisioningParameter(dict):
    """
    Information about a parameter used to provision a product.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Information about a parameter used to provision a product.
        :param str key: The parameter key.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The parameter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceCatalogProvisionedProductDetailsProperties(dict):
    """
    Provisioned ServiceCatalog  Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedProductId":
            suggest = "provisioned_product_id"
        elif key == "provisionedProductStatusMessage":
            suggest = "provisioned_product_status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCatalogProvisionedProductDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCatalogProvisionedProductDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCatalogProvisionedProductDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_product_id: Optional[str] = None,
                 provisioned_product_status_message: Optional[str] = None):
        """
        Provisioned ServiceCatalog  Details
        """
        if provisioned_product_id is not None:
            pulumi.set(__self__, "provisioned_product_id", provisioned_product_id)
        if provisioned_product_status_message is not None:
            pulumi.set(__self__, "provisioned_product_status_message", provisioned_product_status_message)

    @property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> Optional[str]:
        return pulumi.get(self, "provisioned_product_id")

    @property
    @pulumi.getter(name="provisionedProductStatusMessage")
    def provisioned_product_status_message(self) -> Optional[str]:
        return pulumi.get(self, "provisioned_product_status_message")


@pulumi.output_type
class ServiceCatalogProvisioningDetailsProperties(dict):
    """
    Input ServiceCatalog Provisioning Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productId":
            suggest = "product_id"
        elif key == "pathId":
            suggest = "path_id"
        elif key == "provisioningArtifactId":
            suggest = "provisioning_artifact_id"
        elif key == "provisioningParameters":
            suggest = "provisioning_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCatalogProvisioningDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCatalogProvisioningDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCatalogProvisioningDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 product_id: str,
                 path_id: Optional[str] = None,
                 provisioning_artifact_id: Optional[str] = None,
                 provisioning_parameters: Optional[Sequence['outputs.ProjectProvisioningParameter']] = None):
        """
        Input ServiceCatalog Provisioning Details
        :param Sequence['ProjectProvisioningParameter'] provisioning_parameters: Parameters specified by the administrator that are required for provisioning the product.
        """
        pulumi.set(__self__, "product_id", product_id)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if provisioning_artifact_id is not None:
            pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        if provisioning_parameters is not None:
            pulumi.set(__self__, "provisioning_parameters", provisioning_parameters)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> str:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[str]:
        return pulumi.get(self, "path_id")

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> Optional[str]:
        return pulumi.get(self, "provisioning_artifact_id")

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> Optional[Sequence['outputs.ProjectProvisioningParameter']]:
        """
        Parameters specified by the administrator that are required for provisioning the product.
        """
        return pulumi.get(self, "provisioning_parameters")


@pulumi.output_type
class UserProfileCustomImage(dict):
    """
    A custom SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        A custom SageMaker image.
        :param str app_image_config_name: The Name of the AppImageConfig.
        :param str image_name: The name of the CustomImage. Must be unique to your account.
        :param int image_version_number: The version number of the CustomImage.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the CustomImage. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the CustomImage.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class UserProfileJupyterServerAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None):
        """
        The JupyterServer app settings.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class UserProfileKernelGatewayAppSettings(dict):
    """
    The kernel gateway app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.UserProfileCustomImage']] = None,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None):
        """
        The kernel gateway app settings.
        :param Sequence['UserProfileCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'UserProfileResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.UserProfileCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class UserProfileResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['UserProfileResourceSpecInstanceType'] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'UserProfileResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['UserProfileResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class UserProfileSharingSettings(dict):
    """
    Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional['UserProfileSharingSettingsNotebookOutputOption'] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
        :param 'UserProfileSharingSettingsNotebookOutputOption' notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        :param str s3_kms_key_id: When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional['UserProfileSharingSettingsNotebookOutputOption']:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class UserProfileTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class UserProfileUserSettings(dict):
    """
    A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: Optional[str] = None,
                 jupyter_server_app_settings: Optional['outputs.UserProfileJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.UserProfileKernelGatewayAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.UserProfileSharingSettings'] = None):
        """
        A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
        :param str execution_role: The user profile Amazon Resource Name (ARN).
        :param 'UserProfileJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'UserProfileKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param Sequence[str] security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param 'UserProfileSharingSettings' sharing_settings: The sharing settings.
        """
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[str]:
        """
        The user profile Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.UserProfileJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.UserProfileKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.UserProfileSharingSettings']:
        """
        The sharing settings.
        """
        return pulumi.get(self, "sharing_settings")


@pulumi.output_type
class WorkteamCognitoMemberDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cognitoClientId":
            suggest = "cognito_client_id"
        elif key == "cognitoUserGroup":
            suggest = "cognito_user_group"
        elif key == "cognitoUserPool":
            suggest = "cognito_user_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkteamCognitoMemberDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkteamCognitoMemberDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkteamCognitoMemberDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cognito_client_id: str,
                 cognito_user_group: str,
                 cognito_user_pool: str):
        pulumi.set(__self__, "cognito_client_id", cognito_client_id)
        pulumi.set(__self__, "cognito_user_group", cognito_user_group)
        pulumi.set(__self__, "cognito_user_pool", cognito_user_pool)

    @property
    @pulumi.getter(name="cognitoClientId")
    def cognito_client_id(self) -> str:
        return pulumi.get(self, "cognito_client_id")

    @property
    @pulumi.getter(name="cognitoUserGroup")
    def cognito_user_group(self) -> str:
        return pulumi.get(self, "cognito_user_group")

    @property
    @pulumi.getter(name="cognitoUserPool")
    def cognito_user_pool(self) -> str:
        return pulumi.get(self, "cognito_user_pool")


@pulumi.output_type
class WorkteamMemberDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cognitoMemberDefinition":
            suggest = "cognito_member_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkteamMemberDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkteamMemberDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkteamMemberDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cognito_member_definition: 'outputs.WorkteamCognitoMemberDefinition'):
        pulumi.set(__self__, "cognito_member_definition", cognito_member_definition)

    @property
    @pulumi.getter(name="cognitoMemberDefinition")
    def cognito_member_definition(self) -> 'outputs.WorkteamCognitoMemberDefinition':
        return pulumi.get(self, "cognito_member_definition")


@pulumi.output_type
class WorkteamNotificationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationTopicArn":
            suggest = "notification_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkteamNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkteamNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkteamNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notification_topic_arn: str):
        pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)

    @property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> str:
        return pulumi.get(self, "notification_topic_arn")


@pulumi.output_type
class WorkteamTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


