# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetMethodResult',
    'AwaitableGetMethodResult',
    'get_method',
    'get_method_output',
]

@pulumi.output_type
class GetMethodResult:
    def __init__(__self__, api_key_required=None, authorization_scopes=None, authorization_type=None, authorizer_id=None, integration=None, method_responses=None, operation_name=None, request_models=None, request_parameters=None, request_validator_id=None):
        if api_key_required and not isinstance(api_key_required, bool):
            raise TypeError("Expected argument 'api_key_required' to be a bool")
        pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_scopes and not isinstance(authorization_scopes, list):
            raise TypeError("Expected argument 'authorization_scopes' to be a list")
        pulumi.set(__self__, "authorization_scopes", authorization_scopes)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if authorizer_id and not isinstance(authorizer_id, str):
            raise TypeError("Expected argument 'authorizer_id' to be a str")
        pulumi.set(__self__, "authorizer_id", authorizer_id)
        if integration and not isinstance(integration, dict):
            raise TypeError("Expected argument 'integration' to be a dict")
        pulumi.set(__self__, "integration", integration)
        if method_responses and not isinstance(method_responses, list):
            raise TypeError("Expected argument 'method_responses' to be a list")
        pulumi.set(__self__, "method_responses", method_responses)
        if operation_name and not isinstance(operation_name, str):
            raise TypeError("Expected argument 'operation_name' to be a str")
        pulumi.set(__self__, "operation_name", operation_name)
        if request_models and not isinstance(request_models, dict):
            raise TypeError("Expected argument 'request_models' to be a dict")
        pulumi.set(__self__, "request_models", request_models)
        if request_parameters and not isinstance(request_parameters, dict):
            raise TypeError("Expected argument 'request_parameters' to be a dict")
        pulumi.set(__self__, "request_parameters", request_parameters)
        if request_validator_id and not isinstance(request_validator_id, str):
            raise TypeError("Expected argument 'request_validator_id' to be a str")
        pulumi.set(__self__, "request_validator_id", request_validator_id)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[bool]:
        """
        Indicates whether the method requires clients to submit a valid API key.
        """
        return pulumi.get(self, "api_key_required")

    @property
    @pulumi.getter(name="authorizationScopes")
    def authorization_scopes(self) -> Optional[Sequence[str]]:
        """
        A list of authorization scopes configured on the method.
        """
        return pulumi.get(self, "authorization_scopes")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional['MethodAuthorizationType']:
        """
        The method's authorization type.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        The identifier of the authorizer to use on this method.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter
    def integration(self) -> Optional['outputs.MethodIntegration']:
        """
        The backend system that the method calls when it receives a request.
        """
        return pulumi.get(self, "integration")

    @property
    @pulumi.getter(name="methodResponses")
    def method_responses(self) -> Optional[Sequence['outputs.MethodResponse']]:
        """
        The responses that can be sent to the client who calls the method.
        """
        return pulumi.get(self, "method_responses")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        A friendly operation name for the method.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="requestModels")
    def request_models(self) -> Optional[Any]:
        """
        The resources that are used for the request's content type. Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a Model resource name as the value.
        """
        return pulumi.get(self, "request_models")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[Any]:
        """
        The request parameters that API Gateway accepts. Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestValidatorId")
    def request_validator_id(self) -> Optional[str]:
        """
        The ID of the associated request validator.
        """
        return pulumi.get(self, "request_validator_id")


class AwaitableGetMethodResult(GetMethodResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMethodResult(
            api_key_required=self.api_key_required,
            authorization_scopes=self.authorization_scopes,
            authorization_type=self.authorization_type,
            authorizer_id=self.authorizer_id,
            integration=self.integration,
            method_responses=self.method_responses,
            operation_name=self.operation_name,
            request_models=self.request_models,
            request_parameters=self.request_parameters,
            request_validator_id=self.request_validator_id)


def get_method(http_method: Optional[str] = None,
               resource_id: Optional[str] = None,
               rest_api_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMethodResult:
    """
    Resource Type definition for AWS::ApiGateway::Method


    :param str http_method: The backend system that the method calls when it receives a request.
    :param str resource_id: The ID of an API Gateway resource.
    :param str rest_api_id: The ID of the RestApi resource in which API Gateway creates the method.
    """
    __args__ = dict()
    __args__['httpMethod'] = http_method
    __args__['resourceId'] = resource_id
    __args__['restApiId'] = rest_api_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getMethod', __args__, opts=opts, typ=GetMethodResult).value

    return AwaitableGetMethodResult(
        api_key_required=__ret__.api_key_required,
        authorization_scopes=__ret__.authorization_scopes,
        authorization_type=__ret__.authorization_type,
        authorizer_id=__ret__.authorizer_id,
        integration=__ret__.integration,
        method_responses=__ret__.method_responses,
        operation_name=__ret__.operation_name,
        request_models=__ret__.request_models,
        request_parameters=__ret__.request_parameters,
        request_validator_id=__ret__.request_validator_id)


@_utilities.lift_output_func(get_method)
def get_method_output(http_method: Optional[pulumi.Input[str]] = None,
                      resource_id: Optional[pulumi.Input[str]] = None,
                      rest_api_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMethodResult]:
    """
    Resource Type definition for AWS::ApiGateway::Method


    :param str http_method: The backend system that the method calls when it receives a request.
    :param str resource_id: The ID of an API Gateway resource.
    :param str rest_api_id: The ID of the RestApi resource in which API Gateway creates the method.
    """
    ...
