"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const sdk_v2_to_v3_adapter_1 = require("@aws-cdk/sdk-v2-to-v3-adapter");
const utils_1 = require("./utils");
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        const apiCall = new sdk_v2_to_v3_adapter_1.ApiCall(request.service, request.api);
        const parameters = request.parameters ? (0, utils_1.decodeParameters)(request.parameters) : {};
        console.log(`SDK request to ${apiCall.service}.${apiCall.action} with parameters ${JSON.stringify(parameters)}`);
        const response = await apiCall.invoke({ parameters });
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.$metadata;
        let resp;
        if (request.outputPaths || request.flattenResponse === 'true') {
            // Flatten and explode JSON fields
            const flattened = (0, sdk_v2_to_v3_adapter_1.flatten)((0, utils_1.deepParseJson)({ apiCallResponse: response }));
            resp = request.outputPaths ? filterKeys(flattened, request.outputPaths) : flattened;
        }
        else {
            // Otherwise just return the response as-is, without exploding JSON fields
            resp = { apiCallResponse: response };
        }
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
function filterKeys(object, searchStrings) {
    return Object.entries(object).reduce((filteredObject, [key, value]) => {
        for (const searchString of searchStrings) {
            if (key.startsWith(`apiCallResponse.${searchString}`)) {
                filteredObject[key] = value;
            }
        }
        return filteredObject;
    }, {});
}
//# sourceMappingURL=data:application/json;base64,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