"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHandler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const node_fetch_1 = require("node-fetch");
// TODO: can use builtin fetch on node18
const base_1 = require("./base");
class HttpHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        console.log('request', request);
        const response = await (0, node_fetch_1.default)(request.parameters.url, request.parameters.fetchOptions);
        const result = {
            ok: response.ok,
            status: response.status,
            statusText: response.statusText,
            headers: response.headers.raw(),
        };
        result.body = await response.text();
        try {
            result.body = JSON.parse(result.body);
        }
        catch (e) {
            // Okay
        }
        return {
            apiCallResponse: result,
        };
    }
}
exports.HttpHandler = HttpHandler;
//# sourceMappingURL=data:application/json;base64,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