import { Stack } from 'aws-cdk-lib/core';
import { Construct, IConstruct } from 'constructs';
import { IApiCall } from '../api-call-base';
import { ActualResult, ExpectedResult } from '../common';
import { FetchOptions } from '../providers';
import { LambdaInvokeFunctionProps } from '../sdk';
import { IDeployAssert } from '../types';
/**
 * Options for DeployAssert
 */
export interface DeployAssertProps {
    /**
     * A stack to use for assertions
     *
     * @default - a stack is created for you
     */
    readonly stack?: Stack;
}
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
export declare class DeployAssert extends Construct implements IDeployAssert {
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x: any): x is DeployAssert;
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct: IConstruct): DeployAssert;
    scope: Stack;
    private assertionIdCounts;
    constructor(scope: Construct, props?: DeployAssertProps);
    awsApiCall(service: string, api: string, parameters?: any, outputPaths?: string[]): IApiCall;
    httpApiCall(url: string, options?: FetchOptions): IApiCall;
    invokeFunction(props: LambdaInvokeFunctionProps): IApiCall;
    expect(id: string, expected: ExpectedResult, actual: ActualResult): void;
    /**
     * Gets a unique logical id based on a proposed assertion id.
     */
    private uniqueAssertionId;
}
