"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const providers_1 = require("./providers");
const waiter_state_machine_1 = require("./waiter-state-machine");
/**
 * Construct that creates a custom resource that will perform
 * an HTTP API Call
 */
class HttpApiCall extends api_call_base_1.ApiCallBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_HttpCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApiCall);
            }
            throw error;
        }
        let name = '';
        if (!aws_cdk_lib_1.Token.isUnresolved(props.url)) {
            const url = new URL(props.url);
            name = `${url.hostname}${url.pathname}`.replace(/\/|\.|:/g, '');
        }
        this.provider = new providers_1.AssertionsProvider(this, 'HttpProvider');
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                parameters: props,
                expected: aws_cdk_lib_1.Lazy.any({ produce: () => this.expectedResult }),
                stateMachineArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.stateMachineArn }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.HTTP_RESOURCE_TYPE}${name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof HttpApiCall) {
                    if (node.expectedResult) {
                        const result = node.apiCallResource.getAttString('assertion');
                        new aws_cdk_lib_1.CfnOutput(node, 'AssertionResults', {
                            value: result,
                        }).overrideLogicalId(`AssertionResults${id}`);
                    }
                }
            },
        });
    }
    assertAtPath(_path, _expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(_expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        return this;
    }
    waitForAssertions(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_WaiterStateMachineOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.waitForAssertions);
            }
            throw error;
        }
        const waiter = new waiter_state_machine_1.WaiterStateMachine(this, 'WaitFor', {
            ...options,
        });
        this.stateMachineArn = waiter.stateMachineArn;
        this.provider.addPolicyStatementFromSdkCall('states', 'StartExecution');
        return this;
    }
    ;
}
exports.HttpApiCall = HttpApiCall;
_a = JSII_RTTI_SYMBOL_1;
HttpApiCall[_a] = { fqn: "@aws-cdk/integ-tests-alpha.HttpApiCall", version: "2.132.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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