"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
exports.ActualResult = ActualResult;
_a = JSII_RTTI_SYMBOL_1;
ActualResult[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ActualResult", version: "2.132.0-alpha.0" };
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     * });
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
exports.ExpectedResult = ExpectedResult;
_b = JSII_RTTI_SYMBOL_1;
ExpectedResult[_b] = { fqn: "@aws-cdk/integ-tests-alpha.ExpectedResult", version: "2.132.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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