![Logo](./assets/GB-small-logo.png)

## GB Python Modules

This repository contains the python modules that have been developed by GB to facilitate our internal scripting and data standardisation.

Please see the individual sections below for their definitions.

#### common.py

This contains modules that provide the standardised directory paths for a versioned dataset (e.g. PDB for 2021.1) on MARRS workspace.
This was developed for the gb-marrs user.
There are 4 possible modules, one for each directory type:

- download
- work
- rdf
- sql

This also contains standardised rdf/sparql PREFIXES for some MARRS graphs.
This set of Graph PREFIXES is incomplete and will be consolidated to one place in the future.

e.g.

- CHEMBL_DATA = Namespace ("http://generalbioinformatics.com/data/chembl#")
- CHEMBL_VOC = Namespace ("http://generalbioinformatics.com/ontologies/chembl#")

---

#### miriamRegex.py

Contains a python dictionary of identifiers.org regular expressions to validate public ids.
Note: We sometimes apply stronger standards than identifiers.org - for example on case sensitivity.
These bespoke changes are documented in this module.

e.g. miriamPattern["pdb"] = "\^[0-9][a-z0-9]{3}$" # changed from \^[0-9][A-Za-z0-9]{3}$, must be caps for integration

This requires regular updates to maintain concordance with the public repository.

---

#### namespaces.py

This is a set of shorthands for RDF namespaces for both public datasets and internal datasets.

e.g.

- idTaxonomy = Namespace("http://identifiers.org/taxonomy/")
- GBID_CPSD_GENE = Namespace("http://generalbioinformatics.com/identifiers/cpsd/gene/")

---

#### project_graph_modules.py

This module contains functions for extracting and manipulating data from MARRS

##### general functions for data manipulation

|*FUNCTION*|*INPUTS*|*DESCRIPTION*|
|----|----|----|
| **chunks** | l,n | Yield successive n-sized chunks from l. |
| **remove_namespace** | string | remove namespaces from string |
| **df2file** | outfolder, outfilename, df, separator='\t' | prints a dataframe to a tab seperated text file in folder of choice. |
| **df_from_file** | file_path, sep='\t', header=0 | reads a file into a pandas dataframe |
| **dflist_from_folder** | file_list, folder_path | reads a designated list of files from a designated folder into a list of dataframes |
| **collapse_columns** | df, groupby, col_list, separator=';' | collapses values in column list into lists grouped by groupby and separated with ';' and returns the reformatted dataframe |
| **prefix_column_names** | prefix, dataframe, skip=[""] | add a prefix to the column names of a datframe, skipping any as required. |

##### functions for querying the marrs graphql api

> When config is required in the input this refers to a json configuration file with ceres graphql credentials.  As generated by the CAMM tools [graphql_generate_config] (https://gitlab.generalbioinformatics.com/mushroom/camm_tools#graphql_generate_config) tool.
> For example:
> 
> ```
{
    "username": "t123456",
    "graphql": "http://ceres-staging.app.intra/graphql",
    "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyIjp7InVzZXJuYW1lIjoiQ290dGFtIEVsZWFub3IgR0JKSDp0ODQwOTczIiwiZGlzcGxheU5hbWUiOiJFbGVhbm9yIn0sImlhdCI6MTYyMDg5MjMzMiwiZXhwIjoxNjUyNDI4MzMyfQ.w9iZQ9zS0Br3xK_INQwEAC6FRmFvczSSz9MvyM7Ejag"
}
```
> 


|*FUNCTION*|*INPUTS*|*DESCRIPTION*|
|----|----|----|
|**run_ceres_query**|query, config, query_name, input_list, limit=500, offset=0, chunk_size=100, debug=False, taxon=None, List=True|Runs a list of identifier inputs through a query against the ceres api. The chunk_size determines how many identifiers are run in a single query. Use chunk_size=1 and List=False to run a query formatted for a single id. The result data are then flattened into a dataframe. The query_name is used solely for logging progress.|
|**check_graphql_config**|config_file|Submits a simple graphql request to validate that the graphql server is up and running and that the configuration is valid.|
|**get_graphql_template**|query|Returns a string object containing the templated graphql query. Using the input list of identifiers a graphql template is filled in.|
|**run_graphql_query**|query, variables, config|runs a formatted query with variables against a graphql endpoint specified in the config file. The function makes 3 attempts at running the query before terminating.|
|**flatten_json**|data, parent_result_list=None, parent_key=None|Returns a list of dictionaries. This function will recursively search through a nested dictionary object flattening out the results so that they can be converted into a pandas dataframe.|
|**recursive_key_count**|data|Yields the length of all lists in a nested dictionary type structure. Used for checking that the length of lists does not exceed the predefined limit.|
|**check_graphql_json**|json_data, limit|identifies is any results have the same number of results as the query limit, which could indicate missing data|
|**psql_query**|query, config|connect and query MARRS PSQL|

##### common MARRS extraction functions

|*FUNCTION*|*INPUTS*|*DESCRIPTION*|
|----|----|----|
|**getNamespace**|gene,sparql|This returns a full identifiers.org URI for an Ensembl id given just the base ID as input|
|**getTaxon**|geneurl, sparql|return the scientific organism name for a complete gene identifier url|
|**peptideExtraction**|ncbi_taxon, sparql|extracts all ensembl peptides for a taxon that are found in ensembl|
|**geneExtraction**|taxon, sparql|extracts all ensembl genes and peptides for a CPSD taxon that are found in ensembl|
|**enzymeExtraction**|sparql|extracts all enzyme identifier accessions from MARRS|

##### functions required for the project ETLs

|*FUNCTION*|*INPUTS*|*DESCRIPTION*|
|----|----|----|
|**getOrths**|input_list, target_taxon_list, config, limit = 1000, offset = 0, chunk_size=100|retreive homologs from ceres for Ensembl genes and a target species taxon id.|
|**pchemblactive**|input_list, config, limit = 500, offset = 0, chunk_size=100|returns genes with an entry in ChEMBL with a pChembl >= 6|
|**biomartwget**|query, taxon, categorisation, namespace|Convert a list of ids from a biomart query into a set of data for lead generation|
|**dartable_genome_check**|gene_list, sparql|finds genes within the Dartable Genome|
|**dartGen**|HsEns, sparql|Returns a boolean of whether a human gene is in the Dartable Genome|
|**golistDm**|golistName, sparql, taxon|return list of Dm genes annotated with GO from named list of GOs|
|**pdbDirect**|geneList, sparql|return direct hit from pdb|
|**annotatePDB**|graph, protein_dict, minId, minCov, sparql, namespace|Returns PDB relate data (number of blast hits with specific %identity and %coverage) for a protein dictionary|


##### Not in use

|*FUNCTION*|*INPUTS*|*DESCRIPTION*|
|----|----|----|
|**getOrths_ensembl**|genes, taxons, config|return Ensembl orthologs from MARRS PSQL for an input list of Ensembl genes and a target cpsd taxon id.  Will NOT return paralogs|
|**ensemblCheckFailure**|gene, server|For debug purposes - If an ID is not returning values from the Ensembl API, this returns the reason why.|


---

#### rdfstream.py

This module coordinates the writing of an RDF file in nt format.
It works via a tmp file until complete and will gzip the final output.

This contains basic Quality control functions and will soon be deprecated for
a module with more vigorous testing functions.

Example usage:

`from rdfstream import NtWriter with NtWriter (rdf_outfile) as nt: nt.printLiteral(subjectURI, Predicate, "A string" nt.printStatement(subjectURI, Predicate, objectURI)`

---

#### rdfWriterValidated.py

WIP: this is currently not deployed but will soon be the default.

_This module coordinates the writing of an RDF file in nt format.
It works via a tmp file until complete and will gzip the final output._

_By using this module, we are enforcing essential Quality checks.
In order to achieve this, there are non-optional input variables (outlined below)_

---

#### util.py

Contains functions for the following tasks:

- checking all URIs are RDF safe and valid
- checking RDF classes and predicates are defined in shapes
- checking URI identifiers match the identifiers.org regex for the assigned namespace

---

### Contributers

See the CODEOWNERS file for a list of code owners who can review and accept a PR.

### Maintainers

- Accept a PR (merge request)
- Pull down the merged code
- Change the version number in setup.py
- Update the CHANGELOG with details of changes
- Tag the commit:
  `git tag v1.1.4`
- Push these changes back to the repo with a commit message similar to the following:
  `git commit -m "feat(1.1.4): added FLG method helpers"`
- Add the tagged commmit to git:
  `git push origin v1.1.4`
- In gitlab CICD/Pipelines find the new commit (should be at the top) and click the play button to push the new version to PYPY. If you go to CICD/Jobs you should find a 'PASSED' status. If you click on this, in the terminal output at the bottom you will find a link to the new version on PYPY:
  `View at: https://pypi.org/project/gbmarrsmodules/0.1.5/ Job suceeded`
