from dataclasses import dataclass, field
from typing import Optional
from sdk.models import shared


@dataclass
class GeneratePostmanCollectionPathParams:
    api_id: str = field(metadata={'path_param': { 'field_name': 'apiID', 'style': 'simple', 'explode': False }})
    version_id: str = field(metadata={'path_param': { 'field_name': 'versionID', 'style': 'simple', 'explode': False }})
    

@dataclass
class GeneratePostmanCollectionRequest:
    path_params: GeneratePostmanCollectionPathParams = field()
    

@dataclass
class GeneratePostmanCollectionResponse:
    content_type: str = field()
    status_code: int = field()
    error: Optional[shared.Error] = field(default=None)
    postman_collection: Optional[bytes] = field(default=None)
    
