"""
This class does not do anything useful at runtime. Its only purpose is to provide type annotations.
Since sphinx does not support .pyi files (yet?), this is a .py file.
"""

from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:

    from typing import Iterable, List, Optional

    from silaservice_types import GetFeatureDefinition_Responses, SetServerName_Responses

    from sila2.client import ClientMetadataInstance, ClientUnobservableProperty


class SiLAServiceClient:
    """
    This Feature MUST be implemented by each SiLA Server.

    It specifies Commands and Properties to discover the Features a SiLA Server implements as well as details
    about the SiLA Server, like name, type, description, vendor and UUID.

    Any interaction described in this feature MUST not affect the behaviour of any other Feature.
    """

    ServerName: ClientUnobservableProperty[str]
    """
    Human readable name of the SiLA Server. The name can be set using the 'Set Server Name' command.
    """

    ServerType: ClientUnobservableProperty[str]
    """
    The type of this server. It, could be, e.g., in the case of a SiLA Device the model name.
      It is specified by the implementer of the SiLA Server and MAY not be unique.
    """

    ServerUUID: ClientUnobservableProperty[str]
    """
    Globally unique identifier that identifies a SiLA Server. The Server UUID MUST be generated once
      and remain the same for all times.
    """

    ServerDescription: ClientUnobservableProperty[str]
    """
    Description of the SiLA Server. This should include the use and purpose of this SiLA Server.
    """

    ServerVersion: ClientUnobservableProperty[str]
    """
    Returns the version of the SiLA Server. A "Major" and a "Minor" version number (e.g. 1.0) MUST be provided,
      a Patch version number MAY be provided. Optionally, an arbitrary text, separated by an underscore MAY be
      appended, e.g. “3.19.373_mighty_lab_devices”.
    """

    ServerVendorURL: ClientUnobservableProperty[str]
    """
    Returns the URL to the website of the vendor or the website of the product of this SiLA Server.
      This URL SHOULD be accessible at all times.
      The URL is a Uniform Resource Locator as defined in RFC 1738.
    """

    ImplementedFeatures: ClientUnobservableProperty[List[str]]
    """
    Returns a list of fully qualified Feature identifiers of all implemented Features of this SiLA Server.
      This list SHOULD remain the same throughout the lifetime of the SiLA Server.
    """

    def GetFeatureDefinition(
        self, FeatureIdentifier: str, *, metadata: Optional[Iterable[ClientMetadataInstance]] = None
    ) -> GetFeatureDefinition_Responses:
        """
        Get the Feature Definition of an implemented Feature by its fully qualified Feature Identifier.
        This command has no preconditions and no further dependencies and can be called at any time.
        """
        ...

    def SetServerName(
        self, ServerName: str, *, metadata: Optional[Iterable[ClientMetadataInstance]] = None
    ) -> SetServerName_Responses:
        """
        Sets a human readable name to the Server Name Property.Command has no preconditions and
        no further dependencies and can be called at any time.
        """
        ...
