#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['covid',
 'covid.data',
 'covid.data.countries',
 'covid.models',
 'covid.parameters',
 'covid.plot',
 'covid.ui']

package_data = \
{'': ['*'],
 'covid': ['datasets/*',
           'datasets/.pytest_cache/*',
           'datasets/.pytest_cache/v/*',
           'datasets/.pytest_cache/v/cache/*',
           'datasets/contact_matrix/*',
           'datasets/countries/*',
           'datasets/countries/brazil/*',
           'datasets/ibge_demographic/*',
           'locale/*',
           'locale/pt_BR/*',
           'locale/pt_BR/LC_MESSAGES/*',
           'simulation/*'],
 'covid.ui': ['assets/*', 'assets/css-components/*']}

install_requires = \
['Babel~=2.8.0',
 'click~=7.1.1',
 'invoke==1.4.1',
 'matplotlib==3.2.1',
 'numpy~=1.18.2',
 'pandas~=1.0.3',
 'requests~=2.23.0',
 'seaborn~=0.10.0',
 'streamlit~=0.57.3',
 'xlrd~=1.2.0']

extras_require = \
{'dev': ['black==19.10b0', 'pycodestyle==2.5.0'],
 'test': ['coverage==5.0.4', 'pytest==5.4.1']}

setup(name='covid-models',
      version='0.1.1',
      description='Covid',
      author='Fábio Macêdo Mendes',
      author_email='fabiomacedomendes@gmail.com',
      url='http://github.com/fabiommendes/covid-19',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
