# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AssetTagArgs',
    'ChannelLogConfigurationArgs',
    'ChannelTagArgs',
    'OriginEndpointAuthorizationArgs',
    'OriginEndpointCmafEncryptionArgs',
    'OriginEndpointCmafPackageArgs',
    'OriginEndpointDashEncryptionArgs',
    'OriginEndpointDashPackageArgs',
    'OriginEndpointEncryptionContractConfigurationArgs',
    'OriginEndpointHlsEncryptionArgs',
    'OriginEndpointHlsManifestArgs',
    'OriginEndpointHlsPackageArgs',
    'OriginEndpointMssEncryptionArgs',
    'OriginEndpointMssPackageArgs',
    'OriginEndpointSpekeKeyProviderArgs',
    'OriginEndpointStreamSelectionArgs',
    'OriginEndpointTagArgs',
    'PackagingConfigurationCmafEncryptionArgs',
    'PackagingConfigurationCmafPackageArgs',
    'PackagingConfigurationDashEncryptionArgs',
    'PackagingConfigurationDashManifestArgs',
    'PackagingConfigurationDashPackageArgs',
    'PackagingConfigurationHlsEncryptionArgs',
    'PackagingConfigurationHlsManifestArgs',
    'PackagingConfigurationHlsPackageArgs',
    'PackagingConfigurationMssEncryptionArgs',
    'PackagingConfigurationMssManifestArgs',
    'PackagingConfigurationMssPackageArgs',
    'PackagingConfigurationSpekeKeyProviderArgs',
    'PackagingConfigurationStreamSelectionArgs',
    'PackagingConfigurationTagArgs',
    'PackagingGroupAuthorizationArgs',
    'PackagingGroupLogConfigurationArgs',
    'PackagingGroupTagArgs',
]

@pulumi.input_type
class AssetTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ChannelLogConfigurationArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_group_name: Sets a custom AWS CloudWatch log group name for access logs. If a log group name isn't specified, the defaults are used: /aws/MediaPackage/EgressAccessLogs for egress access logs and /aws/MediaPackage/IngressAccessLogs for ingress access logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Sets a custom AWS CloudWatch log group name for access logs. If a log group name isn't specified, the defaults are used: /aws/MediaPackage/EgressAccessLogs for egress access logs and /aws/MediaPackage/IngressAccessLogs for ingress access logs.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)


@pulumi.input_type
class ChannelTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OriginEndpointAuthorizationArgs:
    def __init__(__self__, *,
                 cdn_identifier_secret: pulumi.Input[str],
                 secrets_role_arn: pulumi.Input[str]):
        """
        CDN Authorization credentials
        :param pulumi.Input[str] cdn_identifier_secret: The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        :param pulumi.Input[str] secrets_role_arn: The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        pulumi.set(__self__, "cdn_identifier_secret", cdn_identifier_secret)
        pulumi.set(__self__, "secrets_role_arn", secrets_role_arn)

    @property
    @pulumi.getter(name="cdnIdentifierSecret")
    def cdn_identifier_secret(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        """
        return pulumi.get(self, "cdn_identifier_secret")

    @cdn_identifier_secret.setter
    def cdn_identifier_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "cdn_identifier_secret", value)

    @property
    @pulumi.getter(name="secretsRoleArn")
    def secrets_role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_role_arn")

    @secrets_role_arn.setter
    def secrets_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_role_arn", value)


@pulumi.input_type
class OriginEndpointCmafEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['OriginEndpointSpekeKeyProviderArgs'],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 encryption_method: Optional[pulumi.Input['OriginEndpointCmafEncryptionEncryptionMethod']] = None,
                 key_rotation_interval_seconds: Optional[pulumi.Input[int]] = None):
        """
        A Common Media Application Format (CMAF) encryption configuration.
        :param pulumi.Input[str] constant_initialization_vector: An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        :param pulumi.Input['OriginEndpointCmafEncryptionEncryptionMethod'] encryption_method: The encryption method used
        :param pulumi.Input[int] key_rotation_interval_seconds: Time (in seconds) between each encryption key rotation.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if encryption_method is not None:
            pulumi.set(__self__, "encryption_method", encryption_method)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['OriginEndpointSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> Optional[pulumi.Input['OriginEndpointCmafEncryptionEncryptionMethod']]:
        """
        The encryption method used
        """
        return pulumi.get(self, "encryption_method")

    @encryption_method.setter
    def encryption_method(self, value: Optional[pulumi.Input['OriginEndpointCmafEncryptionEncryptionMethod']]):
        pulumi.set(self, "encryption_method", value)

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")

    @key_rotation_interval_seconds.setter
    def key_rotation_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_rotation_interval_seconds", value)


@pulumi.input_type
class OriginEndpointCmafPackageArgs:
    def __init__(__self__, *,
                 encryption: Optional[pulumi.Input['OriginEndpointCmafEncryptionArgs']] = None,
                 hls_manifests: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestArgs']]]] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 segment_prefix: Optional[pulumi.Input[str]] = None,
                 stream_selection: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']] = None):
        """
        A Common Media Application Format (CMAF) packaging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestArgs']]] hls_manifests: A list of HLS manifest configurations
        :param pulumi.Input[int] segment_duration_seconds: Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        :param pulumi.Input[str] segment_prefix: An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if hls_manifests is not None:
            pulumi.set(__self__, "hls_manifests", hls_manifests)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_prefix is not None:
            pulumi.set(__self__, "segment_prefix", segment_prefix)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['OriginEndpointCmafEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['OriginEndpointCmafEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestArgs']]]]:
        """
        A list of HLS manifest configurations
        """
        return pulumi.get(self, "hls_manifests")

    @hls_manifests.setter
    def hls_manifests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestArgs']]]]):
        pulumi.set(self, "hls_manifests", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="segmentPrefix")
    def segment_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        """
        return pulumi.get(self, "segment_prefix")

    @segment_prefix.setter
    def segment_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_prefix", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)


@pulumi.input_type
class OriginEndpointDashEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['OriginEndpointSpekeKeyProviderArgs'],
                 key_rotation_interval_seconds: Optional[pulumi.Input[int]] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        :param pulumi.Input[int] key_rotation_interval_seconds: Time (in seconds) between each encryption key rotation.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['OriginEndpointSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")

    @key_rotation_interval_seconds.setter
    def key_rotation_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_rotation_interval_seconds", value)


@pulumi.input_type
class OriginEndpointDashPackageArgs:
    def __init__(__self__, *,
                 ad_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackageAdTriggersItem']]]] = None,
                 ads_on_delivery_restrictions: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']] = None,
                 encryption: Optional[pulumi.Input['OriginEndpointDashEncryptionArgs']] = None,
                 include_iframe_only_stream: Optional[pulumi.Input[bool]] = None,
                 manifest_layout: Optional[pulumi.Input['OriginEndpointDashPackageManifestLayout']] = None,
                 manifest_window_seconds: Optional[pulumi.Input[int]] = None,
                 min_buffer_time_seconds: Optional[pulumi.Input[int]] = None,
                 min_update_period_seconds: Optional[pulumi.Input[int]] = None,
                 period_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackagePeriodTriggersItem']]]] = None,
                 profile: Optional[pulumi.Input['OriginEndpointDashPackageProfile']] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 segment_template_format: Optional[pulumi.Input['OriginEndpointDashPackageSegmentTemplateFormat']] = None,
                 stream_selection: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']] = None,
                 suggested_presentation_delay_seconds: Optional[pulumi.Input[int]] = None,
                 utc_timing: Optional[pulumi.Input['OriginEndpointDashPackageUtcTiming']] = None,
                 utc_timing_uri: Optional[pulumi.Input[str]] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackageAdTriggersItem']]] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param pulumi.Input[bool] include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param pulumi.Input['OriginEndpointDashPackageManifestLayout'] manifest_layout: Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        :param pulumi.Input[int] manifest_window_seconds: Time window (in seconds) contained in each manifest.
        :param pulumi.Input[int] min_buffer_time_seconds: Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        :param pulumi.Input[int] min_update_period_seconds: Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackagePeriodTriggersItem']]] period_triggers: A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Channel source contains SCTE-35 ad markers.
        :param pulumi.Input['OriginEndpointDashPackageProfile'] profile: The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        :param pulumi.Input[int] segment_duration_seconds: Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        :param pulumi.Input['OriginEndpointDashPackageSegmentTemplateFormat'] segment_template_format: Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        :param pulumi.Input[int] suggested_presentation_delay_seconds: Duration (in seconds) to delay live content before presentation.
        :param pulumi.Input['OriginEndpointDashPackageUtcTiming'] utc_timing: Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        :param pulumi.Input[str] utc_timing_uri: Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO, HTTP-HEAD or HTTP-XSDATE
        """
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if manifest_layout is not None:
            pulumi.set(__self__, "manifest_layout", manifest_layout)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if min_update_period_seconds is not None:
            pulumi.set(__self__, "min_update_period_seconds", min_update_period_seconds)
        if period_triggers is not None:
            pulumi.set(__self__, "period_triggers", period_triggers)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_template_format is not None:
            pulumi.set(__self__, "segment_template_format", segment_template_format)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)
        if suggested_presentation_delay_seconds is not None:
            pulumi.set(__self__, "suggested_presentation_delay_seconds", suggested_presentation_delay_seconds)
        if utc_timing is not None:
            pulumi.set(__self__, "utc_timing", utc_timing)
        if utc_timing_uri is not None:
            pulumi.set(__self__, "utc_timing_uri", utc_timing_uri)

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackageAdTriggersItem']]]]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @ad_triggers.setter
    def ad_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackageAdTriggersItem']]]]):
        pulumi.set(self, "ad_triggers", value)

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @ads_on_delivery_restrictions.setter
    def ads_on_delivery_restrictions(self, value: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]):
        pulumi.set(self, "ads_on_delivery_restrictions", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['OriginEndpointDashEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['OriginEndpointDashEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @include_iframe_only_stream.setter
    def include_iframe_only_stream(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_iframe_only_stream", value)

    @property
    @pulumi.getter(name="manifestLayout")
    def manifest_layout(self) -> Optional[pulumi.Input['OriginEndpointDashPackageManifestLayout']]:
        """
        Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        """
        return pulumi.get(self, "manifest_layout")

    @manifest_layout.setter
    def manifest_layout(self, value: Optional[pulumi.Input['OriginEndpointDashPackageManifestLayout']]):
        pulumi.set(self, "manifest_layout", value)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time window (in seconds) contained in each manifest.
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manifest_window_seconds", value)

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @min_buffer_time_seconds.setter
    def min_buffer_time_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_buffer_time_seconds", value)

    @property
    @pulumi.getter(name="minUpdatePeriodSeconds")
    def min_update_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        """
        return pulumi.get(self, "min_update_period_seconds")

    @min_update_period_seconds.setter
    def min_update_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_update_period_seconds", value)

    @property
    @pulumi.getter(name="periodTriggers")
    def period_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackagePeriodTriggersItem']]]]:
        """
        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Channel source contains SCTE-35 ad markers.
        """
        return pulumi.get(self, "period_triggers")

    @period_triggers.setter
    def period_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointDashPackagePeriodTriggersItem']]]]):
        pulumi.set(self, "period_triggers", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['OriginEndpointDashPackageProfile']]:
        """
        The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['OriginEndpointDashPackageProfile']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="segmentTemplateFormat")
    def segment_template_format(self) -> Optional[pulumi.Input['OriginEndpointDashPackageSegmentTemplateFormat']]:
        """
        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        return pulumi.get(self, "segment_template_format")

    @segment_template_format.setter
    def segment_template_format(self, value: Optional[pulumi.Input['OriginEndpointDashPackageSegmentTemplateFormat']]):
        pulumi.set(self, "segment_template_format", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)

    @property
    @pulumi.getter(name="suggestedPresentationDelaySeconds")
    def suggested_presentation_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Duration (in seconds) to delay live content before presentation.
        """
        return pulumi.get(self, "suggested_presentation_delay_seconds")

    @suggested_presentation_delay_seconds.setter
    def suggested_presentation_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suggested_presentation_delay_seconds", value)

    @property
    @pulumi.getter(name="utcTiming")
    def utc_timing(self) -> Optional[pulumi.Input['OriginEndpointDashPackageUtcTiming']]:
        """
        Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        """
        return pulumi.get(self, "utc_timing")

    @utc_timing.setter
    def utc_timing(self, value: Optional[pulumi.Input['OriginEndpointDashPackageUtcTiming']]):
        pulumi.set(self, "utc_timing", value)

    @property
    @pulumi.getter(name="utcTimingUri")
    def utc_timing_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO, HTTP-HEAD or HTTP-XSDATE
        """
        return pulumi.get(self, "utc_timing_uri")

    @utc_timing_uri.setter
    def utc_timing_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utc_timing_uri", value)


@pulumi.input_type
class OriginEndpointEncryptionContractConfigurationArgs:
    def __init__(__self__, *,
                 preset_speke20_audio: pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Audio'],
                 preset_speke20_video: pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Video']):
        """
        The configuration to use for encrypting one or more content tracks separately for endpoints that use SPEKE 2.0.
        :param pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Audio'] preset_speke20_audio: A collection of audio encryption presets.
        :param pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Video'] preset_speke20_video: A collection of video encryption presets.
        """
        pulumi.set(__self__, "preset_speke20_audio", preset_speke20_audio)
        pulumi.set(__self__, "preset_speke20_video", preset_speke20_video)

    @property
    @pulumi.getter(name="presetSpeke20Audio")
    def preset_speke20_audio(self) -> pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Audio']:
        """
        A collection of audio encryption presets.
        """
        return pulumi.get(self, "preset_speke20_audio")

    @preset_speke20_audio.setter
    def preset_speke20_audio(self, value: pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Audio']):
        pulumi.set(self, "preset_speke20_audio", value)

    @property
    @pulumi.getter(name="presetSpeke20Video")
    def preset_speke20_video(self) -> pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Video']:
        """
        A collection of video encryption presets.
        """
        return pulumi.get(self, "preset_speke20_video")

    @preset_speke20_video.setter
    def preset_speke20_video(self, value: pulumi.Input['OriginEndpointEncryptionContractConfigurationPresetSpeke20Video']):
        pulumi.set(self, "preset_speke20_video", value)


@pulumi.input_type
class OriginEndpointHlsEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['OriginEndpointSpekeKeyProviderArgs'],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 encryption_method: Optional[pulumi.Input['OriginEndpointHlsEncryptionEncryptionMethod']] = None,
                 key_rotation_interval_seconds: Optional[pulumi.Input[int]] = None,
                 repeat_ext_x_key: Optional[pulumi.Input[bool]] = None):
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        :param pulumi.Input[str] constant_initialization_vector: A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
        :param pulumi.Input['OriginEndpointHlsEncryptionEncryptionMethod'] encryption_method: The encryption method to use.
        :param pulumi.Input[int] key_rotation_interval_seconds: Interval (in seconds) between each encryption key rotation.
        :param pulumi.Input[bool] repeat_ext_x_key: When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if encryption_method is not None:
            pulumi.set(__self__, "encryption_method", encryption_method)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)
        if repeat_ext_x_key is not None:
            pulumi.set(__self__, "repeat_ext_x_key", repeat_ext_x_key)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['OriginEndpointSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> Optional[pulumi.Input['OriginEndpointHlsEncryptionEncryptionMethod']]:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "encryption_method")

    @encryption_method.setter
    def encryption_method(self, value: Optional[pulumi.Input['OriginEndpointHlsEncryptionEncryptionMethod']]):
        pulumi.set(self, "encryption_method", value)

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")

    @key_rotation_interval_seconds.setter
    def key_rotation_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_rotation_interval_seconds", value)

    @property
    @pulumi.getter(name="repeatExtXKey")
    def repeat_ext_x_key(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        return pulumi.get(self, "repeat_ext_x_key")

    @repeat_ext_x_key.setter
    def repeat_ext_x_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "repeat_ext_x_key", value)


@pulumi.input_type
class OriginEndpointHlsManifestArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ad_markers: Optional[pulumi.Input['OriginEndpointHlsManifestAdMarkers']] = None,
                 ad_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestAdTriggersItem']]]] = None,
                 ads_on_delivery_restrictions: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']] = None,
                 include_iframe_only_stream: Optional[pulumi.Input[bool]] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 playlist_type: Optional[pulumi.Input['OriginEndpointHlsManifestPlaylistType']] = None,
                 playlist_window_seconds: Optional[pulumi.Input[int]] = None,
                 program_date_time_interval_seconds: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        A HTTP Live Streaming (HLS) manifest configuration.
        :param pulumi.Input[str] id: The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        :param pulumi.Input['OriginEndpointHlsManifestAdMarkers'] ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestAdTriggersItem']]] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param pulumi.Input[bool] include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param pulumi.Input[str] manifest_name: An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        :param pulumi.Input['OriginEndpointHlsManifestPlaylistType'] playlist_type: The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        :param pulumi.Input[int] playlist_window_seconds: Time window (in seconds) contained in each parent manifest.
        :param pulumi.Input[int] program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param pulumi.Input[str] url: The URL of the packaged OriginEndpoint for consumption.
        """
        pulumi.set(__self__, "id", id)
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if playlist_type is not None:
            pulumi.set(__self__, "playlist_type", playlist_type)
        if playlist_window_seconds is not None:
            pulumi.set(__self__, "playlist_window_seconds", playlist_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional[pulumi.Input['OriginEndpointHlsManifestAdMarkers']]:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        """
        return pulumi.get(self, "ad_markers")

    @ad_markers.setter
    def ad_markers(self, value: Optional[pulumi.Input['OriginEndpointHlsManifestAdMarkers']]):
        pulumi.set(self, "ad_markers", value)

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestAdTriggersItem']]]]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @ad_triggers.setter
    def ad_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsManifestAdTriggersItem']]]]):
        pulumi.set(self, "ad_triggers", value)

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @ads_on_delivery_restrictions.setter
    def ads_on_delivery_restrictions(self, value: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]):
        pulumi.set(self, "ads_on_delivery_restrictions", value)

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @include_iframe_only_stream.setter
    def include_iframe_only_stream(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_iframe_only_stream", value)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        """
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="playlistType")
    def playlist_type(self) -> Optional[pulumi.Input['OriginEndpointHlsManifestPlaylistType']]:
        """
        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        """
        return pulumi.get(self, "playlist_type")

    @playlist_type.setter
    def playlist_type(self, value: Optional[pulumi.Input['OriginEndpointHlsManifestPlaylistType']]):
        pulumi.set(self, "playlist_type", value)

    @property
    @pulumi.getter(name="playlistWindowSeconds")
    def playlist_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time window (in seconds) contained in each parent manifest.
        """
        return pulumi.get(self, "playlist_window_seconds")

    @playlist_window_seconds.setter
    def playlist_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "playlist_window_seconds", value)

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @program_date_time_interval_seconds.setter
    def program_date_time_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "program_date_time_interval_seconds", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the packaged OriginEndpoint for consumption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class OriginEndpointHlsPackageArgs:
    def __init__(__self__, *,
                 ad_markers: Optional[pulumi.Input['OriginEndpointHlsPackageAdMarkers']] = None,
                 ad_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsPackageAdTriggersItem']]]] = None,
                 ads_on_delivery_restrictions: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']] = None,
                 encryption: Optional[pulumi.Input['OriginEndpointHlsEncryptionArgs']] = None,
                 include_iframe_only_stream: Optional[pulumi.Input[bool]] = None,
                 playlist_type: Optional[pulumi.Input['OriginEndpointHlsPackagePlaylistType']] = None,
                 playlist_window_seconds: Optional[pulumi.Input[int]] = None,
                 program_date_time_interval_seconds: Optional[pulumi.Input[int]] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 stream_selection: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']] = None,
                 use_audio_rendition_group: Optional[pulumi.Input[bool]] = None):
        """
        An HTTP Live Streaming (HLS) packaging configuration.
        :param pulumi.Input['OriginEndpointHlsPackageAdMarkers'] ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsPackageAdTriggersItem']]] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param pulumi.Input[bool] include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param pulumi.Input['OriginEndpointHlsPackagePlaylistType'] playlist_type: The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        :param pulumi.Input[int] playlist_window_seconds: Time window (in seconds) contained in each parent manifest.
        :param pulumi.Input[int] program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param pulumi.Input[int] segment_duration_seconds: Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
        :param pulumi.Input[bool] use_audio_rendition_group: When enabled, audio streams will be placed in rendition groups in the output.
        """
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if playlist_type is not None:
            pulumi.set(__self__, "playlist_type", playlist_type)
        if playlist_window_seconds is not None:
            pulumi.set(__self__, "playlist_window_seconds", playlist_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)
        if use_audio_rendition_group is not None:
            pulumi.set(__self__, "use_audio_rendition_group", use_audio_rendition_group)

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional[pulumi.Input['OriginEndpointHlsPackageAdMarkers']]:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        """
        return pulumi.get(self, "ad_markers")

    @ad_markers.setter
    def ad_markers(self, value: Optional[pulumi.Input['OriginEndpointHlsPackageAdMarkers']]):
        pulumi.set(self, "ad_markers", value)

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsPackageAdTriggersItem']]]]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @ad_triggers.setter
    def ad_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointHlsPackageAdTriggersItem']]]]):
        pulumi.set(self, "ad_triggers", value)

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @ads_on_delivery_restrictions.setter
    def ads_on_delivery_restrictions(self, value: Optional[pulumi.Input['OriginEndpointAdsOnDeliveryRestrictions']]):
        pulumi.set(self, "ads_on_delivery_restrictions", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['OriginEndpointHlsEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['OriginEndpointHlsEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @include_iframe_only_stream.setter
    def include_iframe_only_stream(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_iframe_only_stream", value)

    @property
    @pulumi.getter(name="playlistType")
    def playlist_type(self) -> Optional[pulumi.Input['OriginEndpointHlsPackagePlaylistType']]:
        """
        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        """
        return pulumi.get(self, "playlist_type")

    @playlist_type.setter
    def playlist_type(self, value: Optional[pulumi.Input['OriginEndpointHlsPackagePlaylistType']]):
        pulumi.set(self, "playlist_type", value)

    @property
    @pulumi.getter(name="playlistWindowSeconds")
    def playlist_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time window (in seconds) contained in each parent manifest.
        """
        return pulumi.get(self, "playlist_window_seconds")

    @playlist_window_seconds.setter
    def playlist_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "playlist_window_seconds", value)

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @program_date_time_interval_seconds.setter
    def program_date_time_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "program_date_time_interval_seconds", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)

    @property
    @pulumi.getter(name="useAudioRenditionGroup")
    def use_audio_rendition_group(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, audio streams will be placed in rendition groups in the output.
        """
        return pulumi.get(self, "use_audio_rendition_group")

    @use_audio_rendition_group.setter
    def use_audio_rendition_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_audio_rendition_group", value)


@pulumi.input_type
class OriginEndpointMssEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        """
        A Microsoft Smooth Streaming (MSS) encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['OriginEndpointSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['OriginEndpointSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)


@pulumi.input_type
class OriginEndpointMssPackageArgs:
    def __init__(__self__, *,
                 encryption: Optional[pulumi.Input['OriginEndpointMssEncryptionArgs']] = None,
                 manifest_window_seconds: Optional[pulumi.Input[int]] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 stream_selection: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']] = None):
        """
        A Microsoft Smooth Streaming (MSS) packaging configuration.
        :param pulumi.Input[int] manifest_window_seconds: The time window (in seconds) contained in each manifest.
        :param pulumi.Input[int] segment_duration_seconds: The duration (in seconds) of each segment.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['OriginEndpointMssEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['OriginEndpointMssEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The time window (in seconds) contained in each manifest.
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manifest_window_seconds", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The duration (in seconds) of each segment.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['OriginEndpointStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)


@pulumi.input_type
class OriginEndpointSpekeKeyProviderArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 system_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 url: pulumi.Input[str],
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 encryption_contract_configuration: Optional[pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs']] = None):
        """
        A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        :param pulumi.Input[str] resource_id: The resource ID to include in key requests.
        :param pulumi.Input[str] role_arn: An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_ids: The system IDs to include in key requests.
        :param pulumi.Input[str] url: The URL of the external key provider service.
        :param pulumi.Input[str] certificate_arn: An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing secure end-to-end data transfer with the key provider service.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "system_ids", system_ids)
        pulumi.set(__self__, "url", url)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if encryption_contract_configuration is not None:
            pulumi.set(__self__, "encryption_contract_configuration", encryption_contract_configuration)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource ID to include in key requests.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="systemIds")
    def system_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The system IDs to include in key requests.
        """
        return pulumi.get(self, "system_ids")

    @system_ids.setter
    def system_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "system_ids", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the external key provider service.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing secure end-to-end data transfer with the key provider service.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="encryptionContractConfiguration")
    def encryption_contract_configuration(self) -> Optional[pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs']]:
        return pulumi.get(self, "encryption_contract_configuration")

    @encryption_contract_configuration.setter
    def encryption_contract_configuration(self, value: Optional[pulumi.Input['OriginEndpointEncryptionContractConfigurationArgs']]):
        pulumi.set(self, "encryption_contract_configuration", value)


@pulumi.input_type
class OriginEndpointStreamSelectionArgs:
    def __init__(__self__, *,
                 max_video_bits_per_second: Optional[pulumi.Input[int]] = None,
                 min_video_bits_per_second: Optional[pulumi.Input[int]] = None,
                 stream_order: Optional[pulumi.Input['OriginEndpointStreamSelectionStreamOrder']] = None):
        """
        A StreamSelection configuration.
        :param pulumi.Input[int] max_video_bits_per_second: The maximum video bitrate (bps) to include in output.
        :param pulumi.Input[int] min_video_bits_per_second: The minimum video bitrate (bps) to include in output.
        :param pulumi.Input['OriginEndpointStreamSelectionStreamOrder'] stream_order: A directive that determines the order of streams in the output.
        """
        if max_video_bits_per_second is not None:
            pulumi.set(__self__, "max_video_bits_per_second", max_video_bits_per_second)
        if min_video_bits_per_second is not None:
            pulumi.set(__self__, "min_video_bits_per_second", min_video_bits_per_second)
        if stream_order is not None:
            pulumi.set(__self__, "stream_order", stream_order)

    @property
    @pulumi.getter(name="maxVideoBitsPerSecond")
    def max_video_bits_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "max_video_bits_per_second")

    @max_video_bits_per_second.setter
    def max_video_bits_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_video_bits_per_second", value)

    @property
    @pulumi.getter(name="minVideoBitsPerSecond")
    def min_video_bits_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "min_video_bits_per_second")

    @min_video_bits_per_second.setter
    def min_video_bits_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_video_bits_per_second", value)

    @property
    @pulumi.getter(name="streamOrder")
    def stream_order(self) -> Optional[pulumi.Input['OriginEndpointStreamSelectionStreamOrder']]:
        """
        A directive that determines the order of streams in the output.
        """
        return pulumi.get(self, "stream_order")

    @stream_order.setter
    def stream_order(self, value: Optional[pulumi.Input['OriginEndpointStreamSelectionStreamOrder']]):
        pulumi.set(self, "stream_order", value)


@pulumi.input_type
class OriginEndpointTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PackagingConfigurationCmafEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        """
        A CMAF encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)


@pulumi.input_type
class PackagingConfigurationCmafPackageArgs:
    def __init__(__self__, *,
                 hls_manifests: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]],
                 encryption: Optional[pulumi.Input['PackagingConfigurationCmafEncryptionArgs']] = None,
                 include_encoder_configuration_in_segments: Optional[pulumi.Input[bool]] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None):
        """
        A CMAF packaging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]] hls_manifests: A list of HLS manifest configurations.
        :param pulumi.Input[bool] include_encoder_configuration_in_segments: When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        pulumi.set(__self__, "hls_manifests", hls_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_encoder_configuration_in_segments is not None:
            pulumi.set(__self__, "include_encoder_configuration_in_segments", include_encoder_configuration_in_segments)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]]:
        """
        A list of HLS manifest configurations.
        """
        return pulumi.get(self, "hls_manifests")

    @hls_manifests.setter
    def hls_manifests(self, value: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]]):
        pulumi.set(self, "hls_manifests", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['PackagingConfigurationCmafEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['PackagingConfigurationCmafEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="includeEncoderConfigurationInSegments")
    def include_encoder_configuration_in_segments(self) -> Optional[pulumi.Input[bool]]:
        """
        When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        return pulumi.get(self, "include_encoder_configuration_in_segments")

    @include_encoder_configuration_in_segments.setter
    def include_encoder_configuration_in_segments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_encoder_configuration_in_segments", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)


@pulumi.input_type
class PackagingConfigurationDashEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)


@pulumi.input_type
class PackagingConfigurationDashManifestArgs:
    def __init__(__self__, *,
                 manifest_layout: Optional[pulumi.Input['PackagingConfigurationDashManifestManifestLayout']] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 min_buffer_time_seconds: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input['PackagingConfigurationDashManifestProfile']] = None,
                 scte_markers_source: Optional[pulumi.Input['PackagingConfigurationDashManifestScteMarkersSource']] = None,
                 stream_selection: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']] = None):
        """
        A DASH manifest configuration.
        :param pulumi.Input['PackagingConfigurationDashManifestManifestLayout'] manifest_layout: Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        :param pulumi.Input[int] min_buffer_time_seconds: Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        :param pulumi.Input['PackagingConfigurationDashManifestProfile'] profile: The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        :param pulumi.Input['PackagingConfigurationDashManifestScteMarkersSource'] scte_markers_source: The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested content.
        """
        if manifest_layout is not None:
            pulumi.set(__self__, "manifest_layout", manifest_layout)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if scte_markers_source is not None:
            pulumi.set(__self__, "scte_markers_source", scte_markers_source)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="manifestLayout")
    def manifest_layout(self) -> Optional[pulumi.Input['PackagingConfigurationDashManifestManifestLayout']]:
        """
        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        """
        return pulumi.get(self, "manifest_layout")

    @manifest_layout.setter
    def manifest_layout(self, value: Optional[pulumi.Input['PackagingConfigurationDashManifestManifestLayout']]):
        pulumi.set(self, "manifest_layout", value)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @min_buffer_time_seconds.setter
    def min_buffer_time_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_buffer_time_seconds", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['PackagingConfigurationDashManifestProfile']]:
        """
        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['PackagingConfigurationDashManifestProfile']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="scteMarkersSource")
    def scte_markers_source(self) -> Optional[pulumi.Input['PackagingConfigurationDashManifestScteMarkersSource']]:
        """
        The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested content.
        """
        return pulumi.get(self, "scte_markers_source")

    @scte_markers_source.setter
    def scte_markers_source(self, value: Optional[pulumi.Input['PackagingConfigurationDashManifestScteMarkersSource']]):
        pulumi.set(self, "scte_markers_source", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)


@pulumi.input_type
class PackagingConfigurationDashPackageArgs:
    def __init__(__self__, *,
                 dash_manifests: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashManifestArgs']]],
                 encryption: Optional[pulumi.Input['PackagingConfigurationDashEncryptionArgs']] = None,
                 include_encoder_configuration_in_segments: Optional[pulumi.Input[bool]] = None,
                 period_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashPackagePeriodTriggersItem']]]] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 segment_template_format: Optional[pulumi.Input['PackagingConfigurationDashPackageSegmentTemplateFormat']] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashManifestArgs']]] dash_manifests: A list of DASH manifest configurations.
        :param pulumi.Input[bool] include_encoder_configuration_in_segments: When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashPackagePeriodTriggersItem']]] period_triggers: A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad markers.
        :param pulumi.Input['PackagingConfigurationDashPackageSegmentTemplateFormat'] segment_template_format: Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        pulumi.set(__self__, "dash_manifests", dash_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_encoder_configuration_in_segments is not None:
            pulumi.set(__self__, "include_encoder_configuration_in_segments", include_encoder_configuration_in_segments)
        if period_triggers is not None:
            pulumi.set(__self__, "period_triggers", period_triggers)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_template_format is not None:
            pulumi.set(__self__, "segment_template_format", segment_template_format)

    @property
    @pulumi.getter(name="dashManifests")
    def dash_manifests(self) -> pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashManifestArgs']]]:
        """
        A list of DASH manifest configurations.
        """
        return pulumi.get(self, "dash_manifests")

    @dash_manifests.setter
    def dash_manifests(self, value: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashManifestArgs']]]):
        pulumi.set(self, "dash_manifests", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['PackagingConfigurationDashEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['PackagingConfigurationDashEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="includeEncoderConfigurationInSegments")
    def include_encoder_configuration_in_segments(self) -> Optional[pulumi.Input[bool]]:
        """
        When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        return pulumi.get(self, "include_encoder_configuration_in_segments")

    @include_encoder_configuration_in_segments.setter
    def include_encoder_configuration_in_segments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_encoder_configuration_in_segments", value)

    @property
    @pulumi.getter(name="periodTriggers")
    def period_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashPackagePeriodTriggersItem']]]]:
        """
        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad markers.
        """
        return pulumi.get(self, "period_triggers")

    @period_triggers.setter
    def period_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationDashPackagePeriodTriggersItem']]]]):
        pulumi.set(self, "period_triggers", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="segmentTemplateFormat")
    def segment_template_format(self) -> Optional[pulumi.Input['PackagingConfigurationDashPackageSegmentTemplateFormat']]:
        """
        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        return pulumi.get(self, "segment_template_format")

    @segment_template_format.setter
    def segment_template_format(self, value: Optional[pulumi.Input['PackagingConfigurationDashPackageSegmentTemplateFormat']]):
        pulumi.set(self, "segment_template_format", value)


@pulumi.input_type
class PackagingConfigurationHlsEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs'],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 encryption_method: Optional[pulumi.Input['PackagingConfigurationHlsEncryptionEncryptionMethod']] = None):
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        :param pulumi.Input[str] constant_initialization_vector: An HTTP Live Streaming (HLS) encryption configuration.
        :param pulumi.Input['PackagingConfigurationHlsEncryptionEncryptionMethod'] encryption_method: The encryption method to use.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if encryption_method is not None:
            pulumi.set(__self__, "encryption_method", encryption_method)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> Optional[pulumi.Input['PackagingConfigurationHlsEncryptionEncryptionMethod']]:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "encryption_method")

    @encryption_method.setter
    def encryption_method(self, value: Optional[pulumi.Input['PackagingConfigurationHlsEncryptionEncryptionMethod']]):
        pulumi.set(self, "encryption_method", value)


@pulumi.input_type
class PackagingConfigurationHlsManifestArgs:
    def __init__(__self__, *,
                 ad_markers: Optional[pulumi.Input['PackagingConfigurationHlsManifestAdMarkers']] = None,
                 include_iframe_only_stream: Optional[pulumi.Input[bool]] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 program_date_time_interval_seconds: Optional[pulumi.Input[int]] = None,
                 repeat_ext_x_key: Optional[pulumi.Input[bool]] = None,
                 stream_selection: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']] = None):
        """
        An HTTP Live Streaming (HLS) manifest configuration.
        :param pulumi.Input['PackagingConfigurationHlsManifestAdMarkers'] ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
        :param pulumi.Input[bool] include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param pulumi.Input[int] program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param pulumi.Input[bool] repeat_ext_x_key: When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if repeat_ext_x_key is not None:
            pulumi.set(__self__, "repeat_ext_x_key", repeat_ext_x_key)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional[pulumi.Input['PackagingConfigurationHlsManifestAdMarkers']]:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
        """
        return pulumi.get(self, "ad_markers")

    @ad_markers.setter
    def ad_markers(self, value: Optional[pulumi.Input['PackagingConfigurationHlsManifestAdMarkers']]):
        pulumi.set(self, "ad_markers", value)

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @include_iframe_only_stream.setter
    def include_iframe_only_stream(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_iframe_only_stream", value)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @program_date_time_interval_seconds.setter
    def program_date_time_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "program_date_time_interval_seconds", value)

    @property
    @pulumi.getter(name="repeatExtXKey")
    def repeat_ext_x_key(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        return pulumi.get(self, "repeat_ext_x_key")

    @repeat_ext_x_key.setter
    def repeat_ext_x_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "repeat_ext_x_key", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)


@pulumi.input_type
class PackagingConfigurationHlsPackageArgs:
    def __init__(__self__, *,
                 hls_manifests: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]],
                 encryption: Optional[pulumi.Input['PackagingConfigurationHlsEncryptionArgs']] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None,
                 use_audio_rendition_group: Optional[pulumi.Input[bool]] = None):
        """
        An HTTP Live Streaming (HLS) packaging configuration.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]] hls_manifests: A list of HLS manifest configurations.
        :param pulumi.Input[bool] use_audio_rendition_group: When enabled, audio streams will be placed in rendition groups in the output.
        """
        pulumi.set(__self__, "hls_manifests", hls_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if use_audio_rendition_group is not None:
            pulumi.set(__self__, "use_audio_rendition_group", use_audio_rendition_group)

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]]:
        """
        A list of HLS manifest configurations.
        """
        return pulumi.get(self, "hls_manifests")

    @hls_manifests.setter
    def hls_manifests(self, value: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationHlsManifestArgs']]]):
        pulumi.set(self, "hls_manifests", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['PackagingConfigurationHlsEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['PackagingConfigurationHlsEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)

    @property
    @pulumi.getter(name="useAudioRenditionGroup")
    def use_audio_rendition_group(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, audio streams will be placed in rendition groups in the output.
        """
        return pulumi.get(self, "use_audio_rendition_group")

    @use_audio_rendition_group.setter
    def use_audio_rendition_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_audio_rendition_group", value)


@pulumi.input_type
class PackagingConfigurationMssEncryptionArgs:
    def __init__(__self__, *,
                 speke_key_provider: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        """
        A CMAF encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']:
        return pulumi.get(self, "speke_key_provider")

    @speke_key_provider.setter
    def speke_key_provider(self, value: pulumi.Input['PackagingConfigurationSpekeKeyProviderArgs']):
        pulumi.set(self, "speke_key_provider", value)


@pulumi.input_type
class PackagingConfigurationMssManifestArgs:
    def __init__(__self__, *,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 stream_selection: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']] = None):
        """
        A Microsoft Smooth Streaming (MSS) manifest configuration.
        """
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]:
        return pulumi.get(self, "stream_selection")

    @stream_selection.setter
    def stream_selection(self, value: Optional[pulumi.Input['PackagingConfigurationStreamSelectionArgs']]):
        pulumi.set(self, "stream_selection", value)


@pulumi.input_type
class PackagingConfigurationMssPackageArgs:
    def __init__(__self__, *,
                 mss_manifests: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationMssManifestArgs']]],
                 encryption: Optional[pulumi.Input['PackagingConfigurationMssEncryptionArgs']] = None,
                 segment_duration_seconds: Optional[pulumi.Input[int]] = None):
        """
        A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationMssManifestArgs']]] mss_manifests: A list of MSS manifest configurations.
        """
        pulumi.set(__self__, "mss_manifests", mss_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)

    @property
    @pulumi.getter(name="mssManifests")
    def mss_manifests(self) -> pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationMssManifestArgs']]]:
        """
        A list of MSS manifest configurations.
        """
        return pulumi.get(self, "mss_manifests")

    @mss_manifests.setter
    def mss_manifests(self, value: pulumi.Input[Sequence[pulumi.Input['PackagingConfigurationMssManifestArgs']]]):
        pulumi.set(self, "mss_manifests", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['PackagingConfigurationMssEncryptionArgs']]:
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['PackagingConfigurationMssEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "segment_duration_seconds")

    @segment_duration_seconds.setter
    def segment_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "segment_duration_seconds", value)


@pulumi.input_type
class PackagingConfigurationSpekeKeyProviderArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 system_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 url: pulumi.Input[str]):
        """
        A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_ids: The system IDs to include in key requests.
        :param pulumi.Input[str] url: The URL of the external key provider service.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "system_ids", system_ids)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="systemIds")
    def system_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The system IDs to include in key requests.
        """
        return pulumi.get(self, "system_ids")

    @system_ids.setter
    def system_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "system_ids", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the external key provider service.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class PackagingConfigurationStreamSelectionArgs:
    def __init__(__self__, *,
                 max_video_bits_per_second: Optional[pulumi.Input[int]] = None,
                 min_video_bits_per_second: Optional[pulumi.Input[int]] = None,
                 stream_order: Optional[pulumi.Input['PackagingConfigurationStreamSelectionStreamOrder']] = None):
        """
        A StreamSelection configuration.
        :param pulumi.Input[int] max_video_bits_per_second: The maximum video bitrate (bps) to include in output.
        :param pulumi.Input[int] min_video_bits_per_second: The minimum video bitrate (bps) to include in output.
        :param pulumi.Input['PackagingConfigurationStreamSelectionStreamOrder'] stream_order: A directive that determines the order of streams in the output.
        """
        if max_video_bits_per_second is not None:
            pulumi.set(__self__, "max_video_bits_per_second", max_video_bits_per_second)
        if min_video_bits_per_second is not None:
            pulumi.set(__self__, "min_video_bits_per_second", min_video_bits_per_second)
        if stream_order is not None:
            pulumi.set(__self__, "stream_order", stream_order)

    @property
    @pulumi.getter(name="maxVideoBitsPerSecond")
    def max_video_bits_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "max_video_bits_per_second")

    @max_video_bits_per_second.setter
    def max_video_bits_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_video_bits_per_second", value)

    @property
    @pulumi.getter(name="minVideoBitsPerSecond")
    def min_video_bits_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "min_video_bits_per_second")

    @min_video_bits_per_second.setter
    def min_video_bits_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_video_bits_per_second", value)

    @property
    @pulumi.getter(name="streamOrder")
    def stream_order(self) -> Optional[pulumi.Input['PackagingConfigurationStreamSelectionStreamOrder']]:
        """
        A directive that determines the order of streams in the output.
        """
        return pulumi.get(self, "stream_order")

    @stream_order.setter
    def stream_order(self, value: Optional[pulumi.Input['PackagingConfigurationStreamSelectionStreamOrder']]):
        pulumi.set(self, "stream_order", value)


@pulumi.input_type
class PackagingConfigurationTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PackagingGroupAuthorizationArgs:
    def __init__(__self__, *,
                 cdn_identifier_secret: pulumi.Input[str],
                 secrets_role_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cdn_identifier_secret: The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        :param pulumi.Input[str] secrets_role_arn: The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        pulumi.set(__self__, "cdn_identifier_secret", cdn_identifier_secret)
        pulumi.set(__self__, "secrets_role_arn", secrets_role_arn)

    @property
    @pulumi.getter(name="cdnIdentifierSecret")
    def cdn_identifier_secret(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        """
        return pulumi.get(self, "cdn_identifier_secret")

    @cdn_identifier_secret.setter
    def cdn_identifier_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "cdn_identifier_secret", value)

    @property
    @pulumi.getter(name="secretsRoleArn")
    def secrets_role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_role_arn")

    @secrets_role_arn.setter
    def secrets_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_role_arn", value)


@pulumi.input_type
class PackagingGroupLogConfigurationArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_group_name: Sets a custom AWS CloudWatch log group name for egress logs. If a log group name isn't specified, the default name is used: /aws/MediaPackage/VodEgressAccessLogs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Sets a custom AWS CloudWatch log group name for egress logs. If a log group name isn't specified, the default name is used: /aws/MediaPackage/VodEgressAccessLogs.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)


@pulumi.input_type
class PackagingGroupTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


