# Generated by Django 3.0.7 on 2020-09-15 15:42

from django.db import migrations, models
import django.db.models.deletion
import tinymce.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='WeeblyBlog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('blog_id', models.BigIntegerField()),
                ('page_id', models.BigIntegerField()),
                ('title', models.CharField(max_length=256)),
            ],
        ),
        migrations.CreateModel(
            name='WeeblySite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('site_id', models.BigIntegerField()),
                ('site_title', models.CharField(blank=True, max_length=1024, null=True)),
                ('domain', models.CharField(blank=True, max_length=512, null=True)),
                ('is_published', models.BooleanField(default=False)),
                ('language', models.CharField(blank=True, max_length=8, null=True)),
                ('is_found', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='WeeblyStoreProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_id', models.BigIntegerField()),
                ('name', models.CharField(max_length=256)),
                ('description', tinymce.models.HTMLField(blank=True, null=True)),
                ('url', models.CharField(blank=True, max_length=1024, null=True)),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='store_products', to='weebly.WeeblySite')),
            ],
            options={
                'unique_together': {('site', 'product_id')},
            },
        ),
        migrations.CreateModel(
            name='WeeblyUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.BigIntegerField()),
                ('name', models.CharField(blank=True, max_length=256, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='weeblysite',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='weebly.WeeblyUser'),
        ),
        migrations.CreateModel(
            name='WeeblyPaymentNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256)),
                ('detail', models.CharField(blank=True, max_length=256, null=True)),
                ('purchase_not_refund', models.BooleanField(default=True)),
                ('kind', models.CharField(blank=True, choices=[('single', 'Single'), ('setup', 'Setup')], max_length=10, null=True)),
                ('term', models.CharField(blank=True, choices=[('month', 'Month'), ('year', 'Year'), ('forever', 'Forever'), ('refund', 'Refund')], max_length=10, null=True)),
                ('gross_amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('payable_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10)),
                ('currency', models.CharField(blank=True, default='USD', max_length=10, null=True)),
                ('notified_to_weebly', models.BooleanField(default=False)),
                ('notified_to_weebly_on', models.DateTimeField(blank=True, null=True)),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='weebly.WeeblySite')),
            ],
        ),
        migrations.CreateModel(
            name='WeeblyPage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page_id', models.BigIntegerField(unique=True)),
                ('title', models.CharField(max_length=512)),
                ('page_url', models.CharField(blank=True, max_length=1024, null=True)),
                ('hidden', models.BooleanField(default=False)),
                ('page_order', models.IntegerField(default=0)),
                ('parent_id', models.BigIntegerField(blank=True, null=True)),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pages', to='weebly.WeeblySite')),
            ],
        ),
        migrations.CreateModel(
            name='WeeblyBlogPost',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('post_id', models.BigIntegerField()),
                ('title', models.CharField(max_length=256)),
                ('created_date', models.DateTimeField(blank=True, null=True)),
                ('updated_date', models.DateTimeField(blank=True, null=True)),
                ('body', models.TextField(blank=True, null=True)),
                ('link', models.CharField(blank=True, max_length=1024, null=True)),
                ('url', models.CharField(blank=True, max_length=1024, null=True)),
                ('share_message', models.CharField(blank=True, max_length=256, null=True)),
                ('seo_title', models.CharField(blank=True, max_length=256, null=True)),
                ('seo_description', models.TextField(blank=True, null=True)),
                ('tags', models.TextField(blank=True, null=True)),
                ('blog', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='posts', to='weebly.WeeblyBlog')),
            ],
        ),
        migrations.AddField(
            model_name='weeblyblog',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='blogs', to='weebly.WeeblySite'),
        ),
        migrations.CreateModel(
            name='WeeblyStoreProductOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('option_id', models.BigIntegerField()),
                ('name', models.CharField(max_length=256)),
                ('choices', models.TextField()),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='options', to='weebly.WeeblyStoreProduct')),
            ],
            options={
                'unique_together': {('product', 'option_id')},
            },
        ),
        migrations.CreateModel(
            name='WeeblyStoreCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category_id', models.BigIntegerField()),
                ('name', models.CharField(max_length=256)),
                ('parent_category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='weebly.WeeblyStoreCategory')),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='store_categories', to='weebly.WeeblySite')),
            ],
            options={
                'verbose_name_plural': 'weebly store categories',
                'unique_together': {('site', 'category_id')},
            },
        ),
        migrations.CreateModel(
            name='WeeblyAuth',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('auth_token', models.CharField(blank=True, max_length=100, null=True)),
                ('timestamp', models.DateTimeField(blank=True, null=True)),
                ('is_valid', models.BooleanField(default=True)),
                ('version', models.CharField(max_length=20)),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='weebly.WeeblySite')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='weebly.WeeblyUser')),
            ],
            options={
                'unique_together': {('user', 'site')},
            },
        ),
    ]
