continents = {
    "AF": {
        "name": "Africa",
        "center": [1.054628, 29.53125],
        "countries": [
            "DZ",
            "AO",
            "BJ",
            "BW",
            "BF",
            "BI",
            "CM",
            "CV",
            "CF",
            "TD",
            "KM",
            "CD",
            "CG",
            "CI",
            "DJ",
            "EG",
            "GQ",
            "ER",
            "ET",
            "GA",
            "GM",
            "GH",
            "GN",
            "GW",
            "KE",
            "LS",
            "LR",
            "LY",
            "MG",
            "MW",
            "ML",
            "MR",
            "MU",
            "YT",
            "MA",
            "MZ",
            "NA",
            "NE",
            "NG",
            "RE",
            "RW",
            "SH",
            "ST",
            "SN",
            "SC",
            "SL",
            "SO",
            "ZA",
            "SD",
            "SZ",
            "TZ",
            "TG",
            "TN",
            "UG",
            "EH",
            "ZM",
            "ZW"
        ]
    },
    "AS": {
        "name": "Asia",
        "center": [30.448674, 125.15625],
        "countries": [
            "AF",
            "AM",
            "AZ",
            "BH",
            "BD",
            "BT",
            "IO",
            "BN",
            "KH",
            "CN",
            "CX",
            "CC",
            "CY",
            "GE",
            "HK",
            "IN",
            "ID",
            "IR",
            "IQ",
            "IL",
            "JP",
            "JO",
            "KZ",
            "KP",
            "KR",
            "KW",
            "KG",
            "LA",
            "LB",
            "MO",
            "MY",
            "MV",
            "MN",
            "MM",
            "NP",
            "OM",
            "PK",
            "PS",
            "PH",
            "QA",
            "SA",
            "SG",
            "LK",
            "SY",
            "TW",
            "TJ",
            "TH",
            "TL",
            "TR",
            "TM",
            "AE",
            "UZ",
            "VN",
            "YE"
        ]
    },
    "EU": {
        "name": "Europe",
        "center": [45.521744, 21.972656],
        "countries": [
            "AX",
            "AL",
            "AD",
            "AT",
            "BY",
            "BE",
            "BA",
            "BG",
            "HR",
            "CZ",
            "DK",
            "EE",
            "FO",
            "FI",
            "FR",
            "DE",
            "GI",
            "GR",
            "GG",
            "VA",
            "HU",
            "IS",
            "IE",
            "IM",
            "IT",
            "JE",
            "LV",
            "LI",
            "LT",
            "LU",
            "MK",
            "MT",
            "MD",
            "MC",
            "ME",
            "NL",
            "NO",
            "PL",
            "PT",
            "RO",
            "RU",
            "SM",
            "RS",
            "SK",
            "SI",
            "ES",
            "SJ",
            "SE",
            "CH",
            "UA",
            "GB"
        ]
    },
    "NA": {
        "name": "North America",
        "center": [47.694974, -94.042969],
        "countries": [
            "CA",
            "MX",
            "US"
        ]
    },
    "CA": {
        "name": "Central America",
        "center": [0, 0],  # this info is missing
        "countries": [
            "AI",
            "AG",
            "AW",
            "BS",
            "BB",
            "BZ",
            "BM",
            "VG",
            "KY",
            "CR",
            "CU",
            "DM",
            "DO",
            "SV",
            "GL",
            "GD",
            "GP",
            "GT",
            "HT",
            "HN",
            "JM",
            "MQ",
            "MS",
            "AN",
            "NI",
            "PA",
            "PR",
            "BL",
            "KN",
            "LC",
            "MF",
            "PM",
            "VC",
            "TT",
            "TC",
            "VI"
        ]
    },
    "SA": {
        "name": "South America",
        "center": [-4.039618, -65.039062],
        "countries": [
            "AR",
            "BO",
            "BR",
            "CL",
            "CO",
            "EC",
            "FK",
            "GF",
            "GY",
            "PY",
            "PE",
            "SR",
            "UY",
            "VE"
        ]
    },
    "OC": {
        "name": "Oceania",
        "center": [-8.05923, 142.734375],
        "countries": [
            "AS",
            "AU",
            "CK",
            "FJ",
            "PF",
            "GU",
            "KI",
            "MH",
            "FM",
            "NR",
            "NC",
            "NZ",
            "NU",
            "NF",
            "MP",
            "PW",
            "PG",
            "PN",
            "WS",
            "SB",
            "TK",
            "TO",
            "TV",
            "UM",
            "VU",
            "WF"
        ]
    },
    "AN": {
        "name": "Antarctica",
        "center": [-78.836065, 39.375],
        "countries": [
            "AQ",
            "BV",
            "TF",
            "HM",
            "GS"
        ]
    },
}

reverse_continents = {}
for continent_code, continent in continents.items():
    continent['code'] = continent_code
    for country in continent['countries']:
        reverse_continents[country] = continent


def get_continent(country_code):
    country_code = country_code.upper()
    if country_code in reverse_continents:
        return reverse_continents[country_code.upper()]
    else:
        return None
