# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### KongEcs <a name="KongEcs" id="kong-control-plane.KongEcs"></a>

#### Initializers <a name="Initializers" id="kong-control-plane.KongEcs.Initializer"></a>

```typescript
import { KongEcs } from 'kong-control-plane'

new KongEcs(scope: Construct, id: string, props: KongEcsControlPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEcs.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcs.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcs.Initializer.parameter.props">props</a></code> | <code><a href="#kong-control-plane.KongEcsControlPlaneProps">KongEcsControlPlaneProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-control-plane.KongEcs.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-control-plane.KongEcs.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-control-plane.KongEcs.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-control-plane.KongEcsControlPlaneProps">KongEcsControlPlaneProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEcs.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-control-plane.KongEcs.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEcs.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-control-plane.KongEcs.isConstruct"></a>

```typescript
import { KongEcs } from 'kong-control-plane'

KongEcs.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-control-plane.KongEcs.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEcs.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-control-plane.KongEcs.property.controlPlane">controlPlane</a></code> | <code>aws-cdk-lib.aws_ecs.Cluster</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcs.property.clusterDns">clusterDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcs.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcs.property.telemetryDns">telemetryDns</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-control-plane.KongEcs.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `controlPlane`<sup>Required</sup> <a name="controlPlane" id="kong-control-plane.KongEcs.property.controlPlane"></a>

```typescript
public readonly controlPlane: Cluster;
```

- *Type:* aws-cdk-lib.aws_ecs.Cluster

---

##### `clusterDns`<sup>Required</sup> <a name="clusterDns" id="kong-control-plane.KongEcs.property.clusterDns"></a>

```typescript
public readonly clusterDns: string;
```

- *Type:* string

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-control-plane.KongEcs.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `telemetryDns`<sup>Required</sup> <a name="telemetryDns" id="kong-control-plane.KongEcs.property.telemetryDns"></a>

```typescript
public readonly telemetryDns: string;
```

- *Type:* string

---


### KongEks <a name="KongEks" id="kong-control-plane.KongEks"></a>

#### Initializers <a name="Initializers" id="kong-control-plane.KongEks.Initializer"></a>

```typescript
import { KongEks } from 'kong-control-plane'

new KongEks(scope: Construct, id: string, props: EksControlPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | - represents the scope for all the resources. |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.id">id</a></code> | <code>string</code> | - this is a a scope-unique id. |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.props">props</a></code> | <code><a href="#kong-control-plane.EksControlPlaneProps">EksControlPlaneProps</a></code> | - user provided props for the construct. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-control-plane.KongEks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

represents the scope for all the resources.

---

##### `id`<sup>Required</sup> <a name="id" id="kong-control-plane.KongEks.Initializer.parameter.id"></a>

- *Type:* string

this is a a scope-unique id.

---

##### `props`<sup>Required</sup> <a name="props" id="kong-control-plane.KongEks.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-control-plane.EksControlPlaneProps">EksControlPlaneProps</a>

user provided props for the construct.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEks.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-control-plane.KongEks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-control-plane.KongEks.isConstruct"></a>

```typescript
import { KongEks } from 'kong-control-plane'

KongEks.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-control-plane.KongEks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-control-plane.KongEks.property.controlPlane">controlPlane</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.endpoints">endpoints</a></code> | <code><a href="#kong-control-plane.DnsProps">DnsProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.prometheusEndpoint">prometheusEndpoint</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-control-plane.KongEks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `controlPlane`<sup>Required</sup> <a name="controlPlane" id="kong-control-plane.KongEks.property.controlPlane"></a>

```typescript
public readonly controlPlane: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `endpoints`<sup>Required</sup> <a name="endpoints" id="kong-control-plane.KongEks.property.endpoints"></a>

```typescript
public readonly endpoints: DnsProps;
```

- *Type:* <a href="#kong-control-plane.DnsProps">DnsProps</a>

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-control-plane.KongEks.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `prometheusEndpoint`<sup>Optional</sup> <a name="prometheusEndpoint" id="kong-control-plane.KongEks.property.prometheusEndpoint"></a>

```typescript
public readonly prometheusEndpoint: string;
```

- *Type:* string

---


## Structs <a name="Structs" id="Structs"></a>

### AdminProps <a name="AdminProps" id="kong-control-plane.AdminProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.AdminProps.Initializer"></a>

```typescript
import { AdminProps } from 'kong-control-plane'

const adminProps: AdminProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.AdminProps.property.enableHttp">enableHttp</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.AdminProps.property.httpPort">httpPort</a></code> | <code>number</code> | *No description.* |
| <code><a href="#kong-control-plane.AdminProps.property.httpsPort">httpsPort</a></code> | <code>number</code> | *No description.* |

---

##### `enableHttp`<sup>Optional</sup> <a name="enableHttp" id="kong-control-plane.AdminProps.property.enableHttp"></a>

```typescript
public readonly enableHttp: boolean;
```

- *Type:* boolean

---

##### `httpPort`<sup>Optional</sup> <a name="httpPort" id="kong-control-plane.AdminProps.property.httpPort"></a>

```typescript
public readonly httpPort: number;
```

- *Type:* number

---

##### `httpsPort`<sup>Optional</sup> <a name="httpsPort" id="kong-control-plane.AdminProps.property.httpsPort"></a>

```typescript
public readonly httpsPort: number;
```

- *Type:* number

---

### ClusterProps <a name="ClusterProps" id="kong-control-plane.ClusterProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.ClusterProps.Initializer"></a>

```typescript
import { ClusterProps } from 'kong-control-plane'

const clusterProps: ClusterProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.ClusterProps.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.ClusterProps.property.port">port</a></code> | <code>number</code> | *No description.* |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="kong-control-plane.ClusterProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `port`<sup>Optional</sup> <a name="port" id="kong-control-plane.ClusterProps.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

### ClusterTelemetryProps <a name="ClusterTelemetryProps" id="kong-control-plane.ClusterTelemetryProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.ClusterTelemetryProps.Initializer"></a>

```typescript
import { ClusterTelemetryProps } from 'kong-control-plane'

const clusterTelemetryProps: ClusterTelemetryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.ClusterTelemetryProps.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.ClusterTelemetryProps.property.port">port</a></code> | <code>number</code> | *No description.* |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="kong-control-plane.ClusterTelemetryProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `port`<sup>Optional</sup> <a name="port" id="kong-control-plane.ClusterTelemetryProps.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

### ControlPlaneClusterProps <a name="ControlPlaneClusterProps" id="kong-control-plane.ControlPlaneClusterProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.ControlPlaneClusterProps.Initializer"></a>

```typescript
import { ControlPlaneClusterProps } from 'kong-control-plane'

const controlPlaneClusterProps: ControlPlaneClusterProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.ControlPlaneClusterProps.property.eksClusterProps">eksClusterProps</a></code> | <code>aws-cdk-lib.aws_eks.ClusterProps</code> | *No description.* |
| <code><a href="#kong-control-plane.ControlPlaneClusterProps.property.kongTelemetryOptions">kongTelemetryOptions</a></code> | <code><a href="#kong-control-plane.ControlPlaneTelemetryProps">ControlPlaneTelemetryProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.ControlPlaneClusterProps.property.kongHelmOptions">kongHelmOptions</a></code> | <code>aws-cdk-lib.aws_eks.HelmChartOptions</code> | *No description.* |

---

##### `eksClusterProps`<sup>Required</sup> <a name="eksClusterProps" id="kong-control-plane.ControlPlaneClusterProps.property.eksClusterProps"></a>

```typescript
public readonly eksClusterProps: ClusterProps;
```

- *Type:* aws-cdk-lib.aws_eks.ClusterProps

---

##### `kongTelemetryOptions`<sup>Required</sup> <a name="kongTelemetryOptions" id="kong-control-plane.ControlPlaneClusterProps.property.kongTelemetryOptions"></a>

```typescript
public readonly kongTelemetryOptions: ControlPlaneTelemetryProps;
```

- *Type:* <a href="#kong-control-plane.ControlPlaneTelemetryProps">ControlPlaneTelemetryProps</a>

---

##### `kongHelmOptions`<sup>Optional</sup> <a name="kongHelmOptions" id="kong-control-plane.ControlPlaneClusterProps.property.kongHelmOptions"></a>

```typescript
public readonly kongHelmOptions: HelmChartOptions;
```

- *Type:* aws-cdk-lib.aws_eks.HelmChartOptions

---

### ControlPlaneTelemetryProps <a name="ControlPlaneTelemetryProps" id="kong-control-plane.ControlPlaneTelemetryProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.ControlPlaneTelemetryProps.Initializer"></a>

```typescript
import { ControlPlaneTelemetryProps } from 'kong-control-plane'

const controlPlaneTelemetryProps: ControlPlaneTelemetryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.ControlPlaneTelemetryProps.property.createPrometheusWorkspace">createPrometheusWorkspace</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.ControlPlaneTelemetryProps.property.prometheusEndpoint">prometheusEndpoint</a></code> | <code>string</code> | *No description.* |

---

##### `createPrometheusWorkspace`<sup>Required</sup> <a name="createPrometheusWorkspace" id="kong-control-plane.ControlPlaneTelemetryProps.property.createPrometheusWorkspace"></a>

```typescript
public readonly createPrometheusWorkspace: boolean;
```

- *Type:* boolean

---

##### `prometheusEndpoint`<sup>Optional</sup> <a name="prometheusEndpoint" id="kong-control-plane.ControlPlaneTelemetryProps.property.prometheusEndpoint"></a>

```typescript
public readonly prometheusEndpoint: string;
```

- *Type:* string

---

### DevPortalProps <a name="DevPortalProps" id="kong-control-plane.DevPortalProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.DevPortalProps.Initializer"></a>

```typescript
import { DevPortalProps } from 'kong-control-plane'

const devPortalProps: DevPortalProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.DevPortalProps.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.DevPortalProps.property.port">port</a></code> | <code>number</code> | *No description.* |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="kong-control-plane.DevPortalProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `port`<sup>Optional</sup> <a name="port" id="kong-control-plane.DevPortalProps.property.port"></a>

```typescript
public readonly port: number;
```

- *Type:* number

---

### DnsProps <a name="DnsProps" id="kong-control-plane.DnsProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.DnsProps.Initializer"></a>

```typescript
import { DnsProps } from 'kong-control-plane'

const dnsProps: DnsProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.DnsProps.property.adminDns">adminDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.DnsProps.property.clusterDns">clusterDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.DnsProps.property.managerDns">managerDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.DnsProps.property.telemetryDns">telemetryDns</a></code> | <code>string</code> | *No description.* |

---

##### `adminDns`<sup>Required</sup> <a name="adminDns" id="kong-control-plane.DnsProps.property.adminDns"></a>

```typescript
public readonly adminDns: string;
```

- *Type:* string

---

##### `clusterDns`<sup>Required</sup> <a name="clusterDns" id="kong-control-plane.DnsProps.property.clusterDns"></a>

```typescript
public readonly clusterDns: string;
```

- *Type:* string

---

##### `managerDns`<sup>Required</sup> <a name="managerDns" id="kong-control-plane.DnsProps.property.managerDns"></a>

```typescript
public readonly managerDns: string;
```

- *Type:* string

---

##### `telemetryDns`<sup>Required</sup> <a name="telemetryDns" id="kong-control-plane.DnsProps.property.telemetryDns"></a>

```typescript
public readonly telemetryDns: string;
```

- *Type:* string

---

### EksControlPlaneProps <a name="EksControlPlaneProps" id="kong-control-plane.EksControlPlaneProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.EksControlPlaneProps.Initializer"></a>

```typescript
import { EksControlPlaneProps } from 'kong-control-plane'

const eksControlPlaneProps: EksControlPlaneProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.controlPlaneClusterProps">controlPlaneClusterProps</a></code> | <code><a href="#kong-control-plane.ControlPlaneClusterProps">ControlPlaneClusterProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.controlPlaneNodeProps">controlPlaneNodeProps</a></code> | <code>aws-cdk-lib.aws_eks.NodegroupOptions</code> | *No description.* |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.hostedZoneName">hostedZoneName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.licenseSecretsName">licenseSecretsName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.namespace">namespace</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.EksControlPlaneProps.property.rdsProps">rdsProps</a></code> | <code>aws-cdk-lib.aws_rds.DatabaseInstanceProps</code> | *No description.* |

---

##### `controlPlaneClusterProps`<sup>Required</sup> <a name="controlPlaneClusterProps" id="kong-control-plane.EksControlPlaneProps.property.controlPlaneClusterProps"></a>

```typescript
public readonly controlPlaneClusterProps: ControlPlaneClusterProps;
```

- *Type:* <a href="#kong-control-plane.ControlPlaneClusterProps">ControlPlaneClusterProps</a>

> [https://docs.aws.amazon.com/cdk/api/latest/docs/](https://docs.aws.amazon.com/cdk/api/latest/docs/)

---

##### `controlPlaneNodeProps`<sup>Required</sup> <a name="controlPlaneNodeProps" id="kong-control-plane.EksControlPlaneProps.property.controlPlaneNodeProps"></a>

```typescript
public readonly controlPlaneNodeProps: NodegroupOptions;
```

- *Type:* aws-cdk-lib.aws_eks.NodegroupOptions

> [https://docs.aws.amazon.com/cdk/api/latest/docs/](https://docs.aws.amazon.com/cdk/api/latest/docs/)

---

##### `hostedZoneName`<sup>Required</sup> <a name="hostedZoneName" id="kong-control-plane.EksControlPlaneProps.property.hostedZoneName"></a>

```typescript
public readonly hostedZoneName: string;
```

- *Type:* string

---

##### `licenseSecretsName`<sup>Required</sup> <a name="licenseSecretsName" id="kong-control-plane.EksControlPlaneProps.property.licenseSecretsName"></a>

```typescript
public readonly licenseSecretsName: string;
```

- *Type:* string

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="kong-control-plane.EksControlPlaneProps.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* string

---

##### `rdsProps`<sup>Required</sup> <a name="rdsProps" id="kong-control-plane.EksControlPlaneProps.property.rdsProps"></a>

```typescript
public readonly rdsProps: DatabaseInstanceProps;
```

- *Type:* aws-cdk-lib.aws_rds.DatabaseInstanceProps

---

### KongEcsControlPlaneProps <a name="KongEcsControlPlaneProps" id="kong-control-plane.KongEcsControlPlaneProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.KongEcsControlPlaneProps.Initializer"></a>

```typescript
import { KongEcsControlPlaneProps } from 'kong-control-plane'

const kongEcsControlPlaneProps: KongEcsControlPlaneProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.clusterProps">clusterProps</a></code> | <code>aws-cdk-lib.aws_ecs.ClusterProps</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.desiredCount">desiredCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.hostedZoneName">hostedZoneName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.kongFeaturesProps">kongFeaturesProps</a></code> | <code><a href="#kong-control-plane.KongFeatureProps">KongFeatureProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.kongTaskProps">kongTaskProps</a></code> | <code>aws-cdk-lib.aws_ecs.FargateTaskDefinitionProps</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.rdsProps">rdsProps</a></code> | <code>aws-cdk-lib.aws_rds.DatabaseInstanceProps</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.image">image</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.internetFacing">internetFacing</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEcsControlPlaneProps.property.licenseSecret">licenseSecret</a></code> | <code>string</code> | *No description.* |

---

##### `clusterProps`<sup>Required</sup> <a name="clusterProps" id="kong-control-plane.KongEcsControlPlaneProps.property.clusterProps"></a>

```typescript
public readonly clusterProps: ClusterProps;
```

- *Type:* aws-cdk-lib.aws_ecs.ClusterProps

---

##### `desiredCount`<sup>Required</sup> <a name="desiredCount" id="kong-control-plane.KongEcsControlPlaneProps.property.desiredCount"></a>

```typescript
public readonly desiredCount: number;
```

- *Type:* number

---

##### `hostedZoneName`<sup>Required</sup> <a name="hostedZoneName" id="kong-control-plane.KongEcsControlPlaneProps.property.hostedZoneName"></a>

```typescript
public readonly hostedZoneName: string;
```

- *Type:* string

---

##### `kongFeaturesProps`<sup>Required</sup> <a name="kongFeaturesProps" id="kong-control-plane.KongEcsControlPlaneProps.property.kongFeaturesProps"></a>

```typescript
public readonly kongFeaturesProps: KongFeatureProps;
```

- *Type:* <a href="#kong-control-plane.KongFeatureProps">KongFeatureProps</a>

---

##### `kongTaskProps`<sup>Required</sup> <a name="kongTaskProps" id="kong-control-plane.KongEcsControlPlaneProps.property.kongTaskProps"></a>

```typescript
public readonly kongTaskProps: FargateTaskDefinitionProps;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateTaskDefinitionProps

---

##### `rdsProps`<sup>Required</sup> <a name="rdsProps" id="kong-control-plane.KongEcsControlPlaneProps.property.rdsProps"></a>

```typescript
public readonly rdsProps: DatabaseInstanceProps;
```

- *Type:* aws-cdk-lib.aws_rds.DatabaseInstanceProps

---

##### `image`<sup>Optional</sup> <a name="image" id="kong-control-plane.KongEcsControlPlaneProps.property.image"></a>

```typescript
public readonly image: string;
```

- *Type:* string

---

##### `internetFacing`<sup>Optional</sup> <a name="internetFacing" id="kong-control-plane.KongEcsControlPlaneProps.property.internetFacing"></a>

```typescript
public readonly internetFacing: boolean;
```

- *Type:* boolean

---

##### `licenseSecret`<sup>Optional</sup> <a name="licenseSecret" id="kong-control-plane.KongEcsControlPlaneProps.property.licenseSecret"></a>

```typescript
public readonly licenseSecret: string;
```

- *Type:* string

---

### KongFeatureProps <a name="KongFeatureProps" id="kong-control-plane.KongFeatureProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.KongFeatureProps.Initializer"></a>

```typescript
import { KongFeatureProps } from 'kong-control-plane'

const kongFeatureProps: KongFeatureProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongFeatureProps.property.adminProps">adminProps</a></code> | <code><a href="#kong-control-plane.AdminProps">AdminProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongFeatureProps.property.clusterProps">clusterProps</a></code> | <code><a href="#kong-control-plane.ClusterProps">ClusterProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongFeatureProps.property.clusterTelemetryProps">clusterTelemetryProps</a></code> | <code><a href="#kong-control-plane.ClusterTelemetryProps">ClusterTelemetryProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongFeatureProps.property.devPortalProps">devPortalProps</a></code> | <code><a href="#kong-control-plane.DevPortalProps">DevPortalProps</a></code> | *No description.* |
| <code><a href="#kong-control-plane.KongFeatureProps.property.kongBootstrapMigration">kongBootstrapMigration</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.KongFeatureProps.property.kongManagerProps">kongManagerProps</a></code> | <code><a href="#kong-control-plane.KongManagerProps">KongManagerProps</a></code> | *No description.* |

---

##### `adminProps`<sup>Required</sup> <a name="adminProps" id="kong-control-plane.KongFeatureProps.property.adminProps"></a>

```typescript
public readonly adminProps: AdminProps;
```

- *Type:* <a href="#kong-control-plane.AdminProps">AdminProps</a>

---

##### `clusterProps`<sup>Required</sup> <a name="clusterProps" id="kong-control-plane.KongFeatureProps.property.clusterProps"></a>

```typescript
public readonly clusterProps: ClusterProps;
```

- *Type:* <a href="#kong-control-plane.ClusterProps">ClusterProps</a>

---

##### `clusterTelemetryProps`<sup>Required</sup> <a name="clusterTelemetryProps" id="kong-control-plane.KongFeatureProps.property.clusterTelemetryProps"></a>

```typescript
public readonly clusterTelemetryProps: ClusterTelemetryProps;
```

- *Type:* <a href="#kong-control-plane.ClusterTelemetryProps">ClusterTelemetryProps</a>

---

##### `devPortalProps`<sup>Required</sup> <a name="devPortalProps" id="kong-control-plane.KongFeatureProps.property.devPortalProps"></a>

```typescript
public readonly devPortalProps: DevPortalProps;
```

- *Type:* <a href="#kong-control-plane.DevPortalProps">DevPortalProps</a>

---

##### `kongBootstrapMigration`<sup>Required</sup> <a name="kongBootstrapMigration" id="kong-control-plane.KongFeatureProps.property.kongBootstrapMigration"></a>

```typescript
public readonly kongBootstrapMigration: boolean;
```

- *Type:* boolean

---

##### `kongManagerProps`<sup>Required</sup> <a name="kongManagerProps" id="kong-control-plane.KongFeatureProps.property.kongManagerProps"></a>

```typescript
public readonly kongManagerProps: KongManagerProps;
```

- *Type:* <a href="#kong-control-plane.KongManagerProps">KongManagerProps</a>

---

### KongManagerProps <a name="KongManagerProps" id="kong-control-plane.KongManagerProps"></a>

#### Initializer <a name="Initializer" id="kong-control-plane.KongManagerProps.Initializer"></a>

```typescript
import { KongManagerProps } from 'kong-control-plane'

const kongManagerProps: KongManagerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongManagerProps.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.KongManagerProps.property.enableHttp">enableHttp</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-control-plane.KongManagerProps.property.httpPort">httpPort</a></code> | <code>number</code> | *No description.* |
| <code><a href="#kong-control-plane.KongManagerProps.property.httpsPort">httpsPort</a></code> | <code>number</code> | *No description.* |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="kong-control-plane.KongManagerProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `enableHttp`<sup>Optional</sup> <a name="enableHttp" id="kong-control-plane.KongManagerProps.property.enableHttp"></a>

```typescript
public readonly enableHttp: boolean;
```

- *Type:* boolean

---

##### `httpPort`<sup>Optional</sup> <a name="httpPort" id="kong-control-plane.KongManagerProps.property.httpPort"></a>

```typescript
public readonly httpPort: number;
```

- *Type:* number

---

##### `httpsPort`<sup>Optional</sup> <a name="httpsPort" id="kong-control-plane.KongManagerProps.property.httpsPort"></a>

```typescript
public readonly httpsPort: number;
```

- *Type:* number

---



