# -*- coding: utf-8 -*-
#
# This file is part of the parce Python package.
#
# Copyright © 2019-2020 by Wilbert Berendsen <info@wilbertberendsen.nl>
#
# This module is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This module is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.


JAVASCRIPT_KEYWORDS = (
    'for',
    'in',
    'while',
    'do',
    'break',
    'return',
    'continue',
    'switch',
    'case',
    'default',
    'if',
    'else',
    'throw',
    'try',
    'catch',
    'finally',
    'new',
    'delete',
    'typeof',
    'instanceof',
    'void',
    'yield',
    'this',
    'of',
)


JAVASCRIPT_DECLARATORS = (
    'const',
    'let',
    'var',
    'with',
    'function',
)


JAVASCRIPT_RESERVED_KEYWORDS = (
    'abstract',
    'await',
    'boolean',
    'byte',
    'char',
    'class',
    'const',
    'debugger',
    'double',
    'enum',
    'export',
    'extends',
    'final',
    'float',
    'goto',
    'implements',
    'import',
    'int',
    'interface',
    'long',
    'native',
    'package',
    'private',
    'protected',
    'public',
    'short',
    'static',
    'super',
    'synchronized',
    'throws',
    'transient',
    'volatile',
)


JAVASCRIPT_CONSTANTS = (
    'true',
    'false',
    'null',
    'NaN',
    'Infinity',
    'undefined',
)


JAVASCRIPT_PROTOTYPES = (
    'Boolean',
    'Date',
    'Error',
    'Function',
    'Math',
    'netscape',
    'Number',
    'Object',
    'Packages',
    'RegExp',
    'String',
    'Promise',
    'Proxy',
    'sun',
    'decodeURI',
    'decodeURIComponent',
    'encodeURI',
    'encodeURIComponent',
    'Error',
    'eval',
    'isFinite',
    'isNaN',
    'isSafeInteger',
    'parseFloat',
    'parseInt',
)


JAVASCRIPT_BUILTINS = (
    'document',
    'this',
    'window',
)


