import traceback
import logging
from datetime import datetime
from django.db import models


LEVEL_CHOOSE = (
    (0,"DEBUG"),
    (1,"INFO"),
    (2,"WARNING"),
    (3,"ERROR"),
    (4,"CRITICAL"),
)

# Create your models here.
class Logs(models.Model):
    """
    记录日志信息,流水,除ID 外无主键
    """
    name = models.CharField(max_length=32, verbose_name="Logger Name", default="")
    msg = models.TextField(verbose_name="Msg", default="")
    args = models.TextField(verbose_name="Args", default="")

    # level
    levelname = models.IntegerField(choices=LEVEL_CHOOSE,verbose_name="Level",default=0)
    levelno = models.CharField(max_length=32, verbose_name="Level No", default="")
    pathname = models.CharField(max_length=256, verbose_name="Path Name", default="")
    filename = models.CharField(max_length=64, verbose_name="File Name", default="")
    module = models.CharField(max_length=64, verbose_name="Module", default="")
    exc_info = models.TextField(verbose_name="Exc Info", default="")
    exc_text = models.CharField(max_length=32, verbose_name="Exc Text", default="")
    stack_info = models.CharField(max_length=32, verbose_name="Stack Info", default="")
    lineno = models.CharField(max_length=32, verbose_name="Line No", default="")
    funcname = models.CharField(max_length=32, verbose_name="Func Name", default="")

    created = models.DateTimeField(verbose_name="Created Time", default="")
    msecs = models.FloatField(verbose_name="Msecs", default="")
    relativeCreated = models.FloatField(verbose_name="Relative Created", default="")

    thread = models.CharField(max_length=32, verbose_name="Thread", default="")
    threadName = models.CharField(max_length=32, verbose_name="Thread Name", default="")
    processName = models.CharField(max_length=32, verbose_name="Process Name", default="")
    process = models.CharField(max_length=32, verbose_name="Process", default="")

    class Meta:
        verbose_name = "日志中心"
        verbose_name_plural = verbose_name
        indexes = [models.Index(fields=['created', "levelname"]), ]

    def __str__(self):
        return f"{self.name}  {self.levelname} :{self.msg}"

    def __repr__(self):
        return self.__str__()

    def short_message(self):
        return str(self.msg)[:50]

    short_message.allow_tags = True
    short_message.short_description = "Short Message"
