"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
class S3Bucket extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_s3_1.Bucket(this, 'SimpleTestBucket', {
            publicReadAccess: props.readAccess || false,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            enforceSSL: false,
        });
    }
}
exports.S3Bucket = S3Bucket;
_a = JSII_RTTI_SYMBOL_1;
S3Bucket[_a] = { fqn: "test.S3Bucket", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBNEM7QUFDNUMsK0NBQTRDO0FBQzVDLDJDQUF1QztBQWlCdkMsTUFBYSxRQUFTLFNBQVEsc0JBQVM7SUFDckMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksZUFBTSxDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUNuQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUs7WUFDM0MsYUFBYSxFQUFFLDJCQUFhLENBQUMsT0FBTztZQUNwQyxVQUFVLEVBQUUsS0FBSztTQUNsQixDQUFDLENBQUM7SUFDTCxDQUFDOztBQVRILDRCQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEJ1Y2tldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLypcbkEgU2ltcGxlIFMzIENvbnN0cnVjdFxuKi9cblxuZXhwb3J0IGludGVyZmFjZSBTM0J1Y2tldFByb3BzIHtcbiAgLyoqXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqIEB0eXBlIHtib29sZWFufVxuICAgICAqIEBtZW1iZXJvZiBTM0J1Y2tldFByb3BzXG4gICAgICovXG4gIHJlYWRvbmx5IHJlYWRBY2Nlc3M6IGJvb2xlYW47XG59XG5cblxuZXhwb3J0IGNsYXNzIFMzQnVja2V0IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFMzQnVja2V0UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgbmV3IEJ1Y2tldCh0aGlzLCAnU2ltcGxlVGVzdEJ1Y2tldCcsIHtcbiAgICAgIHB1YmxpY1JlYWRBY2Nlc3M6IHByb3BzLnJlYWRBY2Nlc3MgfHwgZmFsc2UsXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgICBlbmZvcmNlU1NMOiBmYWxzZSxcbiAgICB9KTtcbiAgfVxufVxuIl19