import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="alteryx_gallery_py",
    version="1.0.0",
    description="Connect to Alteryx Gallery using API",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/continuus-technoloiges/alteryx_gallery_py",
    author="Continuus Technologies",
    author_email="info@continuus-technologies.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
    ],
    packages=["alteryx_gallery_py"],
    include_package_data=True,
    install_requires=[],
    entry_points={
        "console_scripts": [
            "alteryx_gallery_py=alteryx_gallery_py.__main__:main",
        ]
    },
)
